/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Shape {
    public short x;
    public short y;
    public short width;
    public short height;
    public short left;
    public short right;
    public short top;
    public short bottom;
    public int highlight;
    public int brightness;
    public boolean isBlinking = false;
    public boolean isUsingMask;
    public short imageOrMaskIndex;
    public int[] colors;
    public int scale = 1;
    public boolean isAnimation = false;
    public short animationSlide = 0;
    public short animationSlidesCount = 1;
    public short animationDelay = 0;
    public short animationDelayCurrent = 0;
    public short type = 0;
    public short bonus = 0;
    public boolean touched = false;
    public boolean destroyed = false;
    public int score;

    public void setBoards() {
        this.left = this.x;
        this.right = (short)(this.x + this.width - 1);
        this.top = this.y;
        this.bottom = (short)(this.y + this.height - 1);
    }

    public void setPosition(short x, short y) {
        this.x = x;
        this.y = y;
        this.setBoards();
    }

    private void width() {
        this.width = this.isUsingMask ? (!this.isAnimation ? (short)(Painter.staticObjects[this.imageOrMaskIndex][0] * this.scale) : (short)(Painter.dynamicObjects[this.imageOrMaskIndex][0] * this.scale)) : (short)Painter.imageObjects[this.imageOrMaskIndex].getWidth();
    }

    private void height() {
        this.height = this.isUsingMask ? (!this.isAnimation ? (short)(Painter.staticObjects[this.imageOrMaskIndex][1] * this.scale) : (short)(Painter.dynamicObjects[this.imageOrMaskIndex][1] * this.scale)) : (short)Painter.imageObjects[this.imageOrMaskIndex].getHeight();
    }

    public boolean intersectScreen() {
        if (this.bottom > Painter.screenBottomBoard) {
            return false;
        }
        return this.left < Painter.screenLeftBoard || this.right > Painter.screenRightBoard || this.top < Painter.screenTopBoard || this.bottom > Painter.screenBottomBoard;
    }

    public boolean bursts(Shape s) {
        return this.left - this.width - Painter.spaceBetweenTargets <= s.left && this.right + this.width + Painter.spaceBetweenTargets >= s.right && this.top - this.height - Painter.spaceBetweenTargets <= s.top && this.bottom + this.height + Painter.spaceBetweenTargets >= s.bottom;
    }

    public boolean intersect(Shape s) {
        return this.left <= s.right && this.right >= s.left && this.top <= s.bottom && this.bottom >= s.top;
    }

    public void setView(int highlight, int brightness, boolean isUsingMask, short imageOrMaskIndex) {
        this.highlight = highlight;
        this.brightness = brightness;
        this.isUsingMask = isUsingMask;
        this.imageOrMaskIndex = imageOrMaskIndex;
        this.width();
        this.height();
    }

    public void setColor(int[] colors) {
        this.colors = new int[colors.length];
        System.arraycopy(colors, 0, this.colors, 0, colors.length);
    }

    public void setScale(int scale) {
        this.scale = scale;
        this.width();
        this.height();
    }

    private short getAnimationSlidesCount() {
        return 1;
    }

    public void setAnimation(short animationDelay) {
        this.animationDelay = animationDelay;
        this.animationDelayCurrent = animationDelay;
        this.setAnimation();
    }

    public void setAnimation() {
        this.animationSlide = 0;
        this.animationSlidesCount = this.getAnimationSlidesCount();
        this.isAnimation = true;
    }

    public void animate() {
        if (!this.isAnimation) {
            return;
        }
        this.animationDelayCurrent = (short)(this.animationDelayCurrent - 1);
        if (this.animationDelayCurrent > 0) {
            return;
        }
        this.animationSlide = (short)(this.animationSlide + 1);
        if (this.animationSlide == this.animationSlidesCount) {
            this.animationSlide = 0;
        }
        this.animationDelayCurrent = this.animationDelay;
    }

    public void setType(short newType, boolean setScore) {
        this.setType(newType);
        if (setScore) {
            this.score = Data.SHAPE_SCORES[newType];
        }
    }

    public void setType(short newType) {
        this.type = newType;
        if (this.isUsingMask) {
            this.setColor(Data.SHAPE_COLORS[newType]);
        } else {
            this.imageOrMaskIndex = (short)Data.SHAPE_IMAGE_INDEXES[newType];
        }
    }

    public void prepare() {
        this.touched = false;
        this.destroyed = false;
    }

    public void duplicate(Shape s) {
        this.x = s.x;
        this.y = s.y;
        this.width = s.width;
        this.height = s.height;
        this.left = s.left;
        this.right = s.right;
        this.top = s.top;
        this.bottom = s.bottom;
        this.highlight = s.highlight;
        this.brightness = s.brightness;
        this.isBlinking = s.isBlinking;
        this.isUsingMask = s.isUsingMask;
        this.imageOrMaskIndex = s.imageOrMaskIndex;
        this.isAnimation = s.isAnimation;
        this.animationSlide = s.animationSlide;
        this.animationSlidesCount = s.animationSlidesCount;
        this.animationDelay = s.animationDelay;
        this.animationDelayCurrent = s.animationDelayCurrent;
        this.scale = s.scale;
        this.setType(s.type);
        this.bonus = s.bonus;
        this.touched = s.touched;
        this.destroyed = s.destroyed;
        this.score = s.score;
    }

    public void render(Graphics g) {
        if (!this.isAnimation) {
            if (this.isUsingMask) {
                Painter.renderPieceOfShape(g, Painter.staticObjects[this.imageOrMaskIndex], this.x, this.y, 0, 0, Painter.staticObjects[this.imageOrMaskIndex][0], Painter.staticObjects[this.imageOrMaskIndex][1], this.colors, this.scale);
            } else {
                Painter.renderImage(g, Painter.imageObjects[this.imageOrMaskIndex], this.x, this.y);
            }
        } else {
            byte w = Painter.dynamicObjects[this.imageOrMaskIndex][0];
            byte h = Painter.dynamicObjects[this.imageOrMaskIndex][1];
            byte countOfMask = Painter.dynamicObjects[this.imageOrMaskIndex][2];
            int len = w * h * countOfMask / 8;
            byte[] draws = new byte[len];
            draws[0] = Painter.dynamicObjects[this.imageOrMaskIndex][0];
            draws[1] = Painter.dynamicObjects[this.imageOrMaskIndex][1];
            for (int j = 2; j < len; ++j) {
                draws[j] = Painter.dynamicObjects[this.imageOrMaskIndex][len * this.animationSlide + j + 3];
            }
            Painter.renderObjects(g, this.x, this.y, draws, this.colors, this.scale, 0);
        }
    }

    public Image createImage() {
        return Painter.createImage(Painter.staticObjects[this.imageOrMaskIndex], this.colors, this.scale);
    }
}

