/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Painter {
    public static double bulletSpeed;
    public static int pixelW;
    public static int pixelH;
    public static int basicScale;
    public static int scaleForMessage;
    public static int scaleForHeart;
    public static int scaleForScore;
    public static int scaleForShipIncrement;
    public static int spaceBetweenTargets;
    public static int borderWidth;
    public static int targetsLine;
    public static final int TURN_NO = 0;
    public static final int TURN_90 = 1;
    public static final int TURN_180 = 2;
    public static final int TURN_270 = 3;
    private static int turn;
    public static byte[][] staticObjects;
    public static byte[][] dynamicObjects;
    public static Image[] imageObjects;
    public static short screenLeftBoard;
    public static short screenRightBoard;
    public static short screenTopBoard;
    public static short screenBottomBoard;
    private static int[] tempIntArray;
    private static int tempWidth;
    private static int tempWidth2;
    private static int tempHeight;
    private static int tempColor;
    private static Image img;
    public static Graphics g1;

    public static void addImageObject(short curType) {
        Painter.tempIntArray[0] = tempWidth;
        Painter.tempIntArray[1] = tempHeight;
        tempColor = Data.SHAPE_COLORS[curType][0];
        for (int i = 2; i < tempIntArray.length; ++i) {
            Painter.tempIntArray[i] = tempColor;
        }
        Painter.imageObjects[Data.SHAPE_IMAGE_INDEXES[curType]] = img = Constructor.createImg(tempIntArray, 1, tempColor);
    }

    public static void createTargetsImage() {
        tempWidth = Math.min(Some.W, Some.H) / 16;
        tempHeight = tempWidth * 5 / 8;
        tempIntArray = new int[tempWidth * tempHeight + 2];
        Painter.addImageObject((short)0);
        Painter.addImageObject((short)1);
        Painter.addImageObject((short)2);
        Painter.addImageObject((short)3);
        Painter.addImageObject((short)4);
        Painter.addImageObject((short)5);
    }

    public static void createBulletsImage() {
        Bullet b = new Bullet();
        b.setView(0, 90, true, (short)1);
        b.setScale(basicScale);
        b.setColor(Data.BULLET_COLORS[0]);
        Painter.imageObjects[Data.BULLET_IMAGE_INDEXES[0]] = b.createImage();
        b.setColor(Data.BULLET_COLORS[1]);
        Painter.imageObjects[Data.BULLET_IMAGE_INDEXES[1]] = b.createImage();
        b.setColor(Data.BULLET_COLORS[2]);
        Painter.imageObjects[Data.BULLET_IMAGE_INDEXES[2]] = b.createImage();
    }

    public static void addShipImage(short curType, int width) {
        tempColor = 0xFF00FF;
        Painter.tempIntArray[0] = width;
        Painter.tempIntArray[1] = tempHeight;
        for (int i = 2; i < tempIntArray.length; ++i) {
            Painter.tempIntArray[i] = tempColor;
        }
        Painter.imageObjects[Data.SHIP_IMAGE_INDEXES[curType]] = img = Constructor.createImg(tempIntArray, 1, tempColor);
    }

    public static void createShipImage(int W) {
        tempWidth = W / 6;
        tempHeight = 4 * basicScale;
        tempWidth2 = tempWidth;
        tempIntArray = new int[tempWidth2 * tempHeight + 2];
        Painter.addShipImage((short)1, tempWidth2);
        tempWidth2 = tempWidth * 2;
        tempIntArray = new int[tempWidth2 * tempHeight + 2];
        Painter.addShipImage((short)2, tempWidth2);
        tempWidth2 = tempWidth / 2;
        tempIntArray = new int[tempWidth2 * tempHeight + 2];
        Painter.addShipImage((short)3, tempWidth2);
    }

    public static void init(int W, int H) {
        basicScale = Math.min(W, H) / 100;
        scaleForMessage = 2 * basicScale;
        scaleForHeart = 2 * basicScale;
        scaleForScore = 3 * basicScale / 2;
        scaleForShipIncrement = 4 * basicScale;
        bulletSpeed = (double)Tools.precision * 3.0 * (double)basicScale;
        spaceBetweenTargets = 1 * basicScale;
        borderWidth = 2 * basicScale;
        targetsLine = 30 * basicScale;
        staticObjects = EIo.loadObjects((short)1);
        imageObjects = new Image[11];
        Painter.createTargetsImage();
        Painter.createBulletsImage();
        Painter.createShipImage(W);
        screenLeftBoard = 0;
        screenRightBoard = Tools.round(W / pixelW - 1);
        screenTopBoard = 0;
        screenBottomBoard = Tools.round(H / pixelH - 1);
        int[] colors = new int[]{9900234};
        Background.heart.setColor(colors);
        Background.heart.setView(-987, 90, true, (short)3);
        Background.heart.setScale(scaleForHeart);
        Background.heart.setPosition((short)borderWidth, (short)borderWidth);
    }

    private static int[] fill(int[] result, int y, int x, int w, int sc, int color) {
        for (int i = 0; i < sc * pixelH; ++i) {
            for (int j = 0; j < sc * pixelW; ++j) {
                int xBase = x * pixelW * sc;
                int yBase = y * pixelH * sc;
                int wBase = w * pixelW * sc;
                int basePos = xBase + yBase * wBase;
                if (basePos + j + i * wBase >= result.length) continue;
                result[basePos + j + i * wBase] = color;
            }
        }
        return result;
    }

    public static void renderPieceOfShape(Graphics g, byte[] byteObj, int x, int y, int xp, int yp, int wp, int hp, int[] color, int sc) {
        int width = byteObj[0];
        int height = byteObj[1];
        int currMask = 0;
        if (width < 0) {
            width += 256;
        }
        if (height < 0) {
            height += 256;
        }
        if (xp < 0) {
            xp += 256;
        }
        if (yp < 0) {
            yp += 256;
        }
        int countOfMask = 8 * (byteObj.length - 2) / (width * height);
        g.setColor(color[currMask]);
        int currX = xp;
        int currY = yp;
        while (true) {
            int currBit;
            int currByte;
            int toDraw;
            if (currX == xp + wp) {
                if (++currY == yp + hp) {
                    currY = yp;
                    ++currMask;
                }
                if (currMask == countOfMask) break;
                g.setColor(color[currMask]);
                currX = xp;
            }
            if ((toDraw = byteObj[currByte = (currY * width + currX + currMask * width * height) / 8 + 2] >> (currBit = ((currY * width + currX + currMask * width * height) % 8 - 7) * -1) & 1) != 0) {
                g.fillRect(x * pixelW + (currX - xp) * pixelW * sc, y * pixelH + (currY - yp) * pixelH * sc, pixelW * sc, pixelH * sc);
            }
            ++currX;
        }
    }

    public static void renderPieceOfText(Graphics g, byte[] byteObj, int x, int y, int xp, int yp, int wp, int hp, int[] color, int sc) {
        int width = byteObj[0];
        int height = byteObj[1];
        int currMask = 0;
        if (width < 0) {
            width += 256;
        }
        if (height < 0) {
            height += 256;
        }
        if (xp < 0) {
            xp += 256;
        }
        if (yp < 0) {
            yp += 256;
        }
        int countOfMask = 8 * (byteObj.length - 2) / (width * height);
        g.setColor(color[currMask]);
        int currX = xp;
        int currY = yp;
        while (true) {
            int currBit;
            int currByte;
            int toDraw;
            if (currX == xp + wp) {
                if (++currY == yp + hp) {
                    currY = yp;
                    ++currMask;
                }
                if (currMask == countOfMask) break;
                g.setColor(color[currMask]);
                currX = xp;
            }
            if ((toDraw = byteObj[currByte = (currY * width + currX + currMask * width * height) / 8 + 2] >> (currBit = ((currY * width + currX + currMask * width * height) % 8 - 7) * -1) & 1) != 0) {
                g.fillRect(x + (currX - xp) * pixelW * sc, y + (currY - yp) * pixelH * sc, pixelW * sc, pixelH * sc);
            }
            ++currX;
        }
    }

    public static int[] convertBytesToInts(byte[] byteObj, int[] colorObject, int sc) {
        int i;
        int currColor = 0;
        int currMask = 0;
        int width = byteObj[0];
        int height = byteObj[1];
        if (width < 0) {
            width += 256;
        }
        if (height < 0) {
            height += 256;
        }
        int countOfMask = 8 * (byteObj.length - 2) / (width * height);
        int[] result = new int[width * height * pixelH * pixelW * sc * sc];
        for (i = 1; i < result.length; ++i) {
            result[i] = 0xFF00FF;
        }
        try {
            for (i = 2; i < byteObj.length; ++i) {
                byte currByte = byteObj[i];
                for (int cutBit = 7; cutBit >= 0; --cutBit) {
                    int toDraw;
                    if (currMask == width * height) {
                        currMask = 0;
                        if (++currColor == countOfMask) {
                            return result;
                        }
                    }
                    if ((toDraw = currByte >> cutBit & 1) != 0) {
                        switch (turn) {
                            case 0: {
                                result = Painter.fill(result, currMask / width, currMask % width, width, sc, colorObject[currColor]);
                                break;
                            }
                            case 1: {
                                result = Painter.fill(result, currMask % width, currMask / width, width, sc, colorObject[currColor]);
                                break;
                            }
                            case 2: {
                                result = Painter.fill(result, width - 1 - currMask / width, width - 1 - currMask % width, width, sc, colorObject[currColor]);
                                break;
                            }
                            case 3: {
                                result = Painter.fill(result, width - 1 - currMask % width, width - 1 - currMask / width, width, sc, colorObject[currColor]);
                            }
                        }
                    }
                    ++currMask;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("convertByte");
        }
        return result;
    }

    public static void renderObjects(Graphics g, int x, int y, byte[] byteObj, int[] color, int sc, int turn) {
        Painter.turn = turn;
        g.drawImage(Painter.createImage(byteObj, color, sc), x * pixelW, y * pixelH, 20);
    }

    public static final void renderShape(Graphics g, byte[] byteObj, int x, int y, int[] color, int sc, int BGCOLOR) {
        g.setColor(BGCOLOR);
        g.setClip(0, 0, Background.W, Background.H);
        g.fillRect(0, 0, Background.W, Background.H);
        Painter.renderShape(g, byteObj, x, y, color, sc);
    }

    public static final void renderShape(Graphics g, byte[] byteObj, int x, int y, int[] color, int sc) {
        Painter.renderPieceOfShape(g, byteObj, x, y, 0, 0, byteObj[0], byteObj[1], color, sc);
    }

    public static Image createImage(byte[] byteObj, int[] colorObject, int sc) {
        int width = byteObj[0];
        int height = byteObj[1];
        if (width < 0) {
            width += 256;
        }
        if (height < 0) {
            height += 256;
        }
        return Constructor.createImg(byteObj, sc, colorObject[0]);
    }

    public static void renderImage(Graphics g, Image img, int x, int y) {
        g.drawImage(img, x * pixelW, y * pixelH, 20);
    }

    static {
        pixelW = 1;
        pixelH = 1;
    }
}

