/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Shape {
    public short x;
    public short y;
    public short width;
    public short height;
    public short left;
    public short right;
    public short top;
    public short bottom;
    public int highlight;
    public int brightness;
    public boolean isBlinking = false;
    public boolean isUsingMask;
    public short imageOrMaskIndex;
    public int[] colors;
    public int scale = 1;
    public boolean isAnimation = false;
    public short animationSlide = 0;
    public short animationSlidesCount = 1;
    public short animationDelay = 0;
    public short animationDelayCurrent = 0;
    public short type = 0;
    public short bonus = 0;
    public boolean touched = false;
    public boolean destroyed = false;
    public int score;

    public void setBoards() {
        this.left = this.x;
        this.right = (short)(this.x + this.width - 1);
        this.top = this.y;
        this.bottom = (short)(this.y + this.height - 1);
    }

    public void setPosition(short s, short s2) {
        this.x = s;
        this.y = s2;
        this.setBoards();
    }

    private void a() {
        if (this.isUsingMask) {
            if (!this.isAnimation) {
                this.width = (short)(Painter.staticObjects[this.imageOrMaskIndex][0] * this.scale);
                return;
            }
            this.width = (short)(Painter.dynamicObjects[this.imageOrMaskIndex][0] * this.scale);
            return;
        }
        this.width = (short)Painter.imageObjects[this.imageOrMaskIndex].getWidth();
    }

    private void b() {
        if (this.isUsingMask) {
            if (!this.isAnimation) {
                this.height = (short)(Painter.staticObjects[this.imageOrMaskIndex][1] * this.scale);
                return;
            }
            this.height = (short)(Painter.dynamicObjects[this.imageOrMaskIndex][1] * this.scale);
            return;
        }
        this.height = (short)Painter.imageObjects[this.imageOrMaskIndex].getHeight();
    }

    public boolean intersectScreen() {
        if (this.bottom > Painter.screenBottomBoard) {
            return false;
        }
        return this.left < Painter.screenLeftBoard || this.right > Painter.screenRightBoard || this.top < Painter.screenTopBoard || this.bottom > Painter.screenBottomBoard;
    }

    public boolean bursts(Shape shape) {
        return this.left - this.width - Painter.spaceBetweenTargets <= shape.left && this.right + this.width + Painter.spaceBetweenTargets >= shape.right && this.top - this.height - Painter.spaceBetweenTargets <= shape.top && this.bottom + this.height + Painter.spaceBetweenTargets >= shape.bottom;
    }

    public boolean intersect(Shape shape) {
        return this.left <= shape.right && this.right >= shape.left && this.top <= shape.bottom && this.bottom >= shape.top;
    }

    public void setView(int n, int n2, boolean bl, short s) {
        this.highlight = n;
        this.brightness = n2;
        this.isUsingMask = bl;
        this.imageOrMaskIndex = s;
        this.a();
        this.b();
    }

    public void setColor(int[] nArray) {
        this.colors = new int[nArray.length];
        System.arraycopy(nArray, 0, this.colors, 0, nArray.length);
    }

    public void setScale(int n) {
        this.scale = n;
        this.a();
        this.b();
    }

    public void setAnimation(short s) {
        this.animationDelay = s;
        this.animationDelayCurrent = s;
        this.setAnimation();
    }

    public void setAnimation() {
        this.animationSlide = 0;
        this.animationSlidesCount = 1;
        this.isAnimation = true;
    }

    public void animate() {
        if (!this.isAnimation) {
            return;
        }
        this.animationDelayCurrent = (short)(this.animationDelayCurrent - 1);
        if (this.animationDelayCurrent > 0) {
            return;
        }
        this.animationSlide = (short)(this.animationSlide + 1);
        if (this.animationSlide == this.animationSlidesCount) {
            this.animationSlide = 0;
        }
        this.animationDelayCurrent = this.animationDelay;
    }

    public void setType(short s, boolean bl) {
        this.setType(s);
        if (bl) {
            this.score = Data.SHAPE_SCORES[s];
        }
    }

    public void setType(short s) {
        this.type = s;
        if (this.isUsingMask) {
            this.setColor(Data.SHAPE_COLORS[s]);
            return;
        }
        this.imageOrMaskIndex = (short)Data.SHAPE_IMAGE_INDEXES[s];
    }

    public void prepare() {
        this.touched = false;
        this.destroyed = false;
    }

    public void duplicate(Shape shape) {
        this.x = shape.x;
        this.y = shape.y;
        this.width = shape.width;
        this.height = shape.height;
        this.left = shape.left;
        this.right = shape.right;
        this.top = shape.top;
        this.bottom = shape.bottom;
        this.highlight = shape.highlight;
        this.brightness = shape.brightness;
        this.isBlinking = shape.isBlinking;
        this.isUsingMask = shape.isUsingMask;
        this.imageOrMaskIndex = shape.imageOrMaskIndex;
        this.isAnimation = shape.isAnimation;
        this.animationSlide = shape.animationSlide;
        this.animationSlidesCount = shape.animationSlidesCount;
        this.animationDelay = shape.animationDelay;
        this.animationDelayCurrent = shape.animationDelayCurrent;
        this.scale = shape.scale;
        this.setType(shape.type);
        this.bonus = shape.bonus;
        this.touched = shape.touched;
        this.destroyed = shape.destroyed;
        this.score = shape.score;
    }

    public void render(Graphics graphics) {
        if (!this.isAnimation) {
            if (this.isUsingMask) {
                Painter.renderPieceOfShape(graphics, Painter.staticObjects[this.imageOrMaskIndex], this.x, this.y, 0, 0, Painter.staticObjects[this.imageOrMaskIndex][0], Painter.staticObjects[this.imageOrMaskIndex][1], this.colors, this.scale);
                return;
            }
            Painter.renderImage(graphics, Painter.imageObjects[this.imageOrMaskIndex], this.x, this.y);
            return;
        }
        int n = Painter.dynamicObjects[this.imageOrMaskIndex][0];
        byte by = Painter.dynamicObjects[this.imageOrMaskIndex][1];
        int n2 = Painter.dynamicObjects[this.imageOrMaskIndex][2];
        n = n * by * n2 / 8;
        byte[] byArray = new byte[n];
        byte[] byArray2 = byArray;
        byArray[0] = Painter.dynamicObjects[this.imageOrMaskIndex][0];
        byArray2[1] = Painter.dynamicObjects[this.imageOrMaskIndex][1];
        for (n2 = 2; n2 < n; ++n2) {
            byArray2[n2] = Painter.dynamicObjects[this.imageOrMaskIndex][n * this.animationSlide + n2 + 3];
        }
        Painter.renderObjects(graphics, this.x, this.y, byArray2, this.colors, this.scale, 0);
    }

    public Image createImage() {
        return Painter.createImage(Painter.staticObjects[this.imageOrMaskIndex], this.colors, this.scale);
    }
}

