/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.Game;

import com.spl.j2me.Animation.TiledAnimation;
import com.spl.j2me.Game.AwardsViewScreen;
import com.spl.j2me.Game.Constants;
import com.spl.j2me.Game.GameBuilding;
import com.spl.j2me.Game.GameScreen;
import com.spl.j2me.Game.GameShopScreen;
import com.spl.j2me.Game.MathExt;
import com.spl.j2me.RM.ResourceManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ProducingBuilding
extends GameBuilding {
    public static final int BUILDING_POSITION_MAIN = 0;
    public static final int BUILDING_POSITION_SECOND = 1;
    protected byte positionType;
    protected ProducingBuilding neighbourBuilding;
    protected TiledAnimation productIcon;
    protected int progressBarFullID;
    protected int progressBarEmptyID;
    protected TiledAnimation workAnimation;
    protected boolean isWorking = false;
    protected int currentProductionSpeed = 2048;
    protected int hardWorkTimer = -2048;
    protected int timeToProduce = 0;
    protected int sourceCount = 0;
    protected int transferCount = 0;
    protected int sourceTypeCount = 1;
    protected int currentAnimationSpeed = 120;
    protected boolean isAppearing;
    protected int appearanceDelay = 0;
    protected int appearingYOffset = 400;
    public static int now_producing_buiding = 0;

    public ProducingBuilding(int n, int n2, int n3, byte by) {
        super(n, n2, by);
        this.appearanceDelay = n3;
        this.setupAppearance();
        this.upgradeButtonState = false;
    }

    public void setNeighbourBuilding(ProducingBuilding producingBuilding) {
        this.neighbourBuilding = producingBuilding;
    }

    public void setBuildingPositionType(int n) {
        this.positionType = (byte)n;
    }

    public byte getBuildingPositionType() {
        return this.positionType;
    }

    public void setProgressBar(int n, int n2) {
        this.progressBarEmptyID = n2;
        this.progressBarFullID = n;
    }

    public void setWorkAnimation(TiledAnimation tiledAnimation) {
        this.workAnimation = tiledAnimation;
        this.workAnimation.updateAnimationPosition(Constants.buildingPosition[this.positionID][6], Constants.buildingPosition[this.positionID][7]);
    }

    public void draw(Graphics graphics) {
        Image image;
        if (this.appearanceDelay > 0 || !this.isUpdateEnabled) {
            return;
        }
        if (this.buildingAnimation != null) {
            this.buildingAnimation.setFrameToDraw(this.currentUpgrade > 0 ? this.currentBuildingType * 5 + this.currentUpgrade - 1 : 0);
            this.buildingAnimation.draw(graphics);
            if (this.upgradeButtonState && this.currentUpgrade != 0) {
                this.upgradeButton.draw(graphics);
            }
        }
        if (this.currentUpgrade == 0 && this.productIcon != null) {
            this.productIcon.draw(graphics);
        }
        if ((image = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(this.progressBarEmptyID >> 24, this.progressBarEmptyID & 0xFFFFFF))) != null && this.currentUpgrade > 0 && !this.isAppearing) {
            graphics.drawImage(image, Constants.buildingPosition[this.positionID][4], Constants.buildingPosition[this.positionID][5], 0);
        }
        if (this.isWorking && !this.isAppearing) {
            graphics.setColor(255);
            int n = Constants.producingBuildingTime[this.currentUpgrade] << 11;
            Image image2 = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(this.progressBarFullID >> 24, this.progressBarFullID & 0xFFFFFF));
            if (image != null && image2 != null) {
                int n2 = (n - this.timeToProduce) * image.getHeight() / n;
                graphics.setClip(Constants.buildingPosition[this.positionID][4], Constants.buildingPosition[this.positionID][5] + (image.getHeight() - n2), image.getWidth(), n2);
                graphics.drawImage(image2, Constants.buildingPosition[this.positionID][4], Constants.buildingPosition[this.positionID][5], 0);
                graphics.setClip(0, 0, 240, 320);
            }
            if (this.workAnimation != null) {
                this.workAnimation.draw(graphics);
            }
        }
    }

    public void setTransferCount(int n) {
        this.transferCount = n;
    }

    protected void correctPosition() {
        if (this.positionType == 0 && this.currentUpgrade == 0) {
            this.screenX = Constants.buildingPosition[this.positionID][0] + (this.positionID < 3 ? 10 : 0);
            this.screenY = Constants.buildingPosition[this.positionID][1] - this.height;
            this.x = this.screenX << 11;
            this.y = this.screenY << 11;
        } else if (this.positionType == 1) {
            this.screenX = Constants.buildingPosition[this.positionID][8];
            this.screenY = Constants.buildingPosition[this.positionID][9] - this.height;
            this.x = this.screenX << 11;
            this.y = this.screenY << 11;
        }
        this.buildingAnimation.updateAnimationPosition(this.screenX, this.screenY + this.appearingYOffset);
        if (this.currentUpgrade == 0 && this.productIcon != null) {
            this.productIcon.updateAnimationPosition(this.screenX + 2, this.screenY + 2 - this.appearingYOffset);
        }
    }

    public void addSource() {
        ++this.sourceCount;
        if (this.sourceCount >= this.transferCount) {
            this.startProducing();
        }
    }

    public int getProductNeedType() {
        return Constants.producingBuildingProduceMap[this.currentBuildingType][0];
    }

    public int getProductNeedSecondType() {
        return this.sourceTypeCount > 1 ? Constants.producingBuildingProduceMap[this.currentBuildingType][1] : -1;
    }

    public void setupAppearance() {
        this.isAppearing = true;
        this.appearingYOffset = 400;
    }

    public void startProducing() {
        this.isWorking = true;
        this.timeToProduce = Constants.producingBuildingTime[this.currentUpgrade] << 11;
        if (++now_producing_buiding >= 6) {
            AwardsViewScreen.setAward(12);
        }
        if (this.workAnimation != null) {
            this.workAnimation.resetAnimation();
        }
    }

    public void setAnimation(TiledAnimation tiledAnimation, TiledAnimation tiledAnimation2) {
        this.buildingAnimation = tiledAnimation;
        this.width = this.buildingAnimation.animationWidth;
        this.height = this.buildingAnimation.animationHeight;
        if (tiledAnimation2 == null) {
            this.buildingAnimation.setFrameToDraw(this.currentBuildingType * 5 + this.currentUpgrade - 1);
        } else {
            this.buildingAnimation.setFrameToDraw(0);
        }
        this.buildingAnimation.updateAnimationPosition(this.screenX, this.screenY + this.appearingYOffset);
        if (tiledAnimation2 != null) {
            this.productIcon = tiledAnimation2;
            this.productIcon.setFrameToDraw(Constants.producingBuildingProduceMap[this.currentBuildingType][2]);
        }
    }

    public void setPosition(int n) {
        super.setPosition(n);
        this.correctPosition();
    }

    public void setUpdateEnabled(boolean bl) {
        this.isUpdateEnabled = bl;
    }

    public void tick(long l) {
        if (!this.isUpdateEnabled) {
            return;
        }
        this.tryAddUpgradeButton();
        if (this.isAppearing) {
            this.appearanceDelay = (int)((long)this.appearanceDelay - l);
            if (this.appearanceDelay > 0) {
                return;
            }
            this.appearingYOffset = (int)((long)this.appearingYOffset - 400L * l / 1000L);
            if (this.appearingYOffset < 0) {
                this.isAppearing = false;
                this.appearingYOffset = 0;
                if (this.currentUpgrade == 0 && GameScreen.getCurrentLevel() == 2 && this.callbackParent != null) {
                    this.callbackParent.onShowHint(19, this.screenX + this.width / 2, this.screenY + this.height / 2, false);
                }
                if (this.currentBuildingType == 0 && this.currentUpgrade > 0 && this.callbackParent != null) {
                    this.callbackParent.onShowHint(20, this.screenX + this.width / 2, this.screenY + this.height / 2, false);
                }
            }
            if (this.buildingAnimation != null) {
                this.buildingAnimation.updateAnimationPosition(this.screenX, this.screenY - this.appearingYOffset);
            }
            if (this.currentUpgrade == 0 && this.productIcon != null) {
                this.productIcon.updateAnimationPosition(this.screenX + 2, this.screenY + 2 - this.appearingYOffset);
            }
            if (this.upgradeButtonState && this.upgradeButton != null) {
                this.upgradeButton.updateButtonPosition(Constants.buildingPosition[this.positionID][2], Constants.buildingPosition[this.positionID][3] - this.appearingYOffset);
            }
            return;
        }
        if (this.isWorking) {
            if (this.workAnimation != null) {
                this.workAnimation.updateAnimation(l);
            }
            int n = 2048;
            int n2 = 120;
            if (this.hardWorkTimer >= 0) {
                this.hardWorkTimer = (int)((long)this.hardWorkTimer - (l << 11) / 1000L);
                n += 682;
                int n3 = n2 = this.hardWorkTimer > 1024 ? 80 : 100;
            }
            if (this.currentAnimationSpeed != n2) {
                this.currentAnimationSpeed = n2;
                this.buildingAnimation.setAnimationFrameDelay(this.currentAnimationSpeed);
            }
            this.timeToProduce = (int)((long)this.timeToProduce - (long)n * l / 1000L);
            if (this.timeToProduce <= 0) {
                this.isWorking = false;
                --now_producing_buiding;
                this.createProduct();
                this.sourceCount = 0;
                this.transferCount = 0;
            }
        }
    }

    public void resetUpgradeToNull() {
        this.positionType = 1;
        if (this.currentUpgrade > 0) {
            super.upgradeBuilding(0);
            this.isWorking = false;
            this.sourceCount = 0;
            this.transferCount = 0;
            this.upgradeCost = Constants.producingBuildingCost[this.currentBuildingType][this.currentUpgrade];
            this.correctPosition();
        }
    }

    public void tryAddUpgradeButton() {
        if (this.currentUpgrade > 0 && this.currentUpgrade < GameShopScreen.currentShopState[this.currentBuildingType][0]) {
            this.upgradeButtonState = true;
            if (this.upgradeButton != null) {
                if (GameScreen.currentLevelMoney >= Constants.producingBuildingCost[this.currentBuildingType][this.currentUpgrade + 1]) {
                    this.upgradeButton.setEnabled(true);
                } else {
                    this.upgradeButton.setEnabled(false);
                }
                this.upgradeButton.setFocused(false);
            }
        }
    }

    public void upgradeBuilding(int n) {
        if (n <= 0 && this.currentUpgrade <= 0) {
            return;
        }
        if (!GameScreen.isMoneyEnought(Constants.producingBuildingCost[this.currentBuildingType][this.currentUpgrade + 1])) {
            if (this.callbackParent != null) {
                this.callbackParent.onShowHint(23, -1, -1, false);
            }
            return;
        }
        if (this.neighbourBuilding != null && this.neighbourBuilding.isAppearing) {
            return;
        }
        this.currentUpgrade = (byte)(n > 0 ? this.currentUpgrade + n : 0);
        if (this.currentUpgrade > 0 && this.neighbourBuilding != null) {
            this.positionType = 0;
            this.neighbourBuilding.resetUpgradeToNull();
        }
        if (this.callbackParent != null && this.currentUpgrade == 1) {
            this.callbackParent.onUpdateBuildingAnimation(this.controlID, this.positionID, this.positionType, this.currentBuildingType, this.currentUpgrade);
        }
        this.upgradeButtonState = false;
        this.correctPosition();
        if (this.neighbourBuilding != null) {
            this.neighbourBuilding.correctPosition();
        }
    }

    public void createProduct() {
        if (this.callbackParent != null) {
            int n = -1;
            while (++n < this.transferCount) {
                this.callbackParent.produceProduct(Constants.producingBuildingProduceMap[this.currentBuildingType][2], Constants.buildingPosition[this.positionID][10] + MathExt.rnd() % 4, Constants.buildingPosition[this.positionID][11] + MathExt.rnd() % 4, 0);
            }
        }
    }

    public void setBuildingParams(int n, boolean bl, int n2) {
        this.transferCount = n;
        this.isWorking = bl;
        this.timeToProduce = n2;
    }

    public boolean keyReleased(int n) {
        boolean bl = false;
        if (n == 6 && this.currentUpgrade > 0 && !this.isAppearing) {
            if (this.isWorking) {
                this.hardWorkTimer = this.hardWorkTimer <= 0 ? 409 : (this.hardWorkTimer += 409);
            } else if (this.transferCount <= 0) {
                this.callbackParent.onBuildingProductRequest(this.controlID, Constants.producingBuildingProduceMap[this.currentBuildingType][0], Constants.producingBuildingProduceMap[this.currentBuildingType][1], this.currentUpgrade);
            }
        }
        return bl;
    }

    public boolean pointerReleased(int n, int n2) {
        if (!this.isUpdateEnabled) {
            return false;
        }
        if (super.pointerReleased(n, n2)) {
            if (this.currentUpgrade == 0) {
                this.upgradeBuilding(1);
                return true;
            }
            if (this.currentUpgrade > 0 && !this.isAppearing) {
                if (this.isWorking) {
                    this.hardWorkTimer = this.hardWorkTimer <= 0 ? 409 : (this.hardWorkTimer += 409);
                } else if (this.transferCount <= 0) {
                    this.callbackParent.onBuildingProductRequest(this.controlID, Constants.producingBuildingProduceMap[this.currentBuildingType][0], Constants.producingBuildingProduceMap[this.currentBuildingType][1], this.currentUpgrade);
                }
            }
            return true;
        }
        return false;
    }
}

