/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.Game;

import com.spl.j2me.Game.AnimalBase;
import com.spl.j2me.Game.Constants;
import com.spl.j2me.Game.GameGrass;
import com.spl.j2me.Game.GameScreen;
import com.spl.j2me.Game.MathExt;
import com.spl.j2me.RM.ResourceManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ProducingAnimal
extends AnimalBase {
    public static byte ANIMAL_PARAM_SPEED = 0;
    public static byte ANIMAL_PARAM_HUNGRY_MOVING_SPEED = 1;
    public static byte ANIMAL_PARAM_PRODUCTION_PERIOD = (byte)2;
    public static byte ANIMAL_PARAM_ONE_TIME_BYTE = (byte)3;
    public static byte ANIMAL_PARAM_BITE_WAIT_TIME = (byte)4;
    public static byte ANIMAL_PARAM_HUNGRY_SPEED = (byte)5;
    public static byte ANIMAL_PARAM_HUNGRY_VALUE = (byte)6;
    public static byte ANIMAL_PARAM_CAR_SIZE = (byte)7;
    public static byte ANIMAL_GOAL_ID = (byte)8;
    public static int[][] animalsParams = new int[][]{{25, 55, 40960, 20480, 2, 6144, 102400, 5, 17}, {25, 55, 40960, 20480, 2, 20480, 409600, 2, 18}, {25, 55, 40960, 20480, 2, 40960, 1024000, 1, 19}, {25, 55, 40960, 20480, 2, 40960, 1024000, 2, 20}};
    private boolean isEating = false;
    private int currentMeal;
    private int deathTimer = 0;
    private int biteTimer = 0;
    private int producingTimer = -MathExt.rnd() % 12288;
    public GameGrass currentGrass;
    protected int progressBarID;
    protected boolean bFromSave;

    public ProducingAnimal(int n, int n2, boolean bl) {
        super(n, n2);
        this.currentGrass = null;
        this.currentMovingSpeed = (byte)animalsParams[n2][ANIMAL_PARAM_SPEED];
        this.currentMeal = animalsParams[n2][ANIMAL_PARAM_HUNGRY_VALUE];
        this.bFromSave = bl;
    }

    public ProducingAnimal(ProducingAnimal producingAnimal, int n) {
        super(producingAnimal, n);
        this.animalType = this.animalType;
        this.currentGrass = null;
        this.currentMovingSpeed = producingAnimal.currentMovingSpeed;
        this.currentMeal = producingAnimal.currentMeal;
    }

    public void tick(long l) {
        int n;
        byte by = this.currentMovingDirection;
        super.tick(l);
        if (this.currentMovingDirection != by && this.currentGrass != null) {
            this.currentGrass = null;
        }
        if (this.isAppearing || this.isDroppedOut) {
            return;
        }
        if (this.appearingYOffset < 0) {
            this.appearingYOffset = 0;
            if (this.callbackParent != null) {
                this.callbackParent.onShowHint(this.animalType, this.screenX + this.width / 2, this.screenY + this.height / 2, false);
            }
            if (!this.bFromSave) {
                GameScreen.updateCurrentLevelState(animalsParams[this.animalType][ANIMAL_GOAL_ID], 1);
            }
        }
        if (!this.isEating) {
            this.currentMeal = (int)((long)this.currentMeal - (long)animalsParams[this.animalType][ANIMAL_PARAM_HUNGRY_SPEED] * l / 1000L);
        }
        if (this.currentMeal < animalsParams[this.animalType][ANIMAL_PARAM_HUNGRY_VALUE] * 40 / 100 && this.currentGrass == null) {
            this.callbackParent.onHungry(this.animalType, this.controlID);
            this.currentMovingSpeed = animalsParams[this.animalType][ANIMAL_PARAM_HUNGRY_MOVING_SPEED];
            n = -1;
        }
        if (this.currentMeal <= 0 && !this.isEating) {
            this.deathTimer = 3072;
            this.isEating = true;
            this.isMoveEnabled = false;
            this.animalAnimation.setAnimationSequence(Constants.animalBehaviorAnimeSeq[this.animalType][Constants.animalBehaviorData[this.animalType][this.currentMovingDirection > 4 ? 10 : 11][0]]);
            this.animalAnimation.setAnimationTransform(Constants.animalBehaviorData[this.animalType][this.currentMovingDirection > 4 ? 10 : 11][1] == 1 ? 2 : 0);
            this.animalAnimation.updateAnimationPosition(this.screenX, this.screenY);
            this.animalAnimation.setAnimationFrameDelay(3072 / Constants.animalBehaviorAnimeSeq[this.animalType][Constants.animalBehaviorData[this.animalType][this.currentMovingDirection > 4 ? 10 : 11][0]].length);
            n = -1;
        }
        if (this.currentMeal <= 0 && this.deathTimer >= 0) {
            this.deathTimer = (int)((long)this.deathTimer - (l << 11) / 1000L);
        }
        if (this.deathTimer < 0) {
            this.callbackParent.onComplete(1, this.animalType, this.controlID);
            return;
        }
        if (this.currentGrass != null) {
            this.feedProcess();
            if (this.biteTimer > 0) {
                this.biteTimer = (int)((long)this.biteTimer - (l << 11) / 1000L);
            }
        }
        if (this.currentGrass != null && this.currentMeal >= animalsParams[this.animalType][ANIMAL_PARAM_HUNGRY_VALUE]) {
            this.feed();
        }
        this.checkProducing();
        this.producingTimer = (int)((long)this.producingTimer + (l << 11) / 1000L);
    }

    public void setProgressBarImage(int n) {
        this.progressBarID = n;
    }

    public void checkProducing() {
        if (this.producingTimer >= animalsParams[this.animalType][ANIMAL_PARAM_PRODUCTION_PERIOD]) {
            this.producingTimer = -MathExt.rnd() % 12288;
            this.callbackParent.produceProduct(Constants.animalProducing[this.animalType], this.screenX, this.screenY, 0);
        }
    }

    public void RemoveGrass(int n) {
        if (this.currentGrass != null && this.currentGrass.controlID == n) {
            this.feed();
        }
    }

    private void feed() {
        this.isMoveEnabled = true;
        this.currentGrass = null;
        this.currentMovingSpeed = animalsParams[this.animalType][ANIMAL_PARAM_SPEED];
        this.biteTimer = 0;
        this.isEating = false;
        this.animalAnimation.setAnimationFrameDelay(120);
        this.updateModel();
    }

    private void feedProcess() {
        this.changeDirectionTimer = AnimalBase.ANIMAL_CHANGE_DIRECTION_PERIOD;
        if (this.currentGrass != null && this.currentGrass.isIntersected(this.screenX + this.width / 2 - 8, this.screenY + this.height - 8, 4, 4)) {
            if (!this.isEating) {
                this.isEating = true;
                this.animalAnimation.setAnimationSequence(Constants.animalBehaviorAnimeSeq[this.animalType][Constants.animalBehaviorData[this.animalType][this.currentMovingDirection > 4 ? 8 : 9][0]]);
                this.animalAnimation.setAnimationTransform(Constants.animalBehaviorData[this.animalType][this.currentMovingDirection > 4 ? 8 : 9][1] == 1 ? 2 : 0);
                this.animalAnimation.updateAnimationPosition(this.screenX, this.screenY);
                this.animalAnimation.setAnimationFrameDelay(240);
            }
            this.isMoveEnabled = false;
            if (this.biteTimer <= 0) {
                this.currentMeal += this.currentGrass.bite(animalsParams[this.animalType][ANIMAL_PARAM_ONE_TIME_BYTE]);
                this.biteTimer = animalsParams[this.animalType][ANIMAL_PARAM_BITE_WAIT_TIME] << 11;
            }
        }
    }

    public void setGrass(GameGrass gameGrass) {
        if (gameGrass != null) {
            this.currentGrass = gameGrass;
            int[] nArray = gameGrass.getPosition();
            int n = Math.abs(this.screenX + this.width / 2 - 8 - nArray[0]);
            int n2 = Math.abs(this.screenY + this.height - 8 - nArray[1]);
            int n3 = MathExt.sqrt(n * n + n2 * n2);
            this.movingDirectionX = ((nArray[0] << 11) - (this.screenX + this.width / 2 - 8 << 11)) / n3;
            this.movingDirectionY = ((nArray[1] << 11) - (this.screenY + this.height - 8 << 11)) / n3;
            this.currentAngle = this.countAngle(this.movingDirectionX, this.movingDirectionY);
            this.currentMovingDirection = super.getDirection(this.currentMovingDirection);
            super.updateModel();
        }
    }

    public void draw(Graphics graphics) {
        super.draw(graphics);
        Image image = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(this.progressBarID >> 24, this.progressBarID & 0xFFFFFF));
        if (!this.isAppearing && image != null) {
            Image image2 = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(this.appearingShadowID >> 24, this.appearingShadowID & 0xFFFFFF));
            graphics.drawImage(image2, this.screenX + (this.width - image2.getWidth()) / 2, this.screenY + this.height - image2.getHeight(), 0);
            int n = image.getWidth() * this.currentMeal / animalsParams[this.animalType][ANIMAL_PARAM_HUNGRY_VALUE];
            graphics.setClip(this.screenX + (this.width - image.getWidth()) / 2, this.screenY + this.height, n, image.getHeight());
            graphics.drawImage(image, this.screenX + (this.width - image.getWidth()) / 2, this.screenY + this.height, 0);
            graphics.setClip(0, 0, 240, 320);
        }
    }
}

