/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.Game;

import com.spl.j2me.Game.Constants;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class MathExt
implements Constants {
    public static final int PPOW = 11;
    public static final int PREC = 2048;
    public static final int COS_PERIOD = 8192;
    public static final int COS_PERIOD_MASK = 8191;
    public static final int PI = 4096;
    public static final int HALF_PI = 2048;
    public static int[] COS;
    public static final int AMPL = 2048;
    public static int[] ACOS;
    public static final int ACOS_NUM = 2049;
    private static int prevRnd;

    public static void init(byte[] byArray) {
        int n;
        COS = new int[2049];
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            for (n = 0; n < 2049; ++n) {
                MathExt.COS[n] = dataInputStream.readShort() * 2048 / Short.MAX_VALUE;
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ACOS = new int[2049];
        int n2 = COS.length;
        block3: for (n = 0; n < 2049; ++n) {
            while (n2-- > 0) {
                if (COS[n2] < n * 2048 / 2048) continue;
                MathExt.ACOS[n] = n2;
                continue block3;
            }
        }
        prevRnd = (int)System.currentTimeMillis();
    }

    public static void init(DataInputStream dataInputStream) {
        int n;
        COS = new int[2049];
        try {
            for (n = 0; n < 2049; ++n) {
                MathExt.COS[n] = dataInputStream.readShort() * 2048 / Short.MAX_VALUE;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ACOS = new int[2049];
        n = COS.length;
        block3: for (int i = 0; i < 2049; ++i) {
            while (n-- > 0) {
                if (COS[n] < i * 2048 / 2048) continue;
                MathExt.ACOS[i] = n;
                continue block3;
            }
        }
    }

    public static int cos(int n) {
        switch ((n &= 0x1FFF) >> 11) {
            case 0: {
                return COS[n];
            }
            case 1: {
                return -COS[4096 - n];
            }
            case 2: {
                return -COS[n - 4096];
            }
            case 3: {
                return COS[8192 - n];
            }
        }
        return 0;
    }

    public static int sin(int n) {
        n = n - 2048 & 0x1FFF;
        switch (n >> 11) {
            case 0: {
                return COS[n];
            }
            case 1: {
                return -COS[4096 - n];
            }
            case 2: {
                return -COS[n - 4096];
            }
            case 3: {
                return COS[8192 - n];
            }
        }
        return 0;
    }

    public static int rnd() {
        prevRnd = prevRnd * 125 % 0x2AAAAB;
        return Math.abs(prevRnd) - 1;
    }

    public static int sqrt(int n) {
        int n2 = 46340;
        int n3 = 0;
        int n4 = n2 + n3 >> 1;
        int n5 = n4 * n4;
        while (n2 != n4 && n3 != n4) {
            if (n5 > n) {
                n2 = n4;
            } else {
                n3 = n4;
            }
            n4 = n2 + n3 >> 1;
            n5 = n4 * n4;
        }
        return n4;
    }

    static {
        prevRnd = -1;
    }
}

