/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.Game;

import com.spl.j2me.Animation.AnimatedBackground;
import com.spl.j2me.Animation.TiledAnimation;
import com.spl.j2me.GUIIC.ControlContainer;
import com.spl.j2me.GUIIC.FontManager;
import com.spl.j2me.GUIIC.Handler;
import com.spl.j2me.Game.CarViewElement;
import com.spl.j2me.Game.Constants;
import com.spl.j2me.Game.FarmContainer;
import com.spl.j2me.Game.ProducingAnimal;
import com.spl.j2me.Game.ProfileViewScreen;
import com.spl.j2me.Game.TextScrollControl;
import com.spl.j2me.Game.TiledButtonControl;
import com.spl.j2me.Game.TiledControl;
import com.spl.j2me.RM.ResourceManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CarView
extends ControlContainer
implements Handler,
Constants {
    private AnimatedBackground background;
    private CarViewElement[] products;
    private int cellBackgroundID;
    private int selectedItem;
    private boolean selectedSingle;
    private boolean refreshFocused;
    private boolean sendFocused;
    TiledAnimation productContent;
    TiledAnimation animalContent;
    TiledAnimation listBackground;
    TiledAnimation buttonBackground;
    TiledAnimation scrollBar;
    protected int coinImageID;
    private int[] productCount;
    public int[] selledProducts;
    private int[] animalCount;
    public int[] selledAnimals;
    private int carType;
    private int carCellCount;
    private int[] carCells = new int[7];
    private int[] carCellsCurrentSize = new int[7];
    public int moneyCount = 0;
    private TiledButtonControl[] cellButtons = new TiledButtonControl[7];
    private int currentVisibleProductItem = 0;
    private int currentProductItemCount = 0;
    protected boolean carIsWorking = false;
    protected static final int TAB_CONTROL_ID = 256;
    protected ControlContainer hintPopup;
    protected int currentHintID = -1;
    protected boolean hintShown = false;

    public CarView(int n, Handler handler) {
        super(n, handler);
        this.listBackground = new TiledAnimation(-1, false);
        this.buttonBackground = new TiledAnimation(-1, false);
        int n2 = -1;
        while (++n2 < this.cellButtons.length) {
            this.cellButtons[n2] = new TiledButtonControl(0x20000 | n2, -1, 0, 0);
            this.cellButtons[n2].setControlItemRect(new int[]{0, 0, 18, 19});
            this.cellButtons[n2].setEnabled(false);
            this.addItem(this.cellButtons[n2]);
            this.cellButtons[n2].setHandler(this);
        }
        this.productCount = new int[25];
        this.selledProducts = new int[25];
        this.animalCount = new int[4];
        this.selledAnimals = new int[4];
    }

    public void setCellBackground(int n) {
        this.cellBackgroundID = n;
    }

    public void setScrollBar(TiledAnimation tiledAnimation) {
        this.scrollBar = tiledAnimation;
    }

    public void setHintPopup(ControlContainer controlContainer) {
        this.hintPopup = controlContainer;
    }

    public void setupHintPopup(int n) {
        int n2;
        if (ProfileViewScreen.currentPlayerHintShown[n]) {
            return;
        }
        ProfileViewScreen.currentPlayerHintShown[n] = true;
        this.currentHintID = n;
        if (Constants.hintData[n][0] == -1) {
            return;
        }
        int n3 = Constants.hintData[this.currentHintID][2];
        int n4 = Constants.hintData[this.currentHintID][3];
        int n5 = n2 = n3 < 120 ? 0 : 1;
        n3 = n2 == 0 ? (n3 += 4) : (n3 -= 120);
        n4 = (n2 += n4 < 160 ? 0 : 2) < 2 ? (n4 += 4) : (n4 -= 160);
        ((TiledControl)this.hintPopup.getItem(0)).setArrowPosition(n2);
        ((TextScrollControl)this.hintPopup.getItem(1)).setTextID(Constants.hintData[n][0]);
        this.hintPopup.setControlItemRect(new int[]{n3, n4, 116, 156});
        this.setPopupWindow(this.hintPopup);
        this.hintShown = true;
    }

    public void setupListBackground() {
    }

    public void setCoinImage(int n) {
        this.coinImageID = n;
    }

    public void initProductList() {
        this.products = new CarViewElement[29];
        int n = -1;
        while (++n < 25) {
            this.products[n] = new CarViewElement(n, this);
            this.products[n].setScrollStep(0, 31);
            this.products[n].setControlItemRect(new int[]{0, 0, 205, 31});
        }
        n = 24;
        while (++n < 29) {
            this.products[n] = new CarViewElement(n, this);
            this.products[n].setScrollStep(0, 31);
            this.products[n].setControlItemRect(new int[]{0, 0, 205, 31});
        }
    }

    public void open() {
        super.open();
        this.moneyCount = 0;
        this.currentVisibleProductItem = 0;
        TiledButtonControl tiledButtonControl = (TiledButtonControl)this.getItem(8);
        tiledButtonControl.setEnabled(false);
        int n = -1;
        while (++n < this.productCount.length) {
            if (this.productCount[0] <= 0) continue;
            this.setupHintPopup(14);
        }
        this.selectedSingle = true;
        this.selectedItem = 0;
        this.refreshFocused = false;
        this.sendFocused = false;
        this.getItem(10).setFocused(false);
        this.getItem(8).setFocused(false);
        this.updateProductList();
    }

    public void close() {
        super.close();
    }

    public void setCarWorkingState(boolean bl) {
        this.carIsWorking = bl;
    }

    public void setCarType(int n) {
        this.carType = n - 1;
        this.carCellCount = Constants.supportBuildingData[0][this.carType][1];
        int n2 = -1;
        while (++n2 < this.carCellCount) {
            this.carCells[n2] = 0;
            this.carCellsCurrentSize[n2] = 0;
        }
        n2 = -1;
        while (++n2 < this.cellButtons.length) {
            if (n2 < this.carCellCount) {
                this.cellButtons[n2].updateButtonPosition(Constants.carCellPosition[this.carType][n2][0], Constants.carCellPosition[this.carType][n2][1]);
                this.cellButtons[n2].setEnabled(true);
                continue;
            }
            this.cellButtons[n2].setEnabled(false);
        }
    }

    private void updateProductList() {
        int n = this.currentVisibleProductItem;
        this.currentProductItemCount = 0;
        int n2 = -1;
        while (++n2 < 25) {
            if (this.productCount[n2] <= 0) continue;
            ++this.currentProductItemCount;
        }
        n2 = -1;
        while (++n2 < 4) {
            if (this.animalCount[n2] <= 0) continue;
            ++this.currentProductItemCount;
        }
        if (this.currentProductItemCount > 6) {
            while (n + 6 > this.currentProductItemCount) {
                --n;
            }
        } else if (this.currentProductItemCount == 6 && n > 0) {
            n = 0;
        }
        this.currentVisibleProductItem = n;
        n2 = -n;
        int n3 = 0;
        int n4 = -1;
        while (++n4 < 25) {
            if (this.productCount[n4] > 0) {
                if (n2 >= 0 && n3 < 6 && n3 < this.currentProductItemCount) {
                    ((TiledButtonControl)this.products[n4].getItem(0)).setEnabled(true);
                    ((TiledButtonControl)this.products[n4].getItem(1)).setEnabled(true);
                    this.products[n4].close();
                    this.products[n4].updatePosition(17, 20 + n2 * 33);
                    this.products[n4].open();
                    this.products[n4].updateCount(this.productCount[n4]);
                    this.products[n4].setForceHide(false);
                    ++n3;
                } else {
                    this.products[n4].setForceHide(true);
                }
                ++n2;
                continue;
            }
            this.products[n4].setForceHide(true);
        }
        n4 = 24;
        while (++n4 < 29) {
            if (this.animalCount[n4 - 25] > 0) {
                if (n2 >= 0 && n3 < 6 && n3 < this.currentProductItemCount) {
                    ((TiledButtonControl)this.products[n4].getItem(0)).setEnabled(true);
                    ((TiledButtonControl)this.products[n4].getItem(1)).setEnabled(true);
                    this.products[n4].close();
                    this.products[n4].updatePosition(17, 20 + n2 * 33);
                    this.products[n4].open();
                    this.products[n4].updateCount(this.animalCount[n4 - 25]);
                    this.products[n4].setForceHide(false);
                    ++n3;
                } else {
                    this.products[n4].setForceHide(true);
                }
                ++n2;
                continue;
            }
            this.products[n4].setForceHide(true);
        }
        while (this.selectedItem > this.currentProductItemCount - 1) {
            --this.selectedItem;
        }
        if (this.currentProductItemCount == 0) {
            ++this.selectedItem;
            this.refreshFocused = true;
            this.getItem(10).setFocused(true);
        }
    }

    public void setProductData(int[] nArray) {
        int n = -1;
        while (++n < nArray.length) {
            this.productCount[n] = nArray[n];
            this.selledProducts[n] = 0;
        }
        this.updateProductList();
    }

    public void setAnimalData(int[] nArray) {
        int n = -1;
        while (++n < nArray.length) {
            this.animalCount[n] = nArray[n];
            this.selledAnimals[n] = 0;
        }
        this.updateProductList();
    }

    private int fillCarCells(int n, int n2) {
        int n3 = 0;
        int n4 = n2;
        int n5 = 0;
        n5 = (n & 0xF0000) == 0 ? Constants.productData[n][2] : ProducingAnimal.animalsParams[n & 0xFFFF][ProducingAnimal.ANIMAL_PARAM_CAR_SIZE];
        int n6 = -1;
        while (++n6 < this.carCellCount) {
            if (n3 < n2) {
                if (this.carCellsCurrentSize[n6] == 0) {
                    this.carCells[n6] = n;
                    if (n4 > n5) {
                        this.carCellsCurrentSize[n6] = n5;
                        n4 -= n5;
                        n3 += n5;
                        this.moneyCount += n > 65535 ? n5 * Constants.animalPrice[n & 0xFFFF] / 2 : n5 * Constants.productData[n][0];
                        continue;
                    }
                    this.carCellsCurrentSize[n6] = n4;
                    n3 += n4;
                    this.moneyCount += n > 65535 ? n4 * Constants.animalPrice[n & 0xFFFF] / 2 : n4 * Constants.productData[n][0];
                    continue;
                }
                if (this.carCells[n6] != n) continue;
                if (n4 > n5 - this.carCellsCurrentSize[n6]) {
                    n4 -= n5 - this.carCellsCurrentSize[n6];
                    this.moneyCount += n > 65535 ? (n5 - this.carCellsCurrentSize[n6]) * Constants.animalPrice[n & 0xFFFF] / 2 : (n5 - this.carCellsCurrentSize[n6]) * Constants.productData[n][0];
                    n3 += n5 - this.carCellsCurrentSize[n6];
                    int n7 = n6;
                    this.carCellsCurrentSize[n7] = this.carCellsCurrentSize[n7] + (n5 - this.carCellsCurrentSize[n6]);
                    continue;
                }
                int n8 = n6;
                this.carCellsCurrentSize[n8] = this.carCellsCurrentSize[n8] + n4;
                n3 += n4;
                this.moneyCount += n > 65535 ? n4 * Constants.animalPrice[n & 0xFFFF] / 2 : n4 * Constants.productData[n][0];
                continue;
            }
            return n3;
        }
        return n3;
    }

    public void handle(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n3 == -1) {
            return;
        }
        switch (n4) {
            case 256: {
                this.hintShown = false;
                this.removePopupWindow();
                if (Constants.hintData[this.currentHintID][1] == -1) break;
                this.currentHintID = Constants.hintData[this.currentHintID][1];
                this.setupHintPopup(this.currentHintID);
                break;
            }
            default: {
                int n5;
                if (this.carIsWorking) {
                    return;
                }
                int n6 = n4;
                if (n6 >> 16 == 0) {
                    n5 = n3;
                    int n7 = n6 % 2;
                    int n8 = n7 == 0 ? 1 : this.productCount[n5];
                    n8 = this.fillCarCells(n5, n8);
                    int n9 = n5;
                    this.productCount[n9] = this.productCount[n9] - n8;
                    int n10 = n5;
                    this.selledProducts[n10] = this.selledProducts[n10] + n8;
                    if (this.productCount[n5] == 0) {
                        this.products[n5].getItem(0).setEnabled(false);
                        this.products[n5].getItem(1).setEnabled(false);
                    }
                    this.products[n5].updateCount(this.productCount[n5]);
                } else if (n6 >> 16 == 1) {
                    n5 = n3 - 25;
                    int n11 = (n6 &= 0xFFFF) % 2;
                    int n12 = n11 == 0 ? 1 : this.animalCount[n5];
                    n12 = this.fillCarCells(n5 | 0x10000, n12);
                    int n13 = n5;
                    this.animalCount[n13] = this.animalCount[n13] - n12;
                    int n14 = n5;
                    this.selledAnimals[n14] = this.selledAnimals[n14] + n12;
                    if (this.animalCount[n5] == 0) {
                        this.products[n5].getItem(0).setEnabled(false);
                        this.products[n5].getItem(1).setEnabled(false);
                    }
                    this.products[n5].updateCount(this.animalCount[n5]);
                } else if (n6 >> 16 == 2) {
                    if (this.carCells[n6 &= 0xFFFF] > 65535) {
                        n5 = this.carCells[n6] & 0xFFFF;
                        this.carCells[n6] = 0;
                        int n15 = this.carCellsCurrentSize[n6];
                        this.carCellsCurrentSize[n6] = 0;
                        if (this.animalCount[n5] == 0) {
                            // empty if block
                        }
                        this.moneyCount -= n15 * Constants.animalPrice[n5] / 2;
                        int n16 = n5;
                        this.animalCount[n16] = this.animalCount[n16] + n15;
                        int n17 = n5;
                        this.selledAnimals[n17] = this.selledAnimals[n17] - n15;
                    } else {
                        n5 = this.carCells[n6];
                        this.carCells[n6] = 0;
                        int n18 = this.carCellsCurrentSize[n6];
                        this.carCellsCurrentSize[n6] = 0;
                        this.moneyCount -= n18 * Constants.productData[n5][0];
                        int n19 = n5;
                        this.productCount[n19] = this.productCount[n19] + n18;
                        int n20 = n5;
                        this.selledProducts[n20] = this.selledProducts[n20] - n18;
                    }
                }
                if (this.moneyCount > 0) {
                    TiledButtonControl tiledButtonControl = (TiledButtonControl)this.getItem(8);
                    tiledButtonControl.setEnabled(true);
                } else {
                    TiledButtonControl tiledButtonControl = (TiledButtonControl)this.getItem(8);
                    tiledButtonControl.setEnabled(false);
                }
                this.updateProductList();
            }
        }
    }

    public void setProductContent(TiledAnimation tiledAnimation) {
        this.productContent = tiledAnimation;
        int n = -1;
        while (++n < 25) {
            TiledAnimation tiledAnimation2 = new TiledAnimation(tiledAnimation, -1);
            tiledAnimation2.updateAnimationPosition(2, (31 - tiledAnimation2.animationHeight) / 2);
            this.products[n].setContent(tiledAnimation2, n);
            this.products[n].setContentPrice(Constants.productData[n][0], this.coinImageID, 82, 64);
        }
    }

    public void setAnimalContent(TiledAnimation tiledAnimation) {
        this.animalContent = tiledAnimation;
        int n = 24;
        while (++n < 29) {
            TiledAnimation tiledAnimation2 = new TiledAnimation(tiledAnimation, -1);
            tiledAnimation2.updateAnimationPosition(2, (31 - tiledAnimation2.animationHeight) / 2);
            this.products[n].setContent(tiledAnimation2, n);
            this.products[n].setContentPrice(Constants.animalPrice[n - 25] / 2, this.coinImageID, 82, 64);
        }
    }

    public void setButtons(TiledButtonControl tiledButtonControl, TiledButtonControl tiledButtonControl2) {
        int n = -1;
        while (++n < 25) {
            this.products[n].addButton(new TiledButtonControl(tiledButtonControl, 2 * n, -1, 1));
            this.products[n].addButton(new TiledButtonControl(tiledButtonControl2, 2 * n + 1, 91, 1));
        }
        n = 24;
        while (++n < 29) {
            int n2 = n - 25;
            this.products[n].addButton(new TiledButtonControl(tiledButtonControl, 0x10000 | 2 * n2, -1, 1));
            this.products[n].addButton(new TiledButtonControl(tiledButtonControl2, 0x10000 | 2 * n2 + 1, 91, 1));
        }
    }

    public static void drawFilledArea(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n;
        int n8 = n2;
        graphics.setColor(n5);
        graphics.drawRoundRect(n7++, n8++, n3 -= 2, n4 -= 2, 16, 16);
        graphics.setColor(n6);
        graphics.drawRoundRect(n7++, n8++, n3 -= 2, n4 -= 2, 16, 16);
        graphics.setColor(n5);
        graphics.fillRoundRect(n7++, n8++, --n3, --n4, 16, 16);
    }

    public void draw(Graphics graphics) {
        graphics.setColor(3185919);
        graphics.fillRect(0, 0, 240, 320);
        super.draw(graphics);
        int n = FontManager.getInstance(-1).getFontHeight(1);
        FontManager.getInstance(-1).drawString(graphics, 1, "" + FarmContainer.getLocaleString(88), 78, 16, 1);
        FontManager.getInstance(-1).drawString(graphics, 1, "" + FarmContainer.getLocaleString(89), 140, 16, 1);
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        while (++n4 < 6) {
            graphics.setColor(11099394);
            graphics.fillRoundRect(17, 20 + n4 * 33, 58, 32, 8, 8);
            graphics.setColor(11102466);
            graphics.fillRoundRect(76, 20 + n4 * 33, 149, 32, 8, 8);
            graphics.setColor(5318656);
            graphics.drawRoundRect(17, 20 + n4 * 33, 57, 31, 8, 8);
            graphics.drawRoundRect(76, 20 + n4 * 33, 148, 31, 8, 8);
        }
        graphics.setColor(0xFFFFFF);
        n4 = 16;
        if (this.selectedItem > 0 && !this.refreshFocused && !this.sendFocused) {
            graphics.fillTriangle(120, n4 - 6, 114, n4, 126, n4);
        }
        n4 += 204;
        if (this.selectedItem < this.currentProductItemCount - 1) {
            graphics.fillTriangle(120, n4 + 6, 114, n4, 126, n4);
        }
        while (n2 < 6 && n3 < this.products.length) {
            if (!this.products[n3].m_forceHide) {
                this.products[n3].draw(graphics);
                if (n2 == this.selectedItem - this.currentVisibleProductItem) {
                    if (this.selectedSingle) {
                        this.products[n3].getItem(0).setFocused(true);
                        this.products[n3].getItem(1).setFocused(false);
                    } else {
                        this.products[n3].getItem(0).setFocused(false);
                        this.products[n3].getItem(1).setFocused(true);
                    }
                } else {
                    this.products[n3].getItem(0).setFocused(false);
                    this.products[n3].getItem(1).setFocused(false);
                }
                ++n2;
            }
            ++n3;
        }
        if (!this.carIsWorking) {
            Image image = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(4, 0x1F0000));
            graphics.drawImage(image, 17, 216 + image.getHeight(), 0);
            FontManager.getInstance(-1).drawString(graphics, 0, "" + this.moneyCount, 17 + image.getWidth() * 3 / 2, 216 + image.getHeight() * 2 - (image.getHeight() - FontManager.getInstance(-1).getFontHeight(0)) / 2, 1);
            Image image2 = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(this.cellBackgroundID >> 24, this.cellBackgroundID & 0xFFFFFF));
            Image image3 = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(4, 0x3D0000));
            int n5 = -1;
            while (++n5 < Constants.carCellPosition[this.carType].length) {
                boolean bl2 = false;
                boolean bl3 = false;
                if (this.carCellsCurrentSize[n5] > 0) {
                    int n6;
                    if (image2 != null) {
                        graphics.drawImage(image2, Constants.carCellPosition[this.carType][n5][0], Constants.carCellPosition[this.carType][n5][1], 0);
                    }
                    if (this.carCells[n5] < 65535) {
                        graphics.setColor(65280);
                        n6 = 17 * this.carCellsCurrentSize[n5] / Constants.productData[this.carCells[n5]][2];
                        graphics.fillRoundRect(Constants.carCellPosition[this.carType][n5][0], Constants.carCellPosition[this.carType][n5][1] + 19 + 3, n6, 4, 4, 4);
                        graphics.setColor(0);
                        graphics.drawRoundRect(Constants.carCellPosition[this.carType][n5][0], Constants.carCellPosition[this.carType][n5][1] + 19 + 3, 17, 4, 4, 4);
                        this.productContent.setFrameToDraw(this.carCells[n5]);
                        this.productContent.updateAnimationPosition(Constants.carCellPosition[this.carType][n5][0] + (18 - this.productContent.animationWidth) / 2, Constants.carCellPosition[this.carType][n5][1] + (19 - this.productContent.animationHeight) / 2);
                        this.productContent.draw(graphics);
                        continue;
                    }
                    graphics.setColor(65280);
                    n6 = 17 * this.carCellsCurrentSize[n5] / ProducingAnimal.animalsParams[this.carCells[n5] & 0xFFFF][ProducingAnimal.ANIMAL_PARAM_CAR_SIZE];
                    graphics.fillRoundRect(Constants.carCellPosition[this.carType][n5][0], Constants.carCellPosition[this.carType][n5][1] + 19 + 3, n6, 4, 4, 4);
                    graphics.setColor(0);
                    graphics.drawRoundRect(Constants.carCellPosition[this.carType][n5][0], Constants.carCellPosition[this.carType][n5][1] + 19 + 3, 17, 4, 4, 4);
                    this.animalContent.setFrameToDraw(25 + this.carCells[n5] & 0xFFFF);
                    this.animalContent.updateAnimationPosition(Constants.carCellPosition[this.carType][n5][0], Constants.carCellPosition[this.carType][n5][1]);
                    this.animalContent.draw(graphics);
                    continue;
                }
                graphics.setColor(0);
                graphics.drawRoundRect(Constants.carCellPosition[this.carType][n5][0], Constants.carCellPosition[this.carType][n5][1] + 19 + 3, 17, 4, 4, 4);
                graphics.drawImage(image3, Constants.carCellPosition[this.carType][n5][0], Constants.carCellPosition[this.carType][n5][1], 0);
            }
        }
    }

    public void tick(long l) {
    }

    public void setBackground(AnimatedBackground animatedBackground) {
        this.background = animatedBackground;
    }

    public boolean keyPressed(int n) {
        boolean bl = false;
        if (this.popupWindow != null) {
            bl = this.popupWindow.keyPressed(n);
        }
        if (!bl) {
            switch (n) {
                case 4: {
                    if (this.sendFocused) {
                        --this.selectedItem;
                        this.sendFocused = false;
                        this.getItem(8).setFocused(false);
                        this.refreshFocused = true;
                        this.getItem(10).setFocused(true);
                        break;
                    }
                    if (this.refreshFocused && this.currentProductItemCount > 0) {
                        --this.selectedItem;
                        this.refreshFocused = false;
                        this.getItem(10).setFocused(false);
                        break;
                    }
                    if (this.selectedItem <= 0) break;
                    --this.selectedItem;
                    if (this.selectedItem >= this.currentVisibleProductItem) break;
                    --this.currentVisibleProductItem;
                    this.updateProductList();
                    break;
                }
                case 5: {
                    if (this.selectedItem < this.currentProductItemCount - 1) {
                        ++this.selectedItem;
                        if (this.selectedItem <= this.currentVisibleProductItem - 1 + 6) break;
                        ++this.currentVisibleProductItem;
                        this.updateProductList();
                        break;
                    }
                    if (!this.refreshFocused && !this.sendFocused) {
                        ++this.selectedItem;
                        this.refreshFocused = true;
                        this.getItem(10).setFocused(true);
                        break;
                    }
                    if (!this.getItem((int)8).m_enabled || this.sendFocused) break;
                    ++this.selectedItem;
                    this.refreshFocused = false;
                    this.getItem(10).setFocused(false);
                    this.getItem(8).setFocused(true);
                    this.sendFocused = true;
                    break;
                }
                case 2: {
                    this.selectedSingle = true;
                    break;
                }
                case 3: {
                    this.selectedSingle = false;
                }
            }
        }
        return bl;
    }

    public boolean keyReleased(int n) {
        boolean bl = false;
        if (this.popupWindow != null) {
            bl = this.popupWindow.keyReleased(n);
        }
        if (!bl) {
            if (n == 1) {
                this.getItem(9).action();
            }
            if (n == 6) {
                if (this.refreshFocused) {
                    int n2 = -1;
                    while (++n2 < this.carCellCount) {
                        int n3;
                        int n4;
                        if (this.carCells[n2] > 65535) {
                            n4 = this.carCells[n2] & 0xFFFF;
                            this.carCells[n2] = 0;
                            n3 = this.carCellsCurrentSize[n2];
                            this.carCellsCurrentSize[n2] = 0;
                            if (this.animalCount[n4] == 0) {
                                // empty if block
                            }
                            this.moneyCount -= n3 * Constants.animalPrice[n4] / 2;
                            int n5 = n4;
                            this.animalCount[n5] = this.animalCount[n5] + n3;
                            int n6 = n4;
                            this.selledAnimals[n6] = this.selledAnimals[n6] - n3;
                            continue;
                        }
                        n4 = this.carCells[n2];
                        this.carCells[n2] = 0;
                        n3 = this.carCellsCurrentSize[n2];
                        this.carCellsCurrentSize[n2] = 0;
                        this.moneyCount -= n3 * Constants.productData[n4][0];
                        int n7 = n4;
                        this.productCount[n7] = this.productCount[n7] + n3;
                        int n8 = n4;
                        this.selledProducts[n8] = this.selledProducts[n8] - n3;
                    }
                    this.refreshFocused = false;
                    this.getItem(10).setFocused(false);
                    this.updateProductList();
                    if (this.moneyCount > 0) {
                        TiledButtonControl tiledButtonControl = (TiledButtonControl)this.getItem(8);
                        tiledButtonControl.setEnabled(true);
                    } else {
                        TiledButtonControl tiledButtonControl = (TiledButtonControl)this.getItem(8);
                        tiledButtonControl.setEnabled(false);
                    }
                    return true;
                }
                if (this.sendFocused) {
                    this.getItem(8).action();
                }
                int n9 = 0;
                for (int i = 0; n9 < 6 && i < this.products.length; ++i) {
                    if (this.products[i].m_forceHide) continue;
                    if (n9 == this.selectedItem - this.currentVisibleProductItem) {
                        if (this.selectedSingle) {
                            this.products[i].getItem(0).action();
                        } else {
                            this.products[i].getItem(1).action();
                        }
                        this.products[i].getItem(0).setFocused(false);
                        this.products[i].getItem(1).setFocused(false);
                    }
                    ++n9;
                }
            }
        }
        return bl;
    }
}

