/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.Game;

import com.spl.j2me.Game.AnimalBase;
import com.spl.j2me.Game.AnimalBear;
import com.spl.j2me.Game.Constants;
import com.spl.j2me.Game.MathExt;
import javax.microedition.lcdui.Graphics;

public class AnimalDog
extends AnimalBase
implements Constants {
    private AnimalBear bear = null;
    private boolean isBearHunted = false;
    private int barkTimer = 0;

    public AnimalDog(int n) {
        super(n, 4);
        this.currentMovingSpeed = 30;
    }

    public void draw(Graphics graphics) {
        super.draw(graphics);
    }

    public void tick(long l) {
        super.tick(l);
        if (this.isAppearing || this.isDroppedOut) {
            return;
        }
        if (this.appearingYOffset < 0) {
            this.appearingYOffset = 0;
            if (this.callbackParent != null) {
                this.callbackParent.onShowHint(4, this.screenX + this.width / 2, this.screenY + this.height / 2, false);
            }
        }
        if (this.bear != null && !this.bear.isAppearing && !this.isBearHunted) {
            this.changeDirectionTimer = AnimalBase.ANIMAL_CHANGE_DIRECTION_PERIOD;
            this.updateDirection();
            this.updateModel();
            if (this.bear.isIntersected(this.screenX + this.width / 2, this.screenY + this.height / 2, this.width, this.height)) {
                this.bear.setEnableMove(false);
                this.bear.isAngry = false;
                this.isBearHunted = true;
                this.isMoveEnabled = false;
                this.animalAnimation.setAnimationSequence(Constants.animalBehaviorAnimeSeq[this.animalType][Constants.animalBehaviorData[this.animalType][this.currentMovingDirection > 4 ? 8 : 9][0]]);
                this.animalAnimation.setAnimationTransform(Constants.animalBehaviorData[this.animalType][this.currentMovingDirection > 4 ? 8 : 9][1] == 1 ? 2 : 0);
                this.animalAnimation.updateAnimationPosition(this.screenX, this.screenY);
                this.animalAnimation.setAnimationFrameDelay(240);
            }
        }
        if (this.isBearHunted) {
            if (this.barkTimer < 0) {
                this.barkTimer = 12288;
            }
            this.barkTimer = (int)((long)this.barkTimer - (l << 11) / 1000L);
        }
    }

    public boolean hasBear() {
        return this.bear != null;
    }

    public void setBear(AnimalBear animalBear) {
        this.bear = animalBear;
        this.currentMovingSpeed = 80;
        this.isBearHunted = false;
        this.updateDirection();
    }

    public void removeBear(int n) {
        if (this.bear != null && this.bear.controlID == n) {
            this.bear = null;
            this.currentMovingSpeed = 30;
            this.isBearHunted = false;
            this.isMoveEnabled = true;
        }
    }

    public void updateDirection() {
        int[] nArray = this.bear.getPosition();
        int n = Math.abs(this.screenX + this.width / 2 - nArray[0]);
        int n2 = Math.abs(this.screenY + this.height / 2 - nArray[1]);
        int n3 = MathExt.sqrt(n * n + n2 * n2);
        this.movingDirectionX = ((nArray[0] << 11) - (this.screenX + this.width / 2 << 11)) / n3;
        this.movingDirectionY = ((nArray[1] << 11) - (this.screenY + this.height / 2 << 11)) / n3;
        this.currentAngle = this.countAngle(this.movingDirectionX, this.movingDirectionY);
        this.currentMovingDirection = super.getDirection(this.currentMovingDirection);
        super.updateModel();
    }
}

