/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.Game;

import com.spl.j2me.Animation.TiledAnimation;
import com.spl.j2me.Game.AnimalBase;
import com.spl.j2me.Game.Constants;
import com.spl.j2me.Game.GameScreen;
import com.spl.j2me.Game.MathExt;
import com.spl.j2me.RM.ResourceManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AnimalBear
extends AnimalBase {
    TiledAnimation cageAnimation;
    protected byte cageType;
    protected byte cageCurrentStage = (byte)-1;
    protected byte cageFinalStage;
    protected int cageOffsetX = 0;
    protected int cageOffsetY = 0;
    protected int cageDestroyTimer = 0;
    protected boolean isHunted = false;
    public boolean catchedByDog = false;
    protected int runTimer = 0;
    protected int soundTimer = 0;
    protected int cageAnimationTimer = 0;
    protected int cageBrokingXOffset = 0;
    protected int cageBrokingYOffset = 0;
    protected boolean isMovingToDepot = false;
    protected boolean isRunningAway = false;
    public static byte ANIMAL_PARAM_SPEED = 0;
    public static byte ANIMAL_PARAM_RUN_SPEED = 1;
    public static byte ANIMAL_PARAM_IN_CAGE_TIME = (byte)2;
    public static byte ANIMAL_PARAM_CAGE_ANIM_TIME = (byte)3;
    public boolean isAngry;
    protected int frendlyTimer;
    int[][] animalsParams = new int[][]{{12, 500, 20480, 6144}, {12, 500, 20480, 6144}, {12, 500, 20480, 6144}, {12, 500, 20480, 6144}};

    public AnimalBear(int n, int n2) {
        super(n, n2);
        this.currentMovingSpeed = this.animalsParams[n2 - 6][ANIMAL_PARAM_SPEED];
        this.frendlyTimer = 0;
        this.isAngry = false;
    }

    public void setIsInCage(boolean bl) {
        this.cageCurrentStage = bl ? this.cageFinalStage : (byte)0;
        this.isHunted = bl;
        if (this.isHunted) {
            this.cageAnimation.setFrameToDraw(this.cageCurrentStage);
            this.currentMovingSpeed = (2048 - (this.cageCurrentStage << 11) / this.cageFinalStage) * this.animalsParams[this.animalType - 6][ANIMAL_PARAM_SPEED] / 2048;
            this.runTimer = this.animalsParams[this.animalType - 6][ANIMAL_PARAM_IN_CAGE_TIME] + this.animalsParams[this.animalType - 6][ANIMAL_PARAM_CAGE_ANIM_TIME];
        }
    }

    public void tick(long l) {
        if (!this.isHunted || this.isAppearing) {
            super.tick(l);
        }
        if (!this.isAppearing) {
            if (this.appearingYOffset < 0) {
                this.appearingYOffset = 0;
                if (this.isHunted) {
                    this.isMoveEnabled = false;
                }
                if (this.callbackParent != null) {
                    this.callbackParent.onShowHint(16, this.screenX + this.width / 2, this.screenY + this.height / 2, false);
                }
            }
            if (!this.isAngry && this.frendlyTimer < 3000) {
                this.frendlyTimer = (int)((long)this.frendlyTimer + l);
            } else if (this.isMoveEnabled) {
                this.isAngry = true;
                this.frendlyTimer = 0;
            }
            this.soundTimer = (int)((long)this.soundTimer - (l << 11) / 1000L);
            this.cageAnimation.updateAnimationPosition(this.screenX + this.cageOffsetX, this.screenY + this.cageOffsetY);
            if (!this.isHunted && !this.isRunningAway) {
                if (this.cageAnimation != null && this.cageCurrentStage >= 0) {
                    this.cageAnimation.setFrameToDraw(this.cageCurrentStage);
                }
                if (this.cageCurrentStage >= 0) {
                    if (this.cageDestroyTimer >= 0) {
                        this.cageDestroyTimer = (int)((long)this.cageDestroyTimer - (l << 11) / 1000L);
                    }
                    if (this.cageCurrentStage >= 0 && this.cageDestroyTimer <= 0) {
                        this.cageCurrentStage = (byte)(this.cageCurrentStage - 1);
                        this.cageDestroyTimer = Constants.cageBrokeTime[this.cageType];
                        if (this.cageCurrentStage >= 0) {
                            this.animalAnimation.setFrameToDraw(this.cageCurrentStage);
                        }
                    }
                }
                this.currentMovingSpeed = this.cageCurrentStage >= 0 ? (2048 - (this.cageCurrentStage << 11) / this.cageFinalStage) * this.animalsParams[this.animalType - 6][ANIMAL_PARAM_SPEED] / 2048 : this.animalsParams[this.animalType - 6][ANIMAL_PARAM_SPEED];
            }
            if (this.isHunted) {
                this.isAngry = false;
                this.runTimer = (int)((long)this.runTimer - (l << 11) / 1000L);
                if (this.runTimer <= this.animalsParams[this.animalType - 6][ANIMAL_PARAM_CAGE_ANIM_TIME]) {
                    if (this.cageAnimationTimer <= 0) {
                        this.cageAnimationTimer = this.runTimer < 2048 ? 128 : 512;
                        this.cageBrokingXOffset = this.cageBrokingXOffset == 0 ? -4 + MathExt.rnd() % 8 : 0;
                        this.cageBrokingYOffset = this.cageBrokingYOffset == 0 ? -4 + MathExt.rnd() % 8 : 0;
                        this.x = this.screenX + this.cageBrokingXOffset << 11;
                        this.y = this.screenY + this.cageBrokingYOffset << 11;
                        this.animalAnimation.updateAnimationPosition(this.screenX + this.cageBrokingXOffset, this.screenY + this.cageBrokingYOffset);
                        this.cageAnimation.updateAnimationPosition(this.screenX + this.cageOffsetX + this.cageBrokingXOffset, this.screenY + this.cageOffsetY + this.cageBrokingYOffset);
                    } else {
                        this.cageAnimationTimer = (int)((long)this.cageAnimationTimer - (l << 11) / 1000L);
                    }
                }
                if (this.runTimer <= 0) {
                    this.isMoveEnabled = true;
                    this.isAngry = true;
                    super.dropAnimalOut(-2048, 0);
                    this.currentAngle = this.countAngle(this.movingDirectionX, this.movingDirectionY);
                    this.currentMovingDirection = this.getDirection(this.currentMovingDirection);
                    this.meadowBB[0] = -204800;
                    this.cageCurrentStage = (byte)-1;
                    this.isHunted = false;
                    this.isRunningAway = true;
                    this.updateModel();
                    if (this.callbackParent != null) {
                        this.callbackParent.onBearBrokeCage(this.controlID);
                    }
                }
                if (this.callbackParent != null) {
                    this.callbackParent.onShowHint(18, this.screenX + this.width / 2, this.screenY + this.height / 2, false);
                }
            }
        }
    }

    public void draw(Graphics graphics) {
        super.draw(graphics);
        if (!this.isAppearing) {
            if (this.cageAnimation != null && this.cageCurrentStage >= 0) {
                this.cageAnimation.draw(graphics);
            }
            Image image = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(this.appearingShadowID >> 24, this.appearingShadowID & 0xFFFFFF));
            graphics.drawImage(image, this.screenX + (this.width - image.getWidth()) / 2, this.screenY + this.height - image.getHeight(), 0);
        }
    }

    public void setCatchedByDog(boolean bl) {
        this.catchedByDog = bl;
    }

    public void setCage(TiledAnimation tiledAnimation, int n) {
        this.cageAnimation = tiledAnimation;
        this.cageOffsetX = (this.width - this.cageAnimation.animationWidth) / 2;
        this.cageOffsetY = (this.height - this.cageAnimation.animationHeight) / 2;
        this.cageAnimation.updateAnimationPosition(this.screenX + this.cageOffsetX, this.screenY + this.cageOffsetY);
        this.cageFinalStage = (byte)(tiledAnimation.getFrameCount(false) - 1);
        this.cageType = (byte)n;
    }

    public void buildCage() {
        if (!this.isAppearing) {
            if (!this.isHunted) {
                this.cageCurrentStage = (byte)(this.cageCurrentStage + 1);
            }
            if (this.cageDestroyTimer <= 0) {
                this.cageDestroyTimer = Constants.cageBrokeTime[this.cageType];
            }
            if (this.cageCurrentStage == this.cageFinalStage) {
                this.isHunted = true;
                this.isAngry = false;
                this.cageAnimation.setFrameToDraw(this.cageCurrentStage);
                this.currentMovingSpeed = (2048 - (this.cageCurrentStage << 11) / this.cageFinalStage) * this.animalsParams[this.animalType - 6][ANIMAL_PARAM_SPEED] / 2048;
                this.isMoveEnabled = false;
                this.runTimer = this.animalsParams[this.animalType - 6][ANIMAL_PARAM_IN_CAGE_TIME] + this.animalsParams[this.animalType - 6][ANIMAL_PARAM_CAGE_ANIM_TIME];
            }
        }
    }

    public boolean catchCagedBear() {
        if (this.isHunted) {
            if (!this.catchedByDog) {
                GameScreen.bearNotCatchedByDog = true;
            }
            if (this.callbackParent != null) {
                this.callbackParent.onBearHunted(this.controlID, this.screenX, this.screenY, Constants.animalProducing[this.animalType]);
            }
            return true;
        }
        return false;
    }

    public boolean pointerReleased(int n, int n2) {
        if (this.isMovingToDepot || this.isRunningAway || this.isAppearing) {
            return false;
        }
        if (Math.abs(this.screenX + this.width / 2 - n) < this.width / 2 && Math.abs(this.screenY + this.height / 2 - n2) < this.height / 2 && this.callbackParent != null) {
            if (!this.isHunted) {
                GameScreen.productClick = true;
                this.cageCurrentStage = (byte)(this.cageCurrentStage + 1);
                if (this.cageDestroyTimer <= 0) {
                    this.cageDestroyTimer = Constants.cageBrokeTime[this.cageType];
                }
                if (this.cageCurrentStage == this.cageFinalStage) {
                    this.isHunted = true;
                    this.isAngry = false;
                    this.cageAnimation.setFrameToDraw(this.cageCurrentStage);
                    this.currentMovingSpeed = (2048 - (this.cageCurrentStage << 11) / this.cageFinalStage) * this.animalsParams[this.animalType - 6][ANIMAL_PARAM_SPEED] / 2048;
                    this.isMoveEnabled = false;
                    this.runTimer = this.animalsParams[this.animalType - 6][ANIMAL_PARAM_IN_CAGE_TIME] + this.animalsParams[this.animalType - 6][ANIMAL_PARAM_CAGE_ANIM_TIME];
                }
            } else {
                if (!this.catchedByDog) {
                    GameScreen.bearNotCatchedByDog = true;
                }
                if (this.callbackParent != null) {
                    return this.callbackParent.onBearHunted(this.controlID, this.screenX, this.screenY, Constants.animalProducing[this.animalType]);
                }
            }
        }
        return false;
    }
}

