/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.GUIIC;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FontManager {
    static FontManager instance = null;
    public static final byte ALIGN_CENTER = 0;
    public static final byte ALIGN_LEFT = 1;
    public static final byte ALIGN_RIGHT = 2;
    int m_currentFont = 0;
    Image[] m_fontImage = null;
    char[][] m_fontChars = null;
    short[][][] m_fontCharsCoordinates = null;
    byte[] m_fontOverlay = null;
    byte[] m_fontHeight = null;

    public static FontManager getInstance(int n) {
        return instance == null ? (instance = new FontManager(n)) : instance;
    }

    private FontManager(int n) {
        this.m_fontImage = new Image[n];
        this.m_fontChars = new char[n][];
        this.m_fontCharsCoordinates = new short[n][][];
        this.m_fontOverlay = new byte[n];
        this.m_fontHeight = new byte[n];
    }

    public void setFontImage(int n, Image image) {
        if (n > -1 && n < this.m_fontImage.length) {
            if (this.m_fontImage[n] != null) {
                this.m_fontImage[n] = null;
            }
            this.m_fontImage[n] = image;
        }
    }

    public int getFontHeight(int n) {
        return this.m_fontHeight[n];
    }

    public void createFont(int n, Image image, byte[] byArray, byte by, byte by2) {
        if (n > -1 && n < this.m_fontImage.length) {
            if (this.m_fontImage[n] != null) {
                this.m_fontImage[n] = null;
                this.m_fontChars[n] = null;
                this.m_fontCharsCoordinates[n] = null;
            }
            this.m_fontImage[n] = image;
            this.m_fontOverlay[n] = by;
            this.m_fontHeight[n] = by2;
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            try {
                int n2;
                short s = dataInputStream.readShort();
                byte[] byArray2 = new byte[s];
                dataInputStream.readFully(byArray2);
                String string = new String(byArray2, "UTF-8");
                s = (short)string.length();
                this.m_fontChars[n] = new char[s];
                this.m_fontCharsCoordinates[n] = new short[s][5];
                for (n2 = 0; n2 < string.length(); ++n2) {
                    this.m_fontChars[n][n2] = string.charAt(n2);
                }
                for (n2 = 0; n2 < s; ++n2) {
                    this.m_fontCharsCoordinates[n][n2][0] = dataInputStream.readShort();
                    this.m_fontCharsCoordinates[n][n2][1] = dataInputStream.readShort();
                    this.m_fontCharsCoordinates[n][n2][2] = dataInputStream.readByte();
                    this.m_fontCharsCoordinates[n][n2][3] = dataInputStream.readByte();
                    this.m_fontCharsCoordinates[n][n2][4] = dataInputStream.readByte();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void drawString(Graphics graphics, int n, String string, int n2, int n3, int n4) {
        if (string == null || string.length() == 0 || this.m_fontImage[n] == null || this.m_fontCharsCoordinates[n] == null || this.m_fontChars[n] == null) {
            return;
        }
        int[] nArray = this.getIndexedString(n, string);
        if (n4 == 0) {
            n2 -= nArray[0] >> 1;
        }
        if (n4 == 2) {
            n2 -= nArray[0];
        }
        for (int i = 1; i < nArray.length; ++i) {
            short s = (short)nArray[i];
            if (this.m_fontChars[n][s] != ' ') {
                graphics.drawRegion(this.m_fontImage[n], (int)this.m_fontCharsCoordinates[n][s][0], (int)this.m_fontCharsCoordinates[n][s][1], (int)this.m_fontCharsCoordinates[n][s][2], (int)this.m_fontCharsCoordinates[n][s][3], 0, n2, n3 - this.m_fontCharsCoordinates[n][s][3] + this.m_fontCharsCoordinates[n][s][4], 0);
            }
            n2 += this.m_fontCharsCoordinates[n][s][2] + this.m_fontOverlay[n];
        }
    }

    public int[] getIndexedString(int n, String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return null;
        }
        int[] nArray = new int[n2 + 1];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            nArray[i + 1] = this.getCharIndex(n, string.charAt(i));
            n3 += this.m_fontCharsCoordinates[n][nArray[i + 1]][2];
            n3 += i < n2 ? this.m_fontOverlay[n] : 0;
        }
        nArray[0] = n3;
        return nArray;
    }

    int getCharIndex(int n, char c) {
        int n2 = 0;
        int n3 = this.m_fontChars[n].length - 1;
        int n4 = n2 + n3 >> 1;
        if (this.m_fontChars[n][n3] == c) {
            n4 = n3;
        } else if (this.m_fontChars[n][n2] == c) {
            n4 = n2;
        } else {
            while (n3 - n2 > 1) {
                if (this.m_fontChars[n][n4] > c) {
                    n3 = n4;
                } else {
                    if (this.m_fontChars[n][n4] >= c) break;
                    n2 = n4;
                }
                n4 = n2 + n3 >> 1;
            }
            if (this.m_fontChars[n][n4] != c) {
                n4 = 0;
            }
        }
        return n4;
    }

    public int getStringWidth(String string, int n) {
        int n2 = 0;
        int n3 = -1;
        while (++n3 < string.length()) {
            char c = string.charAt(n3);
            n2 += this.m_fontCharsCoordinates[n][this.getCharIndex(n, c)][2] + this.m_fontOverlay[n];
        }
        return n2;
    }

    public Vector wrapText(int n, String string, int n2) {
        String string2;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        int n6 = 0;
        Vector<String> vector = new Vector<String>();
        int n7 = 0;
        char c = '\u0000';
        int n8 = 0;
        while (n4 != n5 && n7 < n5) {
            c = string.charAt(n7);
            if (c == '\r') continue;
            n8 = this.m_fontCharsCoordinates[n][this.getCharIndex(n, c)][2] + this.m_fontOverlay[n];
            if (n6 + n8 <= n2) {
                if (c == ' ' || c == ',' || c == '.') {
                    n4 = n7 + 1;
                }
                n6 += n8;
                if (c == '\n') {
                    n6 += n2;
                    n4 = n7 + 1;
                }
                ++n7;
                continue;
            }
            if (n3 != n4) {
                string2 = string.substring(n3, n4);
                string2 = string2.replace('\n', ' ');
                string2 = string2.trim();
                vector.addElement(string2);
                n3 = n4;
                n7 = n4;
                n6 = 0;
                continue;
            }
            string2 = string.substring(n3, n7);
            string2 = string2.replace('\n', ' ');
            string2 = string2.trim();
            vector.addElement(string2);
            n3 = n7;
            n4 = n7;
            n6 = 0;
        }
        if (n7 > n4) {
            n4 = n7;
        }
        if (n3 != n4) {
            string2 = string.substring(n3, n4);
            string2 = string2.replace('\n', ' ');
            string2 = string2.trim();
            vector.addElement(string2);
            n3 = n4;
            n7 = n4;
            n6 = 0;
        } else {
            string2 = string.substring(n3, n7);
            string2 = string2.replace('\n', ' ');
            string2 = string2.trim();
            vector.addElement(string2);
            n3 = n7;
            n4 = n7;
            n6 = 0;
        }
        return vector;
    }
}

