/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.Animation;

import com.spl.j2me.GUIIC.ControlItem;
import com.spl.j2me.RM.ResourceManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TiledAnimation
extends ControlItem {
    private int currentFrame;
    private int frameToDraw;
    private byte[] animationSequence;
    private boolean cyclic = false;
    private int frameCount;
    private int tiledAnimationID;
    private Image animationImage;
    private int[][] frames;
    private long animationFrameDelay;
    private long prevFrameTime = 0L;
    private int animationTransform;
    public int animationWidth = 0;
    public int animationHeight = 0;
    protected int drawOffsetX = 0;
    protected int drawOffsetY = 0;
    protected boolean drawCentered;

    public void setAnimationTransform(int n) {
        this.animationTransform = n;
    }

    public TiledAnimation(int n, boolean bl) {
        super(n);
        this.animationTransform = 0;
        this.cyclic = bl;
        this.currentFrame = 0;
        this.drawCentered = true;
    }

    public TiledAnimation(TiledAnimation tiledAnimation, int n) {
        super(n);
        this.frameCount = tiledAnimation.frameCount;
        this.frames = new int[this.frameCount][];
        int n2 = -1;
        while (++n2 < this.frameCount) {
            this.frames[n2] = new int[4];
            int n3 = -1;
            while (++n3 < 4) {
                this.frames[n2][n3] = tiledAnimation.frames[n2][n3];
            }
        }
        if (tiledAnimation.animationSequence != null) {
            this.animationSequence = new byte[tiledAnimation.animationSequence.length];
            n2 = -1;
            while (++n2 < tiledAnimation.animationSequence.length) {
                this.animationSequence[n2] = tiledAnimation.animationSequence[n2];
            }
        }
        this.tiledAnimationID = tiledAnimation.tiledAnimationID;
        this.x = tiledAnimation.x;
        this.y = tiledAnimation.y;
        this.width = tiledAnimation.width;
        this.height = tiledAnimation.height;
        this.cyclic = tiledAnimation.cyclic;
        this.animationHeight = tiledAnimation.animationHeight;
        this.animationWidth = tiledAnimation.animationWidth;
        this.animationFrameDelay = tiledAnimation.animationFrameDelay;
        this.animationTransform = tiledAnimation.animationTransform;
        this.drawCentered = tiledAnimation.drawCentered;
    }

    public void setTiledAnimationImage(int n, int[][] nArray) {
        if (this.frames != null) {
            this.frames = null;
        }
        this.tiledAnimationID = n;
        this.frameCount = nArray.length;
        this.frames = nArray;
        this.animationWidth = nArray[0][2];
        this.animationHeight = nArray[0][3];
    }

    public void setTiledAnimationImage(Image image, int[][] nArray) {
        if (this.frames != null) {
            this.frames = null;
        }
        this.tiledAnimationID = -1;
        this.animationImage = image;
        this.frameCount = nArray.length;
        this.frames = nArray;
        this.animationWidth = nArray[0][2];
        this.animationHeight = nArray[0][3];
    }

    public void setDrawCentered(boolean bl) {
        this.drawCentered = bl;
    }

    public void setAnimationFrameDelay(int n) {
        this.animationFrameDelay = n;
    }

    public void setAnimationSequence(byte[] byArray) {
        this.animationSequence = byArray;
    }

    public void updateAnimationPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public int getFrameCount(boolean bl) {
        return bl ? (this.animationSequence == null ? -1 : this.animationSequence.length) : this.frameCount;
    }

    public void resetAnimation() {
        this.currentFrame = 0;
        this.frameToDraw = this.animationSequence == null ? this.currentFrame : this.animationSequence[this.currentFrame];
        this.prevFrameTime = 0L;
    }

    public boolean updateAnimation(long l) {
        if (this.prevFrameTime > this.animationFrameDelay) {
            int n = this.animationSequence == null ? (this.cyclic ? ++this.currentFrame % this.frameCount : (this.currentFrame = this.currentFrame + 1)) : (this.cyclic ? ++this.currentFrame % this.animationSequence.length : (this.currentFrame = this.currentFrame + 1));
            this.currentFrame = n;
            this.frameToDraw = this.animationSequence == null ? this.currentFrame : this.animationSequence[this.currentFrame];
            this.prevFrameTime = this.prevFrameTime + l - this.animationFrameDelay;
        } else {
            this.prevFrameTime += l;
        }
        if (this.drawCentered) {
            this.drawOffsetX = (this.animationWidth - this.frames[this.frameToDraw][2]) / 2;
            this.drawOffsetY = (this.animationHeight - this.frames[this.frameToDraw][3]) / 2;
        }
        return this.cyclic ? false : this.currentFrame == this.frameCount - 1;
    }

    public void setFrameToDraw(int n) {
        this.frameToDraw = n;
        if (this.frameToDraw < this.frames.length - 1 && this.drawCentered) {
            this.drawOffsetX = (this.animationWidth - this.frames[this.frameToDraw][2]) / 2;
            this.drawOffsetY = (this.animationHeight - this.frames[this.frameToDraw][3]) / 2;
        }
    }

    public int getCurrentFrameHeight(int n) {
        if (n > this.frames.length - 1) {
            return -1;
        }
        return this.frames[n][3];
    }

    public int getCurrentFrameWidth(int n) {
        if (n > this.frames.length - 1) {
            return -1;
        }
        return this.frames[n][2];
    }

    public void draw(Graphics graphics) {
        Image image = null;
        if (this.tiledAnimationID != -1) {
            image = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(this.tiledAnimationID >> 24, this.tiledAnimationID & 0xFFFFFF));
        } else if (this.animationImage != null) {
            image = this.animationImage;
        } else {
            return;
        }
        if (this.frames != null && image != null) {
            if (this.animationTransform != 0) {
                graphics.drawRegion(image, this.frames[this.frameToDraw][0], this.frames[this.frameToDraw][1], this.frames[this.frameToDraw][2], this.frames[this.frameToDraw][3], this.animationTransform, this.x + this.drawOffsetX, this.y + this.drawOffsetY, 0);
            } else {
                graphics.setClip(this.x + this.drawOffsetX, this.y + this.drawOffsetY, this.frames[this.frameToDraw][2], this.frames[this.frameToDraw][3]);
                graphics.drawImage(image, this.x - this.frames[this.frameToDraw][0] + this.drawOffsetX, this.y - this.frames[this.frameToDraw][1] + this.drawOffsetY, 0);
                graphics.setClip(0, 0, 240, 320);
            }
        } else {
            System.out.println("Frames: " + this.frames + " tiledAnimation: " + image);
        }
    }

    protected void destroy() {
    }

    public void delete() {
    }

    public void open() {
    }

    public void close() {
    }

    public boolean keyPressed(int n) {
        return false;
    }

    public boolean keyReleased(int n) {
        return false;
    }

    public boolean keyRepeated(int n) {
        return false;
    }
}

