/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class ICanvas
extends Canvas {
    public static int WIDTH = 240;
    public static int HEIGHT = 320;
    public static int SOFTKEY_HEIGHT = 36;
    public static int SOFTKEY_BAR_HEIGHT = 2;
    private static int SOFTKEY_OFFSET = 2;
    public static int MENU_OFFSET = 14;
    public static int NOMINAL_GAP = 2;
    protected int keyParam;
    protected int keyEvent;
    protected int keyState;
    protected int keyDown;
    protected int keyDownTime;
    public static boolean bTouchscreenEnabled = true;
    private int keypadState;
    private String[] softLabel = new String[]{"", ""};
    static int iTouchX = -100;
    static int iTouchY = -100;
    static int iDraggedX = -100;
    static int iDraggedY = -100;
    static boolean bTouchDown = false;
    private static int iEmuBugOffset = 0;
    private Image offImg;
    private IGraphics g;
    private static int mScreenFliped = 0;
    private long lastPaintTime = -1L;

    public ICanvas() {
        this.setFullScreenMode(true);
        if (Boxal.bInfForceSize) {
            WIDTH = Boxal.iInfForcedWidth;
            HEIGHT = Boxal.iInfForcedHeight;
        } else {
            WIDTH = this.getWidth();
            HEIGHT = this.getHeight();
        }
        if (this.getHeight() < this.getWidth() && Boxal.bForcePortraitMode) {
            WIDTH = this.getHeight();
            HEIGHT = this.getWidth();
        }
        this.offImg = Image.createImage((int)WIDTH, (int)HEIGHT);
        this.g = new IGraphics(this.offImg.getGraphics(), this);
    }

    public void resume() {
        this.keypadState = 0;
    }

    public final void setSoftLabel(String string, String string2) {
        this.softLabel[0] = string;
        this.softLabel[1] = string2;
    }

    public final void drawSoftkeys(Graphics graphics, BoxFont boxFont) {
        graphics.setClip(0, 0, WIDTH, HEIGHT);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, HEIGHT - SOFTKEY_HEIGHT, WIDTH, SOFTKEY_BAR_HEIGHT);
        if (boxFont != null) {
            boxFont.drawString(graphics, this.softLabel[0], SOFTKEY_OFFSET, HEIGHT - SOFTKEY_OFFSET, 36);
            boxFont.drawString(graphics, this.softLabel[1], WIDTH - SOFTKEY_OFFSET, HEIGHT - SOFTKEY_OFFSET, 40);
        }
    }

    public void pointerPressed(int n, int n2) {
        if (n2 > HEIGHT - SOFTKEY_HEIGHT && n < WIDTH >> 2) {
            this.keyPressed(-6);
        } else if (n2 > HEIGHT - SOFTKEY_HEIGHT && n > WIDTH - (WIDTH >> 2)) {
            this.keyPressed(-7);
        }
        iTouchX = n;
        iTouchY = n2;
        iDraggedX = iTouchX;
        iDraggedY = iTouchY;
        bTouchDown = true;
    }

    public void pointerDragged(int n, int n2) {
        iDraggedX = n;
        iDraggedY = n2;
    }

    public void pointerReleased(int n, int n2) {
        if (n2 > HEIGHT - SOFTKEY_HEIGHT && n < WIDTH >> 2) {
            this.keyReleased(-6);
        } else if (n2 > HEIGHT - SOFTKEY_HEIGHT && n > WIDTH - (WIDTH >> 2)) {
            this.keyReleased(-7);
        }
        iTouchX = -100;
        iTouchY = -100;
        iDraggedX = -100;
        iDraggedY = -100;
        bTouchDown = false;
    }

    public void keyPressed(int n) {
        if (mScreenFliped != 0) {
            return;
        }
        if ((n = this.getKey(n)) >= 0) {
            this.keypadState |= 1 << n;
        }
        this.processEvent(0, n);
    }

    public void keyReleased(int n) {
        n = this.getKey(n);
        this.keypadState = 0;
        this.processEvent(1, n);
    }

    private int getKey(int n) {
        if (Boxal.bInfForceKeys && n == Boxal.iInf0) {
            return 0;
        }
        if (Boxal.bInfForceKeys && n == Boxal.iInf1) {
            return 1;
        }
        if (Boxal.bInfForceKeys && n == Boxal.iInf2) {
            return 2;
        }
        if (Boxal.bInfForceKeys && n == Boxal.iInf3) {
            return 3;
        }
        if (Boxal.bInfForceKeys && n == Boxal.iInf4) {
            return 4;
        }
        if (Boxal.bInfForceKeys && n == Boxal.iInf5) {
            return 5;
        }
        if (Boxal.bInfForceKeys && n == Boxal.iInf6) {
            return 6;
        }
        if (Boxal.bInfForceKeys && n == Boxal.iInf7) {
            return 7;
        }
        if (Boxal.bInfForceKeys && n == Boxal.iInf8) {
            return 8;
        }
        if (Boxal.bInfForceKeys && n == Boxal.iInf9) {
            return 9;
        }
        if (Boxal.bInfForceKeys && n == Boxal.iInfStar) {
            return 10;
        }
        if (Boxal.bInfForceKeys && n == Boxal.iInfPound) {
            return 11;
        }
        if (Boxal.bInfForceKeys && (n == Boxal.iInfLSK || Math.abs(n) == Boxal.iInfLSK)) {
            return 21;
        }
        if (Boxal.bInfForceKeys && (n == Boxal.iInfRSK || Math.abs(n) == Boxal.iInfRSK)) {
            return 22;
        }
        if (Boxal.bInfForceKeys && n == Boxal.iInfUp) {
            return 17;
        }
        if (Boxal.bInfForceKeys && n == Boxal.iInfDown) {
            return 19;
        }
        if (Boxal.bInfForceKeys && n == Boxal.iInfLeft) {
            return 16;
        }
        if (Boxal.bInfForceKeys && n == Boxal.iInfRight) {
            return 18;
        }
        if (Boxal.bInfForceKeys && (n == Boxal.iInfFire || Math.abs(n) == Boxal.iInfFire)) {
            return 20;
        }
        switch (n) {
            case 0: {
                return 32;
            }
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 42: {
                return 10;
            }
            case 35: {
                return 11;
            }
            case -6: {
                return 21;
            }
            case -7: {
                return 22;
            }
        }
        switch (this.getGameAction(n)) {
            case 1: {
                return 17;
            }
            case 6: {
                return 19;
            }
            case 2: {
                return 16;
            }
            case 5: {
                return 18;
            }
            case 8: {
                return 20;
            }
        }
        return n;
    }

    public final int getKeypadState() {
        return this.keypadState;
    }

    private void processEvent(int n, int n2) {
        if (n == 0) {
            this.keyParam = n2;
        }
    }

    protected final boolean checkKeyDown(int n) {
        if ((this.keyState & 1 << n) == 0) {
            return false;
        }
        if (this.keyDown == n) {
            ++this.keyDownTime;
        } else {
            this.keyDown = n;
            this.keyDownTime = 1;
        }
        return true;
    }

    public final void paint(Graphics graphics) {
        if (Boxal.bInfUseWatchdog && Boxal.bInfWatchdogInPaint) {
            long l = System.currentTimeMillis() - this.lastPaintTime;
            if (this.lastPaintTime > 0L && l > (long)Boxal.iInfWatchdogTimeout) {
                B.do_pauseApp();
            }
            this.lastPaintTime = System.currentTimeMillis();
        }
        if (Boxal.bInfLandscape && super.getHeight() > super.getWidth() || Boxal.bInfPortrait && super.getHeight() < super.getWidth()) {
            graphics.setColor(0);
            graphics.fillRect(0, 0, super.getWidth(), super.getHeight());
            graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
            graphics.setColor(0xFFFFFF);
            if (A.babble_languages[0].equals("en-GB")) {
                graphics.drawString("PLEASE REORIENTATE HANDSET SCREEN", 7, super.getHeight() >> 1, 20);
            } else if (A.babble_languages[0].equals("fr-FR")) {
                graphics.drawString("R\u00c9ORIENTEZ L'\u00c9CRAN S'IL VOUS PLA\u00ceT", 7, super.getHeight() >> 1, 20);
            } else if (A.babble_languages[0].equals("es-ES")) {
                graphics.drawString("RIPOSIZIONA SCHERMO", 7, super.getHeight() >> 1, 20);
            } else if (A.babble_languages[0].equals("de-DE")) {
                graphics.drawString("BITTE RICHTE DISPLAY NEU AUS", 7, super.getHeight() >> 1, 20);
            } else if (A.babble_languages[0].equals("it-IT")) {
                graphics.drawString("REORIENTA LA PANTALLA DEL M\u00d3VIL", 7, super.getHeight() >> 1, 20);
            }
            if (mScreenFliped == 1) {
                B.do_pauseApp();
            }
            if (++mScreenFliped > 2) {
                mScreenFliped = 2;
            }
            return;
        }
        if (mScreenFliped != 0) {
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (Boxal.bInfForceSize) {
                WIDTH = Boxal.iInfForcedWidth;
                HEIGHT = Boxal.iInfForcedHeight;
            } else {
                WIDTH = this.getWidth();
                HEIGHT = this.getHeight();
            }
            B.flipped = true;
        }
        mScreenFliped = 0;
        if (this.offImg != null) {
            graphics.drawImage(this.offImg, 0, 0, 20);
        }
    }

    public final IGraphics getIGraphics() {
        return this.g;
    }

    public final Image createDarkImage() {
        int[] nArray = new int[WIDTH * HEIGHT];
        this.offImg.getRGB(nArray, 0, WIDTH, 0, 0, WIDTH, HEIGHT);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i] >> 16 & 0xFF;
            int n2 = nArray[i] >> 8 & 0xFF;
            int n3 = nArray[i] & 0xFF;
            n = n < 200 ? 0 : n - 200;
            n2 = n2 < 200 ? 0 : n2 - 200;
            n3 = n3 < 200 ? 0 : n3 - 200;
            nArray[i] = n << 16 | n2 << 8 | n3;
        }
        return Image.createRGBImage((int[])nArray, (int)WIDTH, (int)HEIGHT, (boolean)false);
    }

    private byte[] readRes(String string) throws Exception {
        byte[] byArray = new byte[1024];
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(string);
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.close();
            inputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                byteArrayOutputStream.close();
            }
            catch (Exception exception2) {}
            throw exception;
        }
    }

    public final void writeFullRMS(String string, String[] stringArray) {
        ICanvas iCanvas = null;
        Object object = string;
        System.out.println("Deleting " + object);
        if (RecordStore.listRecordStores() != null) {
            try {
                RecordStore.deleteRecordStore((String)object);
                System.out.println("Deleted " + object);
            }
            catch (Exception exception) {}
        } else {
            System.out.println(object + " doesnt exist to delete");
        }
        try {
            System.out.println("Creating " + string);
            iCanvas = RecordStore.openRecordStore((String)string, (boolean)true);
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("r" + i);
                String string2 = stringArray[i];
                object = iCanvas;
                byte[] byArray = string2.getBytes();
                try {
                    System.out.println("Writing " + string2);
                    object.addRecord(byArray, 0, byArray.length);
                    continue;
                }
                catch (Exception exception) {}
            }
            iCanvas.closeRecordStore();
            return;
        }
        catch (Exception exception) {
            try {
                if (iCanvas != null) {
                    iCanvas.closeRecordStore();
                }
                return;
            }
            catch (Exception exception2) {
                return;
            }
        }
    }

    public static String[] readFullRMS(String stringArray) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)stringArray, (boolean)false);
            System.out.println("Found " + recordStore.getName());
            if (recordStore != null) {
                System.out.println("No. of records " + recordStore.getNumRecords());
                stringArray = new String[recordStore.getNumRecords()];
                for (int i = 0; i < recordStore.getNumRecords(); ++i) {
                    stringArray[i] = new String(recordStore.getRecord(i + 1));
                    System.out.println("reading " + stringArray[i]);
                }
                recordStore.closeRecordStore();
                return stringArray;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void sleep(long l) {
        try {
            if (l < 5L) {
                l = 5L;
            }
            Thread.sleep(l);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public final Image getImage(String string) {
        try {
            byte[] byArray = object.readRes("/" + string + ".png");
            Object object = byArray;
            return Image.createImage((byte[])byArray, (int)0, (int)((ICanvas)object).length);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

