/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Graphics;

class Ship {
    private byte posX;
    private byte posY;
    private boolean vertical;
    public byte lenght;
    private byte player;
    private boolean[] hit;
    private boolean sunken;

    Ship(int _posX, int _posY, boolean _vertical, int _lenght, int _player) {
        this.posX = (byte)_posX;
        this.posY = (byte)_posY;
        this.vertical = _vertical;
        this.lenght = (byte)_lenght;
        this.player = (byte)_player;
        this.hit = new boolean[_lenght];
    }

    public Ship(DataInputStream dis) {
        try {
            this.posX = dis.readByte();
            this.posY = dis.readByte();
            this.vertical = dis.readBoolean();
            this.lenght = dis.readByte();
            this.player = dis.readByte();
            this.sunken = dis.readBoolean();
            this.hit = new boolean[this.lenght];
            for (int i = 0; i < this.lenght; ++i) {
                this.hit[i] = dis.readBoolean();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save(DataOutputStream dos) {
        try {
            dos.writeByte(this.posX);
            dos.writeByte(this.posY);
            dos.writeBoolean(this.vertical);
            dos.writeByte(this.lenght);
            dos.writeByte(this.player);
            dos.writeBoolean(this.sunken);
            for (int i = 0; i < this.lenght; ++i) {
                dos.writeBoolean(this.hit[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final int getPosX1() {
        return this.posX;
    }

    public final int getPosY1() {
        return this.posY;
    }

    public final int getPosX2() {
        if (this.vertical) {
            return this.posX;
        }
        return this.posX + this.lenght - 1;
    }

    public final int getPosY2() {
        if (this.vertical) {
            return this.posY + this.lenght - 1;
        }
        return this.posY;
    }

    public final boolean isSunken() {
        return this.sunken;
    }

    public boolean testField(int x, int y) {
        if (this.vertical) {
            return x == this.posX && y >= this.posY && y - this.posY < this.lenght;
        }
        return y == this.posY && x >= this.posX && x - this.posX < this.lenght;
    }

    public boolean hit(int x, int y) {
        int i;
        if (this.vertical) {
            this.hit[y - this.posY] = true;
        } else {
            this.hit[x - this.posX] = true;
        }
        for (i = 0; i < this.hit.length; ++i) {
            if (this.hit[i]) continue;
            return false;
        }
        this.sunken = true;
        MainCanvas.vibrate(100);
        for (i = -1; i <= this.lenght; ++i) {
            for (int j = -1; j <= 1; ++j) {
                int px = this.posX;
                int py = this.posY;
                if (this.vertical) {
                    py += i;
                    px += j;
                } else {
                    px += i;
                    py += j;
                }
                if (j == 0 && i >= 0 && i < this.lenght) {
                    Game.setField(this.player, px, py, 4);
                    continue;
                }
                Game.setField(this.player, px, py, 2);
            }
        }
        return true;
    }

    public void paintFire(Graphics g) {
        byte frame = Game.gfx.correctFrame(12, Game.animTime / 100, 0);
        for (int i = 0; i < this.lenght; ++i) {
            if (!this.hit[i]) continue;
            if (this.vertical) {
                Game.gfx.paintAnimation(0, 12, frame, Game.boardOffsetX + this.posX * 15, Game.boardOffsetY + (this.posY + i) * 15, 0, g);
                continue;
            }
            Game.gfx.paintAnimation(0, 12, frame, Game.boardOffsetX + (this.posX + i) * 15, Game.boardOffsetY + this.posY * 15, 0, g);
        }
    }

    public static void paint(Graphics g, int posX, int posY, boolean vertical, int lenght, boolean wrack, int player, boolean[] drawPiece) {
        int o = 0;
        if (wrack) {
            o = 25;
        }
        posX = Game.boardOffsetX + posX * 15;
        posY = Game.boardOffsetY + posY * 15;
        if (lenght == 1) {
            if (drawPiece == null || drawPiece[0]) {
                Game.gfx.paintAnimation(0, 10, 0, posX, posY, 0, g);
                Game.gfx.paintAnimation(0, 3 + o, 0, posX, posY, 0, g);
            }
        } else if (vertical) {
            if (drawPiece == null || drawPiece[0]) {
                Game.gfx.paintAnimation(0, 10, 0, posX, posY, 0, g);
                Game.gfx.paintAnimation(0, 5 + o, 0, posX, posY, 0, g);
            }
            for (int i = 1; i < lenght - 1; ++i) {
                posY += 15;
                if (drawPiece != null && !drawPiece[i]) continue;
                Game.gfx.paintAnimation(0, 10, 0, posX, posY, 0, g);
                Game.gfx.paintAnimation(0, 6 + o, 0, posX, posY, 0, g);
            }
            posY += 15;
            if (drawPiece == null || drawPiece[lenght - 1]) {
                Game.gfx.paintAnimation(0, 10, 0, posX, posY, 0, g);
                Game.gfx.paintAnimation(0, 4 + o, 0, posX, posY, 0, g);
            }
        } else {
            if (drawPiece == null || drawPiece[0]) {
                Game.gfx.paintAnimation(0, 10, 0, posX, posY, 0, g);
                Game.gfx.paintAnimation(0, 7 + o, 0, posX, posY, 0, g);
            }
            for (int i = 1; i < lenght - 1; ++i) {
                posX += 15;
                if (drawPiece != null && !drawPiece[i]) continue;
                Game.gfx.paintAnimation(0, 10, 0, posX, posY, 0, g);
                Game.gfx.paintAnimation(0, 9 + o, 0, posX, posY, 0, g);
            }
            posX += 15;
            if (drawPiece == null || drawPiece[lenght - 1]) {
                Game.gfx.paintAnimation(0, 10, 0, posX, posY, 0, g);
                Game.gfx.paintAnimation(0, 8 + o, 0, posX, posY, 0, g);
            }
        }
    }

    public void paint(Graphics g) {
        if (this.sunken || Game.getGameState() == 1 && Game.isComputerMove()) {
            Ship.paint(g, this.posX, this.posY, this.vertical, this.lenght, this.sunken, this.player, this.hit);
            this.paintFire(g);
        } else if (Game.getGameState() == 2 || Game.getGameState() == 0) {
            Ship.paint(g, this.posX, this.posY, this.vertical, this.lenght, this.sunken, this.player, null);
            this.paintFire(g);
        } else {
            g.setColor(255, 0, 0);
            for (int i = 0; i < this.lenght; ++i) {
                int y;
                int x;
                if (!this.hit[i]) continue;
                if (this.vertical) {
                    x = this.posX;
                    y = this.posY + i;
                } else {
                    x = this.posX + i;
                    y = this.posY;
                }
                if (Game.isFieldAnimating(x, y)) continue;
                g.fillRect(Game.boardOffsetX + x * 15, Game.boardOffsetY + y * 15 + 1, 14, 14);
            }
        }
    }
}

