/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class Game {
    public static final int ALPHABET_IN_MENU = 0;
    public static final int LETTER_SPACE_IN_MENU = -1;
    public static final int TEXT_DIAGRAM_TUTORIAL1 = 0;
    public static final int TEXT_DIAGRAM_TUTORIAL2 = 1;
    public static final int TEXT_DIAGRAM_CONGRATULATIONS = 2;
    public static final int TEXT_DIAGRAM_YOUR_TIME = 3;
    public static final int TEXT_BATTLE_TUTORIAL1 = 4;
    public static final int TEXT_BATTLE_TUTORIAL2 = 5;
    public static final int TEXT_BATTLE_NOW_MOVES = 6;
    public static final int TEXT_BATTLE_PLAYER1 = 7;
    public static final int TEXT_BATTLE_PLAYER2 = 8;
    public static final int TEXT_BATTLE_CONGRATULATIONS = 9;
    public static final int TEXT_BATTLE_YOU_WIN = 10;
    public static final int TEXT_BATTLE_YOU_LOSE = 11;
    public static final int TEXT_NUM = 12;
    public static final int TEXT_REMAINING_SHIPS = 53;
    public static final int TEXT_SET_YOUR_SHIPS = 60;
    public static final int TEXT_OPPONENT = 63;
    public static final int TEXT_BATTLESHIPS = 64;
    public static final int TEXT_DIAGRAM_SOLVED = 65;
    public static final int BACKGROUND_COLOR = 14277598;
    public static final int BIT_MOVE = 10;
    public static final int BIT_MOVE_VALUE = 1024;
    public static final int BIT_MOVE_VALUE_SQRT = 32;
    public static final int FIRE_TIME = 100;
    public static final int HIT_TIME = 100;
    public static final int MIST_TIME = 100;
    public static final int CARTOON_FONT_OFFSET = 8;
    public static final int BACKGROUND_SIZE_Y = 220;
    public static final int fieldSizeX = 15;
    public static final int fieldSizeY = 15;
    public static final int BOARD6x6_OFFSET_Y = 53;
    public static final int BOARD8x8_OFFSET_Y = 38;
    public static final int BOARD10x10_OFFSET_Y = 23;
    public static final int REMAINING_CARTOON_Y = 20;
    public static final int GFX_MENU = 0;
    public static final int GFX_SHOT_MIST = 1;
    public static final int GFX_SELECTOR = 2;
    public static final int GFX_SHIP_ONE = 3;
    public static final int GFX_SHIP_DOWN = 4;
    public static final int GFX_SHIP_UP = 5;
    public static final int GFX_SHIP_VERTICAL = 6;
    public static final int GFX_SHIP_LEFT = 7;
    public static final int GFX_SHIP_RIGHT = 8;
    public static final int GFX_SHIP_HORIZONTAL = 9;
    public static final int GFX_WATER = 10;
    public static final int GFX_SHOT_HIT = 11;
    public static final int GFX_FIRE = 12;
    public static final int GFX_SOFT_BACK = 13;
    public static final int GFX_SOFT_MENU = 14;
    public static final int GFX_SOFT_OK = 15;
    public static final int GFX_SOFT_SEND = 16;
    public static final int GFX_SOFT_SHIP_SET = 17;
    public static final int GFX_SOFT_SHIP_ROTATE = 18;
    public static final int GFX_SOFT_SHIP_VIEW = 19;
    public static final int GFX_SOFT_SHIP_FIRING = 20;
    public static final int GFX_SOFT_FIRE = 21;
    public static final int GFX_SOFT_EREASE = 22;
    public static final int GFX_SOFT_SHIP_WATER = 23;
    public static final int GFX_SOFT_CANCEL = 24;
    public static final int GFX_BACKGROUND_6x6 = 25;
    public static final int GFX_BACKGROUND_8x8 = 26;
    public static final int GFX_BACKGROUND_10x10 = 27;
    public static final int GFX_SHIPWRACK_ONE = 28;
    public static final int GFX_SHIPWRACK_DOWN = 29;
    public static final int GFX_SHIPWRACK_UP = 30;
    public static final int GFX_SHIPWRACK_VERTICAL = 31;
    public static final int GFX_SHIPWRACK_LEFT = 32;
    public static final int GFX_SHIPWRACK_RIGHT = 33;
    public static final int GFX_SHIPWRACK_HORIZONTAL = 34;
    public static final int GFX_NOSHIP = 40;
    public static GameAnimation gfx;
    public static final int[] SHIP_TYPE;
    private int shipSet;
    public static final int MODE_BATTLE = 0;
    public static final int MODE_DIAGRAM = 1;
    private int gameMode;
    private static int playerNum;
    private static int player;
    public int size;
    public int difficulty;
    public static final byte STATE_SHIP_SET = 0;
    public static final byte STATE_FIRING = 1;
    public static final byte STATE_SHIP_VIEW = 2;
    public static final byte STATE_DIAGRAM_SOLVING = 3;
    private static int gameState;
    private boolean gameOver;
    private boolean gameOverRecord;
    private boolean paintGameOver;
    private boolean paintSolvedDiagram;
    private boolean paintPlayer;
    private boolean paintRamainingShips;
    private int playerWin;
    boolean paintTutorial1;
    boolean paintTutorial2;
    public static int animTime;
    private int gameTime;
    private String gameTimeString;
    public static final int SAVE_TIME = 30000;
    private int saveTime;
    private static int vibraTime;
    public static final int KEY_REPEAT_START_TIME = 250;
    public static final int KEY_DELAY = 100;
    private int lastKeyCode;
    private int keyTime;
    private boolean keyQuick;
    private static boolean paintShotAnim;
    private static int shotAnimTime;
    private static int shotAnimPosX;
    private static int shotAnimPosY;
    private static boolean shotAnimHit;
    public static int boardOffsetX;
    public static int boardOffsetY;
    private static int backgroundPosY;
    private int cursorPosX;
    private int cursorPosY;
    private boolean cursorVertical;
    public static final int MAP_HIDDEN = 0;
    public static final int MAP_DIAGRAM = 1;
    public static final int FIELD_EMPTY = 0;
    public static final int FIELD_SHIP = 1;
    public static final int FIELD_SHOT = 2;
    public static final int FIELD_HIT = 3;
    public static final int FIELD_SUNK = 4;
    public static final int DIAGRAM_FIELD_UNKNOWN = 0;
    public static final int DIAGRAM_FIELD_WATER = 1;
    public static final int DIAGRAM_FIELD_SHIP = 2;
    public static final int DIAGRAM_FIELD_QUESTION_MARK = 3;
    public static final int DIAGRAM_FIELD_NUM = 4;
    private static byte[][][] map;
    private static byte[] digitsVertical;
    private static byte[] digitsHorizontal;
    public static final int DIR_LEFT = 1;
    public static final int DIR_RIGHT = 2;
    public static final int DIR_UP = 4;
    public static final int DIR_DOWN = 8;
    public static final int DIR_UP_LEFT = 16;
    public static final int DIR_UP_RIGHT = 32;
    public static final int DIR_DOWN_LEFT = 64;
    public static final int DIR_DOWN_RIGHT = 128;
    public static final int DIR_LEFT_RIGHT = 3;
    public static final int DIR_UP_DOWN = 12;
    private static boolean[][] errorMap;
    private static boolean[][] lockMap;
    private Ship[][] ships;
    private byte[] computerShotListX;
    private byte[] computerShotListY;
    private int computerShotListSize;
    private TextMenu tutorial1;
    private TextMenu tutorial2;
    private static StringBuffer sb;
    public BPGraphics endIMG;
    int diagramSize = 6;
    boolean isShowGratulations = false;
    public int iDiagramID = 0;
    int prevKeyCode = 0;
    int pressTimer = 0;
    boolean isShot = false;
    public static final int END_PIC_Y = 21;
    public static final int IDWinText = 66;
    public static final int IDLoseText = 67;
    public static final int RIGH_TIMER_X = 30;
    public static final int WIN_IMAGES_ID = 1;
    public static final int LOSE_IMAGES_ID = 0;
    public static final int DIAGRAM_TICER_ID = 2;

    public Game() {
        this.resetLanguage();
        gfx = new GameAnimation(MainCanvas.midlet, "gfx.ani", "gfx.bgs", null, true, 176, 208);
        this.endIMG = new BPGraphics(MainCanvas.midlet, "e", null);
        backgroundPosY = -6;
    }

    private void countDigits() {
        int s;
        for (int x = 0; x < map[0].length; ++x) {
            s = 0;
            for (int y = 0; y < map[0][0].length; ++y) {
                if (map[0][x][y] <= 0) continue;
                ++s;
            }
            Game.digitsHorizontal[x] = (byte)s;
        }
        for (int y = 0; y < map[0][0].length; ++y) {
            s = 0;
            for (int x = 0; x < map[0].length; ++x) {
                if (map[0][x][y] <= 0) continue;
                ++s;
            }
            Game.digitsVertical[y] = (byte)s;
        }
    }

    public void loadDiagram(String name, int sizeX, int sizeY) {
        InputStream is = ((Object)((Object)MainCanvas.midlet)).getClass().getResourceAsStream(name);
        try {
            DataInputStream dis = new DataInputStream(is);
            byte n = dis.readByte();
            int m = MainCanvas.getRandom(0, n - 1);
            dis.skipBytes(sizeX * sizeY * m);
            for (int y = 0; y < sizeY; ++y) {
                for (int x = 0; x < sizeX; ++x) {
                    byte d = dis.readByte();
                    if (d == 1) {
                        Game.map[0][x][y] = 0;
                        Game.map[1][x][y] = 1;
                        Game.lockMap[x][y] = false;
                        continue;
                    }
                    if (d == 2) {
                        Game.map[0][x][y] = 1;
                        Game.map[1][x][y] = 1;
                        Game.lockMap[x][y] = false;
                        continue;
                    }
                    if (d == -1) {
                        Game.map[0][x][y] = 0;
                        Game.map[1][x][y] = 1;
                        Game.lockMap[x][y] = true;
                        continue;
                    }
                    if (d != -2) continue;
                    Game.map[0][x][y] = 1;
                    Game.map[1][x][y] = 2;
                    Game.lockMap[x][y] = true;
                }
            }
            dis.close();
            this.countDigits();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void countBoardOffset(int sizeX, int sizeY) {
        boardOffsetX = (176 - sizeX * 15) / 2;
        if (sizeY == 6) {
            boardOffsetY = 53;
            this.diagramSize = 6;
        } else if (sizeY == 8) {
            boardOffsetY = 38;
            this.diagramSize = 8;
        } else if (sizeY == 10) {
            boardOffsetY = 23;
            this.diagramSize = 10;
        }
        boardOffsetY += backgroundPosY;
    }

    public void close() {
        map = null;
        errorMap = null;
        lockMap = null;
        this.ships = null;
        digitsHorizontal = null;
        digitsVertical = null;
        this.computerShotListX = null;
        this.computerShotListY = null;
        this.computerShotListSize = 0;
        this.tutorial1 = null;
        this.tutorial2 = null;
    }

    void reset() {
        this.gameOver = false;
        this.paintGameOver = false;
        this.paintSolvedDiagram = false;
        this.paintPlayer = false;
        this.playerWin = -1;
        this.paintTutorial1 = false;
        this.paintTutorial2 = false;
        paintShotAnim = false;
        shotAnimTime = 0;
        shotAnimPosX = 0;
        shotAnimPosY = 0;
        shotAnimHit = false;
        this.saveTime = 30000;
        animTime = 0;
        vibraTime = 0;
        this.lastKeyCode = 0;
        this.keyTime = 0;
        this.keyQuick = false;
        this.cursorPosX = 0;
        this.cursorPosY = 0;
        this.cursorVertical = false;
    }

    public void newGame(int _gameMode, int _playerNum, int _difficulty, int _size, int sizeX, int sizeY, boolean tutorial) {
        this.isShowGratulations = false;
        this.paintRamainingShips = false;
        this.gameMode = _gameMode;
        playerNum = _playerNum;
        this.size = _size;
        this.difficulty = _difficulty;
        player = 0;
        this.shipSet = 0;
        this.reset();
        this.gameTime = 0;
        this.countBoardOffset(sizeX, sizeY);
        gameState = _gameMode == 0 ? 0 : 3;
        map = new byte[2][sizeX][sizeY];
        if (_gameMode == 0) {
            this.ships = new Ship[2][SHIP_TYPE.length];
            if (playerNum == 1) {
                this.computerShotListX = new byte[sizeX * sizeY];
                this.computerShotListY = new byte[sizeX * sizeY];
                this.computerShotListSize = sizeX * sizeY;
                int i = 0;
                for (int x = 0; x < sizeX; ++x) {
                    for (int y = 0; y < sizeY; ++y) {
                        this.computerShotListX[i] = (byte)x;
                        this.computerShotListY[i] = (byte)y;
                        ++i;
                    }
                }
            } else {
                this.paintPlayer = true;
            }
            if (tutorial) {
                this.tutorial1 = new TextMenu(4, null, MainCanvas.lineSpacing, 3, true);
                this.tutorial2 = new TextMenu(5, null, MainCanvas.lineSpacing, 3, true);
                this.paintTutorial1 = true;
                this.paintTutorial2 = false;
            } else {
                this.tutorial1 = null;
                this.tutorial2 = null;
                this.paintTutorial1 = false;
                this.paintTutorial2 = false;
            }
        } else {
            digitsHorizontal = new byte[sizeX];
            digitsVertical = new byte[sizeY];
            errorMap = new boolean[sizeX][sizeY];
            lockMap = new boolean[sizeX][sizeY];
            if (this.difficulty == 0 && sizeX == 6) {
                this.loadDiagram("e6x6", sizeX, sizeY);
            }
            if (this.difficulty == 0 && sizeX == 8) {
                this.loadDiagram("e8x8", sizeX, sizeY);
            }
            if (this.difficulty == 0 && sizeX == 10) {
                this.loadDiagram("e10x10", sizeX, sizeY);
            }
            if (this.difficulty == 1 && sizeX == 6) {
                this.loadDiagram("m6x6", sizeX, sizeY);
            }
            if (this.difficulty == 1 && sizeX == 8) {
                this.loadDiagram("m8x8", sizeX, sizeY);
            }
            if (this.difficulty == 1 && sizeX == 10) {
                this.loadDiagram("m10x10", sizeX, sizeY);
            }
            if (this.difficulty == 2 && sizeX == 6) {
                this.loadDiagram("h6x6", sizeX, sizeY);
            }
            if (this.difficulty == 2 && sizeX == 8) {
                this.loadDiagram("h8x8", sizeX, sizeY);
            }
            if (this.difficulty == 2 && sizeX == 10) {
                this.loadDiagram("h10x10", sizeX, sizeY);
            }
            if (sizeX == 6) {
                this.iDiagramID = 0;
            }
            if (sizeX == 8) {
                this.iDiagramID = 1;
            }
            if (sizeX == 10) {
                this.iDiagramID = 2;
            }
            if (tutorial) {
                this.tutorial1 = new TextMenu(0, null, MainCanvas.lineSpacing, 3, true);
                this.tutorial2 = new TextMenu(1, null, MainCanvas.lineSpacing, 3, true);
                this.paintTutorial1 = true;
                this.paintTutorial2 = false;
            } else {
                this.tutorial1 = null;
                this.tutorial2 = null;
                this.paintTutorial1 = false;
                this.paintTutorial2 = false;
            }
        }
        this.resumeSound();
    }

    public void resetLanguage() {
        BPFontReader.splitGraphicText(2, 176, true);
        BPFontReader.splitGraphicText(0, 176, true);
        BPFontReader.splitGraphicText(1, 176, true);
        BPFontReader.splitGraphicText(4, 176, true);
        BPFontReader.splitGraphicText(5, 176, true);
    }

    public void resumeSound() {
        MainCanvas.playSound(0, true);
    }

    public boolean canSave() {
        return true;
    }

    public void saveGame(DataOutputStream dos) {
        try {
            int j;
            int i;
            dos.writeByte((byte)this.shipSet);
            dos.writeByte((byte)this.gameMode);
            dos.writeByte((byte)playerNum);
            dos.writeByte((byte)player);
            dos.writeByte((byte)this.size);
            dos.writeByte((byte)map[0].length);
            dos.writeByte((byte)map[0][0].length);
            dos.writeByte((byte)this.difficulty);
            dos.writeByte((byte)gameState);
            dos.writeInt(this.gameTime);
            for (i = 0; i < map.length; ++i) {
                for (j = 0; j < map[i].length; ++j) {
                    for (int k = 0; k < map[i][j].length; ++k) {
                        dos.writeByte(map[i][j][k]);
                    }
                }
            }
            if (errorMap != null) {
                dos.writeBoolean(true);
                for (i = 0; i < errorMap.length; ++i) {
                    for (j = 0; j < errorMap[i].length; ++j) {
                        dos.writeBoolean(errorMap[i][j]);
                    }
                }
            } else {
                dos.writeBoolean(false);
            }
            if (lockMap != null) {
                dos.writeBoolean(true);
                for (i = 0; i < lockMap.length; ++i) {
                    for (j = 0; j < lockMap[i].length; ++j) {
                        dos.writeBoolean(lockMap[i][j]);
                    }
                }
            } else {
                dos.writeBoolean(false);
            }
            if (digitsHorizontal != null) {
                dos.writeBoolean(true);
            } else {
                dos.writeBoolean(false);
            }
            if (this.ships != null) {
                dos.writeBoolean(true);
                for (i = 0; i < this.ships.length; ++i) {
                    for (j = 0; j < this.ships[i].length; ++j) {
                        dos.writeBoolean(this.ships[i][j] != null);
                        if (this.ships[i][j] == null) continue;
                        this.ships[i][j].save(dos);
                    }
                }
            } else {
                dos.writeBoolean(false);
            }
            dos.writeByte((byte)this.computerShotListSize);
            for (i = 0; i < this.computerShotListSize; ++i) {
                dos.writeByte(this.computerShotListX[i]);
                dos.writeByte(this.computerShotListY[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadGame(DataInputStream dis) {
        this.reset();
        try {
            int j;
            int i;
            this.shipSet = dis.readByte();
            this.gameMode = dis.readByte();
            playerNum = dis.readByte();
            player = dis.readByte();
            this.size = dis.readByte();
            byte sizeX = dis.readByte();
            byte sizeY = dis.readByte();
            this.countBoardOffset(sizeX, sizeY);
            this.difficulty = dis.readByte();
            gameState = dis.readByte();
            this.gameTime = dis.readInt();
            int time = this.gameTime / 1000;
            this.gameTimeString = MainCanvas.timeToString(time);
            map = new byte[2][sizeX][sizeY];
            for (int i2 = 0; i2 < map.length; ++i2) {
                for (int j2 = 0; j2 < map[i2].length; ++j2) {
                    for (int k = 0; k < map[i2][j2].length; ++k) {
                        Game.map[i2][j2][k] = dis.readByte();
                    }
                }
            }
            boolean temp = dis.readBoolean();
            if (temp) {
                errorMap = new boolean[sizeX][sizeY];
                for (i = 0; i < errorMap.length; ++i) {
                    for (j = 0; j < errorMap[i].length; ++j) {
                        Game.errorMap[i][j] = dis.readBoolean();
                    }
                }
            } else {
                errorMap = null;
            }
            if (temp = dis.readBoolean()) {
                lockMap = new boolean[sizeX][sizeY];
                for (i = 0; i < lockMap.length; ++i) {
                    for (j = 0; j < lockMap[i].length; ++j) {
                        Game.lockMap[i][j] = dis.readBoolean();
                    }
                }
            } else {
                lockMap = null;
            }
            if (temp = dis.readBoolean()) {
                digitsHorizontal = new byte[sizeX];
                digitsVertical = new byte[sizeY];
                this.countDigits();
            }
            if (temp = dis.readBoolean()) {
                this.ships = new Ship[2][SHIP_TYPE.length];
                for (i = 0; i < this.ships.length; ++i) {
                    for (j = 0; j < this.ships[i].length; ++j) {
                        temp = dis.readBoolean();
                        if (!temp) continue;
                        this.ships[i][j] = new Ship(dis);
                    }
                }
            } else {
                this.ships = null;
            }
            this.computerShotListSize = dis.readByte();
            if (this.computerShotListSize > 0) {
                this.computerShotListX = new byte[this.computerShotListSize];
                this.computerShotListY = new byte[this.computerShotListSize];
                for (i = 0; i < this.computerShotListSize; ++i) {
                    this.computerShotListX[i] = dis.readByte();
                    this.computerShotListY[i] = dis.readByte();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.gameMode == 0 && playerNum == 2) {
            this.paintPlayer = true;
        }
    }

    private int getShotAnimTime() {
        if (shotAnimHit) {
            return gfx.getFrameNum(11) * 100;
        }
        return (gfx.getFrameNum(1) + 5) * 100;
    }

    public static boolean isFieldAnimating(int x, int y) {
        return paintShotAnim && x == shotAnimPosX && y == shotAnimPosY;
    }

    public static boolean isComputerMove() {
        return playerNum == 1 && player == 1;
    }

    public static int getGameState() {
        return gameState;
    }

    public static void setField(int player, int x, int y, int field) {
        if (x < 0 || y < 0 || x >= map[player].length || y >= map[player][x].length) {
            return;
        }
        Game.map[player][x][y] = (byte)field;
    }

    public void setSolveRestartMenu() {
        if (this.gameMode == 1 && !this.paintGameOver && !this.paintSolvedDiagram) {
            MainCanvas.itemSolveDiagram.isActive = true;
            MainCanvas.itemRestartDiagram.isActive = true;
        } else {
            MainCanvas.itemSolveDiagram.isActive = false;
            MainCanvas.itemRestartDiagram.isActive = false;
        }
    }

    public void actionKeyPressed(int keyCode) {
        if (keyCode == 2048 || keyCode == 8192) {
            this.lastKeyCode = 0;
            if (this.paintTutorial1) {
                MainCanvas.gameStage = 0;
                MainCanvas.showMenu(MainCanvas.mainMenu, null, 0);
            } else if (this.paintTutorial2) {
                this.paintTutorial1 = true;
                this.paintTutorial2 = false;
            } else if (!MainCanvas.isGamePlaying) {
                MainCanvas.gameStage = 0;
                MainCanvas.showMenu(MainCanvas.mainMenu, null, 0);
            } else {
                this.setSolveRestartMenu();
                MainCanvas.gameStage = 0;
                MainCanvas.showMenu(MainCanvas.inGameMenu, null, 0);
            }
            return;
        }
        if (this.paintTutorial1) {
            if (keyCode == 1024 || keyCode == 256) {
                this.paintTutorial1 = false;
                this.paintTutorial2 = true;
            } else {
                this.tutorial1.keyPressed(keyCode);
            }
        } else if (this.paintTutorial2) {
            if (keyCode == 1024 || keyCode == 256) {
                this.paintTutorial1 = false;
                this.paintTutorial2 = false;
                if (this.gameMode == 1) {
                    MainCanvas.diagramTutorialPresented = true;
                } else {
                    MainCanvas.battleTutorialPresented = true;
                }
            } else {
                this.tutorial2.keyPressed(keyCode);
            }
        } else {
            this.action(keyCode);
            if (keyCode == 1 || keyCode == 16 || keyCode == 32 || keyCode == 2 || keyCode == 64 || keyCode == 128 || keyCode == 4 || keyCode == 8) {
                this.lastKeyCode = keyCode;
                this.keyTime = 0;
                this.keyQuick = false;
            }
        }
    }

    public void clearKeys() {
        this.lastKeyCode = -1;
        this.keyTime = 0;
        this.keyQuick = false;
    }

    public void actionKeyReleased(int keyCode) {
        this.pressTimer = 0;
        this.prevKeyCode = 0;
        if (this.paintTutorial1) {
            this.tutorial1.keyReleased(keyCode);
        } else if (this.paintTutorial2) {
            this.tutorial2.keyReleased(keyCode);
        } else {
            this.lastKeyCode = -1;
            this.keyQuick = false;
        }
    }

    public static void vibrate(int time) {
        if (time > vibraTime) {
            MainCanvas.vibrate(time);
            vibraTime = time;
        }
    }

    private void computerSetShips() {
        while (player == 1) {
            boolean v;
            int y;
            int x;
            do {
                if (v = MainCanvas.getRandom(0, 1) == 1) {
                    x = MainCanvas.getRandom(0, map[0].length - 1);
                    y = MainCanvas.getRandom(0, map[0].length - SHIP_TYPE[this.shipSet]);
                    continue;
                }
                x = MainCanvas.getRandom(0, map[0].length - SHIP_TYPE[this.shipSet]);
                y = MainCanvas.getRandom(0, map[0].length - 1);
            } while (!this.testShipPosition(x, y, v));
            this.setShip(x, y, v);
        }
    }

    private void removeFromShotList(int x, int y) {
        for (int i = 0; i < this.computerShotListSize; ++i) {
            if (this.computerShotListX[i] != x || this.computerShotListY[i] != y) continue;
            this.computerShotListX[i] = this.computerShotListX[this.computerShotListSize - 1];
            this.computerShotListY[i] = this.computerShotListY[this.computerShotListSize - 1];
            --this.computerShotListSize;
            return;
        }
    }

    private void removeFromShotList(int x1, int y1, int x2, int y2) {
        int i = 0;
        while (i < this.computerShotListSize) {
            if (this.computerShotListX[i] >= x1 && this.computerShotListY[i] >= y1 && this.computerShotListX[i] <= x2 && this.computerShotListY[i] <= y2) {
                this.computerShotListX[i] = this.computerShotListX[this.computerShotListSize - 1];
                this.computerShotListY[i] = this.computerShotListY[this.computerShotListSize - 1];
                --this.computerShotListSize;
                continue;
            }
            ++i;
        }
    }

    private int computerShot() {
        Ship ship;
        boolean hit;
        int y;
        int x;
        int op = this.getOpponentPlayer();
        int shotX = -1;
        int shotY = -1;
        int[] order = this.shuffle(4);
        for (x = 0; x < map[op].length; ++x) {
            for (y = 0; y < map[op][x].length; ++y) {
                if (map[op][x][y] != 3) continue;
                if (this.isField(op, x - 1, y, 3)) {
                    if (!this.isField(op, x + 1, y, 0) && !this.isField(op, x + 1, y, 1)) continue;
                    shotX = x + 1;
                    shotY = y;
                    this.removeFromShotList(shotX, shotY);
                    break;
                }
                if (this.isField(op, x + 1, y, 3)) {
                    if (!this.isField(op, x - 1, y, 0) && !this.isField(op, x - 1, y, 1)) continue;
                    shotX = x - 1;
                    shotY = y;
                    this.removeFromShotList(shotX, shotY);
                    break;
                }
                if (this.isField(op, x, y - 1, 3)) {
                    if (!this.isField(op, x, y + 1, 0) && !this.isField(op, x, y + 1, 1)) continue;
                    shotX = x;
                    shotY = y + 1;
                    this.removeFromShotList(shotX, shotY);
                    break;
                }
                if (!this.isField(op, x, y + 1, 3) || !this.isField(op, x, y - 1, 0) && !this.isField(op, x, y - 1, 1)) continue;
                shotX = x;
                shotY = y - 1;
                this.removeFromShotList(shotX, shotY);
                break;
            }
            if (shotX >= 0) break;
        }
        if (shotX < 0) {
            for (x = 0; x < map[op].length; ++x) {
                for (y = 0; y < map[op][x].length; ++y) {
                    if (map[op][x][y] != 3) continue;
                    for (int i = 0; i < 4; ++i) {
                        if (order[i] == 0 && (this.isField(op, x - 1, y, 0) || this.isField(op, x - 1, y, 1))) {
                            shotX = x - 1;
                            shotY = y;
                            this.removeFromShotList(shotX, shotY);
                            break;
                        }
                        if (order[i] == 1 && (this.isField(op, x + 1, y, 0) || this.isField(op, x + 1, y, 1))) {
                            shotX = x + 1;
                            shotY = y;
                            this.removeFromShotList(shotX, shotY);
                            break;
                        }
                        if (order[i] == 2 && (this.isField(op, x, y - 1, 0) || this.isField(op, x, y - 1, 1))) {
                            shotX = x;
                            shotY = y - 1;
                            this.removeFromShotList(shotX, shotY);
                            break;
                        }
                        if (order[i] != 3 || !this.isField(op, x, y + 1, 0) && !this.isField(op, x, y + 1, 1)) continue;
                        shotX = x;
                        shotY = y + 1;
                        this.removeFromShotList(shotX, shotY);
                        break;
                    }
                    if (shotX >= 0) break;
                }
                if (shotX >= 0) break;
            }
        }
        if (shotX < 0) {
            int i = MainCanvas.getRandom(0, this.computerShotListSize - 1);
            shotX = this.computerShotListX[i];
            shotY = this.computerShotListY[i];
            this.computerShotListX[i] = this.computerShotListX[this.computerShotListSize - 1];
            this.computerShotListY[i] = this.computerShotListY[this.computerShotListSize - 1];
            --this.computerShotListSize;
        }
        if ((hit = this.shot(shotX, shotY, ship = this.findShip(op, shotX, shotY))) && ship.isSunken()) {
            this.removeFromShotList(ship.getPosX1() - 1, ship.getPosY1() - 1, ship.getPosX2() + 1, ship.getPosY2() + 1);
        }
        int r = shotX * map[0][0].length + shotY;
        if (hit) {
            return r;
        }
        return -r;
    }

    private void changePlayer() {
        player = player == 0 ? 1 : 0;
        if (playerNum > 1) {
            this.paintPlayer = true;
        }
    }

    private int getOpponentPlayer() {
        if (player == 0) {
            return 1;
        }
        return 0;
    }

    private boolean isField(int player, int x, int y, int field) {
        if (x < 0 || y < 0 || x >= map[0].length || y >= map[0][0].length) {
            return false;
        }
        return map[player][x][y] == (byte)field;
    }

    private boolean testShipPosition2(int shipX, int shipY, boolean shipVertical) {
        int y2;
        int x2;
        int x1 = shipX;
        int y1 = shipY;
        if (shipVertical) {
            x2 = x1;
            y2 = y1 + SHIP_TYPE[this.shipSet] - 1;
        } else {
            x2 = x1 + SHIP_TYPE[this.shipSet] - 1;
            y2 = y1;
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (x2 >= map[0].length) {
            x2 = map[0].length - 1;
        }
        if (y2 >= map[0][0].length) {
            y2 = map[0][0].length - 1;
        }
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                if (map[player][x][y] == 0) continue;
                return false;
            }
        }
        return true;
    }

    private boolean testShipPosition(int shipX, int shipY, boolean shipVertical) {
        int y2;
        int x2;
        int x1 = shipX;
        int y1 = shipY;
        if (shipVertical) {
            x2 = x1;
            y2 = y1 + SHIP_TYPE[this.shipSet] - 1;
        } else {
            x2 = x1 + SHIP_TYPE[this.shipSet] - 1;
            y2 = y1;
        }
        --y1;
        ++x2;
        ++y2;
        if (--x1 < 0) {
            x1 = 0;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (x2 >= map[0].length) {
            x2 = map[0].length - 1;
        }
        if (y2 >= map[0][0].length) {
            y2 = map[0][0].length - 1;
        }
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                if (map[player][x][y] == 0) continue;
                return false;
            }
        }
        return true;
    }

    private void deleteShip(int shipX, int shipY) {
        for (int i = 0; i < this.ships[player].length; ++i) {
            if (this.ships[player][i] == null || !this.ships[player][i].testField(shipX, shipY)) continue;
            int _x1 = this.ships[player][i].getPosX1();
            int _x2 = this.ships[player][i].getPosX2();
            int _y1 = this.ships[player][i].getPosY1();
            int _y2 = this.ships[player][i].getPosY2();
            for (int x = _x1; x <= _x2; ++x) {
                for (int y = _y1; y <= _y2; ++y) {
                    Game.map[Game.player][x][y] = 0;
                }
            }
            this.ships[Game.player][i] = null;
        }
    }

    private void deleteAllShips(int shipX, int shipY, boolean shipVertical) {
        if (shipVertical) {
            for (int y = shipY; y < shipY + SHIP_TYPE[this.shipSet]; ++y) {
                if (map[player][shipX][y] != 1) continue;
                this.deleteShip(shipX, y);
            }
        } else {
            for (int x = shipX; x < shipX + SHIP_TYPE[this.shipSet]; ++x) {
                if (map[player][x][shipY] != 1) continue;
                this.deleteShip(x, shipY);
            }
        }
        this.shipSet = 0;
        for (int i = 0; i < this.ships[player].length; ++i) {
            if (this.ships[player][i] != null) continue;
            this.shipSet = i;
            return;
        }
    }

    private void setShip(int shipX, int shipY, boolean shipVertical) {
        this.ships[Game.player][this.shipSet] = new Ship(shipX, shipY, shipVertical, SHIP_TYPE[this.shipSet], player);
        if (shipVertical) {
            for (int y = shipY; y < shipY + SHIP_TYPE[this.shipSet]; ++y) {
                Game.map[Game.player][shipX][y] = 1;
            }
        } else {
            for (int x = shipX; x < shipX + SHIP_TYPE[this.shipSet]; ++x) {
                Game.map[Game.player][x][shipY] = 1;
            }
        }
        do {
            ++this.shipSet;
            if (this.shipSet < SHIP_TYPE.length) continue;
            this.shipSet = 0;
            this.changePlayer();
            this.correctShipCursor();
            if (player == 0) {
                gameState = 1;
                MainCanvas.save();
            }
            return;
        } while (this.ships[player][this.shipSet] != null);
    }

    private Ship findShip(int player, int x, int y) {
        for (int i = 0; i < this.ships[player].length; ++i) {
            if (!this.ships[player][i].testField(x, y)) continue;
            return this.ships[player][i];
        }
        return null;
    }

    private boolean isAnyShipForPlayer(int player) {
        for (int i = 0; i < this.ships[player].length; ++i) {
            if (this.ships[player][i].isSunken()) continue;
            return true;
        }
        return false;
    }

    private void testGameOver() {
        boolean p0 = this.isAnyShipForPlayer(0);
        boolean p1 = this.isAnyShipForPlayer(1);
        if (!p0 || !p1) {
            this.playerWin = !p1 ? 0 : 1;
            this.gameOver = true;
            MainCanvas.vibrate(100);
        }
    }

    private boolean shot(int x, int y, Ship ship) {
        int opPlayer = this.getOpponentPlayer();
        if (map[opPlayer][x][y] == 0) {
            Game.map[opPlayer][x][y] = 2;
            return false;
        }
        if (map[opPlayer][x][y] == 1) {
            Game.map[opPlayer][x][y] = 3;
            if (ship == null) {
                ship = this.findShip(opPlayer, x, y);
            }
            if (ship.hit(x, y)) {
                this.testGameOver();
            }
            return true;
        }
        return false;
    }

    private int countShipFieldsVsDigitsVertical(int x) {
        int s = 0;
        for (int i = 0; i < map[1][x].length; ++i) {
            if (map[1][x][i] != 2) continue;
            ++s;
        }
        return s - digitsHorizontal[x];
    }

    private int countShipFieldsVsDigitsHorizontal(int y) {
        int s = 0;
        for (int i = 0; i < map[1].length; ++i) {
            if (map[1][i][y] != 2) continue;
            ++s;
        }
        return s - digitsVertical[y];
    }

    private boolean isVerticalLineOK(int x) {
        if (this.countShipFieldsVsDigitsVertical(x) != 0) {
            return false;
        }
        for (int i = 0; i < map[1][x].length; ++i) {
            if (!errorMap[x][i]) continue;
            return false;
        }
        return true;
    }

    private boolean isHorizontalLineOK(int y) {
        if (this.countShipFieldsVsDigitsHorizontal(y) != 0) {
            return false;
        }
        for (int i = 0; i < map[1].length; ++i) {
            if (!errorMap[i][y]) continue;
            return false;
        }
        return true;
    }

    private boolean isVerticalLineComplete(int x) {
        for (int i = 0; i < map[1][x].length; ++i) {
            if (map[1][x][i] == 0) {
                return false;
            }
            if (map[1][x][i] != 3) continue;
            return false;
        }
        return true;
    }

    private boolean isHorizontalLineComplete(int y) {
        for (int i = 0; i < map[1].length; ++i) {
            if (map[1][i][y] == 0) {
                return false;
            }
            if (map[1][i][y] != 3) continue;
            return false;
        }
        return true;
    }

    private boolean isShipOnDiagram(int x, int y) {
        if (x < 0 || y < 0 || x >= map[1].length || y >= map[1][0].length) {
            return false;
        }
        return map[1][x][y] == 2;
    }

    private boolean isShipLenghtOK(int x, int y, int dir) {
        int s = 1;
        do {
            if (dir == 1) {
                --x;
                continue;
            }
            if (dir == 2) {
                ++x;
                continue;
            }
            if (dir == 4) {
                --y;
                continue;
            }
            if (dir != 8) continue;
            ++y;
        } while (this.isShipOnDiagram(x, y) && ++s <= 4);
        return s <= 4;
    }

    public static void restartDiagram() {
        int _sizeX = map[0].length;
        int _sizeY = map[0][0].length;
        for (int y = 0; y < _sizeY; ++y) {
            for (int x = 0; x < _sizeX; ++x) {
                if (lockMap[x][y]) {
                    switch (map[0][x][y]) {
                        case 0: {
                            Game.map[1][x][y] = 1;
                            break;
                        }
                        case 1: {
                            Game.map[1][x][y] = 2;
                        }
                    }
                    continue;
                }
                Game.map[1][x][y] = 1;
            }
        }
    }

    public void solveDiagram() {
        int _sizeX = map[0].length;
        int _sizeY = map[0][0].length;
        for (int y = 0; y < _sizeY; ++y) {
            block5: for (int x = 0; x < _sizeX; ++x) {
                switch (map[0][x][y]) {
                    case 0: {
                        Game.map[1][x][y] = 1;
                        continue block5;
                    }
                    case 1: {
                        Game.map[1][x][y] = 2;
                    }
                }
            }
        }
        this.paintSolvedDiagram = true;
    }

    private void diagramIntegrity() {
        int y;
        int x;
        for (x = 0; x < map[1].length; ++x) {
            for (y = 0; y < map[1][x].length; ++y) {
                Game.errorMap[x][y] = false;
            }
        }
        for (x = 0; x < map[1].length; ++x) {
            for (y = 0; y < map[1][x].length; ++y) {
                if (map[1][x][y] != 2) continue;
                int direction = 0;
                if (this.isShipOnDiagram(x - 1, y)) {
                    direction |= 1;
                }
                if (this.isShipOnDiagram(x + 1, y)) {
                    direction |= 2;
                }
                if (this.isShipOnDiagram(x, y - 1)) {
                    direction |= 4;
                }
                if (this.isShipOnDiagram(x, y + 1)) {
                    direction |= 8;
                }
                if (this.isShipOnDiagram(x - 1, y - 1)) {
                    direction |= 0x10;
                }
                if (this.isShipOnDiagram(x + 1, y - 1)) {
                    direction |= 0x20;
                }
                if (this.isShipOnDiagram(x - 1, y + 1)) {
                    direction |= 0x40;
                }
                if (this.isShipOnDiagram(x + 1, y + 1)) {
                    direction |= 0x80;
                }
                if (direction == 0 || direction == 1 || direction == 2 || direction == 4 || direction == 8 || direction == 3 || direction == 12) {
                    if ((direction & 1) > 0 && !this.isShipLenghtOK(x, y, 1)) {
                        Game.errorMap[x][y] = true;
                    }
                    if ((direction & 2) > 0 && !this.isShipLenghtOK(x, y, 2)) {
                        Game.errorMap[x][y] = true;
                    }
                    if ((direction & 4) > 0 && !this.isShipLenghtOK(x, y, 4)) {
                        Game.errorMap[x][y] = true;
                    }
                    if ((direction & 8) <= 0 || this.isShipLenghtOK(x, y, 8)) continue;
                    Game.errorMap[x][y] = true;
                    continue;
                }
                Game.errorMap[x][y] = true;
            }
        }
        for (x = 0; x < map[1].length; ++x) {
            if (this.countShipFieldsVsDigitsVertical(x) <= 0) continue;
            for (y = 0; y < errorMap[x].length; ++y) {
                if (map[1][x][y] != 2) continue;
                Game.errorMap[x][y] = true;
            }
        }
        for (int y2 = 0; y2 < map[1][0].length; ++y2) {
            if (this.countShipFieldsVsDigitsHorizontal(y2) <= 0) continue;
            for (int x2 = 0; x2 < errorMap.length; ++x2) {
                if (map[1][x2][y2] != 2) continue;
                Game.errorMap[x2][y2] = true;
            }
        }
    }

    private void testDiagramComplete() {
        for (int x = 0; x < map[1].length; ++x) {
            if (this.isVerticalLineComplete(x) && this.isVerticalLineOK(x)) continue;
            return;
        }
        for (int y = 0; y < map[1][0].length; ++y) {
            if (this.isHorizontalLineComplete(y) && this.isHorizontalLineOK(y)) continue;
            return;
        }
        this.gameOver = true;
        this.paintGameOver = true;
        this.gameOverRecord = false;
        int time = this.gameTime / 1000;
        this.gameTimeString = MainCanvas.timeToString(time);
        if (MainCanvas.recordValues[this.size][this.difficulty] == 0 || MainCanvas.recordValues[this.size][this.difficulty] > time) {
            MainCanvas.recordValues[this.size][this.difficulty] = time;
            MainCanvas.recordValuesString[this.size][this.difficulty] = this.gameTimeString;
            MainCanvas.recordValues2SendString[this.size][this.difficulty] = MainCanvas.timeToString2Send(time);
            this.gameOverRecord = true;
        }
    }

    private void correctCursor() {
        if (this.cursorPosX < 0) {
            this.cursorPosX = map[0].length - 1;
        }
        if (this.cursorPosX >= map[0].length) {
            this.cursorPosX = 0;
        }
        if (this.cursorPosY < 0) {
            this.cursorPosY = map[0][0].length - 1;
        }
        if (this.cursorPosY >= map[0][0].length) {
            this.cursorPosY = 0;
        }
    }

    private void correctShipCursor() {
        if (this.cursorPosX < 0) {
            this.cursorPosX = 0;
        }
        if (this.cursorPosX >= map[0].length) {
            this.cursorPosX = map[0].length - 1;
        }
        if (this.cursorPosY < 0) {
            this.cursorPosY = 0;
        }
        if (this.cursorPosY >= map[0][0].length) {
            this.cursorPosY = map[0][0].length - 1;
        }
        if (this.cursorVertical) {
            if (this.cursorPosY + SHIP_TYPE[this.shipSet] > map[0][0].length) {
                this.cursorPosY = map[0][0].length - SHIP_TYPE[this.shipSet];
            }
        } else if (this.cursorPosX + SHIP_TYPE[this.shipSet] > map[0].length) {
            this.cursorPosX = map[0].length - SHIP_TYPE[this.shipSet];
        }
    }

    private void normalCursorService(int keyCode) {
        this.pressTimer = keyCode != this.prevKeyCode ? 0 : ++this.pressTimer;
        if (keyCode != this.prevKeyCode || this.pressTimer > 2) {
            if (keyCode == 4) {
                --this.cursorPosX;
            }
            if (keyCode == 8) {
                ++this.cursorPosX;
            }
            if (keyCode == 1) {
                --this.cursorPosY;
            }
            if (keyCode == 2) {
                ++this.cursorPosY;
            }
            if (keyCode == 16) {
                --this.cursorPosX;
                --this.cursorPosY;
            }
            if (keyCode == 32) {
                ++this.cursorPosX;
                --this.cursorPosY;
            }
            if (keyCode == 64) {
                --this.cursorPosX;
                ++this.cursorPosY;
            }
            if (keyCode == 128) {
                ++this.cursorPosX;
                ++this.cursorPosY;
            }
            if (keyCode == 1024) {
                this.cursorVertical = !this.cursorVertical;
            }
        }
        this.prevKeyCode = keyCode;
    }

    void startShotAnim(int posX, int posY, boolean hit) {
        paintShotAnim = true;
        shotAnimTime = 0;
        shotAnimPosX = posX;
        shotAnimPosY = posY;
        shotAnimHit = hit;
    }

    void action(int keyCode) {
        if (paintShotAnim) {
            return;
        }
        if (this.paintRamainingShips) {
            if (keyCode == 1024 || keyCode == 256 || keyCode == 512) {
                this.paintRamainingShips = false;
            }
        } else if (this.paintGameOver) {
            if (keyCode == 1024 || keyCode == 256) {
                if (this.gameMode == 1) {
                    if (!this.isShowGratulations) {
                        if (keyCode == 1024 || keyCode == 256) {
                            this.isShowGratulations = true;
                        }
                    } else {
                        MainCanvas.gameOver(this.gameMode == 1 ? this.gameOverRecord : false);
                    }
                } else {
                    MainCanvas.gameOver(this.gameMode == 1 ? this.gameOverRecord : false);
                }
            }
        } else if (this.paintSolvedDiagram) {
            if (keyCode == 1024 || keyCode == 256) {
                MainCanvas.gameOver(false);
            }
        } else if (this.paintPlayer) {
            if (keyCode == 1024 || keyCode == 256) {
                this.paintPlayer = false;
            }
        } else if (this.gameMode == 1) {
            this.normalCursorService(keyCode);
            this.correctCursor();
            if (keyCode == 1024) {
                if (!lockMap[this.cursorPosX][this.cursorPosY]) {
                    Game.map[1][this.cursorPosX][this.cursorPosY] = 0;
                    this.diagramIntegrity();
                    this.testDiagramComplete();
                }
            } else if (keyCode == 256) {
                if (!lockMap[this.cursorPosX][this.cursorPosY]) {
                    Game.map[1][this.cursorPosX][this.cursorPosY] = map[1][this.cursorPosX][this.cursorPosY] == 2 ? 1 : (map[1][this.cursorPosX][this.cursorPosY] == 1 ? 2 : 1);
                    this.diagramIntegrity();
                    this.testDiagramComplete();
                }
            } else if (keyCode == 512) {
                this.paintRamainingShips = true;
            }
        } else if (gameState == 0 && (player == 0 || playerNum == 2)) {
            this.normalCursorService(keyCode);
            this.correctShipCursor();
            if (keyCode == 256) {
                if (this.testShipPosition(this.cursorPosX, this.cursorPosY, this.cursorVertical)) {
                    this.setShip(this.cursorPosX, this.cursorPosY, this.cursorVertical);
                } else if (!this.testShipPosition2(this.cursorPosX, this.cursorPosY, this.cursorVertical)) {
                    this.deleteAllShips(this.cursorPosX, this.cursorPosY, this.cursorVertical);
                    this.correctShipCursor();
                }
            } else if (keyCode == 512) {
                this.paintRamainingShips = true;
            }
        } else if (gameState == 1) {
            this.normalCursorService(keyCode);
            this.correctCursor();
            if (keyCode == 256 && (map[this.getOpponentPlayer()][this.cursorPosX][this.cursorPosY] == 0 || map[this.getOpponentPlayer()][this.cursorPosX][this.cursorPosY] == 1)) {
                boolean hit = this.shot(this.cursorPosX, this.cursorPosY, null);
                this.startShotAnim(this.cursorPosX, this.cursorPosY, hit);
            }
            if (keyCode == 1024) {
                gameState = 2;
            } else if (keyCode == 512) {
                this.paintRamainingShips = true;
            }
        } else if (gameState == 2 && keyCode == 1024) {
            gameState = 1;
        }
    }

    public void myAction(int delta) {
        animTime += delta;
        if (this.paintTutorial1) {
            this.tutorial1.run(delta);
            return;
        }
        if (this.paintTutorial2) {
            this.tutorial2.run(delta);
            return;
        }
        if (paintShotAnim) {
            if ((shotAnimTime += delta) > this.getShotAnimTime()) {
                paintShotAnim = false;
                if (this.gameOver) {
                    this.paintGameOver = true;
                }
                if (!shotAnimHit) {
                    this.changePlayer();
                }
            }
            return;
        }
        if (this.paintPlayer || this.paintGameOver || this.paintSolvedDiagram) {
            return;
        }
        this.gameTime += delta;
        this.saveTime -= delta;
        if (this.saveTime <= 0) {
            MainCanvas.save();
            this.saveTime += 30000;
        }
        if (this.lastKeyCode >= 0) {
            this.keyTime += delta;
            if (this.keyQuick) {
                if (this.keyTime >= 100) {
                    this.keyTime -= 100;
                    this.action(this.lastKeyCode);
                }
            } else if (this.keyTime >= 250) {
                this.keyQuick = true;
                this.keyTime -= 250;
                this.action(this.lastKeyCode);
            }
        }
        if ((vibraTime -= delta) < 0) {
            vibraTime = 0;
        }
        if (playerNum == 1 && player == 1) {
            if (gameState == 0) {
                this.computerSetShips();
            } else if (gameState == 1) {
                boolean hit;
                int n = this.computerShot();
                boolean bl = hit = n > 0;
                if (n < 0) {
                    n = -n;
                }
                int x = n / map[0][0].length;
                int y = n % map[0][0].length;
                this.startShotAnim(x, y, hit);
            }
        }
    }

    private void paintGui(Graphics g) {
    }

    private void paintGratulations(Graphics g) {
        if (this.gameMode == 0) {
            g.setClip(0, 0, 176, 208);
            if (playerNum == 2) {
                int h = BPFontReader.getFontHeight(9) + MainCanvas.lineSpacing;
                int w = BPFontReader.getGraphicTextWidth(7, 0);
                int posY = 43 + this.endIMG.images[0][1].getHeight() / 2;
                g.drawImage(this.endIMG.images[0][1], (176 - this.endIMG.images[0][1].getWidth()) / 2, 43, 0);
                BPFontReader.drawGraphicTextLine(7 + player, 0, (176 - w) / 2, posY - h, g, 0);
                w = BPFontReader.getGraphicTextWidth(66, 0);
                BPFontReader.drawGraphicTextLine(66, 0, (176 - w) / 2, posY, g, 0);
            } else if (player == 0) {
                int h = BPFontReader.getFontHeight(9) + MainCanvas.lineSpacing;
                g.drawImage(this.endIMG.images[0][1], (176 - this.endIMG.images[0][1].getWidth()) / 2, 43, 0);
                int w = BPFontReader.getGraphicTextWidth(66, 0);
                BPFontReader.drawGraphicTextLine(66, 0, (176 - w) / 2, 43 + this.endIMG.images[0][1].getHeight() / 2, g, 0);
            } else {
                g.drawImage(this.endIMG.images[0][0], (176 - this.endIMG.images[0][0].getWidth()) / 2, 43, 0);
                int w = BPFontReader.getGraphicTextWidth(67, 0);
                BPFontReader.drawGraphicTextLine(67, 0, (176 - w) / 2, 43 + this.endIMG.images[0][0].getHeight() / 2, g, 0);
            }
        } else if (!this.isShowGratulations) {
            this.paintBoardDiagram(g);
            this.paintCursorDiagram(g);
            int h = BPFontReader.getFontHeight(65) + MainCanvas.lineSpacing;
            BPFontReader.drawGraphicTextLine(65, 0, 88, 2, g, 1);
        } else {
            int i;
            int h = BPFontReader.getFontHeight(2) + MainCanvas.lineSpacing;
            int _height = 10 * h;
            int _y = 0;
            _y = (208 - _height - 23) / 2;
            g.setColor(14277598);
            int space = 5;
            int _border = 5;
            g.fillRect(space + _border, _y + _border, 176 - 2 * space - 2 * _border, _height - 2 * _border);
            g.drawImage(Game.gfx.animationImage[14], space - _border, _y - _border, 0);
            g.drawImage(Game.gfx.animationImage[15], space - _border, _y + _height + _border, 36);
            g.drawImage(Game.gfx.animationImage[16], 176 - space + _border, _y - _border, 24);
            g.drawImage(Game.gfx.animationImage[13], 176 - space + _border, _y + _height + _border, 40);
            short iW = Game.gfx.animationImageWidth[14];
            short iW2 = Game.gfx.animationImageWidth[10];
            int nW = (176 - 2 * space - 2 * iW + 2 * _border) / iW2 + 1;
            for (i = 0; i < nW; ++i) {
                g.drawImage(Game.gfx.animationImage[10], space + iW + i * iW2 - _border, _y - _border, 0);
                g.drawImage(Game.gfx.animationImage[9], space + iW + i * iW2 - _border, _y + _height + _border, 36);
            }
            iW = Game.gfx.animationImageHeight[14];
            iW2 = Game.gfx.animationImageHeight[12];
            nW = (_height - 2 * iW + 2 * _border) / iW2 + 1;
            for (i = 0; i < nW; ++i) {
                g.drawImage(Game.gfx.animationImage[12], space - _border, _y + iW + i * iW2 - _border, 0);
                g.drawImage(Game.gfx.animationImage[11], 176 - space + _border, _y + iW + i * iW2 - _border, 24);
            }
            int l = BPFontReader.drawGraphicTextInWindow(2, 88, h + _y + _border, 0, 0, 176, 208, g, 17, MainCanvas.lineSpacing);
            BPFontReader.drawGraphicTextLine(3, 0, 88, h * (l += 2) + _y + _border, g, 1);
            BPFontReader.drawGraphicTextLine(this.gameTimeString, 88, h * (l + 1) + _y + _border, 0, -1, g, 1);
            if (this.gameOverRecord) {
                BPFontReader.drawGraphicTextLine(58, 0, 88, h * (l + 3) + _y + _border, g, 1);
            }
        }
    }

    private void paintShotAnim(Graphics g) {
        int _missTime;
        int posX = boardOffsetX + shotAnimPosX * 15;
        int posY = boardOffsetY + shotAnimPosY * 15;
        int anim = 1;
        int delay = 100;
        if (shotAnimHit) {
            anim = 11;
            delay = 100;
        }
        if ((_missTime = gfx.getFrameNum(1)) >= shotAnimTime / delay) {
            gfx.paintAnimation(0, anim, shotAnimTime / delay, posX, posY, 0, g);
        } else {
            gfx.paintAnimation(0, 10, 0, posX, posY, 0, g);
        }
    }

    private void paintBoard(Graphics g) {
        if (gameState == 0 || gameState == 2) {
            for (int x = 0; x < map[0].length; ++x) {
                for (int y = 0; y < map[0][0].length; ++y) {
                    gfx.paintAnimation(0, 10, 1 + x % 3 + 3 * (y % 3), boardOffsetX + x * 15, boardOffsetY + y * 15, 0, g);
                }
            }
        }
        if (gameState == 1 || gameState == 2) {
            int play = gameState == 1 ? this.getOpponentPlayer() : player;
            for (int x = 0; x < map[0].length; ++x) {
                for (int y = 0; y < map[0][0].length; ++y) {
                    byte field;
                    if (paintShotAnim && x == shotAnimPosX && y == shotAnimPosY || (field = map[play][x][y]) != 2) continue;
                    if (gameState == 1) {
                        gfx.paintAnimation(0, 10, 1 + x % 3 + 3 * (y % 3), boardOffsetX + x * 15, boardOffsetY + y * 15, 0, g);
                        continue;
                    }
                    gfx.paintAnimation(0, 40, 0, boardOffsetX + x * 15, boardOffsetY + y * 15, 0, g);
                }
            }
        }
    }

    private void paintDiagramField(Graphics g, int field, int x, int y, boolean cursor) {
        int posX = boardOffsetX + x * 15;
        int posY = boardOffsetY + y * 15;
        if (field != 0) {
            if (field == 1) {
                gfx.paintAnimation(0, 10, 1 + x % 3 + 3 * (y % 3), posX, posY, 0, g);
            } else if (field == 3) {
                g.setColor(128, 128, 128);
                g.drawString("  ?", boardOffsetX + x * 15, boardOffsetY + y * 15, 0);
            } else if (field == 2) {
                gfx.paintAnimation(0, 10, 1 + x % 3 + 3 * (y % 3), posX, posY, 0, g);
                if (cursor) {
                    gfx.paintAnimation(0, 3, 0, posX, posY, 0, g);
                } else {
                    if (this.isShipOnDiagram(x - 1, y) && this.isShipOnDiagram(x + 1, y)) {
                        gfx.paintAnimation(0, 9, 0, posX, posY, 0, g);
                    } else if (this.isShipOnDiagram(x, y - 1) && this.isShipOnDiagram(x, y + 1)) {
                        gfx.paintAnimation(0, 6, 0, posX, posY, 0, g);
                    } else if (this.isShipOnDiagram(x - 1, y) && !this.isShipOnDiagram(x + 1, y)) {
                        gfx.paintAnimation(0, 8, 0, posX, posY, 0, g);
                    } else if (this.isShipOnDiagram(x + 1, y) && !this.isShipOnDiagram(x - 1, y)) {
                        gfx.paintAnimation(0, 7, 0, posX, posY, 0, g);
                    } else if (this.isShipOnDiagram(x, y - 1) && !this.isShipOnDiagram(x, y + 1)) {
                        gfx.paintAnimation(0, 4, 0, posX, posY, 0, g);
                    } else if (this.isShipOnDiagram(x, y + 1) && !this.isShipOnDiagram(x, y - 1)) {
                        gfx.paintAnimation(0, 5, 0, posX, posY, 0, g);
                    } else {
                        gfx.paintAnimation(0, 3, 0, posX, posY, 0, g);
                    }
                    byte frame = gfx.correctFrame(40, animTime / 100, 0);
                    if (errorMap[x][y]) {
                        gfx.paintAnimation(0, 40, frame, posX, posY, 0, g);
                    }
                }
            }
        }
    }

    private void paintDiagramFrame(Graphics _g, int x, int y) {
        int posX = boardOffsetX + x * 15;
        int posY = boardOffsetY + y * 15;
        _g.setColor(7536384);
        _g.setClip(0, 0, 176, 208);
        _g.drawRect(posX - 1, posY, 15, 15);
    }

    private void paintDiagramTimer(Graphics _g) {
        int time = this.gameTime / 1000;
        this.gameTimeString = MainCanvas.timeToString(time);
        BPFontReader.drawGraphicTextLine(this.gameTimeString, 88, 0, 0, -1, _g, 1);
    }

    private void paintTicker(Graphics g, int x, int y, int transX, int transY) {
        g.drawImage(this.endIMG.images[0][2], boardOffsetX + x * 15 + transX, boardOffsetY + y * 15 + transY, 0);
    }

    private void paintBoardDiagram(Graphics g) {
        for (int x = 0; x < map[0].length; ++x) {
            for (int y = 0; y < map[0][0].length; ++y) {
                byte field = map[1][x][y];
                this.paintDiagramField(g, field, x, y, false);
                if (!lockMap[x][y]) continue;
                this.paintDiagramFrame(g, x, y);
            }
        }
        int offsetX = (15 - BPFontReader.getASCIICharWidth('0', 0)) / 2;
        for (int x = 0; x < digitsHorizontal.length; ++x) {
            BPFontReader.drawASCIIChar((char)(digitsHorizontal[x] + 48), boardOffsetX + offsetX + x * 15, boardOffsetY + map[0][0].length * 15, 0, g);
            if (!this.isVerticalLineComplete(x) || !this.isVerticalLineOK(x)) continue;
            this.paintTicker(g, x, 0, (15 - this.endIMG.images[0][2].getWidth()) / 2, -2 * this.endIMG.images[0][2].getHeight() + 4);
        }
        int offsetY = (15 - BPFontReader.getFontHeightByAlphabetId(0)) / 2;
        for (int y = 0; y < digitsVertical.length; ++y) {
            BPFontReader.drawASCIIChar((char)(digitsVertical[y] + 48), boardOffsetX + map[0].length * 15, boardOffsetY + offsetY + y * 15, 0, g);
            if (!this.isHorizontalLineComplete(y) || !this.isHorizontalLineOK(y)) continue;
            this.paintTicker(g, 0, y, -2 * this.endIMG.images[0][2].getWidth() + 3, (15 - this.endIMG.images[0][2].getHeight()) / 2);
        }
    }

    private void paintShips(Graphics g) {
        int play = gameState == 0 || gameState == 2 ? player : this.getOpponentPlayer();
        for (int i = 0; i < this.ships[play].length; ++i) {
            if (this.ships[play][i] == null) continue;
            this.ships[play][i].paint(g);
        }
    }

    private void paintCursor(Graphics g) {
        if (playerNum == 1 && player == 1) {
            return;
        }
        if (gameState == 0) {
            Ship.paint(g, this.cursorPosX, this.cursorPosY, this.cursorVertical, SHIP_TYPE[this.shipSet], false, player, null);
        } else if (gameState == 1) {
            gfx.paintAnimation(0, 2, 0, boardOffsetX + this.cursorPosX * 15, boardOffsetY + this.cursorPosY * 15 + 1, 0, g);
        }
    }

    private void paintCursorDiagram(Graphics g) {
        gfx.paintAnimation(0, 2, 0, boardOffsetX + this.cursorPosX * 15, boardOffsetY + this.cursorPosY * 15 + 1, 0, g);
    }

    public void paintBackground(Graphics g) {
        int anim = 0;
        if (map[0].length == 6) {
            anim = 25;
        } else if (map[0].length == 8) {
            anim = 26;
        } else if (map[0].length == 10) {
            anim = 27;
        }
        g.setClip(0, 0, 176, 208);
        gfx.paintAnimation(0, anim, 0, 0, backgroundPosY, 0, g);
    }

    public static void paintSofts(Graphics g, int left, int mid, int right) {
        if (left >= 0) {
            gfx.paintAnimation(0, left, 0, 0, 208 - gfx.getHeight(left, 0), 0, g);
        }
        if (mid >= 0) {
            gfx.paintAnimation(0, mid, 0, (176 - gfx.getWidth(mid, 0)) / 2, 208 - gfx.getHeight(mid, 0), 0, g);
        }
        if (right >= 0) {
            gfx.paintAnimation(0, right, 0, 176 - gfx.getWidth(right, 0), 208 - gfx.getHeight(right, 0), 0, g);
        }
    }

    public void paint(Graphics g, boolean paintSofts) {
        block68: {
            try {
                g.setClip(0, 0, 176, 208);
                this.paintBackground(g);
                int _posX = 9;
                int _posY = MainCanvas.UP_SPACE;
                int _width = 176 - 2 * _posX;
                int _height = 208 - MainCanvas.UP_SPACE - MainCanvas.DOWN_SPACE;
                if (this.paintTutorial1) {
                    g.setColor(0);
                    g.drawRect(_posX - 1, _posY - 1, _width + 1, _height + 1);
                    g.setColor(11119795);
                    g.setColor(14277598);
                    g.fillRect(_posX, _posY, _width, _height);
                    this.tutorial1.paint(g, 0, 0);
                    if (paintSofts) {
                        Game.paintSofts(g, 15, -1, 14);
                    }
                    break block68;
                }
                if (this.paintTutorial2) {
                    g.setColor(0);
                    g.drawRect(_posX - 1, _posY - 1, _width + 1, _height + 1);
                    g.setColor(11119795);
                    g.fillRect(_posX, _posY, _width, _height);
                    this.tutorial2.paint(g, 0, 0);
                    if (paintSofts) {
                        Game.paintSofts(g, 15, -1, 13);
                    }
                    break block68;
                }
                if (this.paintGameOver) {
                    this.paintGratulations(g);
                    if (paintSofts) {
                        Game.paintSofts(g, 15, -1, 14);
                    }
                    break block68;
                }
                if (this.paintPlayer) {
                    int i;
                    this.paintBoard(g);
                    this.paintShips(g);
                    int _h = BPFontReader.getFontHeight(6) + 8;
                    int _hw = _h * 6;
                    g.setColor(14277598);
                    int space = 10;
                    int _border = 5;
                    g.drawImage(Game.gfx.animationImage[14], space - _border, MainCanvas.UP_SPACE - _border, 0);
                    g.drawImage(Game.gfx.animationImage[15], space - _border, MainCanvas.UP_SPACE + _hw + _border, 36);
                    g.drawImage(Game.gfx.animationImage[16], 176 - space + _border, MainCanvas.UP_SPACE - _border, 24);
                    g.drawImage(Game.gfx.animationImage[13], 176 - space + _border, MainCanvas.UP_SPACE + _hw + _border, 40);
                    short iW = Game.gfx.animationImageWidth[14];
                    short iW2 = Game.gfx.animationImageWidth[10];
                    int nW = (176 - 2 * space - 2 * iW + 2 * _border) / iW2 + 1;
                    for (i = 0; i < nW; ++i) {
                        g.drawImage(Game.gfx.animationImage[10], space + iW + i * iW2 - _border, MainCanvas.UP_SPACE - _border, 0);
                        g.drawImage(Game.gfx.animationImage[9], space + iW + i * iW2 - _border, MainCanvas.UP_SPACE + _hw + _border, 36);
                    }
                    iW = Game.gfx.animationImageHeight[14];
                    iW2 = Game.gfx.animationImageHeight[12];
                    nW = (_hw - 2 * iW + 2 * _border) / iW2;
                    for (i = 0; i < nW; ++i) {
                        g.drawImage(Game.gfx.animationImage[12], space - _border, MainCanvas.UP_SPACE + iW + i * iW2 - _border, 0);
                        g.drawImage(Game.gfx.animationImage[11], 176 - space + _border, MainCanvas.UP_SPACE + iW + i * iW2 - _border, 24);
                    }
                    this.cursorPosX = 0;
                    this.cursorPosY = 0;
                    if (gameState == 0) {
                        BPFontReader.drawGraphicTextLine(7 + player, 0, 88, _posY + 2 * _h, g, 1);
                        BPFontReader.drawGraphicTextLine(60, 0, 88, _posY + 5 * _h, g, 1);
                    } else {
                        gameState = 1;
                        BPFontReader.drawGraphicTextLine(6, 0, 88, _posY + 2 * _h, g, 1);
                        BPFontReader.drawGraphicTextLine(7 + player, 0, 88, _posY + 3 * _h, g, 1);
                    }
                    if (paintSofts) {
                        Game.paintSofts(g, 15, -1, 14);
                    }
                    break block68;
                }
                if (this.paintRamainingShips) {
                    int i;
                    _posY = 20;
                    _height = 188 - MainCanvas.DOWN_SPACE;
                    g.setColor(14277598);
                    int space = 10;
                    int _border = 5;
                    g.fillRect(space + _border, 20 + _border, 176 - 2 * space - 2 * _border, _height - 2 * _border);
                    g.drawImage(Game.gfx.animationImage[14], space - _border, 20 - _border, 0);
                    g.drawImage(Game.gfx.animationImage[15], space - _border, 20 + _height + _border, 36);
                    g.drawImage(Game.gfx.animationImage[16], 176 - space + _border, 20 - _border, 24);
                    g.drawImage(Game.gfx.animationImage[13], 176 - space + _border, 20 + _height + _border, 40);
                    short iW = Game.gfx.animationImageWidth[14];
                    short iW2 = Game.gfx.animationImageWidth[10];
                    int nW = (176 - 2 * space - 2 * iW + 2 * _border) / iW2 + 1;
                    for (i = 0; i < nW; ++i) {
                        g.drawImage(Game.gfx.animationImage[10], space + iW + i * iW2 - _border, 20 - _border, 0);
                        g.drawImage(Game.gfx.animationImage[9], space + iW + i * iW2 - _border, 20 + _height + _border, 36);
                    }
                    iW = Game.gfx.animationImageHeight[14];
                    iW2 = Game.gfx.animationImageHeight[12];
                    nW = (_height - 2 * iW + 2 * _border) / iW2 + 1;
                    for (i = 0; i < nW; ++i) {
                        g.drawImage(Game.gfx.animationImage[12], space - _border, 20 + iW + i * iW2 - _border, 0);
                        g.drawImage(Game.gfx.animationImage[11], 176 - space + _border, 20 + iW + i * iW2 - _border, 24);
                    }
                    g.setColor(0);
                    g.setColor(11119795);
                    if (this.gameMode == 1) {
                        BPFontReader.drawGraphicTextLine(64, 0, 88, _posY + 5, g, 1);
                    } else {
                        BPFontReader.drawGraphicTextLine(53, 0, 88, _posY + 5, g, 1);
                    }
                    g.setColor(14277598);
                    for (i = 0; i < 4; ++i) {
                        for (int j = 0; j < 7; ++j) {
                            g.fillRect(_posX + 20 + i * 15, _posY + 30 + j * 15, 15, 15);
                        }
                    }
                    g.setColor(0);
                    for (i = 0; i <= 4; ++i) {
                        g.drawLine(_posX + 20 + i * 15, _posY + 30, _posX + 20 + i * 15, _posY + 30 + 105);
                    }
                    for (int j = 0; j <= 7; ++j) {
                        g.drawLine(_posX + 20, _posY + 30 + j * 15, _posX + 20 + 60, _posY + 30 + j * 15);
                    }
                    gfx.paintAnimation(0, 3, 0, _posX + 20 + 45, _posY + 30 + 0, 0, g);
                    gfx.paintAnimation(0, 7, 0, _posX + 20 + 30, _posY + 30 + 30, 0, g);
                    gfx.paintAnimation(0, 8, 0, _posX + 20 + 45, _posY + 30 + 30, 0, g);
                    gfx.paintAnimation(0, 7, 0, _posX + 20 + 15, _posY + 30 + 60, 0, g);
                    gfx.paintAnimation(0, 9, 0, _posX + 20 + 30, _posY + 30 + 60, 0, g);
                    gfx.paintAnimation(0, 8, 0, _posX + 20 + 45, _posY + 30 + 60, 0, g);
                    gfx.paintAnimation(0, 7, 0, _posX + 20 + 0, _posY + 30 + 90, 0, g);
                    gfx.paintAnimation(0, 9, 0, _posX + 20 + 15, _posY + 30 + 90, 0, g);
                    gfx.paintAnimation(0, 9, 0, _posX + 20 + 30, _posY + 30 + 90, 0, g);
                    gfx.paintAnimation(0, 8, 0, _posX + 20 + 45, _posY + 30 + 90, 0, g);
                    int _ship1 = 0;
                    int _ship2 = 0;
                    int _ship3 = 0;
                    int _ship4 = 0;
                    int _player = player + 1 & 1;
                    if (this.gameMode == 1) {
                        switch (this.diagramSize) {
                            case 6: {
                                _ship1 = 3;
                                _ship2 = 2;
                                _ship3 = 1;
                                _ship4 = 0;
                                break;
                            }
                            default: {
                                _ship1 = 4;
                                _ship2 = 3;
                                _ship3 = 2;
                                _ship4 = 1;
                                break;
                            }
                        }
                    } else if (gameState == 0) {
                        _player = player;
                        _ship1 = 4;
                        _ship2 = 3;
                        _ship3 = 2;
                        _ship4 = 1;
                        if (this.ships[_player] != null) {
                            block25: for (int i2 = 0; i2 < this.ships[_player].length; ++i2) {
                                if (this.ships[_player][i2] == null) continue;
                                switch (this.ships[_player][i2].lenght) {
                                    case 1: {
                                        --_ship1;
                                        continue block25;
                                    }
                                    case 2: {
                                        --_ship2;
                                        continue block25;
                                    }
                                    case 3: {
                                        --_ship3;
                                        continue block25;
                                    }
                                    case 4: {
                                        --_ship4;
                                    }
                                }
                            }
                        }
                    } else {
                        block26: for (int i3 = 0; i3 < this.ships[_player].length; ++i3) {
                            if (this.ships[_player][i3].isSunken()) continue;
                            switch (this.ships[_player][i3].lenght) {
                                case 1: {
                                    ++_ship1;
                                    continue block26;
                                }
                                case 2: {
                                    ++_ship2;
                                    continue block26;
                                }
                                case 3: {
                                    ++_ship3;
                                    continue block26;
                                }
                                case 4: {
                                    ++_ship4;
                                }
                            }
                        }
                    }
                    BPFontReader.drawGraphicTextLine("" + _ship1, _posX + 20 + 90, 2 + _posY + 30 + 0, 0, (int)BPFontReader.letterSpacing[0], g, 8);
                    BPFontReader.drawGraphicTextLine("" + _ship2, _posX + 20 + 90, 2 + _posY + 30 + 30, 0, (int)BPFontReader.letterSpacing[0], g, 8);
                    BPFontReader.drawGraphicTextLine("" + _ship3, _posX + 20 + 90, 2 + _posY + 30 + 60, 0, (int)BPFontReader.letterSpacing[0], g, 8);
                    BPFontReader.drawGraphicTextLine("" + _ship4, _posX + 20 + 90, 2 + _posY + 30 + 90, 0, (int)BPFontReader.letterSpacing[0], g, 8);
                    if (paintSofts) {
                        Game.paintSofts(g, 15, -1, 14);
                    }
                    break block68;
                }
                if (this.gameMode == 0) {
                    this.paintBoard(g);
                    this.paintShips(g);
                    if (paintShotAnim) {
                        this.paintShotAnim(g);
                    } else {
                        this.paintCursor(g);
                    }
                    if (paintSofts) {
                        if (gameState == 0) {
                            if (this.testShipPosition2(this.cursorPosX, this.cursorPosY, this.cursorVertical)) {
                                if (this.testShipPosition(this.cursorPosX, this.cursorPosY, this.cursorVertical)) {
                                    Game.paintSofts(g, 18, 17, 14);
                                } else {
                                    Game.paintSofts(g, 18, 24, 14);
                                }
                            } else {
                                Game.paintSofts(g, 18, 22, 14);
                            }
                        } else if (gameState == 1) {
                            Game.paintSofts(g, 19, 21, 14);
                        } else if (gameState == 2) {
                            Game.paintSofts(g, 20, -1, 14);
                        }
                    }
                    if (playerNum == 2) {
                        int wo = BPFontReader.getGraphicTextWidth(7, 0) + 5;
                        BPFontReader.drawGraphicTextLine(7 + player, 0, (176 - wo) / 2, 1, g, 0);
                    } else if (player == 0) {
                        int wo = BPFontReader.getGraphicTextWidth(7, 0) + 5;
                        BPFontReader.drawGraphicTextLine(7 + player, 2, (176 - wo) / 2, 0, g, 0);
                    } else {
                        int wo = BPFontReader.getGraphicTextWidth(63, 0) + 5;
                        BPFontReader.drawGraphicTextLine(63, 0, (176 - wo) / 2, 1, g, 0);
                    }
                } else {
                    this.paintBoardDiagram(g);
                    if (!this.paintSolvedDiagram) {
                        this.paintCursorDiagram(g);
                        this.paintDiagramTimer(g);
                    }
                    if (paintSofts) {
                        if (this.paintSolvedDiagram) {
                            Game.paintSofts(g, 15, -1, 14);
                        } else {
                            Game.paintSofts(g, 22, 23, 14);
                        }
                    }
                }
                this.paintGui(g);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void shuffle(int[] array) {
        for (int i = 0; i < array.length - 1; ++i) {
            int r = MainCanvas.getRandom(i, array.length - 1);
            int t = array[i];
            array[i] = array[r];
            array[r] = t;
        }
    }

    int[] shuffle(int n) {
        int[] array = new int[n];
        for (int i = 0; i < n; ++i) {
            array[i] = i;
        }
        this.shuffle(array);
        return array;
    }

    static {
        SHIP_TYPE = new int[]{4, 3, 3, 2, 2, 2, 1, 1, 1, 1};
        sb = new StringBuffer();
    }
}

