/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class Utils {
    private static byte[] atanTable = new byte[]{0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 6, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 15, 15, 15, 15, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 22, 22, 22, 22, 23, 23, 23, 23, 23, 24, 24, 24, 24, 25, 25, 25, 25, 25, 26, 26, 26, 26, 26, 27, 27, 27, 27, 27, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 30, 30, 30, 30, 30, 31, 31, 31, 31, 31, 31, 32, 32, 32, 32, 32};
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final char[] charBuffer = new char[33];
    private static char[] timeString = new char[8];
    private static long seed = Platform.clock();
    private static final int MIN_RADIX = 1;
    private static final int MAX_RADIX = 32;
    public static final int IMG_TYPE_CREATE_DIFF = 2;
    public static final int IMG_COLOR_VARIANT_0_BIT = 8;
    public static final int IMG_TYPE_CREATE_HORIZONTAL_MIRROR = 4;
    public static final int IMG_HAS_HORIZONTAL_MIRROR = 128;
    public static final int IMG_HAS_HORIZONTAL_MIRROR_MASK = 127;
    public static final int IMG_TOTAL_COLOR_VARIANT_MASK = 127;
    public static final int IMG_HORIZONTAL_MIRROR_MUST_LOADED = -1;
    private static final int[] progressBackColors = new int[]{0x7F0000, 0x7F7F00, 32512};
    private static final int[] progressFrontColors = new int[]{0xFF0000, 0xFFFF00, 65280};
    public static final int IMAGE_RGB = 0;
    public static final int IMAGE_RGBA = 1;
    public static final int IMAGE_LUMINANCE = 2;
    private static final boolean IMAGE_DEBUG = false;
    private static final int PNG_SIGNATURE1 = -1991225785;
    private static final int PNG_SIGNATURE2 = 218765834;
    private static final int PNG_CHUNK_IHDR = 1229472850;
    private static final int PNG_CHUNK_tRNS = 1951551059;
    private static final int PNG_COLOR_GRAYSCALE = 0;
    private static final int PNG_COLOR_RGB = 2;
    private static final int PNG_COLOR_INDEXED = 3;
    private static final int PNG_COLOR_GRAYSCALE_ALPHA = 4;
    private static final int PNG_COLOR_RGBA = 6;
    private static Random r = new Random();

    public static boolean rectCollision1(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n + n3 > n5 && n < n5 + n7 && n2 + n4 > n6 && n2 < n6 + n8;
    }

    public static final boolean rectCollision2(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n6 + n8 >= n2 && n6 <= n2 + n4 && n5 + n7 >= n && n5 <= n + n3;
    }

    public static int align(int n, int n2) {
        return n + --n2 & ~n2;
    }

    public static int wrap(int n, int n2, int n3) {
        if (n < n2) {
            return n3;
        }
        if (n > n3) {
            return n2;
        }
        return n;
    }

    public static int clamp(int n, int n2, int n3) {
        return Math.max(n2, Math.min(n3, n));
    }

    public static int lerp(int n, int n2, int n3) {
        return n + n3 * (n2 - n) / 256;
    }

    public static int lerp(int n, int n2, int n3, int n4) {
        return n + n3 * (n2 - n) / n4;
    }

    public static int atan2(int n, int n2) {
        int n3;
        if (n == 0) {
            return n2 < 0 ? 128 : 0;
        }
        if (n2 == 0) {
            return n <= 0 ? 192 : 64;
        }
        int n4 = n >= 0 ? n : -n;
        int n5 = n3 = n2 >= 0 ? n2 : -n2;
        if (n4 <= n3) {
            byte by = atanTable[((n4 << 7) + (n3 >> 1)) / n3];
            if (n2 > 0) {
                if (n > 0) {
                    return by;
                }
                return 256 - by;
            }
            if (n > 0) {
                return 128 - by;
            }
            return 128 + by;
        }
        byte by = atanTable[((n3 << 7) + (n4 >> 1)) / n4];
        if (n2 > 0) {
            if (n > 0) {
                return 64 - by;
            }
            return 192 + by;
        }
        if (n > 0) {
            return 64 + by;
        }
        return 192 - by;
    }

    public static int sqrt(int n) {
        int n2 = 1;
        int n3 = 32;
        if (n < 0) {
            return -1;
        }
        if (n == 0) {
            return 0;
        }
        int n4 = 0;
        for (int i = n <= 1 << n2 ? 1 << n2 : 1 << (n3 - 2 + n2 >> 1); i != 0; i >>= 1) {
            int n5 = (n4 + i) * (n4 + i);
            if (n5 <= n) {
                n4 += i;
            }
            if (n5 != n) continue;
            return n4;
        }
        return n4;
    }

    public static int length(int n, int n2) {
        return Utils.sqrt(n * n + n2 * n2);
    }

    public static int distance(int n, int n2, int n3, int n4) {
        int n5 = n - n3;
        int n6 = n2 - n4;
        return Utils.sqrt(n5 * n5 + n6 * n6);
    }

    public static int distanceSquared(int n, int n2, int n3, int n4) {
        int n5 = n - n3;
        int n6 = n2 - n4;
        return n5 * n5 + n6 * n6;
    }

    public static int lerpColor(int[] nArray, int n) {
        int n2 = nArray.length - 1;
        int n3 = n * n2;
        int n4 = Math.min(n2, n3 / 256);
        int n5 = Math.min(n2, n4 + 1);
        int n6 = nArray[n4];
        int n7 = nArray[n5];
        int n8 = n3 - 256 * n4;
        int n9 = Utils.lerp(n6 & 0xFF, n7 & 0xFF, n8);
        int n10 = Utils.lerp(n6 >> 8 & 0xFF, n7 >> 8 & 0xFF, n8);
        int n11 = Utils.lerp(n6 >> 16 & 0xFF, n7 >> 16 & 0xFF, n8);
        return n9 | n10 << 8 | n11 << 16;
    }

    private static int next(int n) {
        seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(seed >>> 48 - n);
    }

    public static int randomBits(int n) {
        return Utils.next(n);
    }

    public static int randomInterval(int n, int n2) {
        int n3 = n2 - n;
        int n4 = Utils.next(31) % (n3 + 1);
        return n + n4;
    }

    public static int randomDeviation(int n, int n2) {
        int n3 = Math.abs(n * n2 / 100);
        return Utils.randomInterval(n - n3, n + n3);
    }

    public static int randomSign() {
        int n = Utils.next(1) & 1;
        return 2 * n - 1;
    }

    public static boolean passProbability(int n) {
        return Utils.randomInterval(0, 100) <= n;
    }

    public static int bitCount(int n) {
        n = (n >> 1 & 0x55555555) + (n & 0x55555555);
        n = (n >> 2 & 0x33333333) + (n & 0x33333333);
        n = (n >> 4 & 0xF0F0F0F) + (n & 0xF0F0F0F);
        n = (n >> 8 & 0xFF00FF) + (n & 0xFF00FF);
        return (n >> 16 & 0xFFFF) + (n & 0xFFFF);
    }

    public static int highestOneBit(int n) {
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        return n ^ n >>> 1;
    }

    public static int lowestOneBit(int n) {
        return n & -n;
    }

    public static int numberOfLeadingZeros(int n) {
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        return Utils.bitCount(~n);
    }

    public static int numberOfTrailingZeros(int n) {
        return Utils.bitCount((n & -n) - 1);
    }

    public static boolean getFlag(int n, int n2) {
        return (n & 1 << n2) != 0;
    }

    public static int setFlag(int n, int n2, boolean bl) {
        int n3 = bl ? 1 : 0;
        return n & ~(1 << n2) | n3 << n2;
    }

    public static int itoa(int n, int n2, char[] cArray, int n3) {
        int n4 = Utils.itoa_backward(n, n2, charBuffer, charBuffer.length);
        int n5 = charBuffer.length - n4;
        Platform.arraycopy(charBuffer, n4, cArray, n3, n5);
        return n5;
    }

    public static String itoa(int n, int n2) {
        int n3 = Utils.itoa_backward(n, n2, charBuffer, charBuffer.length);
        int n4 = charBuffer.length - n3;
        return new String(charBuffer, n3, n4);
    }

    public static int itoa_backward(int n, int n2, char[] cArray, int n3) {
        if (n2 < 1 || n2 > 32) {
            n2 = 10;
        }
        int n4 = n3;
        boolean bl = false;
        if (n < 0) {
            bl = true;
            if ((n = -n) < 0) {
                cArray[--n4] = digits[-(n + n2) % n2];
                n = -(n / n2);
            }
        }
        do {
            cArray[--n4] = digits[n % n2];
        } while ((n /= n2) > 0);
        if (bl) {
            cArray[--n4] = 45;
        }
        return n4;
    }

    public static String formatTime(int n, boolean bl) {
        int n2 = n / 60 % 60;
        int n3 = n % 60;
        int n4 = 0;
        if (bl) {
            int n5 = n / 3600 % 24;
            Utils.timeString[n4++] = (char)(48 + n5 / 10);
            Utils.timeString[n4++] = (char)(48 + n5 % 10);
            Utils.timeString[n4++] = 58;
        }
        Utils.timeString[n4++] = (char)(48 + n2 / 10);
        Utils.timeString[n4++] = (char)(48 + n2 % 10);
        Utils.timeString[n4++] = 58;
        Utils.timeString[n4++] = (char)(48 + n3 / 10);
        Utils.timeString[n4++] = (char)(48 + n3 % 10);
        return new String(timeString, 0, n4);
    }

    public static String formatDecimal(int n) {
        int n2 = Utils.itoa(n, 10, charBuffer, 0);
        if (n2 == 1) {
            Utils.charBuffer[2] = charBuffer[0];
            Utils.charBuffer[1] = 46;
            Utils.charBuffer[0] = 48;
            n2 = 2;
        } else {
            Utils.charBuffer[n2] = charBuffer[n2 - 1];
            Utils.charBuffer[n2 - 1] = 46;
        }
        return new String(charBuffer, 0, n2 + 1);
    }

    public static String formatPercent(int n) {
        int n2 = Utils.itoa(n, 10, charBuffer, 0);
        return new String(charBuffer, 0, n2);
    }

    public static void readImages(PlatformResource platformResource, PlatformImage[] platformImageArray, byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            Utils.readDiffImage(platformResource, platformImageArray, byArray, n2, -1);
            int n3 = byArray[n2];
            n2 += Math.max(1, n3);
            while (n3 > 1) {
                Utils.readDiffImage(platformResource, platformImageArray, byArray, 0, -1);
                --n3;
            }
        }
    }

    public static void readDiffImage(PlatformResource platformResource, PlatformImage[] platformImageArray, byte[] byArray, int n, int n2) {
        boolean bl = true;
        int n3 = 0;
        PlatformImage platformImage = null;
        byte by = platformResource.readByte();
        short s = platformResource.readShort();
        boolean bl2 = false;
        if ((by & 2) == 0) {
            bl2 = true;
            n2 = 0;
        }
        if (s == 0) {
            return;
        }
        byte[] byArray2 = new byte[s];
        platformResource.readFully(byArray2);
        int n4 = 1;
        if (!bl2) {
            n4 = platformResource.readShort();
        }
        if (n2 < 0) {
            int n5 = n;
            byte[] byArray3 = new byte[s];
            for (int i = 0; i < n4; ++i) {
                n3 = (short)(n3 | 1 << 8 + i);
                Platform.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                if (i > 0) {
                    int n6 = platformResource.readUnsignedByte();
                    if (n6 == 0) {
                        n6 = platformResource.readShort();
                    }
                    for (int j = 0; j < n6; ++j) {
                        short s2 = platformResource.readShort();
                        byArray3[s2] = platformResource.readByte();
                    }
                }
                if (platformImageArray[n5] == null) {
                    platformImageArray[n5] = platformImage = Platform.createImage(0, byArray3, 0, byArray3.length);
                }
                ++n5;
            }
        } else {
            int n7;
            int n8 = 0;
            if (n2 > 0) {
                while (++n8 < n2) {
                    n7 = platformResource.readUnsignedByte();
                    if (n7 == 0) {
                        n7 = platformResource.readShort();
                    }
                    platformResource.skipBytes(n7 * 3);
                }
                n7 = platformResource.readUnsignedByte();
                if (n7 == 0) {
                    n7 = platformResource.readShort();
                }
                for (int i = 0; i < n7; ++i) {
                    short s3 = platformResource.readShort();
                    byArray2[s3] = platformResource.readByte();
                }
            }
            n3 = (short)(n3 | 1 << 8 + n2);
            if (bl && platformImageArray[n + n2] == null || !bl && platformImageArray[n] == null) {
                platformImage = Platform.createImage(0, byArray2, 0, byArray2.length);
                if (bl) {
                    platformImageArray[n + n2] = platformImage;
                } else {
                    platformImageArray[n] = platformImage;
                }
            }
            while (++n8 < n4) {
                n7 = platformResource.readUnsignedByte();
                if (n7 == 0) {
                    n7 = platformResource.readShort();
                }
                platformResource.skipBytes(n7 * 3);
            }
        }
        byArray[n] = (byte)n4;
        int n9 = n;
        byArray[n9] = (byte)(byArray[n9] | n3);
        if ((by & 4) != 0) {
            int n10 = n;
            byArray[n10] = (byte)(byArray[n10] | 0x80);
        }
    }

    public static int skipDiffImage(PlatformResource platformResource, int n) {
        int n2 = 0;
        int n3 = 0;
        byte by = platformResource.readByte();
        short s = platformResource.readShort();
        boolean bl = false;
        if ((by & 2) == 0) {
            bl = true;
            n = 0;
        }
        if (s == 0) {
            return n2;
        }
        platformResource.skipBytes(s);
        int n4 = 1;
        if (!bl) {
            n4 = platformResource.readShort();
        }
        if (n < 0) {
            byte[] byArray = new byte[s];
            for (int i = 0; i < n4; ++i) {
                n3 = (short)(n3 | 1 << 8 + i);
                if (i <= 0) continue;
                int n5 = platformResource.readUnsignedByte();
                if (n5 == 0) {
                    n5 = platformResource.readShort();
                }
                for (int j = 0; j < n5; ++j) {
                    short s2 = platformResource.readShort();
                    byArray[s2] = platformResource.readByte();
                }
            }
        } else {
            int n6;
            int n7 = 0;
            if (n > 0) {
                while (++n7 < n) {
                    n6 = platformResource.readUnsignedByte();
                    if (n6 == 0) {
                        n6 = platformResource.readShort();
                    }
                    platformResource.skipBytes(n6 * 3);
                }
                n6 = platformResource.readUnsignedByte();
                if (n6 == 0) {
                    n6 = platformResource.readShort();
                }
                for (int i = 0; i < n6; ++i) {
                    platformResource.readShort();
                    platformResource.readByte();
                }
            }
            n3 = (short)(n3 | 1 << 8 + n);
            while (++n7 < n4) {
                n6 = platformResource.readUnsignedByte();
                if (n6 == 0) {
                    n6 = platformResource.readShort();
                }
                platformResource.skipBytes(n6 * 3);
            }
        }
        n2 = (byte)n4;
        n2 |= n3;
        if ((by & 4) != 0) {
            n2 |= 0x80;
        }
        return n2;
    }

    public static int randomWeight(byte[] byArray, int n, int n2, int n3) {
        if (n2 <= 0) {
            return n3;
        }
        int n4 = 0;
        int n5 = Utils.randomInterval(0, n2 - 1);
        for (int i = 0; i < n - 1; ++i) {
            if (n5 >= (n4 += byArray[i])) continue;
            return i;
        }
        return n - 1;
    }

    public static int findSpan(int[] nArray, int n, int n2) {
        int n3 = nArray.length - 1;
        if (n >= nArray[n3]) {
            return n3 - 1;
        }
        if (n <= nArray[0]) {
            return 0;
        }
        int n4 = 0;
        int n5 = n3;
        while (true) {
            if (n < nArray[n2]) {
                n5 = n2;
            } else if (n >= nArray[n2 + 1]) {
                n4 = n2;
            } else {
                return n2;
            }
            n2 = (n4 + n5) / 2;
        }
    }

    public static int findSpanSequential(short[] sArray, int n, int n2) {
        int n3 = sArray.length - 1;
        if (n >= sArray[n3]) {
            return n3 - 1;
        }
        if (n <= sArray[0]) {
            return 0;
        }
        if (n > sArray[n2]) {
            while (n > sArray[n2 + 1]) {
                ++n2;
            }
        } else {
            while (n < sArray[n2]) {
                --n2;
            }
        }
        return n2;
    }

    public static int computeAlpha(int[] nArray, int n, int n2) {
        int n3 = nArray[n + 0];
        int n4 = nArray[n + 1];
        int n5 = n2 - n3;
        int n6 = n4 - n3;
        return 256 * n5 / n6;
    }

    public static int computeAlpha(short[] sArray, int n, int n2) {
        short s = sArray[n + 0];
        short s2 = sArray[n + 1];
        int n3 = n2 - s;
        int n4 = s2 - s;
        return 256 * n3 / n4;
    }

    public static Object[] add(Object[] objectArray, int n, Object object) {
        if (n == objectArray.length) {
            Object[] objectArray2 = new Object[2 * n + 4];
            Platform.arraycopy(objectArray, 0, objectArray2, 0, n);
            objectArray = objectArray2;
        }
        objectArray[n++] = object;
        return objectArray;
    }

    public static Object[] remove(Object[] objectArray, int n, Object object) {
        for (int i = 0; i < n; ++i) {
            if (object != objectArray[i]) continue;
            Utils.remove(objectArray, n, i);
            return objectArray;
        }
        return objectArray;
    }

    public static void remove(Object[] objectArray, int n, int n2) {
        if (n2 != --n) {
            Platform.arraycopy(objectArray, n2 + 1, objectArray, n2, n - n2);
        }
        objectArray[n] = null;
    }

    public static int readUnsignedByte(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    public static short readShort(byte[] byArray, int n) {
        int n2 = (byArray[n++] & 0xFF) << 8;
        return (short)(n2 |= (byArray[n++] & 0xFF) << 0);
    }

    public static int readUnsignedShort(byte[] byArray, int n) {
        return Utils.readShort(byArray, n) & 0xFFFF;
    }

    public static int readInt(byte[] byArray, int n) {
        int n2 = (byArray[n++] & 0xFF) << 24;
        n2 |= (byArray[n++] & 0xFF) << 16;
        n2 |= (byArray[n++] & 0xFF) << 8;
        return n2 |= (byArray[n++] & 0xFF) << 0;
    }

    public static byte[] readByteArray(byte[] byArray, int n) {
        int n2 = Utils.readUnsignedShort(byArray, n);
        byte[] byArray2 = new byte[n2];
        Platform.arraycopy(byArray, n += 2, byArray2, 0, n2);
        return byArray2;
    }

    public static short[] readShortArray(byte[] byArray, int n) {
        int n2 = Utils.readUnsignedShort(byArray, n);
        n += 2;
        short[] sArray = new short[n2];
        for (int i = 0; i < n2; ++i) {
            sArray[i] = Utils.readShort(byArray, n);
            n += 2;
        }
        return sArray;
    }

    public static int[] readIntArray(byte[] byArray, int n) {
        int n2 = Utils.readUnsignedShort(byArray, n);
        n += 2;
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = Utils.readInt(byArray, n);
            n += 4;
        }
        return nArray;
    }

    public static byte[] readByteArray(PlatformResource platformResource) {
        short s = platformResource.readShort();
        byte[] byArray = new byte[s];
        if (s > 0) {
            platformResource.readFully(byArray);
        }
        return byArray;
    }

    public static short[] readShortArray(PlatformResource platformResource) {
        int n = platformResource.readShort();
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = platformResource.readShort();
        }
        return sArray;
    }

    public static int[] readIntArray(PlatformResource platformResource) {
        int n = platformResource.readShort();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = platformResource.readInt();
        }
        return nArray;
    }

    public static int readInt24(PlatformResource platformResource) {
        int n = platformResource.readByte() & 0xFF;
        int n2 = platformResource.readByte() & 0xFF;
        int n3 = platformResource.readByte() & 0xFF;
        return n << 16 | n2 << 8 | n3 << 0;
    }

    public static String[] readStrings(PlatformResource platformResource) {
        int n = platformResource.readShort();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = platformResource.readUTF();
        }
        return stringArray;
    }

    public static void writeShort(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 0 & 0xFF);
    }

    public static void writeInt(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 0 & 0xFF);
    }

    public static void drawBox(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        PlatformGraphics platformGraphics = Platform.getDisplayGraphics();
        platformGraphics.setColor(n6);
        platformGraphics.fillRect(n -= n5, n2 -= n5, n3 += 2 * n5, n4 += 2 * n5);
        platformGraphics.setColor(n7);
        platformGraphics.drawRect(n, n2, n3 - 1, n4 - 1);
    }

    public static void drawRoundRect(int n, int n2, int n3, int n4) {
        PlatformGraphics platformGraphics = Platform.getDisplayGraphics();
        platformGraphics.drawLine(n + 1, n2, n + n3 - 2, n2);
        platformGraphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 2, n2 + n4 - 1);
        platformGraphics.drawLine(n, n2 + 1, n, n2 + n4 - 2);
        platformGraphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 2);
    }

    public static void drawRegion(PlatformImage platformImage, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        PlatformGraphics platformGraphics = Platform.getDisplayGraphics();
        if ((n7 & 8) != 0) {
            n5 -= n3;
        } else if ((n7 & 1) != 0) {
            n5 -= n3 / 2;
        }
        if ((n7 & 0x20) != 0) {
            n6 -= n4;
        } else if ((n7 & 2) != 0) {
            n6 -= n4 / 2;
        }
        platformGraphics.setClip(n5, n6, n3, n4);
        platformGraphics.drawImage(platformImage, n5 - n, n6 - n2, 20);
    }

    public static void drawPattern(int n, int n2, int n3, int n4, PlatformImage platformImage) {
        Utils.drawPattern(n, n2, n, n2, n3, n4, platformImage, 0, 0, platformImage.getWidth(), platformImage.getHeight());
    }

    public static void drawPattern(int n, int n2, int n3, int n4, PlatformImage platformImage, int n5, int n6, int n7, int n8) {
        Utils.drawPattern(n, n2, n, n2, n3, n4, platformImage, n5, n6, n7, n8);
    }

    public static void drawPattern(int n, int n2, int n3, int n4, int n5, int n6, PlatformImage platformImage, int n7, int n8, int n9, int n10) {
        PlatformGraphics platformGraphics = Platform.getDisplayGraphics();
        platformGraphics.setClip(n3, n4, n5, n6);
        int n11 = n3 + n5;
        int n12 = n4 + n6;
        for (int i = n2; i < n12; i += n10) {
            int n13 = Math.min(n10, n12 - i);
            for (int j = n; j < n11; j += n9) {
                int n14 = Math.min(n9, n11 - j);
                Utils.drawRegion(platformImage, n7, n8, n14, n10, j, i, 0);
            }
        }
    }

    public static void drawAttributeBar(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        PlatformGraphics platformGraphics = Platform.getDisplayGraphics();
        int n9 = Math.min(n3, n7 * n3 / n8);
        platformGraphics.setColor(n5);
        platformGraphics.fillRect(n - 1, n2 - 1, n3 + 2, n4 + 2);
        platformGraphics.setColor(n6);
        platformGraphics.fillRect(n, n2, n9, n4);
    }

    public static void drawHBar(int n, int n2, int n3, int n4, PlatformImage platformImage, PlatformImage platformImage2, int n5, int n6) {
        int n7 = Math.min(n3, n5 * n3 / n6);
        Utils.drawPattern(n, n2, n3, n4, platformImage);
        Utils.drawPattern(n, n2, n7, n4, platformImage2);
    }

    public static void drawVBar(int n, int n2, int n3, int n4, PlatformImage platformImage, PlatformImage platformImage2, int n5, int n6) {
        int n7 = Math.min(n4, n5 * n4 / n6);
        Utils.drawVPattern(n, n2, n3, n4, platformImage);
        Utils.drawVPattern(n, n2 + n4 - n7, n3, n7, platformImage2);
    }

    private static void drawVPattern(int n, int n2, int n3, int n4, PlatformImage platformImage) {
        PlatformGraphics platformGraphics = Platform.getDisplayGraphics();
        int n5 = platformImage.getHeight();
        int n6 = n;
        int n7 = n2 + n4;
        platformGraphics.setClip(n, n2, n3, n4);
        while (n7 >= n2) {
            platformGraphics.drawImage(platformImage, n6, n7 -= n5, 20);
        }
    }

    public static void drawProgressBarColor(int n, int n2, int n3, int n4, int n5) {
        PlatformGraphics platformGraphics = Platform.getDisplayGraphics();
        int n6 = Utils.lerpColor(progressFrontColors, n5);
        platformGraphics.setColor(n6);
        int n7 = n3 * n5 / 256;
        platformGraphics.fillRect(n, n2, n7, n4);
        n6 = Utils.lerpColor(progressBackColors, n5);
        platformGraphics.setColor(n6);
        platformGraphics.drawRect(n - 1, n2 - 1, n3 + 1, n4 + 1);
    }

    public static int drawSymbols(PlatformImage platformImage, String string, char[] cArray, int n, int n2, int n3, int n4) {
        int n5 = string.length();
        int n6 = platformImage.getWidth() / n5;
        int n7 = platformImage.getHeight();
        int n8 = n * n6;
        switch (n4) {
            case 4: {
                break;
            }
            case 8: {
                n2 -= n8;
                break;
            }
            case 1: {
                n2 -= n8 / 2;
            }
        }
        for (int i = 0; i < n; ++i) {
            int n9 = string.indexOf(cArray[i]);
            Utils.drawRegion(platformImage, n9 * n6, 0, n6, n7, n2, n3, 0);
            n2 += n6;
        }
        return n2;
    }

    public static int drawSymbols(PlatformImage platformImage, int[] nArray, int n, char[] cArray, int n2, int n3, int n4, int n5, int n6) {
        int n7 = platformImage.getHeight();
        if ((n5 & 8) != 0) {
            n3 -= Utils.getSymbolsWidth(nArray, n, cArray, n2, n6);
        } else if ((n5 & 1) != 0) {
            n3 -= Utils.getSymbolsWidth(nArray, n, cArray, n2, n6) / 2;
        }
        if ((n5 & 0x20) != 0) {
            n4 -= n7;
        } else if ((n5 & 2) != 0) {
            n4 -= n7 / 2;
        }
        for (int i = 0; i < n2; ++i) {
            int n8 = cArray[i] - n;
            int n9 = nArray[n8 + 1] - nArray[n8];
            Utils.drawRegion(platformImage, nArray[n8], 0, n9, n7, n3, n4, 0);
            n3 += n9 + n6;
        }
        return n3;
    }

    public static int drawSymbol(PlatformImage platformImage, int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = nArray[n + 1] - nArray[n];
        return Utils.drawSymbol(platformImage, nArray[n], n5, n2, n3, n4);
    }

    public static int drawSymbol(PlatformImage platformImage, int n, int n2, int n3, int n4, int n5) {
        int n6 = platformImage.getHeight();
        if ((n5 & 8) != 0) {
            n3 -= n2;
        } else if ((n5 & 1) != 0) {
            n3 -= n2 / 2;
        }
        if ((n5 & 0x20) != 0) {
            n4 -= n6;
        } else if ((n5 & 2) != 0) {
            n4 -= n6 / 2;
        }
        Utils.drawRegion(platformImage, n, 0, n2, n6, n3, n4, 0);
        return n3 += n2;
    }

    public static int getSymbolsWidth(int[] nArray, int n, char[] cArray, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = cArray[i] - n;
            n4 += nArray[n5 + 1] - nArray[n5] + n3;
        }
        return n4 - n3;
    }

    public static int[] generateSymbolsCoords(PlatformImage platformImage, int n) {
        int n2 = platformImage.getWidth();
        int n3 = n2 - 10 * n;
        int[] nArray = new int[12];
        int n4 = 0;
        for (int i = 0; i < 10; ++i) {
            nArray[i] = n4;
            n4 += n;
        }
        nArray[10] = n4;
        nArray[11] = n4 + n3;
        return nArray;
    }

    public static int getImageFormat(byte[] byArray, int n, int n2) {
        int n3 = Utils.readInt(byArray, 0);
        int n4 = Utils.readInt(byArray, 4);
        int n5 = Utils.readInt(byArray, n += 8);
        int n6 = Utils.readInt(byArray, n += 4);
        byte by = byArray[(n += 4) + 9];
        n += n5 + 4;
        switch (by) {
            case 2: {
                return 0;
            }
            case 6: {
                return 1;
            }
            case 3: {
                while (n < n2) {
                    n5 = Utils.readInt(byArray, n);
                    n6 = Utils.readInt(byArray, n += 4);
                    n += 4;
                    if (n6 == 1951551059) {
                        return 1;
                    }
                    n += n5 + 4;
                }
                return 0;
            }
            case 0: {
                return 0;
            }
            case 4: {
                return 1;
            }
        }
        return -1;
    }

    public static void drawTileImage(PlatformImage platformImage, int n, int n2, int n3, int n4, int n5, int n6) {
        PlatformGraphics platformGraphics = Platform.getDisplayGraphics();
        int n7 = platformImage.getWidth() / n3;
        int n8 = platformImage.getHeight() / n4;
        platformGraphics.setClip(n, n2, n7, n8);
        platformGraphics.drawImage(platformImage, n - n5 * n7, n2 - n6 * n8, 20);
    }

    public static int drawNums(PlatformImage platformImage, int n, int n2, int n3, int n4, int n5, boolean bl) {
        PlatformGraphics platformGraphics = Platform.getDisplayGraphics();
        int n6 = platformImage.getWidth() / 11;
        int n7 = platformImage.getHeight();
        n3 -= n6;
        for (int i = 0; i < n2; ++i) {
            int n8 = 10;
            if (n > 0) {
                n8 = n % 10;
            } else if (n == 0 && (bl || i == 0)) {
                n8 = 0;
            }
            platformGraphics.setClip(n3, n4, n6, n7);
            platformGraphics.drawImage(platformImage, n3 - n8 * n6, n4, 20);
            n3 -= n6 + (i + 1 > 0 && (i + 1) % 3 == 0 ? 3 * n5 : n5);
            n /= 10;
        }
        return n3 + n6;
    }

    public static int drawNums10(PlatformImage platformImage, int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = platformImage.getWidth() / 10;
        n3 -= n6;
        for (int i = 0; i < n2; ++i) {
            int n7 = 10;
            if (n > 0) {
                n7 = n % 10;
            } else if (n == 0 && (bl || i == 0)) {
                n7 = 0;
            }
            Utils.drawTileImage(platformImage, n3, n4, 10, 1, n7, 0);
            n3 -= n6 + n5;
            n /= 10;
        }
        return n3 + n6;
    }

    public static boolean compareArray(char[] cArray, int n, char[] cArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            if (cArray[n + i] == cArray2[n2 + i]) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(int n, int[] nArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            if (nArray[n2 + i] != n) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int n, char[] cArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            if (cArray[n2 + i] != n) continue;
            return i;
        }
        return -1;
    }

    public static boolean containsAll(char[] cArray, char[] cArray2, int n) {
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (Utils.indexOf((int)c, cArray2, 0, n) != -1) continue;
            return false;
        }
        return true;
    }

    public static void sort(int[] nArray, int[] nArray2, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[nArray[i]];
            for (int j = i; j >= 1 && nArray2[nArray[j - 1]] >= n2; --j) {
                int n3 = nArray[j];
                nArray[j] = nArray[j - 1];
                nArray[j - 1] = n3;
            }
        }
    }

    public static void reverse(int[] nArray, int n) {
        int n2 = 0;
        int n3 = n >> 1;
        int n4 = n - 1;
        while (n2 < n3) {
            int n5 = nArray[n2];
            nArray[n2] = nArray[n4];
            nArray[n4] = n5;
            ++n2;
            --n4;
        }
    }

    public static boolean isInside(int n, int n2, int n3, int n4, int n5, int n6) {
        return n >= n3 && n < n3 + n5 && n2 >= n4 && n2 < n4 + n6;
    }

    public static boolean intersectsBoxBox(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n3 >= n5 && n <= n7 && n4 >= n6 && n2 <= n8;
    }

    public static boolean intersectsRectRect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n;
        int n10 = n + n3 - 1;
        int n11 = n2;
        int n12 = n2 + n4 - 1;
        int n13 = n5;
        int n14 = n5 + n7 - 1;
        int n15 = n6;
        int n16 = n6 + n8 - 1;
        return n10 >= n13 && n9 <= n14 && n12 >= n15 && n11 <= n16;
    }

    public static int distanceX(int n, int n2, int n3) {
        int n4;
        int n5 = n2 - n3;
        if (n5 < 0) {
            n5 += n;
        }
        if ((n4 = n2 - n3) > 0) {
            n4 -= n;
        }
        return n5 <= -n4 ? n5 : n4;
    }

    public static int getRandomInt() {
        return r.nextInt();
    }

    public static void p(String string) {
        System.out.println(string);
    }
}

