/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class Sound_MM_API
extends PlatformSound
implements PlayerListener {
    private static final String[] CONTENT_TYPES = new String[]{"midi", "x-wav", "amr", "x-ogg", "mpeg", "aac"};
    private static final int DELAY_TIME = 100;
    private static final int STATE_STOP = 0;
    private static final int STATE_PLAY = 1;
    private int format;
    private byte[] soundData;
    private String resourceName;
    private int state;
    private int volume;
    private int loopCount;
    private Player player;

    public Sound_MM_API(int n, byte[] byArray) {
        this.format = n;
        this.soundData = byArray;
        PlatformSound.registerSound(this);
    }

    public Sound_MM_API(int n, String string) {
        this.format = n;
        this.resourceName = string;
        PlatformSound.registerSound(this);
    }

    public void setLoopCount(int n) {
        this.loopCount = n;
    }

    public void setVolume(int n) {
    }

    public void play() {
        boolean bl;
        int n = 0;
        do {
            this.realize();
            if (this.player == null) {
                return;
            }
            bl = false;
            try {
                this.player.start();
            }
            catch (Exception exception) {
                bl = true;
            }
            if (!bl) continue;
            ++n;
            this.stop();
            Platform.sleep(2000);
        } while (bl && n < 3);
        if (bl) {
            return;
        }
        this.state = 1;
    }

    public void prefetch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realize() {
        block23: {
            if (this.player != null) {
                try {
                    this.player.prefetch();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            InputStream inputStream = this.soundData != null ? new ByteArrayInputStream(this.soundData, 0, this.soundData.length) : this.getClass().getResourceAsStream(this.resourceName);
            try {
                String string = "audio/" + CONTENT_TYPES[this.format];
                this.player = Manager.createPlayer((InputStream)inputStream, (String)string);
                try {
                    this.player.realize();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.player.prefetch();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.player.setLoopCount(this.loopCount);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Exception exception) {
                if (this.player == null) break block23;
                try {
                    this.player.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.player = null;
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                        inputStream = null;
                    }
                }
                catch (Exception exception) {
                    inputStream = null;
                }
            }
        }
    }

    public boolean isPlaying() {
        if (this.player == null) {
            return false;
        }
        try {
            return this.player.getState() == 400;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void stop() {
        if (this.player == null) {
            return;
        }
        this.state = 0;
        try {
            if (this.player != null) {
                this.player.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.player != null) {
                this.player.deallocate();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.player != null) {
                this.player.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.player = null;
    }

    static void stopAllSounds() {
    }

    public void close() {
        this.state = 0;
        if (this.player == null) {
            return;
        }
        try {
            this.player.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.player.deallocate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.player.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.player = null;
    }

    public void playerUpdate(Player player, String string, Object object) {
    }
}

