/*
 * Decompiled with CFR 0.152.
 */
package com.hardwire.utils;

import com.hardwire.utils.MathUtils;
import com.hardwire.utils.Matrix2x2;

public final class Vector2 {
    public int x;
    public int y;
    public static final Vector2 ZERO = new Vector2(0, 0);

    public Vector2() {
        this.y = 0;
        this.x = 0;
    }

    public Vector2(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public Vector2(Vector2 vector2) {
        this.x = vector2.x;
        this.y = vector2.y;
    }

    public Vector2(int n, long l, boolean bl) {
        n = MathUtils.wrapAngle(n);
        bl = false;
        boolean bl2 = false;
        if (n > 3294198) {
            bl2 = true;
            n = 6588397 - n;
        }
        if (n > 1647099) {
            bl = true;
            n = 3294198 - n;
        }
        n = (n * (MathUtils.Sin.length - 1) << 1) / 3294198;
        this.x = MathUtils.Sin[MathUtils.Sin.length - 1 - n];
        this.y = MathUtils.Sin[n];
        if (bl) {
            this.x = -this.x;
        }
        if (bl2) {
            this.y = -this.y;
        }
        this.x = (int)((long)this.x * l >> 10);
        this.y = (int)((long)this.y * l >> 10);
    }

    public final void makePerpendicular() {
        int n = this.x;
        this.x = -this.y;
        this.y = n;
    }

    public final Vector2 shiftLeft() {
        this.x <<= 10;
        this.y <<= 10;
        return this;
    }

    public final Vector2 shiftRight() {
        this.x >>= 10;
        this.y >>= 10;
        return this;
    }

    public final void add(Vector2 vector2) {
        this.x += vector2.x;
        this.y += vector2.y;
    }

    public final void add(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public final void subtract(Vector2 vector2) {
        this.x -= vector2.x;
        this.y -= vector2.y;
    }

    public final void multiplyWithShift(int n) {
        this.x = (int)((long)this.x * (long)n >> 10);
        this.y = (int)((long)this.y * (long)n >> 10);
    }

    public final void multiplyWithShift(int n, int n2) {
        this.x = (int)((long)this.x * (long)n >> n2 * 10);
        this.y = (int)((long)this.y * (long)n >> n2 * 10);
    }

    public final void multiply(Matrix2x2 matrix2x2) {
        int n = this.x * matrix2x2.data[0][0] + this.y * matrix2x2.data[0][1];
        int n2 = this.x * matrix2x2.data[1][0] + this.y * matrix2x2.data[1][1];
        this.x = n;
        this.y = n2;
    }

    public final void multiplyWithShift(Matrix2x2 matrix2x2) {
        int n = (int)((long)this.x * (long)matrix2x2.data[0][0] + (long)this.y * (long)matrix2x2.data[0][1] >> 10);
        int n2 = (int)((long)this.x * (long)matrix2x2.data[1][0] + (long)this.y * (long)matrix2x2.data[1][1] >> 10);
        this.x = n;
        this.y = n2;
    }

    public final void multiplyTransposedWithShift(Matrix2x2 matrix2x2) {
        int n = (int)((long)this.x * (long)matrix2x2.data[0][0] + (long)this.y * (long)matrix2x2.data[1][0] >> 10);
        int n2 = (int)((long)this.x * (long)matrix2x2.data[0][1] + (long)this.y * (long)matrix2x2.data[1][1] >> 10);
        this.x = n;
        this.y = n2;
    }

    public final void divide(int n) {
        this.x /= n;
        this.y /= n;
    }

    public final void divideWithShift(int n) {
        this.x = (int)(((long)this.x << 10) / (long)n);
        this.y = (int)(((long)this.y << 10) / (long)n);
    }

    public final Vector2 minus(Vector2 vector2) {
        return new Vector2(this.x - vector2.x, this.y - vector2.y);
    }

    public final Vector2 timesWithShift(int n) {
        return new Vector2((int)((long)this.x * (long)n >> 10), (int)((long)this.y * (long)n >> 10));
    }

    public final int dotProductWithShift(Vector2 vector2) {
        return (int)((long)this.x * (long)vector2.x + (long)this.y * (long)vector2.y >> 10);
    }

    public final int crossProduct(Vector2 vector2) {
        return this.x * vector2.y - this.y * vector2.x;
    }

    public final int crossProductWithShift(Vector2 vector2) {
        return (int)((long)this.x * (long)vector2.y - (long)this.y * (long)vector2.x >> 10);
    }

    public final void zero() {
        this.y = 0;
        this.x = 0;
    }

    public final boolean isNull() {
        return this.x == 0 && this.y == 0;
    }

    public final void copy(Vector2 vector2) {
        this.x = vector2.x;
        this.y = vector2.y;
    }

    public final void copyOpposite(Vector2 vector2) {
        this.x = -vector2.x;
        this.y = -vector2.y;
    }

    public final void copyPerpendicular(Vector2 vector2) {
        this.x = -vector2.y;
        this.y = vector2.x;
    }

    public final void set(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public final int normaliseWithShift() {
        int n = this.length();
        if (n == 1024) {
            return n;
        }
        this.x = (int)(((long)this.x << 10) / (long)n);
        this.y = (int)(((long)this.y << 10) / (long)n);
        return n;
    }

    public final int length() {
        int n;
        int n2 = this.x < 0 ? -this.x : this.x;
        int n3 = n = this.y < 0 ? -this.y : this.y;
        if (n2 == 0) {
            return n;
        }
        if (n == 0) {
            return n2;
        }
        if (n2 < n) {
            n2 ^= n;
            n ^= n2;
            n2 ^= n;
        }
        n += n >> 1;
        return n2 - (n2 >> 5) - (n2 >> 7) + (n >> 2) + (n >> 6);
    }

    public final long length_squared() {
        return (long)this.x * (long)this.x + (long)this.y * (long)this.y;
    }
}

