/*
 * Decompiled with CFR 0.152.
 */
package com.hardwire.dymix;

import com.hardwire.dymix.DynamicObject;
import com.hardwire.dymix.PhysicalObject;
import com.hardwire.utils.MathUtils;
import com.hardwire.utils.Matrix2x2;
import com.hardwire.utils.Vector2;

public final class Joint {
    public PhysicalObject obj1;
    public PhysicalObject obj2;
    private Vector2 localAnchor1;
    private Vector2 localAnchor2;
    private byte limitState = 0;
    private int limitLowerAngle = 0;
    private int limitUpperAngle = 0;
    private static Vector2 tmpVector = new Vector2();
    private static Vector2 absoluteAnchor1 = new Vector2();
    private static Vector2 absoluteAnchor2 = new Vector2();
    private static Vector2 r1 = new Vector2();
    private static Vector2 r2 = new Vector2();
    private static Matrix2x2 K = new Matrix2x2();
    private static Vector2 bias = new Vector2();
    private static Vector2 impulse = new Vector2();

    public Joint(PhysicalObject physicalObject, PhysicalObject physicalObject2, Vector2 vector2, Vector2 vector22) {
        this.obj1 = physicalObject;
        this.obj2 = physicalObject2;
        this.localAnchor1 = new Vector2(vector2);
        this.localAnchor2 = new Vector2(vector22);
    }

    public Joint(PhysicalObject physicalObject, PhysicalObject physicalObject2, Vector2 vector2, Vector2 vector22, int n, int n2) {
        this.obj1 = physicalObject;
        this.obj2 = physicalObject2;
        this.localAnchor1 = new Vector2(vector2);
        this.localAnchor2 = new Vector2(vector22);
        this.limitState = 1;
        this.limitLowerAngle = n;
        this.limitUpperAngle = n2;
    }

    public final Vector2 getAbsoluteAnchor1() {
        absoluteAnchor1.copy(this.localAnchor1);
        absoluteAnchor1.multiplyWithShift(this.obj1.getOrientation());
        PhysicalObject physicalObject = this.obj1;
        absoluteAnchor1.add(physicalObject.centerPos);
        return absoluteAnchor1;
    }

    public final Vector2 getAbsoluteAnchor2() {
        absoluteAnchor2.copy(this.localAnchor2);
        absoluteAnchor2.multiplyWithShift(this.obj2.getOrientation());
        PhysicalObject physicalObject = this.obj2;
        absoluteAnchor2.add(physicalObject.centerPos);
        return absoluteAnchor2;
    }

    public final Vector2 getLocalAnchor1() {
        return this.localAnchor1;
    }

    public final Vector2 getLocalAnchor2() {
        return this.localAnchor2;
    }

    public final void _applyImpulse() {
        int n;
        int n2 = this.obj1.getInvMass_shifted2();
        int n3 = this.obj2.getInvMass_shifted2();
        int n4 = this.obj1.getInvInertia_shifted2();
        int n5 = this.obj2.getInvInertia_shifted2();
        r1.copy(this.localAnchor1);
        r1.multiplyWithShift(this.obj1.getOrientation());
        r2.copy(this.localAnchor2);
        r2.multiplyWithShift(this.obj2.getOrientation());
        Joint.K.data[0][0] = n = n2 + n3 >> 10;
        Joint.K.data[0][1] = 0;
        Joint.K.data[1][0] = 0;
        Joint.K.data[1][1] = n;
        int[] nArray = Joint.K.data[0];
        nArray[0] = nArray[0] + (int)(((long)n4 * (long)Joint.r1.y >> 20) * (long)Joint.r1.y >> 10);
        n = -((int)(((long)n4 * (long)Joint.r1.x >> 20) * (long)Joint.r1.y >> 10));
        int[] nArray2 = Joint.K.data[0];
        nArray2[1] = nArray2[1] + n;
        int[] nArray3 = Joint.K.data[1];
        nArray3[0] = nArray3[0] + n;
        int[] nArray4 = Joint.K.data[1];
        nArray4[1] = nArray4[1] + (int)(((long)n4 * (long)Joint.r1.x >> 20) * (long)Joint.r1.x >> 10);
        int[] nArray5 = Joint.K.data[0];
        nArray5[0] = nArray5[0] + (int)(((long)n5 * (long)Joint.r2.y >> 20) * (long)Joint.r2.y >> 10);
        n = -((int)(((long)n5 * (long)Joint.r2.x >> 20) * (long)Joint.r2.y >> 10));
        int[] nArray6 = Joint.K.data[0];
        nArray6[1] = nArray6[1] + n;
        int[] nArray7 = Joint.K.data[1];
        nArray7[0] = nArray7[0] + n;
        int[] nArray8 = Joint.K.data[1];
        nArray8[1] = nArray8[1] + (int)(((long)n5 * (long)Joint.r2.x >> 20) * (long)Joint.r2.x >> 10);
        K.invert();
        PhysicalObject physicalObject = this.obj1;
        bias.copy(physicalObject.centerPos);
        bias.add(r1);
        physicalObject = this.obj2;
        bias.subtract(physicalObject.centerPos);
        bias.subtract(r2);
        bias.multiplyWithShift(102);
        impulse.copyPerpendicular(r2);
        impulse.multiplyWithShift(this.obj2.getAngularVelocity_shifted(), 2);
        tmpVector.copyPerpendicular(r1);
        tmpVector.multiplyWithShift(this.obj1.getAngularVelocity_shifted(), 2);
        impulse.subtract(tmpVector);
        impulse.add(this.obj2.getLinearVelocity());
        impulse.subtract(this.obj1.getLinearVelocity());
        impulse.subtract(bias);
        Joint.impulse.x = -Joint.impulse.x;
        Joint.impulse.y = -Joint.impulse.y;
        impulse.multiplyWithShift(K);
        if (n2 > 0) {
            physicalObject = (DynamicObject)this.obj1;
            tmpVector.copy(impulse);
            tmpVector.multiplyWithShift(n2, 3);
            ((DynamicObject)physicalObject).getLinearVelocity().subtract(tmpVector);
            if (n4 > 0) {
                ((DynamicObject)physicalObject).setAngularVelocity_shifted(((DynamicObject)physicalObject).getAngularVelocity_shifted() - (int)((long)r1.crossProductWithShift(impulse) * (long)n4 >> 20));
            }
            if (((DynamicObject)physicalObject).isAsleep()) {
                ((DynamicObject)physicalObject).wakeUp();
            }
        }
        if (n3 > 0) {
            physicalObject = (DynamicObject)this.obj2;
            tmpVector.copy(impulse);
            tmpVector.multiplyWithShift(n3, 3);
            ((DynamicObject)physicalObject).getLinearVelocity().add(tmpVector);
            if (n5 > 0) {
                ((DynamicObject)physicalObject).setAngularVelocity_shifted(((DynamicObject)physicalObject).getAngularVelocity_shifted() + (int)((long)r2.crossProductWithShift(impulse) * (long)n5 >> 20));
            }
            if (((DynamicObject)physicalObject).isAsleep()) {
                ((DynamicObject)physicalObject).wakeUp();
            }
        }
        if (this.limitState != 0) {
            int n6 = MathUtils.angleDistance(this.obj1.getAngle_shifted(), this.obj2.getAngle_shifted());
            this.limitState = n6 <= this.limitLowerAngle ? (byte)2 : (n6 >= this.limitUpperAngle ? (byte)3 : (byte)1);
            if (this.limitState != 1) {
                n2 = (int)(-((long)(this.obj2.getAngularVelocity_shifted() - this.obj1.getAngularVelocity_shifted()) << 20) / (long)(n4 + n5));
                if (this.limitState == 2 && n2 < 0) {
                    n2 = 0;
                } else if (this.limitState == 3 && n2 > 0) {
                    n2 = 0;
                }
                if (n4 > 0) {
                    ((DynamicObject)this.obj1).setAngularVelocity_shifted(this.obj1.getAngularVelocity_shifted() - (int)((long)n2 * (long)n4 >> 20));
                }
                if (n5 > 0) {
                    ((DynamicObject)this.obj2).setAngularVelocity_shifted(this.obj2.getAngularVelocity_shifted() + (int)((long)n2 * (long)n5 >> 20));
                }
            }
        }
    }
}

