/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public class TCP
extends Thread {
    public boolean m_connected;
    public boolean m_bError = false;
    public String m_bErrorString;
    private TCPRecv m_receiveThread;
    protected Vector incomingQueue;
    protected Vector outgoingQueue;
    protected byte[] outgoing_data_on_receive_connection;
    protected String url;
    protected StreamConnection connection = null;
    protected InputStream istream = null;
    protected OutputStream ostream = null;
    protected StreamConnection receive_connection = null;
    protected InputStream receive_istream = null;
    protected OutputStream receive_ostream = null;

    public TCP(String string) {
        if (GLLibConfig.xplayer_ENABLE_DEBUG) {
            this.m_bErrorString = null;
            if (GLLibConfig.xplayer_ENABLE_DUAL_TCP) {
                System.out.println("Using dual connection tcp");
            } else {
                System.out.println("Using single connection tcp");
            }
        }
        this.incomingQueue = new Vector();
        this.outgoingQueue = new Vector();
        this.url = string;
        if (GLLibConfig.xplayer_ENABLE_DUAL_TCP) {
            this.outgoing_data_on_receive_connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(byte[] byArray) {
        Vector vector = this.outgoingQueue;
        synchronized (vector) {
            this.outgoingQueue.addElement(byArray);
            if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                System.out.println("Adding packet to outgoing queue");
            }
        }
    }

    public void sendEstablishConnectionPackageOnReceive(byte[] byArray) {
        if (GLLibConfig.xplayer_ENABLE_DUAL_TCP) {
            this.outgoing_data_on_receive_connection = byArray;
        } else {
            this.sendPacket(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] recvPacket() {
        byte[] byArray = null;
        Vector vector = this.incomingQueue;
        synchronized (vector) {
            if (this.incomingQueue.size() > 0) {
                byArray = (byte[])this.incomingQueue.firstElement();
                this.incomingQueue.removeElementAt(0);
            }
        }
        return byArray;
    }

    public void connect() {
        block3: {
            if (!this.m_connected) {
                try {
                    new Thread(this).start();
                }
                catch (Exception exception) {
                    if (!GLLibConfig.xplayer_ENABLE_DEBUG) break block3;
                    System.out.println("TCP: connect exception: " + exception.toString());
                    exception.printStackTrace();
                }
            }
        }
    }

    public void disconnect() {
        if (GLLibConfig.xplayer_ENABLE_DEBUG) {
            System.out.println("disconnecting tcp ... ");
        }
        this.m_connected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        if (GLLibConfig.xplayer_ENABLE_DEBUG) {
            System.out.println("cleanup tcp .. ");
        }
        if (this.m_receiveThread != null) {
            this.m_receiveThread.m_running = false;
        }
        try {
            if (this.istream != null) {
                this.istream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.ostream != null) {
                this.ostream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.istream = null;
        this.ostream = null;
        this.connection = null;
        if (GLLibConfig.xplayer_ENABLE_DUAL_TCP) {
            try {
                if (this.receive_istream != null) {
                    this.receive_istream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.receive_ostream != null) {
                    this.receive_ostream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.receive_connection != null) {
                    this.receive_connection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.receive_istream = null;
            this.receive_ostream = null;
            this.receive_connection = null;
        }
        Vector vector = this.outgoingQueue;
        synchronized (vector) {
            while (this.outgoingQueue.size() > 0) {
                this.outgoingQueue.removeElementAt(0);
            }
        }
        vector = this.incomingQueue;
        synchronized (vector) {
            while (this.incomingQueue.size() > 0) {
                this.incomingQueue.removeElementAt(0);
            }
        }
        try {
            this.m_receiveThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block53: {
            this.m_connected = false;
            this.m_bError = false;
            try {
                if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                    System.out.println("TCP: Opening connection to " + this.url);
                }
                this.connection = (StreamConnection)Connector.open((String)this.url);
                if (this.connection == null) {
                    if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                        this.m_bErrorString = "StreamConnection.open to " + this.url;
                    }
                    this.m_bError = true;
                    return;
                }
                if (GLLibConfig.xplayer_ENABLE_DUAL_TCP) {
                    if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                        System.out.println("TCP: Opening receive connection to " + this.url);
                    }
                    this.receive_connection = (StreamConnection)Connector.open((String)this.url);
                    if (this.receive_connection == null) {
                        if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                            this.m_bErrorString = "StreamConnection.open to " + this.url;
                        }
                        this.m_bError = true;
                        return;
                    }
                }
            }
            catch (Exception exception) {
                if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                    System.out.println("TCP: run exception: " + exception.toString());
                    exception.printStackTrace();
                }
                this.m_bError = true;
                if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                    this.m_bErrorString = "StreamConnection.open to " + this.url + " exception: " + exception;
                }
                return;
            }
            this.ostream = null;
            if (GLLibConfig.xplayer_ENABLE_DUAL_TCP) {
                this.receive_ostream = null;
            }
            try {
                if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                    System.out.println("TCP: Opening output stream");
                }
                this.ostream = this.connection.openOutputStream();
                if (this.ostream == null) {
                    this.m_bError = true;
                    if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                        this.m_bErrorString = "StreamConnection.openOutputStream to " + this.url;
                    }
                    return;
                }
                if (GLLibConfig.xplayer_ENABLE_DUAL_TCP) {
                    this.receive_ostream = this.receive_connection.openOutputStream();
                    if (this.receive_ostream == null) {
                        this.m_bError = true;
                        if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                            this.m_bErrorString = "StreamConnection.openOutputStream to " + this.url;
                        }
                        return;
                    }
                }
            }
            catch (Exception exception) {
                if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                    System.out.println("TCP: run exception: " + exception.toString());
                    exception.printStackTrace();
                }
                this.m_bError = true;
                if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                    this.m_bErrorString = "StreamConnection.openOutputStream to " + this.url + " exception: " + exception;
                }
                return;
            }
            this.istream = null;
            if (GLLibConfig.xplayer_ENABLE_DUAL_TCP) {
                this.receive_istream = null;
            }
            try {
                if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                    System.out.println("TCP: Opening input stream");
                }
                this.istream = this.connection.openInputStream();
                if (this.istream == null) {
                    this.m_bError = true;
                    if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                        this.m_bErrorString = "StreamConnection.openInputStream to " + this.url;
                    }
                    return;
                }
                if (GLLibConfig.xplayer_ENABLE_DUAL_TCP) {
                    this.receive_istream = this.receive_connection.openInputStream();
                    if (this.receive_istream == null) {
                        this.m_bError = true;
                        if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                            this.m_bErrorString = "StreamConnection.openInputStream to " + this.url;
                        }
                        return;
                    }
                }
            }
            catch (Exception exception) {
                if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                    System.out.println("TCP: run exception: " + exception.toString());
                    exception.printStackTrace();
                }
                this.m_bError = true;
                if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                    this.m_bErrorString = "StreamConnection.openInputStream to " + this.url + " exception: " + exception;
                }
                return;
            }
            this.m_connected = true;
            if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                System.out.println("TCP: Connection established, starting recv thread");
            }
            this.m_receiveThread = GLLibConfig.xplayer_ENABLE_DUAL_TCP ? new TCPRecv(this.receive_istream, this.incomingQueue) : new TCPRecv(this.istream, this.incomingQueue);
            this.m_receiveThread.start();
            byte[] byArray = new byte[1];
            while (this.m_connected && this.m_receiveThread.m_running) {
                byte[] byArray2;
                Vector vector = this.outgoingQueue;
                synchronized (vector) {
                    byArray2 = null;
                    if (this.outgoingQueue.size() > 0) {
                        byArray2 = (byte[])this.outgoingQueue.firstElement();
                        this.outgoingQueue.removeElementAt(0);
                    }
                }
                if (byArray2 == null) {
                    Thread.yield();
                    continue;
                }
                if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                    System.out.println("TCP: new packet to send");
                }
                byArray[0] = (byte)(byArray2.length & 0xFF);
                try {
                    this.ostream.write(byArray);
                    this.ostream.write(byArray2);
                }
                catch (Exception exception) {
                    if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                        System.out.println("TCP: send exception: " + exception.toString());
                        exception.printStackTrace();
                    }
                    this.m_bError = true;
                    if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                        this.m_bErrorString = "Send th: " + (exception.getMessage() == null ? exception.toString() : exception.getMessage());
                    }
                    this.m_connected = false;
                }
                if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                    System.out.println("TCP: Sent " + byArray[0] + " bytes packet:" + new String(byArray2));
                }
                if (GLLibConfig.xplayer_ENABLE_DUAL_TCP && this.outgoing_data_on_receive_connection != null) {
                    byArray[0] = (byte)(this.outgoing_data_on_receive_connection.length & 0xFF);
                    try {
                        this.receive_ostream.write(byArray);
                        this.receive_ostream.write(this.outgoing_data_on_receive_connection);
                    }
                    catch (Exception exception) {
                        if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                            System.out.println("TCP: send exception when sending establish connection on receive: " + exception.toString());
                            exception.printStackTrace();
                        }
                        this.m_bError = true;
                        if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                            this.m_bErrorString = "Send th: " + (exception.getMessage() == null ? exception.toString() : exception.getMessage());
                        }
                        this.m_connected = false;
                    }
                    this.outgoing_data_on_receive_connection = null;
                }
                Thread.yield();
            }
            this.m_connected = false;
            this.cleanup();
            try {
                this.join();
            }
            catch (Exception exception) {
                if (!GLLibConfig.xplayer_ENABLE_DEBUG) break block53;
                System.out.println("TCP: join exception: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    private class TCPRecv
    extends Thread {
        private InputStream is;
        private Vector v;
        private boolean m_running;
        private byte[] localReceiveBuffer;
        private int len;
        private int receiveBufferOffset;
        private byte[] receiveBufferQueue;

        public TCPRecv(InputStream inputStream, Vector vector) {
            this.is = inputStream;
            this.v = vector;
            this.localReceiveBuffer = new byte[255];
        }

        void recvBytes() {
            block4: {
                this.len = -2;
                try {
                    this.len = this.is.read(this.localReceiveBuffer);
                }
                catch (Exception exception) {
                    TCP.this.m_bError = true;
                    if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                        TCP.this.m_bErrorString = "Recv th: " + (exception.getMessage() == null ? exception.toString() : exception.getMessage());
                    }
                    this.m_running = false;
                    if (!GLLibConfig.xplayer_ENABLE_DEBUG) break block4;
                    System.out.println("TCP: recv exception: " + exception.toString());
                    exception.printStackTrace();
                }
            }
            if (this.len <= 0) {
                this.m_running = false;
                return;
            }
            byte[] byArray = new byte[this.len + this.receiveBufferQueue.length - this.receiveBufferOffset];
            System.arraycopy(this.receiveBufferQueue, this.receiveBufferOffset, byArray, 0, this.receiveBufferQueue.length - this.receiveBufferOffset);
            System.arraycopy(this.localReceiveBuffer, 0, byArray, this.receiveBufferQueue.length - this.receiveBufferOffset, this.len);
            this.receiveBufferOffset = 0;
            this.receiveBufferQueue = byArray;
            Thread.yield();
        }

        int getByte() {
            while (this.m_running && this.receiveBufferQueue.length - this.receiveBufferOffset < 1) {
                this.recvBytes();
            }
            return this.m_running ? this.receiveBufferQueue[this.receiveBufferOffset++] : -1;
        }

        byte[] getBytes(int n) {
            while (this.m_running && this.receiveBufferQueue.length - this.receiveBufferOffset < n) {
                this.recvBytes();
            }
            byte[] byArray = new byte[n];
            System.arraycopy(this.receiveBufferQueue, this.receiveBufferOffset, byArray, 0, n);
            this.receiveBufferOffset += n;
            return byArray;
        }

        public void start() {
            this.m_running = true;
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.receiveBufferQueue = new byte[0];
            this.receiveBufferOffset = 0;
            if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                System.out.println("TCPRecv: Starting receiver");
            }
            while (this.m_running) {
                int n = this.getByte();
                if (n == -1) {
                    this.m_running = false;
                    continue;
                }
                if (n < 0) {
                    n += 256;
                }
                byte[] byArray = this.getBytes(n);
                Vector vector = this.v;
                synchronized (vector) {
                    this.v.addElement(byArray);
                }
                if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                    System.out.println("TCPRecv: Received " + n + " bytes packet:" + new String(byArray));
                }
                Thread.yield();
            }
        }
    }
}

