/*
 * Decompiled with CFR 0.152.
 */
package de.tuttas.GameAPI;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Sprite {
    public Image image;
    public int x;
    public int y;
    public int width;
    public int height;
    public boolean visible = true;
    int bx;
    int by;
    int bw;
    int bh;
    int moveX;
    int moveY;

    public Sprite() {
    }

    public Sprite(Image i) {
        this.image = i;
        this.init();
    }

    private void init() {
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        this.bx = 0;
        this.by = 0;
        this.bw = this.width;
        this.bh = this.height;
    }

    public void setImage(Image i) {
        this.image = i;
        this.init();
    }

    public void move(int dx, int dy) {
        this.moveX += dx;
        if (Math.abs(this.moveX) / 100 >= 1) {
            this.x += this.moveX / 100;
            this.moveX = this.moveX < 0 ? (this.moveX += 100) : (this.moveX -= 100);
        }
        this.moveY += dy;
        if (Math.abs(this.moveY) / 100 >= 1) {
            this.y += this.moveY / 100;
            this.moveY = this.moveY < 0 ? (this.moveY += 100) : (this.moveY -= 100);
        }
    }

    public void setBoundaryBox(int xb, int yb, int w, int h) {
        this.bx = xb;
        this.by = yb;
        this.bw = w;
        this.bh = h;
    }

    public boolean collision(Sprite sprite) {
        if (!this.visible) {
            return false;
        }
        return sprite.dotInSprite(this.x + this.bx, this.y + this.by) || sprite.dotInSprite(this.x + this.bw, this.y + this.by) || sprite.dotInSprite(this.x + this.bx, this.y + this.bh) || sprite.dotInSprite(this.x + this.bw, this.y + this.bh);
    }

    public boolean dotInSprite(int xTest, int yTest) {
        return this.x + this.bx < xTest && this.x + this.bw > xTest && this.y + this.by < yTest && this.y + this.bh > yTest;
    }

    public void setPos(int xPos, int yPos) {
        this.x = xPos;
        this.y = yPos;
    }

    public void setVisible(boolean state) {
        this.visible = state;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void paint(Graphics g) {
        if (this.visible) {
            g.drawImage(this.image, this.x, this.y, 20);
        }
    }
}

