/*
 * Decompiled with CFR 0.152.
 */
package com.funfil.midp.games.spritehandler;

import com.funfil.midp.games.spritehandler.LayerSprite;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class FunPainter {
    private Vector spriteLayer = new Vector(0);

    public void paint(Graphics g) {
        try {
            for (int i = 0; i < this.spriteLayer.size(); ++i) {
                LayerSprite sprite = (LayerSprite)this.spriteLayer.elementAt(i);
                sprite.paint(g);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public LayerSprite[] getSprites() {
        Object[] anArray = new LayerSprite[this.spriteLayer.size()];
        this.spriteLayer.copyInto(anArray);
        return anArray;
    }

    public void add(LayerSprite sprite) {
        this.spriteLayer.addElement(sprite);
    }

    private void throwException(boolean flag) {
        if (flag) {
            throw new IndexOutOfBoundsException();
        }
    }

    public void insert(LayerSprite sprite, int index) {
        this.throwException(index > this.spriteLayer.size() && index < 0);
        this.spriteLayer.insertElementAt(sprite, index);
    }

    public LayerSprite removeAt(int index) {
        this.throwException(index >= this.spriteLayer.size() && index < 0);
        LayerSprite sprite = (LayerSprite)this.spriteLayer.elementAt(index);
        this.spriteLayer.removeElementAt(index);
        return sprite;
    }

    public void removeAll() {
        this.spriteLayer.removeAllElements();
    }

    public void remove(LayerSprite sprite) {
        this.spriteLayer.removeElement(sprite);
    }

    public void bringBack(int index) {
        this.insert(this.removeAt(index), 0);
    }

    public void bringFront(int index) {
        this.add(this.removeAt(index));
    }

    public void bringForward(int index) {
        this.insert(this.removeAt(index), index + 1);
    }

    public void bringBackward(int index) {
        this.insert(this.removeAt(index), index - 1);
    }
}

