/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class AALTileset {
    private Image m_image;
    private Image[] m_images;
    private long[] m_rectsShort;
    private byte[][] m_indexTranslationTable;
    private int m_numTiles;
    private boolean m_isClipped;

    public static AALTileset createTileset(int n, long[] lArray, byte[] byArray, byte[] byArray2, boolean bl) throws IOException {
        try {
            int n2;
            AALTileset aALTileset = new AALTileset();
            aALTileset.m_image = AALDevice.createImage(n);
            aALTileset.m_images = null;
            aALTileset.m_rectsShort = lArray;
            aALTileset.m_numTiles = byArray.length;
            aALTileset.m_indexTranslationTable = new byte[8][];
            aALTileset.m_isClipped = false;
            for (int i = 0; i < aALTileset.m_numTiles; ++i) {
                n2 = byArray2[i] & 0xFF;
                int n3 = byArray[i] & 0xFF;
                if (n2 == 0) continue;
                if (aALTileset.m_indexTranslationTable[n2] == null) {
                    aALTileset.m_indexTranslationTable[n2] = new byte[aALTileset.m_numTiles];
                }
                aALTileset.m_indexTranslationTable[n2][n3] = (byte)i;
            }
            if (bl) {
                Image image = aALTileset.m_image;
                aALTileset.m_image = null;
                aALTileset.m_images = new Image[aALTileset.m_numTiles];
                aALTileset.m_rectsShort = null;
                aALTileset.m_isClipped = true;
                for (n2 = 0; n2 < aALTileset.m_numTiles; ++n2) {
                    long l = lArray[n2];
                    int n4 = (int)(l & 0xFFFFL);
                    int n5 = (int)(l >>> 16 & 0xFFFFL);
                    int n6 = (int)(l >>> 32 & 0xFFFFL);
                    int n7 = (int)(l >>> 48 & 0xFFFFL);
                    aALTileset.m_images[n2] = Image.createImage((int)n5, (int)n4);
                    aALTileset.m_images[n2].getGraphics().drawImage(image, -n7, -n6, 20);
                }
            }
            return aALTileset;
        }
        catch (Exception exception) {
            System.out.println(exception + "  222222222222");
            return null;
        }
    }

    public int getNbTiles() {
        return this.m_numTiles;
    }

    public int getTileWidth(int n) {
        try {
            int n2 = !this.m_isClipped ? (int)(this.m_rectsShort[n] >>> 16) & 0xFFFF : this.m_images[n].getWidth();
            return n2;
        }
        catch (Exception exception) {
            System.out.println(exception + "  3333333333");
            return 0;
        }
    }

    public int getTileHeight(int n) {
        try {
            int n2 = !this.m_isClipped ? (int)this.m_rectsShort[n] & 0xFFFF : this.m_images[n].getHeight();
            return n2;
        }
        catch (Exception exception) {
            System.out.println(exception + "  444444444");
            return 0;
        }
    }

    public void drawTile(int n, int n2, int n3) {
        try {
            if (this.m_isClipped) {
                AALDevice.s_activeGraphics.drawImage(this.m_images[n], n2, n3, 20);
                return;
            }
            long l = this.m_rectsShort[n];
            int n4 = (int)(l & 0xFFFFL);
            int n5 = (int)(l >>> 16 & 0xFFFFL);
            int n6 = (int)(l >>> 32 & 0xFFFFL);
            int n7 = (int)(l >>> 48 & 0xFFFFL);
            Graphics graphics = AALDevice.s_activeGraphics;
            AALTileset.clipRect(graphics, n2, n3, n5, n4);
            graphics.drawImage(this.m_image, n2 -= n7, n3 -= n6, 20);
            graphics.setClip(0, 0, AALDevice.s_viewportWidth, AALDevice.s_viewportHeight);
        }
        catch (Exception exception) {
            System.out.println(exception + "  5555555");
        }
    }

    private static void clipRect(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.clipRect(n, n2, n3, n4);
    }

    public int getTileWidth(int n, int n2) {
        int n3 = n2 == 0 ? n : this.m_indexTranslationTable[n2][n] & 0xFF;
        return this.getTileWidth(n3);
    }

    public int getTileHeight(int n, int n2) {
        int n3 = n2 == 0 ? n : this.m_indexTranslationTable[n2][n] & 0xFF;
        return this.getTileHeight(n3);
    }

    public void drawTile(int n, int n2, int n3, int n4) {
        int n5 = n2 == 0 ? n : this.m_indexTranslationTable[n2][n] & 0xFF;
        this.drawTile(n5, n3, n4);
    }
}

