/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public abstract class GLLib
extends Canvas
implements Runnable {
    public static Graphics g = null;
    private static Graphics s_lastPaintGraphics = null;
    static boolean s_game_isPaused;
    static int s_game_state;
    private static long s_game_timeWhenFrameStart;
    static boolean s_game_interruptNotify;
    private static int s_screenWidth;
    private static int s_screenHeight;
    private static Display s_display;
    private static boolean s_game_isInPaint;
    static MIDlet s_application;
    private static int m_FPSLimiter;
    private long m_frameCoheranceTimer;
    private Image m_imgBackBuffer = null;
    private Graphics m_gBackBuffer = null;
    static int s_game_frameDT;
    private static long s_game_frameDTTimer;
    private static int s_game_totalExecutionTime;
    private static int s_game_currentFrameNB;
    static GLLib s_gllib_instance;
    private static byte[] s_keyState;
    private static byte[] s_keyStateRT;
    private static int m_last_key_pressed;
    private static int s_keysDisabledTimer;
    private static Hashtable standardKeyTable;
    private static Hashtable gameActionKeyTable;
    private static int s_math_F_1;
    static Random s_math_random;
    private static int[] s_math_cosTable;
    private static int[] s_math_sqrtTable;
    private static int[] s_math_aTanTable;
    static final int Math_AngleMUL;
    static final int Math_Angle90;
    private static int Math_Angle180;
    private static int Math_Angle270;
    private static int Math_Angle360;
    private static int Math_FixedPoint_PI;
    static final int ratioDegreesToAngleFixedPoint;
    private static String s_pack_filename;
    private static InputStream s_pack_is;
    private static int s_pack_curOffset;
    private static short s_pack_nbData;
    private static int[] s_pack_offset;
    private static short s_pack_subPack_nbOf;
    private static short[] s_pack_subPack_fat;
    private static int s_pack_subPack_curSubPack;
    static int s_pack_lastDataReadMimeType;
    private static boolean s_pack_lastDataIsCompress;
    private static byte[] s_Pack_SkipBuffer;
    private static byte[][] MIME_type;
    private static byte[] m_Buffer;
    private static int m_inSize;
    private static long m_Range;
    private static long m_Code;
    private static byte[] m_outStream;
    private static int inputIndex;
    private static short[] m_lzmaInternalData;
    private static int Stream_readOffset;
    private static int text_nbString;
    static String text_encoding;
    private static byte[] text_array;
    private static int[] text_arrayOffset;
    private static String[] text_stringCacheArray;
    private static String StrEN;
    private static String StrDE;
    private static String StrFR;
    private static String StrIT;
    private static String StrES;
    private static String StrBR;
    private static String StrPT;
    private static String StrJP;
    private static String StrCN;
    private static String StrKR;
    private static String StrRU;
    private static String StrTR;
    private static String StrPL;
    private static String StrCZ;
    private static String StrNL;
    private static RecordStore s_rs;
    private static int s_alphaRectCurrentARGB;
    private static int[] s_alphaRectARGBData;
    private static boolean s_PFX_initializd;
    static int s_PFX_type;
    static int[][] s_PFX_params;
    private static Image s_PFX_screenBuffer;
    private static Graphics s_PFX_screenBufferG;
    private static int s_PFX_enableScreenBuffer;
    private static int s_PFX_enableScreenBufferThisFrame;

    abstract void Game_update() throws Exception;

    public GLLib(Object object, Object object2) {
        s_gllib_instance = this;
        s_game_state = -1;
        s_game_isInPaint = true;
        s_application = (MIDlet)object;
        s_display = (Display)object2;
        this.SetupDisplay();
        gameActionKeyTable = new Hashtable();
        standardKeyTable = new Hashtable<Integer, Integer>();
        standardKeyTable.put(new Integer(48), new Integer(6));
        standardKeyTable.put(new Integer(49), new Integer(7));
        standardKeyTable.put(new Integer(50), new Integer(1));
        standardKeyTable.put(new Integer(51), new Integer(9));
        standardKeyTable.put(new Integer(52), new Integer(3));
        standardKeyTable.put(new Integer(53), new Integer(5));
        standardKeyTable.put(new Integer(54), new Integer(4));
        standardKeyTable.put(new Integer(55), new Integer(13));
        standardKeyTable.put(new Integer(56), new Integer(2));
        standardKeyTable.put(new Integer(57), new Integer(15));
        standardKeyTable.put(new Integer(35), new Integer(17));
        standardKeyTable.put(new Integer(42), new Integer(16));
        standardKeyTable.put(new Integer(-6), new Integer(18));
        standardKeyTable.put(new Integer(-7), new Integer(19));
        gameActionKeyTable.put(new Integer(-5), new Integer(5));
        gameActionKeyTable.put(new Integer(-1), new Integer(1));
        gameActionKeyTable.put(new Integer(-2), new Integer(2));
        gameActionKeyTable.put(new Integer(-3), new Integer(3));
        gameActionKeyTable.put(new Integer(-4), new Integer(4));
        this.m_frameCoheranceTimer = s_game_frameDTTimer = System.currentTimeMillis();
    }

    protected final void Init() {
        if (s_game_state >= 0) {
            return;
        }
        s_screenWidth = 640;
        s_screenHeight = 360;
        s_keyState = new byte[20];
        s_keyStateRT = new byte[20];
        GLLib.Math_RandSetSeed(System.currentTimeMillis());
        s_game_state = 0;
        new Thread(this).start();
    }

    protected static void Pause() {
        if (!s_game_isPaused) {
            s_game_isPaused = true;
            GLLibPlayer.Snd_PauseNotify();
        }
    }

    protected final void Resume() {
        if (s_game_isPaused) {
            long l;
            s_game_timeWhenFrameStart = l = System.currentTimeMillis();
            s_game_frameDTTimer = l;
            this.m_frameCoheranceTimer = l;
            s_game_isPaused = false;
            this.SetupDisplay();
            s_game_interruptNotify = true;
            if (!s_game_isInPaint) {
                this.repaint();
            }
            GLLib.ResetKey();
        }
    }

    public void hideNotify() {
        GLLib.Pause();
    }

    public void showNotify() {
        this.Resume();
    }

    public void sizeChanged(int n, int n2) {
        s_screenWidth = n;
        s_screenHeight = n2;
    }

    private void SetupDisplay() {
        if (s_display.getCurrent() != this) {
            s_display.setCurrent((Displayable)this);
        }
        this.setFullScreenMode(true);
    }

    public void run() {
        try {
            this.SetupDisplay();
            s_game_isInPaint = false;
            while (s_game_state >= 0) {
                if (!s_game_isPaused) {
                    this.repaint();
                    this.serviceRepaints();
                    long l = System.currentTimeMillis();
                    this.m_frameCoheranceTimer = Math.min(this.m_frameCoheranceTimer, l);
                    Thread.sleep(Math.max(1L, (long)m_FPSLimiter - (l - this.m_frameCoheranceTimer)));
                    this.m_frameCoheranceTimer = System.currentTimeMillis();
                    continue;
                }
                this.m_frameCoheranceTimer = Math.min(this.m_frameCoheranceTimer, System.currentTimeMillis());
                Thread.sleep(1L);
            }
        }
        catch (Exception exception) {
            s_game_state = -1;
        }
        s_keyState = null;
        s_keyStateRT = null;
        MIME_type = null;
        System.gc();
        s_application.notifyDestroyed();
    }

    public void paint(Graphics graphics) {
        if (s_game_isPaused || s_game_isInPaint) {
            return;
        }
        s_game_isInPaint = true;
        for (int i = 0; i < 20; ++i) {
            GLLib.s_keyState[i] = s_keyStateRT[i];
            if (s_keyStateRT[i] == 0) continue;
            if (s_keyStateRT[i] < 0) {
                GLLib.s_keyStateRT[i] = 0;
                continue;
            }
            if (s_keyStateRT[i] >= 126) continue;
            int n = i;
            s_keyStateRT[n] = (byte)(s_keyStateRT[n] + 1);
            if (i < 18) continue;
            int n2 = i;
            s_keyStateRT[n2] = -s_keyStateRT[n2];
        }
        if (s_keysDisabledTimer > 0) {
            if (s_keysDisabledTimer != Integer.MAX_VALUE) {
                s_keysDisabledTimer -= s_game_frameDT;
            }
            GLLib.ResetKey();
        }
        if ((s_game_frameDT = (int)((s_game_timeWhenFrameStart = System.currentTimeMillis()) - s_game_frameDTTimer)) < 0) {
            s_game_frameDT = 0;
        }
        if (s_game_frameDT > 1000) {
            s_game_frameDT = 1000;
        }
        s_game_frameDTTimer = s_game_timeWhenFrameStart;
        s_game_totalExecutionTime += s_game_frameDT;
        ++s_game_currentFrameNB;
        try {
            g = s_lastPaintGraphics = graphics;
            this.Game_update();
        }
        catch (Exception exception) {
            s_game_state = -1;
        }
        s_game_interruptNotify = false;
        s_game_isInPaint = false;
    }

    protected void keyPressed(int n) {
        byte by = GLLib.Game_TranslateKeyCode(n);
        if (s_keyStateRT[by] > 0) {
            return;
        }
        if (s_keyStateRT[by] < 0) {
            GLLib.s_keyStateRT[by] = 0;
        }
        if (s_keyStateRT[by] < 126) {
            byte by2 = by;
            s_keyStateRT[by2] = (byte)(s_keyStateRT[by2] + 1);
        }
    }

    protected void keyReleased(int n) {
        byte by = GLLib.Game_TranslateKeyCode(n);
        if (s_keyStateRT[by] > 0) {
            byte by2 = by;
            s_keyStateRT[by2] = -s_keyStateRT[by2];
        }
    }

    public static void Game_KeySetKeyCode(boolean bl, int n, int n2) {
        Hashtable hashtable = standardKeyTable;
        Integer n3 = new Integer(n);
        Integer n4 = (Integer)hashtable.get(n3);
        if (n4 != null) {
            hashtable.remove(n3);
        }
        hashtable.put(n3, new Integer(n2));
    }

    private static byte Game_TranslateKeyCode(int n) {
        Integer n2 = new Integer(n);
        Integer n3 = (Integer)standardKeyTable.get(n2);
        if (n3 != null) {
            return n3.byteValue();
        }
        n3 = (Integer)gameActionKeyTable.get(n2);
        if (n3 != null) {
            return n3.byteValue();
        }
        return 0;
    }

    public static void ResetKey() {
        if (s_keyState != null && s_keyStateRT != null) {
            for (int i = 0; i < 20; ++i) {
                GLLib.s_keyState[i] = 0;
                GLLib.s_keyStateRT[i] = 0;
            }
        }
    }

    public static int IsAnyKeyDown() {
        int n = 20;
        while (--n >= 0) {
            if (s_keyState[n] <= 0) continue;
            return n;
        }
        return -1;
    }

    public static boolean IsKeyDown(int n) {
        return s_keyState[n] > 0;
    }

    public static int WasAnyKeyPressed() {
        int n = 20;
        while (--n >= 0) {
            if (s_keyState[n] != 1) continue;
            return n;
        }
        return -1;
    }

    public static int WasAnyKeyReleased() {
        int n = 20;
        while (--n >= 0) {
            if (s_keyState[n] >= 0) continue;
            return n;
        }
        return -1;
    }

    public static boolean WasKeyPressed(int n) {
        return s_keyState[n] == 1;
    }

    public static boolean WasKeyReleased(int n) {
        return s_keyState[n] < 0;
    }

    static void Math_Init(String string, int n, int n2) throws Exception {
        GLLib.Pack_Open(string);
        s_math_cosTable = (int[])GLLib.Pack_ReadArray(0);
        s_math_sqrtTable = (int[])GLLib.Pack_ReadArray(1);
        GLLib.Pack_Close();
    }

    static final int Math_FixedPointToInt(int n) {
        return n + (s_math_F_1 >> 1) >> 8;
    }

    static final void Math_RandSetSeed(long l) {
        if (s_math_random == null) {
            s_math_random = new Random(l);
            return;
        }
        s_math_random.setSeed(l);
    }

    static int Math_Rand(int n, int n2) {
        if (n2 != n) {
            int n3 = s_math_random.nextInt();
            if (n3 < 0) {
                n3 = -n3;
            }
            return n + n3 % (n2 - n);
        }
        return n2;
    }

    static int Math_Cos(int n) {
        if (n < 0) {
            n = -n;
        }
        if ((n &= Math_Angle360 - 1) <= Math_Angle90) {
            return s_math_cosTable[n];
        }
        if (n < Math_Angle180) {
            n = Math_Angle180 - n;
            return -s_math_cosTable[n];
        }
        if (n <= Math_Angle270) {
            return -s_math_cosTable[n -= Math_Angle180];
        }
        n = Math_Angle360 - n;
        return s_math_cosTable[n];
    }

    private static int Math_Tan(int n) {
        int n2 = GLLib.Math_Cos(n);
        if (n2 == 0) {
            return Integer.MAX_VALUE;
        }
        n = GLLib.Math_Cos(Math_Angle90 - n);
        return (n << 8) / n2;
    }

    private static int Math_AtanSlow(int n, int n2, int n3) {
        for (int i = n; i < n2; ++i) {
            if (GLLib.Math_Tan(i) > n3 || n3 >= GLLib.Math_Tan(i + 1)) continue;
            return i;
        }
        if (n == Math_Angle90 || n2 == Math_Angle90) {
            return Math_Angle90;
        }
        if (n == Math_Angle270 || n2 == Math_Angle270) {
            return Math_Angle270;
        }
        return 0;
    }

    static int Math_Atan(int n, int n2) {
        int n3;
        if (s_math_aTanTable == null) {
            s_math_aTanTable = new int[s_math_F_1 + 1];
            for (n3 = 0; n3 < s_math_F_1 + 1; ++n3) {
                int n4 = n3;
                int n5 = s_math_F_1;
                GLLib.s_math_aTanTable[n3] = n5 > 0 ? (n4 > 0 ? GLLib.Math_AtanSlow(0, Math_Angle90, n4 * s_math_F_1 / n5) : (n4 == 0 ? 0 : GLLib.Math_AtanSlow(Math_Angle270, Math_Angle360, n4 * s_math_F_1 / n5))) : (n5 == 0 ? (n4 > 0 ? Math_Angle90 : (n4 == 0 ? 0 : Math_Angle270)) : (n4 > 0 ? GLLib.Math_AtanSlow(Math_Angle90, Math_Angle180, n4 * s_math_F_1 / n5) : (n4 == 0 ? Math_Angle180 : GLLib.Math_AtanSlow(Math_Angle180, Math_Angle270, n4 * s_math_F_1 / n5))));
            }
        }
        if (n == 0) {
            if (n2 > 0) {
                return Math_Angle90;
            }
            if (n2 == 0) {
                return 0;
            }
            return Math_Angle270;
        }
        if (n > 0) {
            if (n2 >= 0) {
                if (n >= n2) {
                    n3 = n2 * s_math_F_1 / n;
                    return s_math_aTanTable[n3];
                }
                n3 = n * s_math_F_1 / n2;
                return Math_Angle90 - s_math_aTanTable[n3];
            }
            if (n >= (n2 = -n2)) {
                n3 = n2 * s_math_F_1 / n;
                return Math_Angle360 - s_math_aTanTable[n3];
            }
            n3 = n * s_math_F_1 / n2;
            return Math_Angle270 + s_math_aTanTable[n3];
        }
        n = -n;
        if (n2 >= 0) {
            if (n >= n2) {
                n3 = n2 * s_math_F_1 / n;
                return Math_Angle180 - s_math_aTanTable[n3];
            }
            n3 = n * s_math_F_1 / n2;
            return Math_Angle90 + s_math_aTanTable[n3];
        }
        if (n >= (n2 = -n2)) {
            n3 = n2 * s_math_F_1 / n;
            return Math_Angle180 + s_math_aTanTable[n3];
        }
        n3 = n * s_math_F_1 / n2;
        return Math_Angle270 - s_math_aTanTable[n3];
    }

    static int Math_Sqrt(int n) {
        if (n >= 65536) {
            if (n >= 0x1000000) {
                if (n >= 0x10000000) {
                    if (n >= 0x40000000) {
                        return s_math_sqrtTable[n >> 24] << 8;
                    }
                    return s_math_sqrtTable[n >> 22] << 7;
                }
                if (n >= 0x4000000) {
                    return s_math_sqrtTable[n >> 20] << 6;
                }
                return s_math_sqrtTable[n >> 18] << 5;
            }
            if (n >= 0x100000) {
                if (n >= 0x400000) {
                    return s_math_sqrtTable[n >> 16] << 4;
                }
                return s_math_sqrtTable[n >> 14] << 3;
            }
            if (n >= 262144) {
                return s_math_sqrtTable[n >> 12] << 2;
            }
            return s_math_sqrtTable[n >> 10] << 1;
        }
        if (n >= 256) {
            if (n >= 4096) {
                if (n >= 16384) {
                    return s_math_sqrtTable[n >> 8];
                }
                return s_math_sqrtTable[n >> 6] >> 1;
            }
            if (n >= 1024) {
                return s_math_sqrtTable[n >> 4] >> 2;
            }
            return s_math_sqrtTable[n >> 2] >> 3;
        }
        if (n >= 0) {
            return s_math_sqrtTable[n] >> 4;
        }
        return 0;
    }

    static int Math_FixedPoint_Add(int n, int n2) {
        long l = (long)n + (long)n2;
        return (int)l;
    }

    static int Math_FixedPoint_Subtract(int n, int n2) {
        long l = (long)n - (long)n2;
        return (int)l;
    }

    static int Math_FixedPoint_Multiply(int n, int n2) {
        long l = (long)n * (long)n2 + (long)(s_math_F_1 >> 1) >> 8;
        return (int)l;
    }

    static int Math_FixedPoint_Divide(int n, int n2) {
        return (int)(((long)n << 8 << 1) / (long)n2 + 1L) >> 1;
    }

    static void Pack_Open(String string) {
        if (s_pack_filename != null && string.compareTo(s_pack_filename) == 0) {
            return;
        }
        GLLib.Pack_Close();
        s_pack_filename = string;
        s_pack_is = GLLib.Pack_GetInputStreamFromName(s_pack_filename);
        s_pack_nbData = (short)GLLib.Pack_Read16();
        s_pack_subPack_nbOf = (short)GLLib.Pack_Read16();
        s_pack_subPack_fat = new short[s_pack_subPack_nbOf];
        for (int i = 0; i < s_pack_subPack_nbOf; ++i) {
            GLLib.s_pack_subPack_fat[i] = (short)GLLib.Pack_Read16();
        }
        s_pack_subPack_curSubPack = 0;
        GLLib.Pack_GetDataOffset();
    }

    private static InputStream Pack_GetInputStreamFromName(String object) {
        InputStream inputStream = "".getClass().getResourceAsStream((String)object);
        object = inputStream;
        object = inputStream;
        return inputStream;
    }

    private static void Pack_GetDataOffset() {
        int n = s_pack_subPack_curSubPack == s_pack_subPack_nbOf - 1 ? s_pack_nbData - s_pack_subPack_fat[s_pack_subPack_curSubPack] : s_pack_subPack_fat[s_pack_subPack_curSubPack + 1] - s_pack_subPack_fat[s_pack_subPack_curSubPack];
        s_pack_offset = new int[n + 1];
        for (int i = 0; i < n + 1; ++i) {
            GLLib.s_pack_offset[i] = GLLib.Pack_Read() & 0xFF | (GLLib.Pack_Read() & 0xFF) << 8 | ((GLLib.Pack_Read() & 0xFF) << 16 | (GLLib.Pack_Read() & 0xFF) << 24);
        }
    }

    static void Pack_Close() {
        if (s_pack_is != null) {
            try {
                s_pack_is.close();
            }
            catch (Exception exception) {}
            s_pack_is = null;
        }
        s_pack_curOffset = 0;
        System.gc();
    }

    private static int Pack_PositionAtData(int n) {
        int n2;
        for (n2 = s_pack_subPack_nbOf - 1; n2 >= 0 && s_pack_subPack_fat[n2] > n; --n2) {
        }
        if (s_pack_subPack_curSubPack != n2) {
            s_pack_subPack_curSubPack = n2;
            GLLib.Pack_Close();
            if (s_pack_subPack_curSubPack == 0) {
                String string = s_pack_filename;
                s_pack_filename = null;
                GLLib.Pack_Open(string);
            } else {
                s_pack_is = GLLib.Pack_GetInputStreamFromName(s_pack_filename + "." + s_pack_subPack_curSubPack);
                GLLib.Pack_GetDataOffset();
            }
        } else if (s_pack_is == null) {
            if (s_pack_subPack_curSubPack == 0) {
                String string = s_pack_filename;
                s_pack_filename = null;
                GLLib.Pack_Open(string);
            } else {
                s_pack_is = GLLib.Pack_GetInputStreamFromName(s_pack_filename + "." + s_pack_subPack_curSubPack);
            }
        }
        int n3 = s_pack_offset[n -= s_pack_subPack_fat[s_pack_subPack_curSubPack]];
        n = s_pack_offset[n + 1] - s_pack_offset[n];
        if (s_pack_curOffset != n3) {
            if (s_pack_curOffset > n3) {
                GLLib.Pack_Close();
                s_pack_is = s_pack_subPack_curSubPack == 0 ? GLLib.Pack_GetInputStreamFromName(s_pack_filename) : GLLib.Pack_GetInputStreamFromName(s_pack_filename + "." + s_pack_subPack_curSubPack);
            } else {
                n3 -= s_pack_curOffset;
            }
            GLLib.Pack_Skip(n3);
        }
        s_pack_lastDataIsCompress = false;
        if (n > 0) {
            s_pack_lastDataReadMimeType = GLLib.Pack_Read() & 0xFF;
            if (s_pack_lastDataReadMimeType >= 127) {
                s_pack_lastDataReadMimeType -= 127;
                s_pack_lastDataIsCompress = true;
            }
            --n;
        }
        return n;
    }

    static byte[] Pack_ReadData(int n) {
        n = GLLib.Pack_PositionAtData(n);
        byte[] byArray = null;
        if (s_pack_lastDataIsCompress) {
            try {
                Object object;
                int n2 = n;
                Object object2 = s_pack_is;
                byte[] byArray2 = new byte[13];
                byte[] byArray3 = new byte[n2 - 13];
                GLLib.Stream_ReadFully((InputStream)object2, byArray2, 0, 13);
                GLLib.Stream_ReadFully((InputStream)object2, byArray3, 0, n2 - 13);
                object2 = new int[5];
                for (n2 = 0; n2 < 5; ++n2) {
                    object2[n2] = byArray2[n2] & 0xFF;
                }
                n2 = 0;
                for (object = 0; object < 4; ++object) {
                    n2 += (byArray2[object + 5] & 0xFF) << (object << 3);
                }
                Object object3 = object2[0];
                object = object3;
                Object object4 = object3 / 45;
                int n3 = (object %= 45) / 9;
                int n4 = object % 9;
                object = 1846 + (768 << n4 + n3);
                m_outStream = new byte[n2];
                m_lzmaInternalData = new short[object];
                reference v1 = object4;
                object4 = n2;
                byte[] byArray4 = byArray3;
                Object object5 = v1;
                n2 = n4;
                n4 = object << 1;
                int n5 = byArray4.length;
                int n6 = 1846 + (768 << n2 + n3);
                short[] sArray = m_lzmaInternalData;
                int n7 = 0;
                boolean bl = false;
                int n8 = 0;
                int n9 = 1;
                int n10 = 1;
                int n11 = 1;
                int n12 = 1;
                int n13 = 0;
                object5 = (1 << object5) - 1;
                n3 = (1 << n3) - 1;
                if (n4 >= n6 << 1) {
                    int n14;
                    for (n4 = 0; n4 < n6; ++n4) {
                        sArray[n4] = 1024;
                    }
                    int n15 = n5;
                    m_Buffer = byArray4;
                    m_inSize = n15;
                    inputIndex = 0;
                    m_Code = 0L;
                    m_Range = 0xFFFFFFFFL;
                    for (n14 = 0; n14 < 5; ++n14) {
                        m_Code = m_Code << 8 | (long)GLLib.LZMA_RangeDecoderReadByte();
                    }
                    while (n13 < object4) {
                        n4 = n13 & object5;
                        if (GLLib.LZMA_RangeDecoderBitDecode(0 + (n7 << 4) + n4) == 0) {
                            int n16 = 1846 + 768 * (((n13 & n3) << n2) + ((n8 & 0xFF) >> 8 - n2));
                            n7 = n7 < 4 ? 0 : (n7 < 10 ? (n7 -= 3) : (n7 -= 6));
                            if (bl) {
                                n15 = n5 = m_outStream[n13 - n9];
                                n14 = 1;
                                do {
                                    int n17 = n15 >> 7 & 1;
                                    n15 = (byte)(n15 << 1);
                                    int n18 = GLLib.LZMA_RangeDecoderBitDecode(n16 + (n17 + 1 << 8) + n14);
                                    n14 = n14 << 1 | n18;
                                    if (n17 == n18) continue;
                                    while (n14 < 256) {
                                        n14 = n14 << 1 | GLLib.LZMA_RangeDecoderBitDecode(n16 + n14);
                                    }
                                    break;
                                } while (n14 < 256);
                                n8 = n14 & 0xFF;
                                bl = false;
                            } else {
                                n15 = 1;
                                while ((n15 = n15 << 1 | GLLib.LZMA_RangeDecoderBitDecode(n16 + n15)) < 256) {
                                }
                                n8 = n15 & 0xFF;
                            }
                            GLLib.m_outStream[n13++] = (byte)n8;
                            continue;
                        }
                        bl = true;
                        if (GLLib.LZMA_RangeDecoderBitDecode(n7 + 192) == 1) {
                            if (GLLib.LZMA_RangeDecoderBitDecode(n7 + 204) == 0) {
                                if (GLLib.LZMA_RangeDecoderBitDecode(240 + (n7 << 4) + n4) == 0) {
                                    n7 = n7 < 7 ? 9 : 11;
                                    n8 = m_outStream[n13 - n9] & 0xFF;
                                    GLLib.m_outStream[n13++] = (byte)n8;
                                    continue;
                                }
                            } else {
                                int n19;
                                if (GLLib.LZMA_RangeDecoderBitDecode(n7 + 216) == 0) {
                                    n19 = n10;
                                } else {
                                    if (GLLib.LZMA_RangeDecoderBitDecode(n7 + 228) == 0) {
                                        n19 = n11;
                                    } else {
                                        n19 = n12;
                                        n12 = n11;
                                    }
                                    n11 = n10;
                                }
                                n10 = n9;
                                n9 = n19;
                            }
                            n4 = GLLib.LZMA_LenDecode(1332, n4);
                            n7 = n7 < 7 ? 8 : 11;
                        } else {
                            n12 = n11;
                            n11 = n10;
                            n10 = n9;
                            n7 = n7 < 7 ? 7 : 10;
                            int n20 = GLLib.LZMA_RangeDecoderBitTreeDecode(432 + (((n4 = GLLib.LZMA_LenDecode(818, n4)) < 4 ? n4 : 3) << 6), 6);
                            if (n20 >= 4) {
                                n5 = (n20 >> 1) - 1;
                                n9 = (2 | n20 & 1) << n5;
                                if (n20 < 14) {
                                    n9 += GLLib.LZMA_RangeDecoderReverseBitTreeDecode(n9 + 688 - n20 - 1, n5);
                                } else {
                                    n20 = n5 - 4;
                                    long l = m_Range;
                                    long l2 = m_Code;
                                    n5 = 0;
                                    while (n20 > 0) {
                                        n5 <<= 1;
                                        if (l2 >= (l >>= 1)) {
                                            l2 -= l;
                                            n5 |= 1;
                                        }
                                        if (l < 0x1000000L) {
                                            l <<= 8;
                                            l2 = l2 << 8 | (long)GLLib.LZMA_RangeDecoderReadByte();
                                        }
                                        --n20;
                                    }
                                    m_Range = l;
                                    m_Code = l2;
                                    n9 += n5 << 4;
                                    n9 += GLLib.LZMA_RangeDecoderReverseBitTreeDecode(802, 4);
                                }
                            } else {
                                n9 = n20;
                            }
                            ++n9;
                        }
                        n4 += 2;
                        do {
                            n8 = m_outStream[n13 - n9] & 0xFF;
                            GLLib.m_outStream[n13++] = (byte)n8;
                        } while (--n4 > 0 && n13 < object4);
                    }
                }
                m_lzmaInternalData = null;
                m_Buffer = null;
                System.gc();
                s_pack_curOffset += n;
                byArray = m_outStream;
                m_outStream = null;
            }
            catch (Exception exception) {}
        } else {
            byArray = new byte[n];
            GLLib.Pack_ReadFully(byArray, 0, byArray.length);
        }
        return byArray;
    }

    private static void Pack_Skip(int n) {
        if (n == 0) {
            return;
        }
        if (s_Pack_SkipBuffer == null) {
            s_Pack_SkipBuffer = new byte[256];
        }
        while (n > 256) {
            GLLib.Pack_ReadFully(s_Pack_SkipBuffer, 0, 256);
            n -= 256;
        }
        if (n > 0) {
            GLLib.Pack_ReadFully(s_Pack_SkipBuffer, 0, n);
        }
    }

    private static int Pack_Read() {
        int n = 0;
        try {
            n = s_pack_is.read();
        }
        catch (Exception exception) {}
        ++s_pack_curOffset;
        return n;
    }

    private static int Pack_Read16() {
        return GLLib.Pack_Read() & 0xFF | (GLLib.Pack_Read() & 0xFF) << 8;
    }

    private static int Pack_ReadFully(byte[] byArray, int n, int n2) {
        n = 0;
        int n3 = n2;
        try {
            while (n3 > 0) {
                int n4 = s_pack_is.read(byArray, n, n3);
                n3 -= n4;
                n += n4;
            }
        }
        catch (Exception exception) {}
        s_pack_curOffset += n2;
        return n2;
    }

    static Object Pack_ReadArray(int n) {
        Object object;
        GLLib.Pack_PositionAtData(n);
        Stream_readOffset = 0;
        if (s_pack_lastDataIsCompress) {
            object = GLLib.Pack_ReadData(n);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            object = byteArrayInputStream;
            object = GLLib.Mem_ReadArray(byteArrayInputStream);
        } else {
            object = GLLib.Mem_ReadArray(s_pack_is);
            s_pack_curOffset += Stream_readOffset;
        }
        return object;
    }

    static void Pack_LoadMIME(String string) {
        if (MIME_type == null) {
            InputStream inputStream = s_pack_is;
            s_pack_is = GLLib.Pack_GetInputStreamFromName(string);
            int n = GLLib.Pack_Read();
            MIME_type = new byte[n][];
            for (int i = 0; i < n; ++i) {
                int n2 = GLLib.Pack_Read();
                GLLib.MIME_type[i] = new byte[n2];
                GLLib.Pack_ReadFully(MIME_type[i], 0, n2);
            }
            try {
                s_pack_is.close();
            }
            catch (Exception exception) {}
            s_pack_is = inputStream;
        }
    }

    static String GetMIME(int n) {
        if (n >= MIME_type.length) {
            return "";
        }
        try {
            return new String(MIME_type[n], "UTF-8");
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static int LZMA_RangeDecoderReadByte() {
        if (inputIndex == m_inSize) {
            return 255;
        }
        return m_Buffer[inputIndex++] & 0xFF;
    }

    private static int LZMA_RangeDecoderBitDecode(int n) {
        long l = (m_Range >> 11) * (long)m_lzmaInternalData[n];
        if (m_Code < l) {
            m_Range = l;
            int n2 = n;
            m_lzmaInternalData[n2] = (short)(m_lzmaInternalData[n2] + (2048 - m_lzmaInternalData[n] >> 5));
            if (m_Range < 0x1000000L) {
                m_Code = m_Code << 8 | (long)GLLib.LZMA_RangeDecoderReadByte();
                m_Range <<= 8;
            }
            return 0;
        }
        m_Code -= l;
        int n3 = n;
        m_lzmaInternalData[n3] = (short)(m_lzmaInternalData[n3] - (m_lzmaInternalData[n] >> 5));
        if ((m_Range -= l) < 0x1000000L) {
            m_Code = m_Code << 8 | (long)GLLib.LZMA_RangeDecoderReadByte();
            m_Range <<= 8;
        }
        return 1;
    }

    private static int LZMA_RangeDecoderBitTreeDecode(int n, int n2) {
        int n3 = 1;
        for (int i = n2; i > 0; --i) {
            n3 = (n3 << 1) + GLLib.LZMA_RangeDecoderBitDecode(n + n3);
        }
        return n3 - (1 << n2);
    }

    private static int LZMA_LenDecode(int n, int n2) {
        if (GLLib.LZMA_RangeDecoderBitDecode(n) == 0) {
            return GLLib.LZMA_RangeDecoderBitTreeDecode(n + 2 + (n2 << 3), 3);
        }
        if (GLLib.LZMA_RangeDecoderBitDecode(n + 1) == 0) {
            return 8 + GLLib.LZMA_RangeDecoderBitTreeDecode(n + 130 + (n2 << 3), 3);
        }
        return 16 + GLLib.LZMA_RangeDecoderBitTreeDecode(n + 258, 8);
    }

    private static int LZMA_RangeDecoderReverseBitTreeDecode(int n, int n2) {
        int n3 = 1;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = GLLib.LZMA_RangeDecoderBitDecode(n + n3);
            n3 = (n3 << 1) + n5;
            n4 |= n5 << i;
        }
        return n4;
    }

    static final void setColor(int n, int n2, int n3) {
        g.setColor(n << 16 | n2 << 8 | n3);
    }

    static final void SetClip(int n, int n2, int n3, int n4) {
        g.setClip(n, n2, n3, n4);
    }

    static final void DrawLine(int n, int n2, int n3, int n4) {
        g.drawLine(n, n2, n3, n4);
    }

    static final void FillRect(int n, int n2, int n3, int n4) {
        g.fillRect(n, n2, n3, n4);
    }

    static final void DrawRect(int n, int n2, int n3, int n4) {
        g.drawRect(n, n2, n3, n4);
    }

    static final void DrawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        g.drawRoundRect(n, n2, n3, n4, 16, 16);
    }

    static final void FillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        g.fillRoundRect(n, n2, n3, n4, 16, 16);
    }

    static final Image CreateRGBImage(int[] object, int n, int n2, boolean bl) {
        Image image = Image.createRGBImage((int[])object, (int)n, (int)n2, (boolean)bl);
        object = image;
        return image;
    }

    static final void DrawRGB(Graphics graphics, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        graphics.drawRGB(nArray, 0, n2, n3, n4, n5, n6, bl);
    }

    static short Mem_GetShort(byte[] byArray, int n) {
        return (short)(byArray[n++] & 0xFF | (byArray[n] & 0xFF) << 8);
    }

    private static Object Mem_ReadArray(InputStream inputStream) {
        Object[] objectArray = null;
        try {
            int n = GLLib.Stream_Read(inputStream);
            int n2 = n >> 4;
            int n3 = n & 7;
            n = (n & 8) != 0 ? GLLib.Stream_Read16(inputStream) : GLLib.Stream_Read(inputStream);
            switch (n3) {
                case 0: {
                    byte[] byArray = new byte[n];
                    for (n2 = 0; n2 < n; ++n2) {
                        byArray[n2] = (byte)GLLib.Stream_Read(inputStream);
                    }
                    objectArray = byArray;
                    break;
                }
                case 1: {
                    short[] sArray = new short[n];
                    if (n2 == 0) {
                        for (n2 = 0; n2 < n; ++n2) {
                            sArray[n2] = (byte)GLLib.Stream_Read(inputStream);
                        }
                    } else {
                        for (n2 = 0; n2 < n; ++n2) {
                            sArray[n2] = (short)GLLib.Stream_Read16(inputStream);
                        }
                    }
                    objectArray = sArray;
                    break;
                }
                case 2: {
                    int[] nArray = new int[n];
                    if (n2 == 0) {
                        for (n2 = 0; n2 < n; ++n2) {
                            nArray[n2] = (byte)GLLib.Stream_Read(inputStream);
                        }
                    } else if (n2 == 1) {
                        for (n2 = 0; n2 < n; ++n2) {
                            nArray[n2] = (short)GLLib.Stream_Read16(inputStream);
                        }
                    } else {
                        for (n2 = 0; n2 < n; ++n2) {
                            nArray[n2] = GLLib.Stream_Read32(inputStream);
                        }
                    }
                    objectArray = nArray;
                    break;
                }
                default: {
                    Object[] objectArray2;
                    switch (n3 &= 3) {
                        case 0: {
                            Object object;
                            if (n2 == 2) {
                                object = new byte[n][];
                                objectArray2 = (Object[])object;
                                break;
                            }
                            byte[][][] byArrayArray = new byte[n][][];
                            object = byArrayArray;
                            objectArray2 = (Object[])byArrayArray;
                            break;
                        }
                        case 1: {
                            Object object;
                            if (n2 == 2) {
                                short[][] sArrayArray = new short[n][];
                                object = sArrayArray;
                                objectArray2 = (Object[])sArrayArray;
                                break;
                            }
                            short[][][] sArrayArray = new short[n][][];
                            object = sArrayArray;
                            objectArray2 = (Object[])sArrayArray;
                            break;
                        }
                        default: {
                            Object object;
                            if (n2 == 2) {
                                int[][] nArrayArray = new int[n][];
                                object = nArrayArray;
                                objectArray2 = (Object[])nArrayArray;
                                break;
                            }
                            int[][][] nArrayArray = new int[n][][];
                            object = nArrayArray;
                            objectArray2 = (Object[])nArrayArray;
                        }
                    }
                    for (int i = 0; i < n; ++i) {
                        objectArray2[i] = GLLib.Mem_ReadArray(inputStream);
                    }
                    objectArray = objectArray2;
                    break;
                }
            }
        }
        catch (Exception exception) {}
        return objectArray;
    }

    private static int Stream_Read(InputStream inputStream) throws Exception {
        int n = inputStream.read();
        if (n >= 0) {
            ++Stream_readOffset;
        }
        return n;
    }

    private static int Stream_Read16(InputStream inputStream) throws Exception {
        return GLLib.Stream_Read(inputStream) & 0xFF | (GLLib.Stream_Read(inputStream) & 0xFF) << 8;
    }

    private static int Stream_Read32(InputStream inputStream) throws Exception {
        return GLLib.Stream_Read(inputStream) & 0xFF | (GLLib.Stream_Read(inputStream) & 0xFF) << 8 | ((GLLib.Stream_Read(inputStream) & 0xFF) << 16 | (GLLib.Stream_Read(inputStream) & 0xFF) << 24);
    }

    private static int Stream_ReadFully(InputStream inputStream, byte[] byArray, int n, int n2) {
        n = 0;
        int n3 = n2;
        try {
            while (n3 > 0) {
                int n4 = inputStream.read(byArray, n, n3);
                n3 -= n4;
                n += n4;
            }
        }
        catch (Exception exception) {}
        Stream_readOffset += n2;
        return n2;
    }

    static String Text_GetLanguageAsString(int n) {
        switch (n) {
            case 0: {
                return StrEN;
            }
            case 1: {
                return StrDE;
            }
            case 2: {
                return StrFR;
            }
            case 3: {
                return StrIT;
            }
            case 4: {
                return StrES;
            }
            case 5: {
                return StrBR;
            }
            case 6: {
                return StrPT;
            }
            case 7: {
                return StrJP;
            }
            case 8: {
                return StrCN;
            }
            case 9: {
                return StrKR;
            }
            case 10: {
                return StrRU;
            }
            case 12: {
                return StrPL;
            }
            case 11: {
                return StrTR;
            }
            case 13: {
                return StrCZ;
            }
            case 14: {
                return StrNL;
            }
        }
        return null;
    }

    private static int Text_LoadTextFromStream(InputStream inputStream) {
        try {
            text_nbString = GLLib.Stream_Read32(inputStream);
            text_arrayOffset = new int[text_nbString + 1];
            for (int i = 1; i < text_nbString + 1; ++i) {
                GLLib.text_arrayOffset[i] = GLLib.Stream_Read32(inputStream);
            }
            text_array = new byte[text_arrayOffset[text_nbString]];
            GLLib.Stream_ReadFully(inputStream, text_array, 0, text_array.length);
        }
        catch (Exception exception) {}
        return text_array.length + (text_nbString + 1 << 2);
    }

    static void Text_LoadTextFromPack(String object, int n) {
        GLLib.Text_FreeAll();
        GLLib.Pack_Open((String)object);
        GLLib.Pack_PositionAtData(n);
        if (s_pack_lastDataIsCompress) {
            object = GLLib.Pack_ReadData(n);
            object = new ByteArrayInputStream((byte[])object);
            GLLib.Text_LoadTextFromStream((InputStream)object);
        } else {
            GLLib.Text_LoadTextFromStream(s_pack_is);
        }
        GLLib.Pack_Close();
        GLLib.Text_BuildStringCache();
    }

    static void Text_LoadTextFromPack(String object, int n, int n2) {
        GLLib.Text_FreeAll();
        GLLib.Pack_Open((String)object);
        GLLib.Pack_PositionAtData(1);
        if (s_pack_lastDataIsCompress) {
            object = new ByteArrayInputStream(GLLib.Pack_ReadData(1));
            GLLib.Text_LoadTextFromStream((InputStream)object);
        } else {
            s_pack_curOffset += GLLib.Text_LoadTextFromStream(s_pack_is);
        }
        int n3 = text_nbString;
        int[] nArray = text_arrayOffset;
        byte[] byArray = text_array;
        GLLib.Text_FreeAll();
        GLLib.Pack_PositionAtData(n2);
        if (s_pack_lastDataIsCompress) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(GLLib.Pack_ReadData(n2));
            GLLib.Text_LoadTextFromStream(byteArrayInputStream);
        } else {
            s_pack_curOffset += GLLib.Text_LoadTextFromStream(s_pack_is);
        }
        int n4 = text_nbString;
        int[] nArray2 = text_arrayOffset;
        byte[] byArray2 = text_array;
        int n5 = 1;
        while (n5 < n4 + 1) {
            int n6 = n5++;
            nArray2[n6] = nArray2[n6] + nArray[n3];
        }
        GLLib.Text_FreeAll();
        GLLib.Pack_Close();
        text_nbString = n3 + n4;
        text_arrayOffset = new int[text_nbString + 1];
        System.arraycopy(nArray, 0, text_arrayOffset, 0, nArray.length);
        System.arraycopy(nArray2, 1, text_arrayOffset, nArray.length, nArray2.length - 1);
        text_array = new byte[text_arrayOffset[text_nbString]];
        System.arraycopy(byArray, 0, text_array, 0, byArray.length);
        System.arraycopy(byArray2, 0, text_array, byArray.length, byArray2.length);
        GLLib.Text_BuildStringCache();
    }

    private static String Text_FromUTF8(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = n;
        n += n2;
        while (n4 < n) {
            if ((byArray[n4] & 0x80) == 0) {
                cArray[n3++] = (char)byArray[n4++];
                continue;
            }
            if ((byArray[n4] & 0xE0) == 224 && n4 + 2 < n && (byArray[n4 + 1] & 0xC0) == 128 && (byArray[n4 + 2] & 0xC0) == 128) {
                cArray[n3++] = (char)((byArray[n4] & 0xF) << 12 | (byArray[n4 + 1] & 0x3F) << 6 | byArray[n4 + 2] & 0x3F);
                n4 += 3;
                continue;
            }
            if ((byArray[n4] & 0xC0) == 192 && n4 + 1 < n && (byArray[n4 + 1] & 0xC0) == 128) {
                cArray[n3++] = (char)((byArray[n4] & 0x1F) << 6 | byArray[n4 + 1] & 0x3F);
                n4 += 2;
                continue;
            }
            return "";
        }
        return new String(cArray, 0, n3);
    }

    static String Text_GetString(int n) {
        if (text_stringCacheArray != null) {
            return text_stringCacheArray[n];
        }
        try {
            int n2 = text_arrayOffset[n + 1] - text_arrayOffset[n];
            if (n2 == 0) {
                return null;
            }
            if (!text_encoding.equals("UTF-8")) {
                return new String(text_array, text_arrayOffset[n], n2, text_encoding);
            }
            return GLLib.Text_FromUTF8(text_array, text_arrayOffset[n], n2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void Text_BuildStringCache() {
        String[] stringArray = new String[text_nbString];
        for (int i = 0; i < text_nbString; ++i) {
            stringArray[i] = GLLib.Text_GetString(i);
        }
        text_stringCacheArray = stringArray;
        text_arrayOffset = null;
        text_array = null;
        System.gc();
    }

    private static void Text_FreeAll() {
        if (text_stringCacheArray != null) {
            for (int i = 0; i < text_nbString; ++i) {
                GLLib.text_stringCacheArray[i] = null;
            }
            text_stringCacheArray = null;
        }
        text_arrayOffset = null;
        text_array = null;
        text_nbString = 0;
    }

    private static void Rms_Close() {
        if (s_rs == null) {
            return;
        }
        try {
            s_rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {}
        s_rs = null;
    }

    private static void Rms_Open(String string) throws RecordStoreException {
        s_rs = RecordStore.openRecordStore((String)string, (boolean)true);
    }

    static byte[] Rms_Read(String string) {
        return GLLib.Rms_Read_Single(string);
    }

    private static byte[] Rms_Read_Single(String string) {
        byte[] byArray = null;
        try {
            GLLib.Rms_Open(string);
            if (s_rs.getNumRecords() > 0) {
                byArray = s_rs.getRecord(1);
            }
        }
        catch (RecordStoreException recordStoreException) {
            new StringBuffer().append("ERROR! Failed reading from RMS: ").append((Object)recordStoreException);
            byArray = null;
        }
        GLLib.Rms_Close();
        return byArray;
    }

    static void Rms_Write(String string, byte[] byArray) {
        int n = byArray.length;
        boolean bl = false;
        String string2 = string;
        try {
            GLLib.Rms_Open(string2);
            if (s_rs.getNumRecords() > 0) {
                s_rs.setRecord(1, byArray, 0, n);
            } else {
                s_rs.addRecord(byArray, 0, n);
            }
        }
        catch (RecordStoreException recordStoreException) {}
        GLLib.Rms_Close();
    }

    public static void AlphaRect_SetColor(int n) {
        if (n != s_alphaRectCurrentARGB || s_alphaRectARGBData == null) {
            s_alphaRectCurrentARGB = n;
            if (s_alphaRectARGBData == null) {
                s_alphaRectARGBData = new int[256];
            }
            int n2 = 256;
            while (n2 > 0) {
                GLLib.s_alphaRectARGBData[--n2] = n;
            }
        }
    }

    public static void AlphaRect_Draw(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = g.getClipX();
        int n6 = g.getClipY();
        int n7 = g.getClipWidth();
        int n8 = g.getClipHeight();
        int n9 = n > n5 ? n : n5;
        int n10 = n2 > n6 ? n2 : n6;
        n3 = (n + n3 < n5 + n7 ? n + n3 : n5 + n7) - n9;
        n4 = (n2 + n4 < n6 + n8 ? n2 + n4 : n6 + n8) - n10;
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        GLLib.SetClip(n9, n10, n3, n4);
        if (n3 * n4 < 256) {
            GLLib.DrawRGB(graphics, s_alphaRectARGBData, 0, n3, n9, n10, n3, n4, true);
        } else {
            n3 += n9;
            n4 += n10;
            for (n = n9; n < n3; n += 16) {
                for (n2 = n10; n2 < n4; n2 += 16) {
                    GLLib.DrawRGB(graphics, s_alphaRectARGBData, 0, 16, n, n2, 16, 16, true);
                }
            }
        }
        GLLib.SetClip(n5, n6, n7, n8);
    }

    static {
        s_screenWidth = 640;
        s_screenHeight = 360;
        m_FPSLimiter = 66;
        m_last_key_pressed = -9999;
        s_math_F_1 = 256;
        Math_AngleMUL = 256;
        Math_Angle90 = 90 * Math_AngleMUL / 360;
        Math_Angle180 = 180 * Math_AngleMUL / 360;
        Math_Angle270 = 270 * Math_AngleMUL / 360;
        Math_Angle360 = 360 * Math_AngleMUL / 360;
        Math_FixedPoint_PI = 804;
        ratioDegreesToAngleFixedPoint = GLLib.Math_FixedPoint_Divide(256, 360);
        Stream_readOffset = 0;
        text_encoding = "UTF-8";
        StrEN = "EN";
        StrDE = "DE";
        StrFR = "FR";
        StrIT = "IT";
        StrES = "ES";
        StrBR = "BR";
        StrPT = "PT";
        StrJP = "JP";
        StrCN = "CN";
        StrKR = "KR";
        StrRU = "RU";
        StrTR = "TR";
        StrPL = "PL";
        StrCZ = "CZ";
        StrNL = "NL";
        s_PFX_initializd = false;
        s_PFX_type = 0;
        s_PFX_params = null;
        s_PFX_screenBuffer = null;
        s_PFX_screenBufferG = null;
        s_PFX_enableScreenBuffer = 0;
        s_PFX_enableScreenBufferThisFrame = 0;
    }
}

