/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.saves;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import sk.inlogic.rms.RMSHandler;
import sk.inlogic.saves.SavedTutorialItem;

public class SavedTutorial
implements RMSHandler {
    public Vector savedTutorial = new Vector();

    public boolean isSavedTutorial() {
        return this.savedTutorial.size() > 0;
    }

    public SavedTutorialItem getSavedTutorial() {
        if (this.savedTutorial.size() > 0) {
            return (SavedTutorialItem)this.savedTutorial.firstElement();
        }
        return null;
    }

    public void saveTutorial(SavedTutorialItem tutorialItem) {
        if (this.savedTutorial.size() > 0) {
            this.savedTutorial.setElementAt(tutorialItem, 0);
        } else {
            this.savedTutorial.addElement(tutorialItem);
        }
    }

    public void load(DataInputStream dis, String rmsName) throws IOException {
        this.savedTutorial.removeAllElements();
        if (dis.readInt() != 0) {
            int j;
            SavedTutorialItem gameItem = new SavedTutorialItem();
            gameItem.tutorialLayer = dis.readInt();
            gameItem.tutorialDialog = dis.readInt();
            gameItem.tutorialCounter = dis.readInt();
            gameItem.matches = dis.readInt();
            gameItem.playedTime = dis.readInt();
            gameItem.removedCursor = dis.readInt();
            gameItem.tilesCount = dis.readInt();
            gameItem.screen = dis.readInt();
            gameItem.combos = dis.readInt();
            gameItem.comboTime = dis.readInt();
            gameItem.comboMultiplier = dis.readInt();
            gameItem.tiles = new byte[gameItem.tilesCount];
            gameItem.removed = new int[gameItem.tilesCount];
            gameItem.showed = new byte[gameItem.tilesCount];
            gameItem.markedTiles = new int[2];
            gameItem.markedTilesType = new byte[2];
            gameItem.hints = new int[2];
            for (j = 0; j < gameItem.tilesCount; ++j) {
                gameItem.tiles[j] = dis.readByte();
            }
            for (j = 0; j < gameItem.tilesCount; ++j) {
                gameItem.removed[j] = dis.readInt();
            }
            for (j = 0; j < gameItem.tilesCount; ++j) {
                gameItem.showed[j] = dis.readByte();
            }
            for (j = 0; j < 2; ++j) {
                gameItem.markedTiles[j] = dis.readInt();
            }
            for (j = 0; j < 2; ++j) {
                gameItem.markedTilesType[j] = dis.readByte();
            }
            for (j = 0; j < 2; ++j) {
                gameItem.hints[j] = dis.readInt();
            }
            gameItem.isHint = dis.readBoolean();
            gameItem.isDialog = dis.readBoolean();
            gameItem.isFinished = dis.readBoolean();
            this.savedTutorial.addElement(gameItem);
        }
    }

    public void save(DataOutputStream dos, String rmsName) throws IOException {
        int j;
        SavedTutorialItem gameItem = (SavedTutorialItem)this.savedTutorial.firstElement();
        dos.writeInt(1);
        dos.writeInt(gameItem.tutorialLayer);
        dos.writeInt(gameItem.tutorialDialog);
        dos.writeInt(gameItem.tutorialCounter);
        dos.writeInt(gameItem.matches);
        dos.writeInt(gameItem.playedTime);
        dos.writeInt(gameItem.removedCursor);
        dos.writeInt(gameItem.tilesCount);
        dos.writeInt(gameItem.screen);
        dos.writeInt(gameItem.combos);
        dos.writeInt(gameItem.comboTime);
        dos.writeInt(gameItem.comboMultiplier);
        for (j = 0; j < gameItem.tilesCount; ++j) {
            dos.writeByte(gameItem.tiles[j]);
        }
        for (j = 0; j < gameItem.tilesCount; ++j) {
            dos.writeInt(gameItem.removed[j]);
        }
        for (j = 0; j < gameItem.tilesCount; ++j) {
            dos.writeByte(gameItem.showed[j]);
        }
        for (j = 0; j < 2; ++j) {
            dos.writeInt(gameItem.markedTiles[j]);
        }
        for (j = 0; j < 2; ++j) {
            dos.writeByte(gameItem.markedTilesType[j]);
        }
        for (j = 0; j < 2; ++j) {
            dos.writeInt(gameItem.hints[j]);
        }
        dos.writeBoolean(gameItem.isHint);
        dos.writeBoolean(gameItem.isDialog);
        dos.writeBoolean(gameItem.isFinished);
    }

    public void setDefault(DataOutputStream dos, String rmsName) throws IOException {
        dos.writeInt(0);
    }
}

