/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.util;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.util.ArrayInt;
import sk.inlogic.util.ArrayObject;

public class Particles {
    static final int MAX_PARTICLES = 320;
    private static int[] partX = new int[320];
    private static int[] partY = new int[320];
    private static int[] partVelX = new int[320];
    private static int[] partVelY = new int[320];
    private static int[] partAccX = new int[320];
    private static int[] partAccY = new int[320];
    private static int[] partCol = new int[320];
    private static int[] partSize = new int[320];
    private static int[] partLife = new int[320];
    private static Sprite[] partSprite = new Sprite[320];
    private static int[] partFrame = new int[320];
    private static int[] partClass = new int[320];

    public static void resetParticles() {
        ArrayInt.resetArray(partX);
        ArrayObject.resetObjectsArray(partSprite);
        System.gc();
    }

    public static int createParticle(int X2, int Y, int VelX, int VelY, int AccX, int AccY, int Size, int Col, int Life, int Class2) {
        for (int i = partX.length - 1; i >= 0; --i) {
            if (partX[i] != -9999999) continue;
            Particles.partSprite[i] = null;
            Particles.partFrame[i] = 0;
            Particles.partX[i] = X2 << 8;
            Particles.partY[i] = Y << 8;
            Particles.partVelX[i] = MainCanvas.WIDTH * (VelX << 5) / 240;
            Particles.partVelY[i] = MainCanvas.WIDTH * (VelY << 5) / 240;
            Particles.partAccX[i] = MainCanvas.WIDTH * (AccX << 5) / 240;
            Particles.partAccY[i] = MainCanvas.WIDTH * (AccY << 5) / 240;
            Particles.partSize[i] = Size;
            Particles.partCol[i] = Col;
            Particles.partLife[i] = Life;
            Particles.partClass[i] = Class2;
            return i;
        }
        return -1;
    }

    public static int createParticle(int X2, int Y, int VelX, int VelY, int AccX, int AccY, Sprite Source, int Frame, int Life, int Class2) {
        for (int i = partX.length - 1; i >= 0; --i) {
            if (partX[i] != -9999999) continue;
            Particles.partSprite[i] = Source;
            Particles.partFrame[i] = Frame;
            Particles.partX[i] = X2 << 8;
            Particles.partY[i] = Y << 8;
            Particles.partVelX[i] = MainCanvas.WIDTH * (VelX << 5) / 240;
            Particles.partVelY[i] = MainCanvas.WIDTH * (VelY << 5) / 240;
            Particles.partAccX[i] = MainCanvas.WIDTH * (AccX << 5) / 240;
            Particles.partAccY[i] = MainCanvas.WIDTH * (AccY << 5) / 240;
            Particles.partSize[i] = 0;
            Particles.partCol[i] = 0;
            Particles.partLife[i] = Life;
            Particles.partClass[i] = Class2;
            return i;
        }
        return -1;
    }

    public static void update() {
        for (int i = partX.length - 1; i >= 0; --i) {
            if (partX[i] == -9999999) continue;
            if (partLife[i] > 0) {
                int n = i;
                partLife[n] = partLife[n] - 1;
                int n2 = i;
                partX[n2] = partX[n2] + partVelX[i];
                int n3 = i;
                partY[n3] = partY[n3] + partVelY[i];
                int n4 = i;
                partVelX[n4] = partVelX[n4] + partAccX[i];
                int n5 = i;
                partVelY[n5] = partVelY[n5] + partAccY[i];
                continue;
            }
            Particles.partX[i] = -9999999;
        }
    }

    public static void paint(Graphics g, int Class2) {
        for (int i = partX.length - 1; i >= 0; --i) {
            if (partX[i] == -9999999) continue;
            if (partClass[i] != Class2) {
                System.out.println(partClass[i] + " != " + Class2);
                continue;
            }
            int px = partX[i] >> 8;
            int py = partY[i] >> 8;
            if (partSprite[i] != null) {
                partSprite[i].setPosition(px - partSprite[i].getWidth() / 2, py - partSprite[i].getHeight() / 2);
                partSprite[i].setFrame(partFrame[i]);
                partSprite[i].paint(g);
                continue;
            }
            int tmp = partSize[i] / 2;
            g.setColor(partCol[i]);
            g.fillRect(px - tmp, py - tmp, partSize[i], partSize[i]);
        }
    }

    public static int activeParticles() {
        return ArrayInt.getNonNullValuesCount(partX);
    }
}

