/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ArrayInt {
    public static final int INT_NULL = -9999999;

    public static void resetArray(int[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = -9999999;
        }
    }

    public static void splitArray(int[] array) {
        int firstEmptyPos = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == -9999999) continue;
            if (firstEmptyPos != i) {
                array[firstEmptyPos] = array[i];
                array[i] = -9999999;
            }
            ++firstEmptyPos;
        }
    }

    public static int getIndexOfValue(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static boolean existValue(int[] array, int value) {
        return ArrayInt.getIndexOfValue(array, value) != -1;
    }

    public static void addUniqueValue(int[] array, int value) {
        if (!ArrayInt.existValue(array, value)) {
            ArrayInt.addValue(array, value);
        }
    }

    public static void addValue(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != -9999999) continue;
            array[i] = value;
            break;
        }
    }

    public static int removeValue(int[] array, int value) {
        int removedCount = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            array[i] = -9999999;
            ++removedCount;
        }
        return removedCount;
    }

    public static int getNonNullValuesCount(int[] array) {
        int count = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == -9999999) continue;
            ++count;
        }
        return count;
    }

    public static void swapIntArrayVals(int[] intArray, int idx1, int idx2) {
        int tmp = intArray[idx1];
        intArray[idx1] = intArray[idx2];
        intArray[idx2] = tmp;
    }

    public static void addIntArrayOnPos(int[] intArray, int intVal, int pos) {
        if (intArray.length - 1 < pos) {
            return;
        }
        for (int i = intArray.length - 2; i >= pos; --i) {
            intArray[i + 1] = intArray[i];
        }
        intArray[pos] = intVal;
    }

    public static void shiftEmptyValuesToEnd(int[] intArray) {
        int firstNullPos = 0;
        int len = intArray.length;
        for (int i = 0; i < len; ++i) {
            if (intArray[i] == -9999999) continue;
            if (firstNullPos != i) {
                intArray[firstNullPos] = intArray[i];
                intArray[i] = -9999999;
            }
            ++firstNullPos;
        }
    }

    public static int getLastNonEmptyValue(int[] intArray) {
        int len = intArray.length;
        for (int i = len - 1; i >= 0; --i) {
            if (intArray[i] == -9999999) continue;
            return intArray[i];
        }
        return -9999999;
    }

    public static int getLastNonEmptyValueIdx(int[] intArray) {
        int len = intArray.length;
        for (int i = len - 1; i >= 0; --i) {
            if (intArray[i] == -9999999) continue;
            return i;
        }
        return -9999999;
    }

    public static void resetArrayToValue(int[] intArray, int value) {
        for (int i = 0; i < intArray.length; ++i) {
            intArray[i] = value;
        }
    }

    public static void saveIntArrayValues(int[] intArray, DataOutputStream data) throws IOException {
        for (int i = 0; i < intArray.length; ++i) {
            data.writeInt(intArray[i]);
        }
    }

    static final void loadIntArrayValues(int[] intArray, DataInputStream data) throws IOException {
        for (int i = 0; i < intArray.length; ++i) {
            intArray[i] = data.readInt();
        }
    }
}

