/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public final class LoadSave {
    static final String RECORD_STORE_NAME = "jeremy";
    static int hiscoreListLength;
    static final String RESOURCE_FILE_NAME = "/a.c";
    static Image[] packImage;
    static String[] packName;
    static InputStream is;
    static DataInputStream din;
    static int loading;
    static int resNum;
    static long time;
    static int fileLength;
    static int scrNum;
    private static byte[] imagePNG;
    private static final int PALLETE_SHIFT = 33;
    private static int palleteLength;
    private static final int[] CRC32_TABLE;

    private static void createDefaultRecord() {
        try {
            int i;
            RecordStore RS = RecordStore.openRecordStore((String)RECORD_STORE_NAME, (boolean)true);
            if (RS.getNumRecords() != 0) {
                RS.closeRecordStore();
                return;
            }
            byte[][] target = new byte[3][];
            target[0] = new byte[2];
            target[0][0] = 1;
            target[0][1] = 3;
            target[1] = new byte[1];
            target[1][0] = 0;
            int count = 0;
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            DataOutputStream ds = new DataOutputStream(bs);
            for (i = hiscoreListLength; i > 0; --i) {
                ds.writeInt(++count * 4000);
                ds.writeChars("AAA");
            }
            target[2] = bs.toByteArray();
            ds.close();
            for (i = 0; i < target.length; ++i) {
                RS.addRecord(target[i], 0, target[i].length);
            }
            RS.closeRecordStore();
            Object var1_2 = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static byte[][] getRecord() {
        byte[][] target = null;
        try {
            RecordStore RS = RecordStore.openRecordStore((String)RECORD_STORE_NAME, (boolean)false);
            target = new byte[RS.getNumRecords()][];
            for (int i = 0; i < target.length; ++i) {
                target[i] = RS.getRecord(i + 1);
            }
            RS.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return target;
    }

    static void setRecord(byte[][] target) {
        try {
            RecordStore RS = RecordStore.openRecordStore((String)RECORD_STORE_NAME, (boolean)false);
            for (int i = 0; i < target.length; ++i) {
                RS.setRecord(i + 1, target[i], 0, target[i].length);
            }
            RS.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void init() {
        try {
            time = System.currentTimeMillis();
            LoadSave.createDefaultRecord();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void drawLogo(Graphics g) {
        try {
            g.setClip(0, 0, 130, 130);
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, 130, 130);
            Image logo = Image.createImage((String)"/logo.png");
            g.drawImage(logo, (130 - logo.getWidth()) / 2, (130 - logo.getHeight()) / 2, 0);
            Object var1_1 = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void progressBar(Graphics g) {
        LoadSave.drawLogo(g);
        loading = System.currentTimeMillis() - time > (long)3000 ? 0 : 1;
    }

    static Image getImage(String fileName) {
        try {
            Image image = Image.createImage((String)("/" + fileName));
            return image;
        }
        catch (Exception ex) {
            Image image = null;
            return image;
        }
    }

    static byte[] getFile(String fileName) {
        try {
            int b;
            System.gc();
            InputStream is = ((Object)((Object)a.instance)).getClass().getResourceAsStream("/" + fileName);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((b = is.read()) != -1) {
                baos.write(b);
            }
            byte[] data = baos.toByteArray();
            fileLength = data.length;
            is.close();
            baos.close();
            byte[] byArray = data;
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static byte[][] getMap(int level) {
        try {
            InputStream is = ((Object)((Object)a.instance)).getClass().getResourceAsStream("/" + level + ".o");
            DataInputStream din = new DataInputStream(is);
            System.gc();
            scrNum = din.readUnsignedByte();
            Game.maxCells = scrNum * 4;
            din.readUnsignedByte();
            byte[] temp = new byte[scrNum * 8];
            din.readFully(temp);
            byte[][] packLevel = new byte[scrNum * 4 + 5][4];
            for (int k = 0; k < scrNum * 8; ++k) {
                packLevel[k / 2][k % 2 * 2] = (byte)(temp[k] >> 4 & 0xF);
                packLevel[k / 2][k % 2 * 2 + 1] = (byte)(temp[k] & 0xF);
            }
            temp = null;
            din.close();
            is = null;
            din = null;
            byte[][] byArray = packLevel;
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static void saveLevel() {
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            DataOutputStream ds = new DataOutputStream(bs);
            ds.writeByte(Game.level);
            ds.writeInt(Game.money);
            ds.writeInt(Game.damage);
            ds.writeInt(Game.motor);
            ds.writeInt(Game.turbo);
            ds.writeInt(Game.score);
            byte[][] RS = LoadSave.getRecord();
            RS[1] = bs.toByteArray();
            LoadSave.setRecord(RS);
            RS = null;
            ds.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void loadLevel() {
        try {
            byte[][] RS = LoadSave.getRecord();
            ByteArrayInputStream bs = new ByteArrayInputStream(RS[1]);
            DataInputStream ds = new DataInputStream(bs);
            Game.level = ds.readByte();
            Game.money = ds.readInt();
            Game.damage = ds.readInt();
            Game.motor = ds.readInt();
            Game.turbo = ds.readInt();
            Game.score = ds.readInt();
            ds.close();
            Object var0 = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void loadPNG(String fileName) {
        imagePNG = null;
        imagePNG = LoadSave.getFile(fileName);
        palleteLength = imagePNG[33] << 24 | imagePNG[34] << 16 | imagePNG[35] << 8 | imagePNG[36];
    }

    static Image getPNGImage() {
        return Image.createImage((byte[])imagePNG, (int)0, (int)imagePNG.length);
    }

    static void HLS(int h, int l, int s) {
        try {
            int i = palleteLength;
            while ((i -= 3) > 0) {
                int rgb = LoadSave.effectHSB(imagePNG[i + 41] & 0xFF, imagePNG[i + 1 + 41] & 0xFF, imagePNG[i + 2 + 41] & 0xFF, h, s, l);
                LoadSave.imagePNG[i + 41] = (byte)(rgb >>> 16 & 0xFF);
                LoadSave.imagePNG[i + 1 + 41] = (byte)(rgb >>> 8 & 0xFF);
                LoadSave.imagePNG[i + 2 + 41] = (byte)(rgb & 0xFF);
            }
            int crc = LoadSave.updateCRC(imagePNG, 37, palleteLength + 4);
            LoadSave.imagePNG[41 + LoadSave.palleteLength + 0] = (byte)(crc >> 24 & 0xFF);
            LoadSave.imagePNG[41 + LoadSave.palleteLength + 1] = (byte)(crc >> 16 & 0xFF);
            LoadSave.imagePNG[41 + LoadSave.palleteLength + 2] = (byte)(crc >> 8 & 0xFF);
            LoadSave.imagePNG[41 + LoadSave.palleteLength + 3] = (byte)(crc >> 0 & 0xFF);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static int effectHSB(int red, int green, int blue, int hue, int saturation, int brightness) {
        int cmin;
        int cmax;
        int newHue = 45 * hue;
        int newSaturation = 45 * saturation;
        int newBrightness = 45 * brightness;
        int n = cmax = red > green ? red : green;
        if (blue > cmax) {
            cmax = blue;
        }
        int n2 = cmin = red < green ? red : green;
        if (blue < cmin) {
            cmin = blue;
        }
        int cdelta = cmax - cmin;
        brightness = (cmax << 14) / 255;
        saturation = cmax != 0 ? (cdelta << 14) / cmax : 0;
        if (saturation == 0) {
            hue = 0;
        } else {
            int redc = (cmax - red << 14) / cdelta;
            int greenc = (cmax - green << 14) / cdelta;
            int bluec = (cmax - blue << 14) / cdelta;
            if (red == cmax) {
                hue = bluec - greenc;
            } else {
                hue = green == cmax ? 32768 + redc - bluec : 65536 + greenc - redc;
                if ((hue /= 6) < 0) {
                    hue += 16384;
                }
            }
        }
        hue += newHue & 0x3FFF;
        brightness += newBrightness & 0x3FFF;
        if ((saturation += newSaturation & 0x3FFF) == 0) {
            green = blue = brightness * 255 + 8192 >>> 14;
            red = blue;
        } else {
            int h = (hue - (hue >>> 14 << 14)) * 6;
            int f = h - (h >>> 14 << 14);
            int p = brightness * (16384 - saturation) >>> 14;
            int q = brightness * (16384 - (saturation * f >>> 14)) >>> 14;
            int t = brightness * (16384 - (saturation * (16384 - f) >>> 14)) >>> 14;
            switch (h >>> 14) {
                case 0: {
                    red = brightness * 255 + 8192 >>> 14;
                    green = t * 255 + 8192 >>> 14;
                    blue = p * 255 + 8192 >>> 14;
                    break;
                }
                case 1: {
                    red = q * 255 + 8192 >>> 14;
                    green = brightness * 255 + 8192 >>> 14;
                    blue = p * 255 + 8192 >>> 14;
                    break;
                }
                case 2: {
                    red = p * 255 + 8192 >>> 14;
                    green = brightness * 255 + 8192 >>> 14;
                    blue = t * 255 + 8192 >>> 14;
                    break;
                }
                case 3: {
                    red = p * 255 + 8192 >>> 14;
                    green = q * 255 + 8192 >>> 14;
                    blue = brightness * 255 + 8192 >>> 14;
                    break;
                }
                case 4: {
                    red = t * 255 + 8192 >>> 14;
                    green = p * 255 + 8192 >>> 14;
                    blue = brightness * 255 + 8192 >>> 14;
                    break;
                }
                case 5: {
                    red = brightness * 255 + 8192 >>> 14;
                    green = p * 255 + 8192 >>> 14;
                    blue = q * 255 + 8192 >>> 14;
                    break;
                }
            }
        }
        return red << 16 | green << 8 | blue;
    }

    private static int updateCRC(byte[] data, int offset, int length) {
        int nCrc = -1;
        while (--length >= 0) {
            nCrc = nCrc >>> 8 ^ CRC32_TABLE[(nCrc ^ data[offset++]) & 0xFF];
        }
        return ~nCrc;
    }

    static {
        RECORD_STORE_NAME = RECORD_STORE_NAME;
        hiscoreListLength = 10;
        RESOURCE_FILE_NAME = RESOURCE_FILE_NAME;
        PALLETE_SHIFT = 33;
        CRC32_TABLE = new int[]{0, 1996959894, -301047508, -1727442502, 124634137, 1886057615, -379345611, -1637575261, 249268274, 2044508324, -522852066, -1747789432, 162941995, 2125561021, -407360249, -1866523247, 498536548, 1789927666, -205950648, -2067906082, 450548861, 1843258603, -187386543, -2083289657, 325883990, 1684777152, -43845254, -1973040660, 335633487, 1661365465, -99664541, -1928851979, 997073096, 1281953886, -715111964, -1570279054, 1006888145, 1258607687, -770865667, -1526024853, 901097722, 1119000684, -608450090, -1396901568, 853044451, 1172266101, -589951537, -1412350631, 651767980, 1373503546, -925412992, -1076862698, 565507253, 1454621731, -809855591, -1195530993, 671266974, 1594198024, -972236366, -1324619484, 795835527, 1483230225, -1050600021, -1234817731, 1994146192, 31158534, -1731059524, -271249366, 1907459465, 112637215, -1614814043, -390540237, 2013776290, 251722036, -1777751922, -519137256, 2137656763, 141376813, -1855689577, -429695999, 1802195444, 476864866, -2056965928, -228458418, 1812370925, 453092731, -2113342271, -183516073, 1706088902, 314042704, -1950435094, -54949764, 1658658271, 366619977, -1932296973, -69972891, 1303535960, 984961486, -1547960204, -725929758, 1256170817, 1037604311, -1529756563, -740887301, 1131014506, 879679996, -1385723834, -631195440, 1141124467, 855842277, -1442165665, -586318647, 1342533948, 654459306, -1106571248, -921952122, 1466479909, 544179635, -1184443383, -832445281, 1591671054, 702138776, -1328506846, -942167884, 1504918807, 783551873, -1212326853, -1061524307, -306674912, -1698712650, 62317068, 1957810842, -355121351, -1647151185, 81470997, 1943803523, -480048366, -1805370492, 225274430, 2053790376, -468791541, -1828061283, 167816743, 2097651377, -267414716, -2029476910, 503444072, 1762050814, -144550051, -2140837941, 426522225, 1852507879, -19653770, -1982649376, 282753626, 1742555852, -105259153, -1900089351, 397917763, 1622183637, -690576408, -1580100738, 953729732, 1340076626, -776247311, -1497606297, 1068828381, 1219638859, -670225446, -1358292148, 906185462, 1090812512, -547295293, -1469587627, 829329135, 1181335161, -882789492, -1134132454, 628085408, 1382605366, -871598187, -1156888829, 570562233, 1426400815, -977650754, -1296233688, 733239954, 1555261956, -1026031705, -1244606671, 752459403, 1541320221, -1687895376, -328994266, 1969922972, 40735498, -1677130071, -351390145, 1913087877, 83908371, -1782625662, -491226604, 2075208622, 213261112, -1831694693, -438977011, 2094854071, 198958881, -2032938284, -237706686, 1759359992, 534414190, -2118248755, -155638181, 1873836001, 414664567, -2012718362, -15766928, 1711684554, 285281116, -1889165569, -127750551, 1634467795, 376229701, -1609899400, -686959890, 1308918612, 956543938, -1486412191, -799009033, 1231636301, 1047427035, -1362007478, -640263460, 1088359270, 936918000, -1447252397, -558129467, 1202900863, 817233897, -1111625188, -893730166, 1404277552, 615818150, -1160759803, -841546093, 1423857449, 601450431, -1285129682, -1000256840, 1567103746, 711928724, -1274298825, -1022587231, 1510334235, 755167117};
    }
}

