/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import sk.inlogic.RMSObjects;
import sk.inlogic.saves.Data;
import sk.inlogic.saves.SavedGameData;

public class Variables {
    public static int ARCADE_MODE = 0;
    public static int TIME_MODE = 1;
    public static int totalGames;
    public static int totalBaskets;
    public static int cleanShots;
    public static int ofTheBoard;
    public static int highShots;
    public static int buzzerBeaters;
    public static int bestCombo;
    public static int bestScoreTime;
    public static int bestScoreArcade;

    public static void save(int mode, Data data) {
        SavedGameData savIt = new SavedGameData();
        savIt.totalGames = totalGames;
        savIt.totalBaskets = totalBaskets;
        savIt.cleanShots = cleanShots;
        savIt.offBoard = ofTheBoard;
        savIt.highShots = highShots;
        savIt.buzzerBeaters = buzzerBeaters;
        savIt.bestCombo = bestCombo;
        savIt.bestScoreTime = bestScoreTime;
        savIt.bestScoreArcade = bestScoreArcade;
        savIt.bestCombo = bestCombo;
        RMSObjects.createRMSConnect(mode);
        if (!RMSObjects.rmsConnects[mode].isExist()) {
            RMSObjects.rmsConnects[mode].create();
        }
        data.saveGame(savIt);
        RMSObjects.rmsConnects[mode].save();
        RMSObjects.freeRMSConnect(mode);
    }

    public static void load(int mode, Data data) {
        SavedGameData savGamData = null;
        RMSObjects.createRMSConnect(mode);
        if (!RMSObjects.rmsConnects[mode].isExist()) {
            RMSObjects.rmsConnects[mode].create();
        }
        if (RMSObjects.rmsConnects[mode].load()) {
            savGamData = data.getSavedGameData();
        }
        RMSObjects.freeRMSConnect(mode);
        if (savGamData != null) {
            totalGames = savGamData.totalGames;
            totalBaskets = savGamData.totalBaskets;
            cleanShots = savGamData.cleanShots;
            ofTheBoard = savGamData.offBoard;
            highShots = savGamData.highShots;
            buzzerBeaters = savGamData.buzzerBeaters;
            bestCombo = savGamData.bestCombo;
            bestScoreTime = savGamData.bestScoreTime;
            bestScoreArcade = savGamData.bestScoreArcade;
            if (mode == ARCADE_MODE) {
                bestCombo = savGamData.bestScoreArcade;
            } else if (mode == TIME_MODE) {
                bestCombo = savGamData.bestScoreTime;
            }
        } else {
            System.out.println("data is null");
        }
    }

    private static void printData(int mode) {
        System.out.println("");
        if (mode == ARCADE_MODE) {
            System.out.println("ARCADE MODE");
        } else if (mode == TIME_MODE) {
            System.out.println("TIME MODE");
        }
        System.out.println("totalGames: " + totalGames);
        System.out.println("totalBaskets: " + totalBaskets);
        System.out.println("cleanShots: " + cleanShots);
        System.out.println("ofTheBoard: " + ofTheBoard);
        System.out.println("highShots: " + highShots);
        System.out.println("buzzerBeaters: " + buzzerBeaters);
        System.out.println("bestCombo: " + bestCombo);
        System.out.println("bestScoreTime: " + bestScoreTime);
        System.out.println("bestScoreArcade: " + bestScoreArcade);
        System.out.println("-----------------------------------------");
        System.out.println("");
    }
}

