/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GameBuffer {
    byte[] buf;
    ByteArrayInputStream bis = null;
    Game_Canvas gc;
    static byte[] readLocalBuffer = new byte[256];

    public GameBuffer(Game_Canvas gc) {
        this.gc = gc;
    }

    public byte[][] loadByteArrayBufferDirect(int filename, byte[][] sourcePointer, boolean sameFlag, boolean nullFlag) {
        int arrayCount = 0;
        int arrayBlockSize = 0;
        int i = 0;
        int j = 0;
        try {
            this.buf = this.gc.pr.readFile(filename);
            this.bis = new ByteArrayInputStream(this.buf);
            arrayCount = this.getShort(this.bis);
            if (sameFlag) {
                arrayBlockSize = this.bis.read();
                sourcePointer = new byte[arrayCount][arrayBlockSize];
            } else {
                sourcePointer = new byte[arrayCount][];
            }
            for (i = 0; i < arrayCount; ++i) {
                if (!sameFlag) {
                    arrayBlockSize = this.bis.read();
                    sourcePointer[i] = (byte[])(arrayBlockSize == 0 && nullFlag ? null : new byte[arrayBlockSize]);
                }
                for (j = 0; j < arrayBlockSize; ++j) {
                    sourcePointer[i][j] = (byte)this.bis.read();
                }
            }
            this.bis.close();
        }
        catch (Exception e) {
            sourcePointer = null;
            try {
                this.bis.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            return null;
        }
        System.gc();
        return sourcePointer;
    }

    public char[][] loadCharArrayBufferDirect(int filename, char[][] sourcePointer, boolean sameFlag, boolean nullFlag) {
        int arrayCount = 0;
        int arrayBlockSize = 0;
        int i = 0;
        int j = 0;
        int changeByte = 0;
        try {
            this.buf = this.gc.pr.readFile(filename);
            this.bis = new ByteArrayInputStream(this.buf);
            arrayCount = this.getShort(this.bis);
            if (sameFlag) {
                arrayBlockSize = this.bis.read();
                sourcePointer = new char[arrayCount][arrayBlockSize];
            } else {
                sourcePointer = new char[arrayCount][];
            }
            for (i = 0; i < arrayCount; ++i) {
                if (!sameFlag) {
                    arrayBlockSize = this.bis.read();
                    sourcePointer[i] = (char[])(arrayBlockSize == 0 && nullFlag ? null : new char[arrayBlockSize]);
                }
                for (j = 0; j < arrayBlockSize; ++j) {
                    changeByte = this.bis.read();
                    sourcePointer[i][j] = (char)(changeByte >= 0 ? changeByte : changeByte + 256);
                }
            }
            this.bis.close();
        }
        catch (Exception e) {
            sourcePointer = null;
            try {
                this.bis.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            return null;
        }
        System.gc();
        return sourcePointer;
    }

    public int[][] loadShortArrayBufferDirect(int filename, int[][] sourcePointer, boolean sameFlag, boolean nullFlag) {
        int arrayCount = 0;
        int arrayBlockSize = 0;
        int i = 0;
        int j = 0;
        try {
            this.buf = this.gc.pr.readFile(filename);
            this.bis = new ByteArrayInputStream(this.buf);
            arrayCount = this.getShort(this.bis);
            if (sameFlag) {
                arrayBlockSize = this.bis.read();
                sourcePointer = new int[arrayCount][arrayBlockSize];
            } else {
                sourcePointer = new int[arrayCount][];
            }
            for (i = 0; i < arrayCount; ++i) {
                if (!sameFlag) {
                    arrayBlockSize = this.bis.read();
                    sourcePointer[i] = (int[])(arrayBlockSize == 0 && nullFlag ? null : new int[arrayBlockSize]);
                }
                for (j = 0; j < arrayBlockSize; ++j) {
                    sourcePointer[i][j] = this.getShort(this.bis);
                }
            }
            this.bis.close();
        }
        catch (Exception e) {
            sourcePointer = null;
            try {
                this.bis.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            return null;
        }
        System.gc();
        return sourcePointer;
    }

    public String[] loadStringArrayBuffer(int filename, String[] sourceArray, boolean nullFlag) {
        int stringCount = 0;
        int i = 0;
        try {
            this.buf = this.gc.pr.readFile(filename);
            this.bis = new ByteArrayInputStream(this.buf);
            stringCount = this.getShort(this.bis);
            sourceArray = new String[stringCount];
            for (i = 0; i < stringCount; ++i) {
                int stringLength = this.bis.read();
                if (stringLength == 0) {
                    if (nullFlag) {
                        sourceArray[i] = null;
                        continue;
                    }
                    sourceArray[i] = "";
                    continue;
                }
                this.bis.read(readLocalBuffer, 0, stringLength);
                sourceArray[i] = new String(readLocalBuffer, 0, stringLength);
            }
            this.bis.close();
        }
        catch (Exception e) {
            sourceArray = null;
            try {
                this.bis.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        System.gc();
        return sourceArray;
    }

    public byte[] loadByteSingleArrayBufferDirect(int filename, byte[] sourcePointer) {
        int arrayCount = 0;
        int i = 0;
        try {
            this.buf = this.gc.pr.readFile(filename);
            this.bis = new ByteArrayInputStream(this.buf);
            arrayCount = this.getShort(this.bis);
            sourcePointer = new byte[arrayCount];
            for (i = 0; i < arrayCount; ++i) {
                sourcePointer[i] = (byte)this.bis.read();
            }
            this.bis.close();
        }
        catch (Exception e) {
            sourcePointer = null;
            try {
                this.bis.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            return null;
        }
        System.gc();
        return sourcePointer;
    }

    public int[] loadShortSingleArrayBufferDirect(int filename, int[] sourcePointer) {
        int arrayCount = 0;
        int i = 0;
        try {
            this.buf = this.gc.pr.readFile(filename);
            this.bis = new ByteArrayInputStream(this.buf);
            arrayCount = this.getShort(this.bis);
            sourcePointer = new int[arrayCount];
            for (i = 0; i < arrayCount; ++i) {
                sourcePointer[i] = this.getShort(this.bis);
            }
            this.bis.close();
        }
        catch (Exception e) {
            sourcePointer = null;
            try {
                this.bis.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            return null;
        }
        System.gc();
        return sourcePointer;
    }

    public int[] loadIntSingleArrayBufferDirect(int filename, int[] sourcePointer) {
        int arrayCount = 0;
        int i = 0;
        try {
            this.buf = this.gc.pr.readFile(filename);
            this.bis = new ByteArrayInputStream(this.buf);
            arrayCount = this.getShort(this.bis);
            sourcePointer = new int[arrayCount];
            for (i = 0; i < arrayCount; ++i) {
                sourcePointer[i] = this.getInt(this.bis);
            }
            this.bis.close();
        }
        catch (Exception e) {
            sourcePointer = null;
            try {
                this.bis.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            return null;
        }
        System.gc();
        return sourcePointer;
    }

    public char[] loadCharSingleArrayBufferDirect(int filename, char[] sourcePointer) {
        int arrayCount = 0;
        int tempNumber = 0;
        int i = 0;
        try {
            this.buf = this.gc.pr.readFile(filename);
            this.bis = new ByteArrayInputStream(this.buf);
            arrayCount = this.getShort(this.bis);
            sourcePointer = new char[arrayCount];
            for (i = 0; i < arrayCount; ++i) {
                tempNumber = this.bis.read();
                if (tempNumber < 0) {
                    tempNumber += 256;
                }
                sourcePointer[i] = (char)tempNumber;
            }
            this.bis.close();
        }
        catch (Exception e) {
            sourcePointer = null;
            try {
                this.bis.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            return null;
        }
        System.gc();
        return sourcePointer;
    }

    int getShort(InputStream is) {
        try {
            int gsNum1 = is.read();
            int gsNum2 = is.read();
            int result = gsNum1 | gsNum2 << 8;
            if (result > Short.MAX_VALUE) {
                result -= 65536;
            }
            return result;
        }
        catch (Exception e) {
            return 1;
        }
    }

    int getInt(InputStream is) {
        int gsNum2;
        try {
            int gsNum1 = is.read();
            gsNum2 = is.read();
            gsNum1 += gsNum2 * 256;
            gsNum2 = is.read();
            gsNum1 += gsNum2 * 65536;
            gsNum2 = is.read();
        }
        catch (Exception e) {
            return 1;
        }
        return gsNum1 += gsNum2 * 0x1000000;
    }
}

