/*
 * Decompiled with CFR 0.152.
 */
package javak.microedition.lcdui;

import javak.microedition.lcdui.Font;
import javak.microedition.lcdui.Image;

public class Graphics {
    public static final boolean ARGB_SUPPORTED = true;
    private static final int FP_BITS = 13;
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int BASELINE = 64;
    public static final int SOLID = 0;
    public static final int DOTTED = 1;
    public static final int HFLIP = 2;
    public static final int VFLIP = 1;
    private int m_iAlpha = 255;
    private int m_iSizeX = 256;
    private int m_iSizeY = 256;
    private int m_iWidth = 0;
    private int m_iHeight = 0;
    private Font m_vFont = Font.getDefaultFont();
    private int[] m_iClip = new int[4];
    private int[] m_iOldClip = new int[4];
    public javax.microedition.lcdui.Graphics m_Graphics;
    public boolean m_bGetGraphics;

    public Graphics() {
        this.m_iWidth = 0;
        this.m_iHeight = 0;
    }

    public Graphics(int _iW, int _iH) {
        this.m_iWidth = _iW;
        this.m_iHeight = _iH;
        this.m_iClip[2] = this.m_iOldClip[2] = _iW;
        this.m_iClip[3] = this.m_iOldClip[3] = _iH;
    }

    public void setGraphics(javax.microedition.lcdui.Graphics _g) {
        if (!this.m_bGetGraphics) {
            this.m_Graphics = _g;
            this.m_iWidth = _g.getClipWidth();
            this.m_iHeight = _g.getClipHeight();
            this.m_bGetGraphics = true;
        }
    }

    public void translate(int _iX, int _iY) {
        this.m_Graphics.translate(_iX, _iY);
    }

    public int getTranslateX() {
        return this.m_Graphics.getTranslateX();
    }

    public int getTranslateY() {
        return this.m_Graphics.getTranslateY();
    }

    public void setStrokeStyle(int _iStyle) {
        this.m_Graphics.setStrokeStyle(_iStyle);
    }

    public int getStrokeStyle() {
        return this.m_Graphics.getStrokeStyle();
    }

    public void setClip(int _iX, int _iY, int _iW, int _iH) {
        this.m_Graphics.setClip(_iX, _iY, _iW, _iH);
    }

    public void clipRect(int _iX, int _iY, int _iW, int _iH) {
        this.m_Graphics.clipRect(_iX, _iY, _iW, _iH);
    }

    public void saveClip() {
        this.m_iOldClip[0] = this.m_Graphics.getClipX();
        this.m_iOldClip[1] = this.m_Graphics.getClipY();
        this.m_iOldClip[2] = this.m_Graphics.getClipWidth();
        this.m_iOldClip[3] = this.m_Graphics.getClipHeight();
    }

    public void restoreClip() {
        this.m_Graphics.setClip(this.m_iOldClip[0], this.m_iOldClip[1], this.m_iOldClip[2], this.m_iOldClip[3]);
    }

    public int getClipX() {
        return this.m_Graphics.getClipX();
    }

    public int getClipY() {
        return this.m_Graphics.getClipY();
    }

    public int getClipWidth() {
        return this.m_Graphics.getClipWidth();
    }

    public int getClipHeight() {
        return this.m_Graphics.getClipHeight();
    }

    public void setAlpha(int _iA) {
        this.m_iAlpha = Math.min(_iA, 255);
    }

    public int getAlpha() {
        return this.m_iAlpha;
    }

    public void setGrayScale(int _iValue) {
        this.m_Graphics.setGrayScale(_iValue);
    }

    public int getGrayScale() {
        return this.m_Graphics.getGrayScale();
    }

    public void setColor(int _iR, int _iG, int _iB) {
        this.m_Graphics.setColor(_iR << 16 | _iG << 8 | _iB);
    }

    public void setColor(int _iA, int _iR, int _iG, int _iB) {
        this.m_iAlpha = _iA;
        this.m_Graphics.setColor(_iR << 16 | _iG << 8 | _iB);
    }

    public void setColor(int _iARGB) {
        int iA = _iARGB >> 24 & 0xFF;
        if (iA > 0) {
            this.m_iAlpha = iA;
        }
        this.m_Graphics.setColor(_iARGB);
    }

    public void setColor(int _iAlpha, int _iColor) {
        this.m_iAlpha = _iAlpha;
        this.m_Graphics.setColor(_iColor);
    }

    public int getRedComponent() {
        return this.m_Graphics.getRedComponent();
    }

    public int getGreenComponent() {
        return this.m_Graphics.getGreenComponent();
    }

    public int getBlueComponent() {
        return this.m_Graphics.getBlueComponent();
    }

    public int getColor() {
        return this.m_Graphics.getColor();
    }

    public int getBlendedColor(int _iColor1, int _iColor2, int _iQuantity) {
        int iFinalColor = 0;
        int iA1 = _iColor1 >> 24 & 0xFF;
        int iA2 = _iColor2 >> 24 & 0xFF;
        int iR1 = _iColor1 >> 16 & 0xFF;
        int iR2 = _iColor2 >> 16 & 0xFF;
        int iG1 = _iColor1 >> 8 & 0xFF;
        int iG2 = _iColor2 >> 8 & 0xFF;
        int iB1 = _iColor1 & 0xFF;
        int iB2 = _iColor2 & 0xFF;
        if (iA1 > 0 && iA2 > 0) {
            iFinalColor |= iA1 + ((iA2 - iA1) * _iQuantity >> 8) << 24;
        }
        iFinalColor |= iR1 + ((iR2 - iR1) * _iQuantity >> 8) << 16;
        iFinalColor |= iG1 + ((iG2 - iG1) * _iQuantity >> 8) << 8;
        return iFinalColor |= iB1 + ((iB2 - iB1) * _iQuantity >> 8);
    }

    public void setBlendedColor(int _iColor1, int _iColor2, int _iQuantity) {
        this.setColor(this.getBlendedColor(_iColor1, _iColor2, _iQuantity));
    }

    public void setImageSize(int _iScaleX, int _iScaleY) {
        if (_iScaleX < 0) {
            _iScaleX = 0;
        }
        if (_iScaleY < 0) {
            _iScaleY = 0;
        }
        this.m_iSizeX = _iScaleX;
        this.m_iSizeY = _iScaleY;
    }

    public int getImageSizeX() {
        return this.m_iSizeX;
    }

    public int getImageSizeY() {
        return this.m_iSizeY;
    }

    public void drawLine(int _iX0, int _iY0, int _iX1, int _iY1) {
        this.m_Graphics.drawLine(_iX0, _iY0, _iX1, _iY1);
    }

    public void drawRect(int _iX, int _iY, int _iW, int _iH) {
        this.m_Graphics.drawRect(_iX, _iY, _iW, _iH);
    }

    public void fillRect(int _iX, int _iY, int _iW, int _iH) {
        this.m_Graphics.fillRect(_iX, _iY, _iW, _iH);
    }

    public void drawRoundRect(int _iX, int _iY, int _iW, int _iH) {
        this.m_Graphics.drawRoundRect(_iX, _iY, _iW, _iH, _iW, _iH);
    }

    public void fillRoundRect(int _iX, int _iY, int _iW, int _iH) {
        this.m_Graphics.fillRoundRect(_iX, _iY, _iW, _iH, _iW, _iH);
    }

    public void drawRoundRect(int _iX, int _iY, int _iW, int _iH, int _iArcW, int _iArcH) {
        this.m_Graphics.drawRoundRect(_iX, _iY, _iW, _iH, _iArcW, _iArcH);
    }

    public void fillRoundRect(int _iX, int _iY, int _iW, int _iH, int _iArcW, int _iArcH) {
        this.m_Graphics.fillRoundRect(_iX, _iY, _iW, _iH, _iArcW, _iArcH);
    }

    public void drawArc(int _iX, int _iY, int _iW, int _iH, int _iStartAngle, int _iArcAngle) {
        this.m_Graphics.drawArc(_iX, _iY, _iW, _iH, _iStartAngle, _iArcAngle);
    }

    public void fillArc(int _iX, int _iY, int _iW, int _iH, int _iStartAngle, int _iArcAngle) {
        this.m_Graphics.fillArc(_iX, _iY, _iW, _iH, _iStartAngle, _iArcAngle);
    }

    public void drawTriangle(int _x0, int _y0, int _x1, int _y1, int _x2, int _y2) {
        this.m_Graphics.drawLine(_x0, _y0, _x1, _y1);
        this.m_Graphics.drawLine(_x1, _y1, _x2, _y2);
        this.m_Graphics.drawLine(_x2, _y2, _x0, _y0);
    }

    public void fillTriangle(int _x0, int _y0, int _x1, int _y1, int _x2, int _y2) {
        this.m_Graphics.fillTriangle(_x0, _y0, _x1, _y1, _x2, _y2);
    }

    private void fillMIDP1Triangle(int _x0, int _y0, int _x1, int _y1, int _x2, int _y2) {
        int bc_den;
        int bc_num;
        int ac_den;
        int ac_num;
        int ab_den;
        int ab_num;
        int temp;
        if (_y0 > _y1) {
            temp = _x0;
            _x0 = _x1;
            _x1 = temp;
            temp = _y0;
            _y0 = _y1;
            _y1 = temp;
        }
        if (_y1 > _y2) {
            temp = _x1;
            _x1 = _x2;
            _x2 = temp;
            temp = _y1;
            _y1 = _y2;
            _y2 = temp;
        }
        if (_y0 > _y1) {
            temp = _x0;
            _x0 = _x1;
            _x1 = temp;
            temp = _y0;
            _y0 = _y1;
            _y1 = temp;
        }
        if (_y1 - _y0 > 0) {
            ab_num = _x1 - _x0;
            ab_den = _y1 - _y0;
        } else {
            ab_num = _x1 - _x0;
            ab_den = 1;
        }
        if (_y2 - _y0 > 0) {
            ac_num = _x2 - _x0;
            ac_den = _y2 - _y0;
        } else {
            ac_num = 0;
            ac_den = 1;
        }
        if (_y2 - _y1 > 0) {
            bc_num = _x2 - _x1;
            bc_den = _y2 - _y1;
        } else {
            bc_num = 0;
            bc_den = 1;
        }
        int h1 = _y1 - _y0;
        int h2 = _y2 - _y1;
        if (_x0 < _x1) {
            int sx;
            int ex;
            int y;
            for (y = 0; y < h1; ++y) {
                ex = _x0 + ab_num * y / ab_den;
                sx = _x0 + ac_num * y / ac_den;
                if (ex - sx <= 0) continue;
                this.m_Graphics.fillRect(sx, _y0 + y, ex - sx, 1);
            }
            for (y = 0; y < h2; ++y) {
                ex = _x1 + bc_num * y / bc_den;
                int y2 = h1 + y;
                sx = _x0 + ac_num * y2 / ac_den;
                if (ex - sx <= 0) continue;
                this.m_Graphics.fillRect(sx, _y1 + y, ex - sx, 1);
            }
        } else {
            int sx;
            int ex;
            int y;
            for (y = 0; y < h1; ++y) {
                ex = _x0 + ac_num * y / ac_den;
                sx = _x0 + ab_num * y / ab_den;
                if (ex - sx <= 0) continue;
                this.m_Graphics.fillRect(sx, _y0 + y, ex - sx, 1);
            }
            for (y = 0; y < h2; ++y) {
                int y2 = h1 + y;
                ex = _x0 + ac_num * y2 / ac_den;
                sx = _x1 + bc_num * y / bc_den;
                if (ex - sx <= 0) continue;
                this.m_Graphics.fillRect(sx, _y1 + y, ex - sx, 1);
            }
        }
    }

    public void setFont(Font _Font) {
        this.m_vFont = _Font;
        this.m_Graphics.setFont(_Font.m_vFont);
    }

    public Font getFont() {
        return this.m_vFont;
    }

    public void drawString(String _zText, int _iPosX, int _iPosY) {
        this.m_Graphics.drawString(_zText, _iPosX, _iPosY, 0);
    }

    public void drawString(String _zText, int _iPosX, int _iPosY, int _iAnchor) {
        if ((_iAnchor & 0x20) != 0) {
            _iPosY -= this.m_vFont.getHeight();
        }
        if ((_iAnchor & 0x40) != 0) {
            _iPosY -= this.m_vFont.getBaselinePosition();
        }
        if ((_iAnchor & 8) != 0) {
            _iPosY -= this.m_vFont.stringWidth(_zText);
        }
        if ((_iAnchor & 2) != 0) {
            _iPosY -= this.m_vFont.getBaselinePosition() >> 1;
        }
        if ((_iAnchor & 1) != 0) {
            _iPosY -= this.m_vFont.stringWidth(_zText) >> 1;
        }
        this.m_Graphics.drawString(_zText, _iPosX, _iPosY, 0);
    }

    public void drawSubstring(String _zStr, int _iOffset, int _iLen, int _iX, int _iY, int _iAnchor) {
        this.drawString(_zStr.substring(_iOffset, _iLen), _iX, _iY, _iAnchor);
    }

    public void drawChar(char _iChar, int _iX, int _iY, int _iAnchor) {
        this.drawString(String.valueOf(_iChar), _iX, _iY, _iAnchor);
    }

    public void drawChars(char[] _Data, int _iOffset, int _iLength, int _iX, int _iY, int _iAnchor) {
        this.drawString(String.valueOf(_Data), _iX, _iY, _iAnchor);
    }

    public void drawRGB(int[] _iRgbData, int _iOffset, int _iScanlength, int _iX, int _iY, int _iW, int _iH, boolean _bAlpha) {
        this.m_Graphics.drawRGB(_iRgbData, _iOffset, _iScanlength, _iX, _iY, _iW, _iH, _bAlpha);
    }

    public void drawImage(Image _vImage, int _iX, int _iY, int _iAnchor) {
        if (this.m_iAlpha < 1) {
            return;
        }
        if ((_iAnchor & 0x20) != 0) {
            _iY -= _vImage.getHeight();
        }
        if ((_iAnchor & 8) != 0) {
            _iX -= _vImage.getWidth();
        }
        if ((_iAnchor & 2) != 0) {
            _iY -= _vImage.getHeight() >> 1;
        }
        if ((_iAnchor & 1) != 0) {
            _iX -= _vImage.getWidth() >> 1;
        }
        if (this.m_iSizeX == 256 && this.m_iSizeY == 256 && this.m_iAlpha == 255) {
            this.m_Graphics.drawImage(_vImage.m_vImage, _iX, _iY, 0);
        } else {
            int iPosXImg = _iX;
            int iPosYImg = _iY;
            int iDrawRGB_OffsetX = 0;
            int iDrawRGB_OffsetY = 0;
            int srcW = _vImage.getWidth();
            int srcH = _vImage.getHeight();
            int destW = srcW * this.m_iSizeX >> 8;
            int destH = srcH * this.m_iSizeY >> 8;
            if (destW == 0 || destH == 0) {
                return;
            }
            if ((_iAnchor & 0x20) != 0) {
                iPosYImg += srcH - destH;
            }
            if ((_iAnchor & 8) != 0) {
                iPosXImg += srcW - destW;
            }
            if ((_iAnchor & 2) != 0) {
                iPosYImg += srcH - destH >> 1;
            }
            if ((_iAnchor & 1) != 0) {
                iPosXImg += srcW - destW >> 1;
            }
            try {
                int[] srcPixels = new int[srcW];
                int[] destPixels = new int[destW];
                int ratioW = (srcW << 13) / destW;
                int ratioH = (srcH << 13) / destH;
                if (iPosXImg < this.m_Graphics.getClipX()) {
                    iDrawRGB_OffsetX = this.m_Graphics.getClipX() - iPosXImg;
                }
                if (iPosXImg + destW > this.m_Graphics.getClipX() + this.m_Graphics.getClipWidth()) {
                    destW -= iPosXImg + destW - (this.m_Graphics.getClipX() + this.m_Graphics.getClipWidth());
                }
                if (iPosYImg < this.m_Graphics.getClipY()) {
                    iDrawRGB_OffsetY = this.m_Graphics.getClipY() - iPosYImg;
                }
                if (iPosYImg + destW > this.m_Graphics.getClipY() + this.m_Graphics.getClipHeight()) {
                    destH -= iPosYImg + destH - (this.m_Graphics.getClipY() + this.m_Graphics.getClipHeight());
                }
                int iTransparentColor = _vImage.getTransparentColor();
                for (int destY = iDrawRGB_OffsetY; destY < destH; ++destY) {
                    int srcY = destY * ratioH >> 13;
                    _vImage.getRGB(srcPixels, 0, srcW, 0, srcY, srcW, 1);
                    for (int destX = iDrawRGB_OffsetX; destX < destW; ++destX) {
                        int srcX = destX * ratioW >> 13;
                        destPixels[destX] = srcPixels[srcX];
                    }
                    this.m_Graphics.drawRGB(destPixels, 0, destW, iPosXImg, iPosYImg + destY, destW, 1, true);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void drawRegion(Image _vSrc, int _iSrcX, int _iSrcY, int _iWidth, int _iHeight, int _iTransform, int _iDestX, int _iDestY, int _iAnchor) {
        if (this.m_iAlpha < 1) {
            return;
        }
        if (this.m_iSizeX == 256 && this.m_iSizeY == 256 && this.m_iAlpha == 255) {
            this.m_Graphics.drawRegion(_vSrc.m_vImage, _iSrcX, _iSrcY, _iWidth, _iHeight, _iTransform, _iDestX, _iDestY, _iAnchor);
        } else {
            int destW = _iWidth * this.m_iSizeX >> 8;
            int destH = _iHeight * this.m_iSizeY >> 8;
            if (destW == 0 || destH == 0) {
                return;
            }
            if ((_iAnchor & 0x20) != 0) {
                _iDestY -= _iHeight * this.m_iSizeY >> 8;
            }
            if ((_iAnchor & 8) != 0) {
                _iDestX -= _iWidth * this.m_iSizeX >> 8;
            }
            if ((_iAnchor & 2) != 0) {
                _iDestY -= _iHeight * this.m_iSizeY >> 9;
            }
            if ((_iAnchor & 1) != 0) {
                _iDestX -= _iWidth * this.m_iSizeX >> 9;
            }
            int iDrawRGB_OffsetX = 0;
            int iDrawRGB_OffsetY = 0;
            try {
                int[] srcPixels = new int[_iWidth];
                int[] destPixels = new int[destW];
                int ratioW = (_iWidth << 13) / destW;
                int ratioH = (_iHeight << 13) / destH;
                if (_iDestX < this.m_Graphics.getClipX()) {
                    iDrawRGB_OffsetX = this.m_Graphics.getClipX() - _iDestX;
                }
                if (_iDestX + destW > this.m_Graphics.getClipX() + this.m_Graphics.getClipWidth()) {
                    destW -= _iDestX + destW - (this.m_Graphics.getClipX() + this.m_Graphics.getClipWidth());
                }
                if (_iDestY < this.m_Graphics.getClipY()) {
                    iDrawRGB_OffsetY = this.m_Graphics.getClipY() - _iDestY;
                }
                if (_iDestY + destW > this.m_Graphics.getClipY() + this.m_Graphics.getClipHeight()) {
                    destH -= _iDestY + destH - (this.m_Graphics.getClipY() + this.m_Graphics.getClipHeight());
                }
                int iTransparentColor = _vSrc.getTransparentColor();
                for (int destY = iDrawRGB_OffsetY; destY < destH; ++destY) {
                    int srcX;
                    int destX;
                    int srcY = destY * ratioH >> 13;
                    _vSrc.getRGB(srcPixels, 0, _iWidth, _iSrcX, srcY + _iSrcY, _iWidth, 1);
                    if ((_iTransform & 2) != 0) {
                        for (destX = iDrawRGB_OffsetX; destX < destW; ++destX) {
                            srcX = destX * ratioW >> 13;
                            destPixels[destPixels.length - 1 - destX] = srcPixels[srcX];
                        }
                    } else {
                        for (destX = iDrawRGB_OffsetX; destX < destW; ++destX) {
                            srcX = destX * ratioW >> 13;
                            destPixels[destX] = srcPixels[srcX];
                        }
                    }
                    this.m_Graphics.drawRGB(destPixels, 0, destW, _iDestX, _iDestY + destY, destW, 1, true);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

