/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.weeld;

import com.kitmaker.MGCC.GfxManager;
import com.kitmaker.MGCC.Main;
import com.kitmaker.weeld.MSpriteData;
import com.kitmaker.weeld.MSpriteLoader;
import javak.microedition.lcdui.Graphics;

public class WeeldSprite {
    protected static MSpriteData[][] poolData;
    private int poolDataID;
    private int animation;
    private int frame;
    private int frameCount;
    private boolean firstLoopFinished = false;
    private long delayCount;
    private int framePoolPointer;
    private int spriteX;
    private int spriteY;
    private byte spriteOrientation;
    private boolean isPlaying;
    private int[] rect = new int[4];
    private final byte POSITIONERRECTANGLE_FLAG = (byte)15;

    public WeeldSprite(int poolID, int[] img_index, String[] anu_path, int spriteX, int spriteY, int poolMaxNumber) {
        if (poolData == null) {
            poolData = new MSpriteData[poolMaxNumber][1];
        } else if (poolID >= poolData.length) {
            System.out.println("id de pool mayor al permitido.. se expande el pool de datos.. evitarlo por favor");
            MSpriteData[][] auxData = new MSpriteData[poolID + 1][1];
            for (int i = 0; i < poolData.length; ++i) {
                for (int j = 0; j < poolData[i].length; ++j) {
                    auxData[i][j] = poolData[i][j];
                }
            }
            poolData = auxData;
        }
        try {
            this.poolDataID = poolID;
            for (int i = 0; i < anu_path.length; ++i) {
                if (poolData[this.poolDataID][i] != null) continue;
                WeeldSprite.poolData[this.poolDataID][i] = MSpriteLoader.loadMSprite(img_index, anu_path[i]);
            }
        }
        catch (Exception e) {
            System.out.println("error al tratar de crear data de sprites");
            e.printStackTrace();
        }
        this.spriteX = spriteX;
        this.spriteY = spriteY;
    }

    public void setAnimation(int id) {
        this.animation = id;
        int pos = this.animation << 1;
        this.frameCount = WeeldSprite.poolData[this.poolDataID][0].animationTable[pos + 1] - WeeldSprite.poolData[this.poolDataID][0].animationTable[pos] + 1;
        this.setFrame(0);
        this.notifyStartOfAnimation();
    }

    public int getAnimation() {
        return this.animation;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getCurrentFrame() {
        return this.frame;
    }

    public int getNumberOfFramesOfCurrentAnim() {
        short startIndex = WeeldSprite.poolData[this.poolDataID][0].frameTableIndex[this.framePoolPointer << 1];
        short endIndex = WeeldSprite.poolData[this.poolDataID][0].frameTableIndex[(this.framePoolPointer << 1) + 1];
        return endIndex - startIndex;
    }

    public void setFrame(int frame) {
        this.frame = frame;
        this.delayCount = Main.ms_lLastFrameTime;
        int frameIndex = WeeldSprite.poolData[this.poolDataID][0].animationTable[this.animation << 1] + frame;
        this.framePoolPointer = WeeldSprite.poolData[this.poolDataID][0].frameTable[frameIndex << 2];
    }

    public int getAnimationCount() {
        return WeeldSprite.poolData[this.poolDataID][0].animationTable.length >>> 1;
    }

    public void update(int zoom) {
        int frameIndex = WeeldSprite.poolData[this.poolDataID][zoom].animationTable[this.animation << 1] + this.frame;
        if ((Main.ms_lLastFrameTime - this.delayCount) / 100L < (long)WeeldSprite.poolData[this.poolDataID][zoom].frameTable[(frameIndex << 2) + 1]) {
            return;
        }
        this.delayCount = Main.ms_lLastFrameTime;
        if (this.frame >= this.frameCount - 2) {
            this.firstLoopFinished = true;
        }
        if (this.frame >= this.frameCount - 1) {
            this.setFrame(0);
        } else {
            this.setFrame(this.frame + 1);
        }
    }

    public void drawFrame(Graphics g, int _iZoom) {
        if (GfxManager.ms_Grafico[WeeldSprite.poolData[this.poolDataID][_iZoom].ms_ImageIndex[_iZoom]] == null) {
            System.out.println("No hay imagenes cargadas para esta sprite " + WeeldSprite.poolData[this.poolDataID][_iZoom].ms_ImageIndex[_iZoom]);
            return;
        }
        int startIndex = WeeldSprite.poolData[this.poolDataID][_iZoom].frameTableIndex[this.framePoolPointer << 1];
        short endIndex = WeeldSprite.poolData[this.poolDataID][_iZoom].frameTableIndex[(this.framePoolPointer << 1) + 1];
        while (startIndex < endIndex) {
            byte flag;
            int clipIndex = WeeldSprite.poolData[this.poolDataID][_iZoom].framePoolTable[startIndex++] << 2;
            short x = WeeldSprite.poolData[this.poolDataID][_iZoom].framePoolTable[startIndex++];
            short y = WeeldSprite.poolData[this.poolDataID][_iZoom].framePoolTable[startIndex++];
            if (((flag = (byte)WeeldSprite.poolData[this.poolDataID][_iZoom].framePoolTable[startIndex++]) & 1) != 0) continue;
            this.drawImageClip(g, x, y, clipIndex, flag, _iZoom);
        }
    }

    protected void drawImageClip(Graphics g, int x, int y, int clipIndex, byte flip, int _iZoom) {
        int index = clipIndex;
        short clipX = WeeldSprite.poolData[this.poolDataID][_iZoom].imageClipPool[index++];
        short clipY = WeeldSprite.poolData[this.poolDataID][_iZoom].imageClipPool[index++];
        short clipW = WeeldSprite.poolData[this.poolDataID][_iZoom].imageClipPool[index++];
        short clipH = WeeldSprite.poolData[this.poolDataID][_iZoom].imageClipPool[index++];
        if (flip == 4) {
            flip = (byte)3;
        }
        g.drawRegion(GfxManager.ms_Grafico[WeeldSprite.poolData[this.poolDataID][_iZoom].ms_ImageIndex[_iZoom]], clipX, clipY, clipW, clipH, flip, x + this.spriteX, y + this.spriteY, 0);
    }

    public int getSpriteDrawX() {
        return this.spriteX;
    }

    public int getSpriteDrawY() {
        return this.spriteY;
    }

    public void setDrawX(int dX) {
        this.spriteX = dX;
    }

    public void setDrawY(int dY) {
        this.spriteY = dY;
    }

    public void updateSpritePositionBy(int xinc, int yinc) {
        this.spriteX += xinc;
        this.spriteY += yinc;
    }

    public byte getSpriteOrientation() {
        return this.spriteOrientation;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void setSpriteOrientation(byte orientation) {
        this.spriteOrientation = orientation;
    }

    public void notifyStartOfAnimation() {
        this.firstLoopFinished = false;
        this.isPlaying = true;
    }

    public void notifyEndOfAnimation() {
        this.firstLoopFinished = true;
        this.isPlaying = false;
    }

    public boolean loopFinished() {
        return this.firstLoopFinished;
    }

    public static void unloadSpriteData() {
        poolData = null;
    }
}

