/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.MGCC;

import com.kitmaker.MGCC.MGCC;
import com.kitmaker.MGCC.Main;
import com.kitmaker.MGCC.MiscUtils;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class SndManager {
    public static final boolean SOUND_SUPPORTED = true;
    private static final boolean FX_SUPPORTED = false;
    static final byte MUSIC_NOMUSIC = -1;
    static final byte MUSIC_MAINMENU = 0;
    static final byte MUSIC_WORLDMAP = 1;
    static final byte MUSIC_YOUWIN = 2;
    static final byte MUSIC_RINGTONE = 3;
    static final byte MUSIC_T_PRACTICE = 4;
    static final byte MUSIC_T_AREA51 = 5;
    static final byte MUSIC_T_ZOMBIE = 6;
    static final byte MUSIC_T_JURASSIC = 7;
    static final byte MUSIC_T_ISLANDS = 8;
    static final String[] MUSIC_FILES = new String[]{"/m_menu.mid", "/m_world.mid", "/m_youwin.mid", "/m_ringtone.mid", "/mg_training.mid", "/mg_area51.mid", "/mg_zombie.mid", "/mg_jurassic.mid", "/mg_islands.mid"};
    static final byte FX_NOFX = -1;
    static final byte FX_MENU_OK = 0;
    static final byte FX_MENU_MOVE = 1;
    static final byte FX_MENU_BACK = 2;
    static final byte FX_BALL_HIT = 3;
    static final byte FX_BALL_BOUND = 4;
    static final byte FX_BALL_HOLE = 5;
    static final byte FX_A_COCK = 6;
    static final byte FX_A_COW = 7;
    static final byte FX_A_CROW = 8;
    static final byte FX_A_PIG = 9;
    static final String[] SNDFX_FILES = new String[]{"/m_open.wav", "/m_select.wav", "/m_back.wav", "/b_hit.wav", "/b_bound.wav", "/b_hole.wav", "/a_cock.wav", "/a_cow.wav", "/a_crow.wav", "/a_pig.wav"};
    static final int[] SOUND_VOLUME = new int[]{0, 90};
    public static boolean ms_bSound = false;
    static int ms_iSoundVolumeIndex = SOUND_VOLUME.length - 1;
    static boolean ms_bUpdatingSound = false;
    static boolean ms_bNewClip;
    static final int NUM_MUSIC;
    static final int NUM_SNDFX;
    static byte ms_iCurrentFXClip;
    static long ms_lCurrentClipStartTime;
    private static Player ms_vMusicPlayer;
    public static Player[] ms_vSndFxPlayer;
    static final int NUM_MUSIC_CLIPS;
    static byte ms_iCurrentMusicClip;
    static byte ms_iNewMusicClip;
    static boolean ms_bCurrentMusicLooping;
    static boolean ms_bNewMusicLooping;
    static final int NUM_FX_CLIPS;
    static final String MEDIAID_MID = "audio/midi";
    static final String MEDIAID_WAV = "audio/x-wav";
    static final String MEDIAID_AMR = "audio/amr";
    static final String MEDIAID_MP3 = "audio/mpeg";
    static String ms_zMediaId;
    static boolean ms_bPausedClip;
    static byte ms_iPausedCurrentClip;
    static boolean ms_bPausedCurrentLooping;
    public static final int TONE_MOVE = 0;
    public static final int TONE_SELECT = 1;
    public static final int TONE_BACK = 2;

    static void DeleteFX() {
        SndManager.StopFX();
        for (byte i = 0; i < ms_vSndFxPlayer.length; i = (byte)(i + 1)) {
            SndManager.DeleteFX(i);
        }
    }

    static void DeleteFX(byte _iIndex) {
        if (ms_vSndFxPlayer != null) {
            try {
                ms_vSndFxPlayer[_iIndex].close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            SndManager.ms_vSndFxPlayer[_iIndex] = null;
        }
    }

    static void LoadFX(byte index) {
        SndManager.ms_vSndFxPlayer[index] = null;
    }

    static void UpdateMusic() {
        if (Main.ms_bPaused) {
            return;
        }
        ms_bUpdatingSound = true;
        if (System.currentTimeMillis() >= ms_lCurrentClipStartTime) {
            if (ms_bSound && (ms_bNewClip || ms_bCurrentMusicLooping) && (ms_iCurrentMusicClip == -1 || ms_vMusicPlayer == null || ms_vMusicPlayer.getState() != 400)) {
                if (ms_bNewClip) {
                    if (ms_iCurrentMusicClip != -1) {
                        try {
                            ms_vMusicPlayer.close();
                        }
                        catch (Exception e) {
                            MiscUtils.DebugMsg("*ERR UpdtSnd-close of sound(" + ms_iCurrentMusicClip + ") failed: Exc " + e.toString() + " -- " + e.getMessage() + " - Frame " + Main.ms_iFrame);
                        }
                        ms_vMusicPlayer = null;
                    }
                    ms_iCurrentMusicClip = ms_iNewMusicClip;
                    ms_bCurrentMusicLooping = ms_bNewMusicLooping;
                } else {
                    try {
                        if (ms_vMusicPlayer.getState() != 400) {
                            ms_vMusicPlayer.deallocate();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (ms_vMusicPlayer == null) {
                    try {
                        ms_vMusicPlayer = Manager.createPlayer((InputStream)((Object)((Object)MGCC.ms_vInstance)).getClass().getResourceAsStream(MUSIC_FILES[ms_iCurrentMusicClip]), (String)MEDIAID_MID);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (ms_vMusicPlayer != null && ms_vMusicPlayer.getState() != 200) {
                    try {
                        ms_vMusicPlayer.realize();
                    }
                    catch (Exception e) {
                        ms_vMusicPlayer = null;
                    }
                }
                try {
                    ms_vMusicPlayer.start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ms_bNewClip = false;
        }
        ms_bUpdatingSound = false;
    }

    static void PlayMusic(byte _iSoundID, boolean _bLooping, int _iDelay) {
        if (ms_bSound) {
            ms_zMediaId = MEDIAID_MID;
            ms_bNewMusicLooping = _bLooping;
            ms_lCurrentClipStartTime = System.currentTimeMillis() + (long)_iDelay;
            ms_iCurrentMusicClip = _iSoundID;
            ms_iNewMusicClip = _iSoundID;
            ms_bNewClip = true;
        }
    }

    static void PlayFX(byte _iFXID, int _bLoopCount) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void StopMusic() {
        if (ms_iCurrentMusicClip != -1) {
            ms_bNewClip = false;
            if (ms_vMusicPlayer != null && ms_vMusicPlayer.getState() != 200) {
                try {
                    ms_vMusicPlayer.close();
                }
                finally {
                    ms_vMusicPlayer = null;
                }
            }
            ms_bNewMusicLooping = false;
            ms_bCurrentMusicLooping = false;
            ms_lCurrentClipStartTime = Long.MAX_VALUE;
        }
    }

    public static void StopFX() {
    }

    static void PauseMusic() {
        if (ms_iCurrentMusicClip != -1) {
            ms_bNewClip = false;
            if (ms_vMusicPlayer != null && ms_vMusicPlayer.getState() != 200) {
                ms_bPausedClip = true;
                ms_iPausedCurrentClip = ms_iCurrentMusicClip;
                ms_bPausedCurrentLooping = ms_bCurrentMusicLooping;
                try {
                    ms_vMusicPlayer.stop();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
            }
            ms_bNewMusicLooping = false;
            ms_bCurrentMusicLooping = false;
            ms_lCurrentClipStartTime = Long.MAX_VALUE;
        }
    }

    static void UnpauseMusic() {
        if (ms_bSound && ms_bPausedClip) {
            ms_bNewMusicLooping = ms_bPausedCurrentLooping;
            ms_lCurrentClipStartTime = System.currentTimeMillis() + 100L;
            ms_iNewMusicClip = ms_iPausedCurrentClip;
            ms_bNewClip = true;
            ms_bPausedClip = false;
        }
    }

    public static void PlayTone(int _iType) {
        try {
            if (ms_bSound) {
                if (_iType == 0) {
                    Manager.playTone((int)68, (int)50, (int)SOUND_VOLUME[ms_iSoundVolumeIndex]);
                } else if (_iType == 1) {
                    Manager.playTone((int)60, (int)50, (int)SOUND_VOLUME[ms_iSoundVolumeIndex]);
                    Manager.playTone((int)68, (int)200, (int)SOUND_VOLUME[ms_iSoundVolumeIndex]);
                } else if (_iType == 2) {
                    Manager.playTone((int)60, (int)50, (int)SOUND_VOLUME[ms_iSoundVolumeIndex]);
                    Manager.playTone((int)52, (int)200, (int)SOUND_VOLUME[ms_iSoundVolumeIndex]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void FlushSndManager() {
        ms_bSound = false;
        SndManager.StopMusic();
        SndManager.DeleteFX();
    }

    static {
        NUM_MUSIC = MUSIC_FILES.length;
        NUM_SNDFX = SNDFX_FILES.length;
        ms_iCurrentFXClip = (byte)-1;
        ms_lCurrentClipStartTime = Long.MAX_VALUE;
        ms_vSndFxPlayer = new Player[NUM_SNDFX];
        NUM_MUSIC_CLIPS = MUSIC_FILES.length;
        ms_iCurrentMusicClip = (byte)-1;
        ms_iNewMusicClip = (byte)-1;
        NUM_FX_CLIPS = SNDFX_FILES.length;
    }
}

