/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.MGCC;

import com.kitmaker.MGCC.ArabicReshaper;
import com.kitmaker.MGCC.FntManager;
import com.kitmaker.MGCC.MGCC;
import com.kitmaker.MGCC.Main;
import com.kitmaker.MGCC.ModeMenu;
import com.kitmaker.MGCC.ModeWorld;
import java.io.DataInputStream;
import javak.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class MiscUtils {
    public static final int MODE_SAVE = 0;
    public static final int MODE_LOAD = 1;
    public static final String FILE_PLY = "MGCCPLY";
    public static final String FILE_SYS = "MGCCSYS";
    public static final String FILE_ACH = "MGCCACH";
    private static int ms_iRmsOffset;
    private static int ms_iRmsMode;
    private static byte[] ms_iRmsData;
    private static byte[] ms_iSaveData;
    private static String ms_zRmsId;
    private static RecordStore ms_RecordStore;
    public static boolean ms_bSavedData;
    private static final String ARABIC_TEST1 = "\u0627\u0644\u0645\u0633\u062d";
    private static final String ARABIC_TEST2 = "\u0627\u0644\u0645\u0633";
    private static final String JAPANS_TEST1 = "\u52c9";
    private static final String JAPANS_TEST2 = "\u5f37";
    public static final boolean ARABIC_PROPER_SUPPORT;
    public static final boolean ARABIC_SUPPORT;
    public static final boolean BENGAL_SUPPORT;
    public static final boolean JAPANS_SUPPORT;
    static boolean ms_bShowDebug;
    static boolean ms_bAllowLogging;

    static long longFromBytes(byte[] data, int offset) {
        long iRet = ((char)data[offset] & 0xFF) << 56;
        iRet += (long)(((char)data[offset + 1] & 0xFF) << 48);
        iRet += (long)(((char)data[offset + 2] & 0xFF) << 40);
        iRet += (long)(((char)data[offset + 3] & 0xFF) << 32);
        iRet += (long)(((char)data[offset + 4] & 0xFF) << 24);
        iRet += (long)(((char)data[offset + 5] & 0xFF) << 16);
        iRet += (long)(((char)data[offset + 6] & 0xFF) << 8);
        return iRet += (long)((char)data[offset + 7] & 0xFF);
    }

    private static int intFromBytes(byte[] data, int offset) {
        int iRet = ((char)data[offset] & 0xFF) << 24;
        iRet += ((char)data[offset + 1] & 0xFF) << 16;
        iRet += ((char)data[offset + 2] & 0xFF) << 8;
        return iRet += (char)data[offset + 3] & 0xFF;
    }

    private static short shortFromBytes(byte[] data, int offset) {
        int iRet = ((char)data[offset] & 0xFF) << 8;
        return (short)(iRet += (char)data[offset + 1] & 0xFF);
    }

    private static boolean booleanFromBytes(byte[] data, int[] offset) {
        boolean bRet = data[offset[0]] != 0;
        offset[0] = offset[0] + 1;
        return bRet;
    }

    static int asBytes(long i, byte[] data, int offset) {
        data[offset++] = (byte)(i >> 56 & 0xFFL);
        data[offset++] = (byte)(i >> 48 & 0xFFL);
        data[offset++] = (byte)(i >> 40 & 0xFFL);
        data[offset++] = (byte)(i >> 32 & 0xFFL);
        data[offset++] = (byte)(i >> 24 & 0xFFL);
        data[offset++] = (byte)(i >> 16 & 0xFFL);
        data[offset++] = (byte)(i >> 8 & 0xFFL);
        data[offset] = (byte)(i & 0xFFL);
        return 8;
    }

    private static int asBytes(int i, byte[] data, int offset) {
        data[offset++] = (byte)(i >> 24 & 0xFF);
        data[offset++] = (byte)(i >> 16 & 0xFF);
        data[offset++] = (byte)(i >> 8 & 0xFF);
        data[offset] = (byte)(i & 0xFF);
        return 4;
    }

    private static int asBytes(short i, byte[] data, int offset) {
        data[offset++] = (byte)(i >> 8 & 0xFF);
        data[offset] = (byte)(i & 0xFF);
        return 2;
    }

    private static int asBytes(byte i, byte[] data, int offset) {
        data[offset] = i;
        return 1;
    }

    private static int asBytes(boolean i, byte[] data, int offset) {
        data[offset] = i ? (byte)1 : 0;
        return 1;
    }

    private static byte byteFromBytes(byte[] data, int[] offset) {
        byte cRet = data[offset[0]];
        offset[0] = offset[0] + 1;
        return cRet;
    }

    private static void RmsInit(String _zFile, int _iRmsMode) {
        ms_zRmsId = _zFile;
        ms_iRmsMode = _iRmsMode;
        ms_iRmsOffset = 0;
        if (ms_iRmsMode == 1) {
            ms_iRmsData = null;
            ms_RecordStore = null;
            try {
                ms_RecordStore = RecordStore.openRecordStore((String)_zFile, (boolean)false);
                int iNumRecords = ms_RecordStore.getNumRecords();
                if (iNumRecords == 0) {
                    MiscUtils.RmsDelete(_zFile);
                    return;
                }
                for (int i = 0; i < iNumRecords; ++i) {
                    ms_iRmsData = ms_RecordStore.getRecord(i + 1);
                }
                ms_RecordStore.closeRecordStore();
            }
            catch (Exception e) {
                MiscUtils.RmsDelete(_zFile);
            }
        } else {
            ms_iRmsData = new byte[512];
        }
    }

    private static void RmsClose() {
        if (ms_iRmsMode == 0) {
            ms_iSaveData = new byte[ms_iRmsOffset];
            System.arraycopy(ms_iRmsData, 0, ms_iSaveData, 0, ms_iRmsOffset);
            ms_iRmsData = null;
            if (MiscUtils.RmsDelete(ms_zRmsId)) {
                ms_RecordStore = null;
                try {
                    ms_RecordStore = RecordStore.openRecordStore((String)ms_zRmsId, (boolean)true);
                    if (ms_iRmsOffset > ms_RecordStore.getSizeAvailable()) {
                        return;
                    }
                    ms_RecordStore.addRecord(ms_iSaveData, 0, ms_iRmsOffset);
                    ms_RecordStore.closeRecordStore();
                }
                catch (Exception e) {
                    MiscUtils.RmsDelete(ms_zRmsId);
                }
            }
        }
    }

    private static boolean RmsProcessData(boolean _bData) {
        if (ms_iRmsMode == 1) {
            _bData = ms_iRmsData[ms_iRmsOffset++] == 1;
        } else {
            MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)(_bData ? 1 : 0);
        }
        return _bData;
    }

    private static byte RmsProcessData(byte _bData) {
        if (ms_iRmsMode == 1) {
            _bData = ms_iRmsData[ms_iRmsOffset++];
        } else {
            MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = _bData;
        }
        return _bData;
    }

    private static short RmsProcessData(short _sData) {
        if (ms_iRmsMode == 1) {
            _sData = MiscUtils.shortFromBytes(ms_iRmsData, ms_iRmsOffset);
            ms_iRmsOffset += 2;
        } else {
            ms_iRmsOffset += MiscUtils.asBytes(_sData, ms_iRmsData, ms_iRmsOffset);
        }
        return _sData;
    }

    private static int RmsProcessData(int _iData) {
        if (ms_iRmsMode == 1) {
            _iData = MiscUtils.intFromBytes(ms_iRmsData, ms_iRmsOffset);
            ms_iRmsOffset += 4;
        } else {
            ms_iRmsOffset += MiscUtils.asBytes(_iData, ms_iRmsData, ms_iRmsOffset);
        }
        return _iData;
    }

    private static long RmsProcessData(long _iData) {
        if (ms_iRmsMode == 1) {
            _iData = MiscUtils.longFromBytes(ms_iRmsData, ms_iRmsOffset);
            ms_iRmsOffset += 8;
        } else {
            ms_iRmsOffset += MiscUtils.asBytes(_iData, ms_iRmsData, ms_iRmsOffset);
        }
        return _iData;
    }

    private static String RmsProcessData(String _zData) {
        if (ms_iRmsMode == 1) {
            int iLength = ms_iRmsData[ms_iRmsOffset++];
            _zData = "";
            for (int i = 0; i < iLength; ++i) {
                _zData = _zData + (char)ms_iRmsData[ms_iRmsOffset++];
            }
        } else {
            MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)_zData.length();
            char[] iChars = _zData.toCharArray();
            for (int k = 0; k < iChars.length; ++k) {
                MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)iChars[k];
            }
        }
        return _zData;
    }

    private static boolean[] RmsProcessData(boolean[] _bData) {
        if (ms_iRmsMode == 1) {
            _bData = new boolean[ms_iRmsData[ms_iRmsOffset++]];
            for (int b = 0; b < _bData.length; ++b) {
                _bData[b] = ms_iRmsData[ms_iRmsOffset++] == 1;
            }
        } else {
            MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)_bData.length;
            for (int i = 0; i < _bData.length; ++i) {
                MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)(_bData[i] ? 1 : 0);
            }
        }
        return _bData;
    }

    private static byte[] RmsProcessData(byte[] _bData) {
        if (ms_iRmsMode == 1) {
            _bData = new byte[ms_iRmsData[ms_iRmsOffset++]];
            for (int b = 0; b < _bData.length; ++b) {
                _bData[b] = ms_iRmsData[ms_iRmsOffset++];
            }
        } else {
            MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)_bData.length;
            for (int i = 0; i < _bData.length; ++i) {
                MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = _bData[i];
            }
        }
        return _bData;
    }

    private static short[] RmsProcessData(short[] _sData) {
        if (ms_iRmsMode == 1) {
            _sData = new short[ms_iRmsData[ms_iRmsOffset++]];
            for (int s = 0; s < _sData.length; ++s) {
                _sData[s] = MiscUtils.shortFromBytes(ms_iRmsData, ms_iRmsOffset);
                ms_iRmsOffset += 2;
            }
        } else {
            MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)_sData.length;
            for (int i = 0; i < _sData.length; ++i) {
                ms_iRmsOffset += MiscUtils.asBytes(_sData[i], ms_iRmsData, ms_iRmsOffset);
            }
        }
        return _sData;
    }

    private static int[] RmsProcessData(int[] _iData) {
        if (ms_iRmsMode == 1) {
            _iData = new int[ms_iRmsData[ms_iRmsOffset++]];
            for (int i = 0; i < _iData.length; ++i) {
                _iData[i] = MiscUtils.intFromBytes(ms_iRmsData, ms_iRmsOffset);
                ms_iRmsOffset += 4;
            }
        } else {
            MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)_iData.length;
            for (int i = 0; i < _iData.length; ++i) {
                ms_iRmsOffset += MiscUtils.asBytes(_iData[i], ms_iRmsData, ms_iRmsOffset);
            }
        }
        return _iData;
    }

    private static String[] RmsProcessData(String[] _zData) {
        if (ms_iRmsMode == 1) {
            int iArrayLength = ms_iRmsData[ms_iRmsOffset++];
            for (int i = 0; i < iArrayLength; ++i) {
                int iStringLength = ms_iRmsData[ms_iRmsOffset++];
                _zData[i] = "";
                for (int k = 0; k < iStringLength; ++k) {
                    int n = i;
                    _zData[n] = _zData[n] + (char)ms_iRmsData[ms_iRmsOffset++];
                }
            }
        } else {
            MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)_zData.length;
            for (int i = 0; i < _zData.length; ++i) {
                MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)_zData[i].length();
                char[] iChars = _zData[i].toCharArray();
                for (int k = 0; k < iChars.length; ++k) {
                    MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)iChars[k];
                }
            }
        }
        return _zData;
    }

    private static boolean[][] RmsProcessData(boolean[][] _bData) {
        if (ms_iRmsMode == 1) {
            int i;
            _bData = new boolean[ms_iRmsData[ms_iRmsOffset++]][];
            for (i = 0; i < ((boolean[][])_bData).length; ++i) {
                _bData[i] = new boolean[ms_iRmsData[ms_iRmsOffset++]];
            }
            for (i = 0; i < ((boolean[][])_bData).length; ++i) {
                for (int j = 0; j < _bData[i].length; ++j) {
                    _bData[i][j] = ms_iRmsData[ms_iRmsOffset++] == 1;
                }
            }
        } else {
            int i;
            MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)((boolean[][])_bData).length;
            for (i = 0; i < ((boolean[][])_bData).length; ++i) {
                MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)_bData[i].length;
            }
            for (i = 0; i < ((boolean[][])_bData).length; ++i) {
                for (int j = 0; j < _bData[i].length; ++j) {
                    MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)(_bData[i][j] ? 1 : 0);
                }
            }
        }
        return _bData;
    }

    private static byte[][] RmsProcessData(byte[][] _bData) {
        if (ms_iRmsMode == 1) {
            int i;
            _bData = new byte[ms_iRmsData[ms_iRmsOffset++]][];
            for (i = 0; i < ((byte[][])_bData).length; ++i) {
                _bData[i] = new byte[ms_iRmsData[ms_iRmsOffset++]];
            }
            for (i = 0; i < ((byte[][])_bData).length; ++i) {
                for (int j = 0; j < _bData[i].length; ++j) {
                    _bData[i][j] = ms_iRmsData[ms_iRmsOffset++];
                }
            }
        } else {
            int i;
            MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)((byte[][])_bData).length;
            for (i = 0; i < ((byte[][])_bData).length; ++i) {
                MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)_bData[i].length;
            }
            for (i = 0; i < ((byte[][])_bData).length; ++i) {
                for (int j = 0; j < _bData[i].length; ++j) {
                    MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = _bData[i][j];
                }
            }
        }
        return _bData;
    }

    private static short[][] RmsProcessData(short[][] _sData) {
        if (ms_iRmsMode == 1) {
            int i;
            _sData = new short[ms_iRmsData[ms_iRmsOffset++]][];
            for (i = 0; i < ((short[][])_sData).length; ++i) {
                _sData[i] = new short[ms_iRmsData[ms_iRmsOffset++]];
            }
            for (i = 0; i < ((short[][])_sData).length; ++i) {
                for (int j = 0; j < _sData[i].length; ++j) {
                    _sData[i][j] = MiscUtils.shortFromBytes(ms_iRmsData, ms_iRmsOffset);
                    ms_iRmsOffset += 2;
                }
            }
        } else {
            int i;
            MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)((short[][])_sData).length;
            for (i = 0; i < ((short[][])_sData).length; ++i) {
                MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)_sData[i].length;
            }
            for (i = 0; i < ((short[][])_sData).length; ++i) {
                for (int j = 0; j < _sData[i].length; ++j) {
                    ms_iRmsOffset += MiscUtils.asBytes(_sData[i][j], ms_iRmsData, ms_iRmsOffset);
                }
            }
        }
        return _sData;
    }

    private static int[][] RmsProcessData(int[][] _iData) {
        if (ms_iRmsMode == 1) {
            int i;
            _iData = new int[ms_iRmsData[ms_iRmsOffset++]][];
            for (i = 0; i < ((int[][])_iData).length; ++i) {
                _iData[i] = new int[ms_iRmsData[ms_iRmsOffset++]];
            }
            for (i = 0; i < ((int[][])_iData).length; ++i) {
                for (int j = 0; j < _iData[i].length; ++j) {
                    _iData[i][j] = MiscUtils.intFromBytes(ms_iRmsData, ms_iRmsOffset);
                    ms_iRmsOffset += 4;
                }
            }
        } else {
            int i;
            MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)((int[][])_iData).length;
            for (i = 0; i < ((int[][])_iData).length; ++i) {
                MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)_iData[i].length;
            }
            for (i = 0; i < ((int[][])_iData).length; ++i) {
                for (int j = 0; j < _iData[i].length; ++j) {
                    ms_iRmsOffset += MiscUtils.asBytes(_iData[i][j], ms_iRmsData, ms_iRmsOffset);
                }
            }
        }
        return _iData;
    }

    private static String[][] RmsProcessData(String[][] _zData) {
        if (ms_iRmsMode == 1) {
            int iArrayLength = ms_iRmsData[ms_iRmsOffset++];
            for (int i = 0; i < iArrayLength; ++i) {
                int iSubArrayLength = ms_iRmsData[ms_iRmsOffset++];
                for (int j = 0; j < iSubArrayLength; ++j) {
                    int iStringLength = ms_iRmsData[ms_iRmsOffset++];
                    _zData[i][j] = "";
                    for (int k = 0; k < iStringLength; ++k) {
                        String[] stringArray = _zData[i];
                        int n = j;
                        stringArray[n] = stringArray[n] + (char)ms_iRmsData[ms_iRmsOffset++];
                    }
                }
            }
        } else {
            MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)_zData.length;
            for (int i = 0; i < _zData.length; ++i) {
                MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)_zData[i].length;
                for (int j = 0; j < _zData[i].length; ++j) {
                    MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)_zData[i][j].length();
                    char[] iChars = _zData[i][j].toCharArray();
                    for (int k = 0; k < iChars.length; ++k) {
                        MiscUtils.ms_iRmsData[MiscUtils.ms_iRmsOffset++] = (byte)iChars[k];
                    }
                }
            }
        }
        return _zData;
    }

    private static boolean RmsDelete(String _File) {
        ms_RecordStore = null;
        try {
            ms_RecordStore = RecordStore.openRecordStore((String)_File, (boolean)true);
            if (ms_RecordStore != null) {
                ms_RecordStore.closeRecordStore();
                RecordStore.deleteRecordStore((String)_File);
                ms_RecordStore = null;
            }
        }
        catch (RecordStoreException rse) {
            return true;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void RmsLoadSaveData(String _zFile, int _iMode) {
        MiscUtils.RmsInit(_zFile, _iMode);
        boolean bl = ms_bSavedData = ms_iRmsData != null;
        if (ms_iRmsData == null) {
            return;
        }
        if (_zFile.equals(FILE_PLY)) {
            ModeMenu.ms_sName = MiscUtils.RmsProcessData(ModeMenu.ms_sName);
            ModeWorld.ms_iPlayer = MiscUtils.RmsProcessData(ModeWorld.ms_iPlayer);
            ModeWorld.ms_iPlayerMoney = MiscUtils.RmsProcessData(ModeWorld.ms_iPlayerMoney);
            ModeWorld.ms_iMapPosIndex = MiscUtils.RmsProcessData(ModeWorld.ms_iMapPosIndex);
            ModeWorld.ms_iNumHandsBeated = MiscUtils.RmsProcessData(ModeWorld.ms_iNumHandsBeated);
            ModeWorld.ms_iNumWormsBeated = MiscUtils.RmsProcessData(ModeWorld.ms_iNumWormsBeated);
            for (int i = 0; i < 4; ++i) {
                ModeWorld.ms_iRankingTournmt[i] = MiscUtils.RmsProcessData(ModeWorld.ms_iRankingTournmt[i]);
            }
            ModeWorld.ms_iTnmtsStatus = MiscUtils.RmsProcessData(ModeWorld.ms_iTnmtsStatus);
            ModeWorld.ms_iTnmtsCurrentStg = MiscUtils.RmsProcessData(ModeWorld.ms_iTnmtsCurrentStg);
            ModeWorld.ms_iShopItemStatus = MiscUtils.RmsProcessData(ModeWorld.ms_iShopItemStatus);
            ModeWorld.ms_iGamePercentage = MiscUtils.RmsProcessData(ModeWorld.ms_iGamePercentage);
            ModeWorld.ms_iGameAchivements = MiscUtils.RmsProcessData(ModeWorld.ms_iGameAchivements);
            ModeWorld.ms_lAccumulatedMillics = MiscUtils.RmsProcessData(ModeWorld.ms_lAccumulatedMillics);
            ModeWorld.ms_iPlayerHits = MiscUtils.RmsProcessData(ModeWorld.ms_iPlayerHits);
            ModeWorld.ms_iPlayerHoles = MiscUtils.RmsProcessData(ModeWorld.ms_iPlayerHoles);
            ModeWorld.ms_iChallengeWins = MiscUtils.RmsProcessData(ModeWorld.ms_iChallengeWins);
            ModeWorld.ms_iChallengeLoses = MiscUtils.RmsProcessData(ModeWorld.ms_iChallengeLoses);
            ModeWorld.ms_iPlayerGames = MiscUtils.RmsProcessData(ModeWorld.ms_iPlayerGames);
            ModeWorld.ms_bWalkPlaces = MiscUtils.RmsProcessData(ModeWorld.ms_bWalkPlaces);
        } else if (_zFile.equals(FILE_SYS)) {
            Main.ms_bVibration = MiscUtils.RmsProcessData(Main.ms_bVibration);
            Main.ms_iLanguage = MiscUtils.RmsProcessData(Main.ms_iLanguage);
        } else if (_zFile.equals(FILE_ACH)) {
            ModeMenu.ms_bAchievements = MiscUtils.RmsProcessData(ModeMenu.ms_bAchievements);
        }
        MiscUtils.RmsClose();
    }

    public static void LanguageSectionClear(String[] _zStringArray) {
        for (int i = 0; i < _zStringArray.length; ++i) {
            _zStringArray[i] = null;
        }
    }

    public static void LanguageLoadConfiguration() {
        int i;
        String[] zLanguage = new String[32];
        MiscUtils.LanguageSectionLoad("/cf.lng", 0, zLanguage);
        int iNumLines = 0;
        for (int i2 = 0; i2 < zLanguage.length; ++i2) {
            if (zLanguage[i2] == null || zLanguage[i2].equals("")) continue;
            ++iNumLines;
        }
        int iNumLanguages = iNumLines / 3;
        String[] vTextLanguageMenu = new String[iNumLanguages];
        String[] zLanguageTextFile = new String[iNumLanguages];
        String[] zSelectLanguageTx = new String[iNumLanguages];
        for (i = 0; i < iNumLanguages; ++i) {
            vTextLanguageMenu[i] = "";
            zLanguageTextFile[i] = "";
            zSelectLanguageTx[i] = "";
        }
        for (i = 0; i < iNumLines; i += 3) {
            zLanguageTextFile[i / 3] = zLanguage[i];
            vTextLanguageMenu[i / 3] = zLanguage[i + 1];
            zSelectLanguageTx[i / 3] = zLanguage[i + 2];
        }
        zSelectLanguageTx[iNumLanguages - 1] = zSelectLanguageTx[iNumLanguages - 1].substring(0, zSelectLanguageTx[iNumLanguages - 1].length() - 1);
        for (i = 0; i < zLanguageTextFile.length; ++i) {
            if (zLanguageTextFile[i].startsWith("ar") && !ARABIC_SUPPORT) {
                --iNumLanguages;
                continue;
            }
            if (zLanguageTextFile[i].startsWith("bn") && !BENGAL_SUPPORT) {
                --iNumLanguages;
                continue;
            }
            if (!zLanguageTextFile[i].startsWith("ja") || JAPANS_SUPPORT) continue;
            --iNumLanguages;
        }
        Main.ms_vTextLanguageMenu = new String[iNumLanguages * 2];
        Main.ms_zLanguageTextFile = new String[iNumLanguages];
        iNumLanguages = 0;
        for (i = 0; i < zLanguageTextFile.length; ++i) {
            if (zLanguageTextFile[i].startsWith("ar") && !ARABIC_SUPPORT || zLanguageTextFile[i].startsWith("bn") && !BENGAL_SUPPORT || zLanguageTextFile[i].startsWith("ja") && !JAPANS_SUPPORT) continue;
            Main.ms_vTextLanguageMenu[iNumLanguages] = vTextLanguageMenu[i];
            Main.ms_zLanguageTextFile[iNumLanguages] = "/" + zLanguageTextFile[i];
            Main.ms_vTextLanguageMenu[Main.ms_zLanguageTextFile.length + iNumLanguages] = zSelectLanguageTx[i];
            ++iNumLanguages;
        }
    }

    public static void LanguageSectionLoad(String _zLanguageFile, int _iLanguageSection, String[] _zStringArray) {
        int iStrings = 0;
        int iLanguageStartPos = 0;
        int i = 0;
        DataInputStream vInputS = null;
        int iLanguageSectionIndex = _iLanguageSection;
        System.gc();
        boolean iMoment = false;
        try {
            vInputS = new DataInputStream(((Object)((Object)MGCC.ms_vInstance)).getClass().getResourceAsStream(_zLanguageFile));
            vInputS.skip(iLanguageSectionIndex * 4);
            iLanguageStartPos = vInputS.readInt();
            vInputS.skip(iLanguageStartPos - iLanguageSectionIndex * 4 - 4);
            iStrings = vInputS.readShort();
            int[] iStringLength = new int[iStrings];
            short iLongestStringLength = vInputS.readShort();
            byte[] bChar = new byte[iLongestStringLength];
            for (i = 0; i < iStrings; ++i) {
                iStringLength[i] = vInputS.readByte();
                if ((iStringLength[i] & 0x80) == 0) continue;
                iStringLength[i] = iStringLength[i] & 0x7F | vInputS.readByte() << 7;
            }
            for (i = 0; i < iStrings; ++i) {
                for (int iReadBytes = 0; iReadBytes < iStringLength[i]; ++iReadBytes) {
                    bChar[iReadBytes] = vInputS.readByte();
                }
                try {
                    if (i == 0 && bChar[0] == -17 && bChar[1] == -69 && bChar[2] == -65) {
                        _zStringArray[i] = new String(bChar, 3, iStringLength[i] - 3, "UTF-8");
                        continue;
                    }
                    _zStringArray[i] = new String(bChar, 0, iStringLength[i], "UTF-8");
                    continue;
                }
                catch (Exception ex) {
                    _zStringArray[i] = new String(bChar, 0, iStringLength[i]);
                }
            }
            vInputS.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (ARABIC_SUPPORT && !ARABIC_PROPER_SUPPORT && (_zLanguageFile.startsWith("/ar") || _zLanguageFile.startsWith("/cf"))) {
            block7: for (i = 0; i < iStrings; ++i) {
                for (int j = 0; j < _zStringArray[i].length(); ++j) {
                    String zNewtext;
                    if ((_zStringArray[i].charAt(j) < '\u0600' || _zStringArray[i].charAt(j) > '\u06ff') && (_zStringArray[i].charAt(j) < '\u0750' || _zStringArray[i].charAt(j) > '\u077f')) continue;
                    _zStringArray[i] = zNewtext = ArabicReshaper.Convert(_zStringArray[i]);
                    continue block7;
                }
            }
        }
        MGCC.ms_zLanguage = _zLanguageFile.substring(1, 3);
        FntManager.SetFontType(1);
        if (ARABIC_SUPPORT && MGCC.ms_zLanguage.equals("ar") || BENGAL_SUPPORT && MGCC.ms_zLanguage.equals("bn") || JAPANS_SUPPORT && MGCC.ms_zLanguage.equals("ja")) {
            FntManager.SetFontType(0);
        }
        System.gc();
    }

    public static boolean LanguageCheckFontSupport(String _zText1, String _zText2) {
        Image vImage1 = Image.createImage((int)Font.getDefaultFont().getHeight(), (int)Font.getDefaultFont().getHeight());
        Image vImage2 = Image.createImage((int)Font.getDefaultFont().getHeight(), (int)Font.getDefaultFont().getHeight());
        Graphics g1 = vImage1.getGraphics();
        g1.drawString(_zText1, 0, 0, 0);
        Graphics g2 = vImage2.getGraphics();
        g2.drawString(_zText2, 0, 0, 0);
        int[] iData1 = new int[vImage1.getWidth() * vImage1.getHeight()];
        int[] iData2 = new int[vImage2.getWidth() * vImage2.getHeight()];
        vImage1.getRGB(iData1, 0, vImage1.getWidth(), 0, 0, vImage1.getWidth(), vImage1.getHeight());
        vImage2.getRGB(iData2, 0, vImage2.getWidth(), 0, 0, vImage2.getWidth(), vImage2.getHeight());
        boolean bEqual = true;
        for (int i = 0; i < iData1.length; ++i) {
            if (iData1[i] == iData2[i]) continue;
            bEqual = false;
            break;
        }
        return bEqual;
    }

    public static void DebugHandleKeys() {
    }

    public static void DebugMsg(String _zMessage) {
    }

    public static void DebugMsg(String _zMessage, Exception _vException) {
    }

    public static void DebugReadPostmortemData() {
    }

    public static void DebugPostmortemMsg(String _zMessage) {
    }

    static {
        ms_RecordStore = null;
        ARABIC_PROPER_SUPPORT = !MiscUtils.LanguageCheckFontSupport(ARABIC_TEST1, ARABIC_TEST2);
        ARABIC_SUPPORT = Font.getDefaultFont().stringWidth(String.valueOf('\u0627')) != Font.getDefaultFont().stringWidth(String.valueOf('\u0628'));
        BENGAL_SUPPORT = Font.getDefaultFont().stringWidth(String.valueOf('\u09f7')) != Font.getDefaultFont().stringWidth(String.valueOf('\u0985'));
        JAPANS_SUPPORT = !MiscUtils.LanguageCheckFontSupport(JAPANS_TEST1, JAPANS_TEST2);
        ms_bShowDebug = false;
        ms_bAllowLogging = true;
    }
}

