/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

class cWorld {
    byte[][] cMatrix;
    byte[][] rMatrix;
    byte idMapTiles;
    byte idMapTilesWeather;
    byte iMatrixWidth;
    byte iMatrixHeight;
    byte iWidthBlock;
    byte iHeightBlock;
    boolean flagLinePorteriaNorth = false;
    boolean flagLinePorteriaSouth = false;
    int sideChamp;
    int sideChampLast;
    int iFrontierXLow;
    int iFrontierYLow;
    int iFrontierXHigh;
    int iFrontierYHigh;
    public short[] myLines_xExtreme1;
    public short[] myLines_yExtreme1;
    public short[] myLines_xExtreme2;
    public short[] myLines_yExtreme2;
    public short[] myLines_detectionRange;
    public short[] myLines_x;
    public short[] myLines_y;
    public short[] myCircles_xExtreme1;
    public short[] myCircles_yExtreme1;
    public short[] myCircles_xExtreme2;
    public short[] myCircles_yExtreme2;
    public short[] myCircles_iniAngle;
    public short[] myCircles_endAngle;
    public short[] myCircles_isFilled;
    public short[] myCircles_detectionRange;
    public short[] myCircles_x;
    public short[] myCircles_y;
    short[][][] myAlineacion;
    Point2D circleCenterField;
    Point2D circleSouthField;
    Point2D circleNorthField;
    Point2D porteriaSouth;
    Point2D porteriaNorth;
    static short[][] myPublicidad;
    public static final int COLLISION_MATRIX = 0;
    public static final int RENDER_MATRIX = 1;
    public static final int FRONTIER_FUERA_BANDA = 252160;
    public static final int FRONTIER_FUERA_FONDO = 447600;
    public static final int RANGO_PORTERIA = 4320;
    public static final int LINE_AREA_GOALKEEPER_HEIGHT = 284800;
    public static final int LINE_AREA_GOALKEEPER_WIDTH = 152960;
    public static final int LINE_PENALTY_GOALKEEPER_HEIGHT = 310400;
    public static final int LINE_PENALTY_GOALKEEPER_WIDTH = 145920;
    public static final int LINE_SUBPENALTY_GOALKEEPER_HEIGHT = 382720;
    public static final int LINE_SUBPENALTY_GOALKEEPER_WIDTH = 48000;
    public static final byte COLISION_TYPE_EMPTY = 0;
    public static final byte COLISION_TYPE_1 = 1;
    public static final byte COLISION_TYPE_2 = 2;
    public static final byte COLISION_TYPE_3 = 3;
    public static final byte COLISION_TYPE_4 = 4;
    public static final byte COLISION_TYPE_5 = 5;
    public static final byte COLISION_TYPE_GOAL1 = 6;
    public static final byte COLISION_TYPE_GOAL2 = 7;
    public static final byte INDEX_LINE_MIDDLE_FIELD = 4;
    public static final byte NUMBER_OF_LINES_PER_FIELD = 6;
    public static final byte INDEX_LINES_PORTERIA_SOUTH = 17;
    public static final byte NUMBER_OF_LINES_PER_PORTERIA_SOUTH = 11;
    public static final byte INDEX_LINES_PORTERIA_NORTH = 28;
    public static final byte NUMBER_OF_LINES_PER_PORTERIA_NORTH = 11;
    public static final byte NUMBER_OF_CIRCLES_PER_FIELD = 4;
    public static final byte INITIAL_CIRCLE_GAME = 1;
    public static final byte PENALTY_CIRCLE_SOUTH = 2;
    public static final byte CORNER_EAST_FIELD_SOUTH = 4;
    public static final byte CORNER_WEST_FIELD_SOUTH = 5;
    public static final byte PENALTY_CIRCLE_NORTH = 6;
    public static final byte CORNER_EAST_FIELD_NORTH = 8;
    public static final byte CORNER_WEST_FIELD_NORTH = 9;
    public static final byte VESTIDORES = 0;
    public static final byte CENTRO_CAMPO = 1;
    public static final byte SAQUE_INICIAL_ATAQUE_NORTE = 2;
    public static final byte SAQUE_INICIAL_DEFENSA_NORTE = 3;
    public static final byte ALINEACION_4_3_3 = 4;
    public static final byte ALINEACION_3_4_3 = 5;
    public static final byte ALINEACION_3_3_4 = 6;
    public static final byte ALINEACION_2_4_4 = 7;
    public static final byte ALINEACION_4_4_2 = 8;
    public static final byte SAQUE_INICIAL_ATAQUE_SUR = 9;
    public static final byte SAQUE_INICIAL_DEFENSA_SUR = 10;
    public static final byte PORTERO_NORTE = 11;
    public static final byte PORTERO_SUR = 12;
    public static int zoneGoal;
    boolean arrayview = false;
    static int xIniSelectionTmp;
    static int yIniSelectionTmp;
    static byte gSelectedWeather;
    static int yyy;
    static byte gSelectedStadium;
    static int AyIniSelectionTmp;

    cWorld(int pidMapTiles, int pidMapTilesWeather) {
        this.idMapTiles = (byte)pidMapTiles;
        this.idMapTilesWeather = (byte)pidMapTilesWeather;
        this.porteriaSouth = new Point2D(199, 442);
        this.porteriaNorth = new Point2D(955, 62);
    }

    void free() {
        this.cMatrix = null;
        this.rMatrix = null;
        this.myLines_xExtreme1 = null;
        this.myLines_yExtreme1 = null;
        this.myLines_xExtreme2 = null;
        this.myLines_yExtreme2 = null;
        this.myLines_detectionRange = null;
        this.myLines_x = null;
        this.myLines_y = null;
        this.myCircles_xExtreme1 = null;
        this.myCircles_yExtreme1 = null;
        this.myCircles_xExtreme2 = null;
        this.myCircles_yExtreme2 = null;
        this.myCircles_iniAngle = null;
        this.myCircles_endAngle = null;
        this.myCircles_isFilled = null;
        this.myCircles_detectionRange = null;
        this.myCircles_x = null;
        this.myCircles_y = null;
        this.myAlineacion = null;
        this.circleCenterField = null;
        this.circleSouthField = null;
        this.circleNorthField = null;
        this.porteriaSouth = null;
        this.porteriaNorth = null;
    }

    public void init(String file) throws IOException {
        InputStream is = file.getClass().getResourceAsStream(file);
        this.readWorld(is, true);
        is.close();
    }

    void readWorld(InputStream is, boolean isBlock) throws IOException {
        String fileTileImages = "";
        int lengthFileTileImages = is.read() & 0xFF;
        if (lengthFileTileImages > 0) {
            int numberOfImagesTiles = Utils.readInt(is);
            for (int i = 0; i < lengthFileTileImages; ++i) {
                fileTileImages = fileTileImages + (char)(is.read() & 0xFF);
            }
        }
        this.iMatrixWidth = (byte)Utils.readInt(is);
        this.iMatrixHeight = (byte)Utils.readInt(is);
        this.iWidthBlock = (byte)Utils.readInt(is);
        this.iHeightBlock = (byte)Utils.readInt(is);
        this.iFrontierXLow = 88;
        this.iFrontierYLow = 102;
        this.iFrontierXHigh = (short)(this.iMatrixWidth * this.iWidthBlock - this.iFrontierXLow);
        this.iFrontierYHigh = (short)(this.iMatrixHeight * this.iHeightBlock - this.iFrontierYLow);
        this.cMatrix = new byte[this.iMatrixWidth][this.iMatrixHeight];
        this.rMatrix = new byte[this.iMatrixWidth][this.iMatrixHeight];
        for (int i = 0; i < this.iMatrixWidth; ++i) {
            for (int j = 0; j < this.iMatrixHeight; ++j) {
                this.cMatrix[i][j] = (byte)(is.read() & 0xFF);
                this.rMatrix[i][j] = (byte)(is.read() & 0xFF);
            }
        }
        int numberOfLines = Utils.readInt(is);
        this.myLines_xExtreme1 = new short[numberOfLines];
        this.myLines_yExtreme1 = new short[numberOfLines];
        this.myLines_xExtreme2 = new short[numberOfLines];
        this.myLines_yExtreme2 = new short[numberOfLines];
        this.myLines_detectionRange = new short[numberOfLines];
        this.myLines_x = new short[numberOfLines];
        this.myLines_y = new short[numberOfLines];
        for (int z = 0; z < numberOfLines; ++z) {
            this.myLines_xExtreme1[z] = (short)Utils.readShort(is);
            this.myLines_yExtreme1[z] = (short)Utils.readShort(is);
            this.myLines_xExtreme2[z] = (short)Utils.readShort(is);
            this.myLines_yExtreme2[z] = (short)Utils.readShort(is);
            this.myLines_detectionRange[z] = (short)(Utils.readShort(is) / 2);
            this.myLines_x[z] = (short)((this.myLines_xExtreme1[z] + this.myLines_xExtreme2[z]) / 2);
            this.myLines_y[z] = (short)((this.myLines_yExtreme1[z] + this.myLines_yExtreme2[z]) / 2);
        }
        int numberOfCircles = Utils.readInt(is);
        this.myCircles_xExtreme1 = new short[numberOfCircles];
        this.myCircles_yExtreme1 = new short[numberOfCircles];
        this.myCircles_xExtreme2 = new short[numberOfCircles];
        this.myCircles_yExtreme2 = new short[numberOfCircles];
        this.myCircles_iniAngle = new short[numberOfCircles];
        this.myCircles_endAngle = new short[numberOfCircles];
        this.myCircles_isFilled = new short[numberOfCircles];
        this.myCircles_detectionRange = new short[numberOfCircles];
        this.myCircles_x = new short[numberOfCircles];
        this.myCircles_y = new short[numberOfCircles];
        for (int z = 0; z < numberOfCircles; ++z) {
            this.myCircles_xExtreme1[z] = (short)Utils.readShort(is);
            this.myCircles_yExtreme1[z] = (short)Utils.readShort(is);
            this.myCircles_xExtreme2[z] = (short)Utils.readShort(is);
            this.myCircles_yExtreme2[z] = (short)Utils.readShort(is);
            this.myCircles_iniAngle[z] = (short)Utils.readShort(is);
            this.myCircles_endAngle[z] = (short)Utils.readShort(is);
            this.myCircles_isFilled[z] = (short)Utils.readShort(is);
            this.myCircles_x[z] = (short)(this.myCircles_xExtreme1[z] + this.myCircles_xExtreme2[z] / 2);
            this.myCircles_y[z] = (short)(this.myCircles_yExtreme1[z] + this.myCircles_yExtreme2[z] / 2);
            this.myCircles_detectionRange[z] = (short)(Math.abs(this.myCircles_xExtreme2[z]) > Math.abs(this.myCircles_yExtreme2[z]) ? Math.abs(this.myCircles_xExtreme2[z] / 2) : Math.abs(this.myCircles_yExtreme2[z] / 2));
        }
        this.circleCenterField = new Point2D(this.myCircles_x[1], this.myCircles_y[1]);
        this.circleSouthField = new Point2D(this.myCircles_x[2], this.myCircles_y[2]);
        this.circleNorthField = new Point2D(this.myCircles_x[6], this.myCircles_y[6]);
        int numberOfAlineaciones = Utils.readInt(is);
        this.myAlineacion = new short[numberOfAlineaciones][][];
        for (int z = 0; z < numberOfAlineaciones; ++z) {
            int numberOfPointsAlineacion = Utils.readInt(is);
            this.myAlineacion[z] = new short[numberOfPointsAlineacion][2];
            for (int y = 0; y < numberOfPointsAlineacion; ++y) {
                this.myAlineacion[z][y][0] = (short)Utils.readShort(is);
                this.myAlineacion[z][y][1] = (short)Utils.readShort(is);
            }
        }
    }

    Point2D getPositionInField(int team, int positionType, int indexPlayer) {
        Point2D output = null;
        if (team == 0) {
            switch (positionType) {
                case 0: {
                    output = new Point2D(this.myAlineacion[positionType][0][0] - (this.iWidthBlock >> 2) * indexPlayer, this.myAlineacion[positionType][0][1] - (this.iHeightBlock >> 2) * indexPlayer);
                    break;
                }
                case 1: {
                    output = new Point2D(this.myAlineacion[positionType][0][0], this.myAlineacion[positionType][0][1]);
                    break;
                }
                case 2: 
                case 3: 
                case 9: 
                case 10: {
                    output = new Point2D(this.myAlineacion[positionType][indexPlayer][0], this.myAlineacion[positionType][indexPlayer][1]);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    output = new Point2D(this.myAlineacion[positionType][indexPlayer][0] - this.iWidthBlock / 6, this.myAlineacion[positionType][indexPlayer][1] + this.iHeightBlock / 6);
                    break;
                }
                case 11: 
                case 12: {
                    output = new Point2D(this.myAlineacion[positionType][0][0], this.myAlineacion[positionType][0][1]);
                }
            }
        } else {
            switch (positionType) {
                case 0: {
                    output = new Point2D(this.myAlineacion[positionType][1][0] - (this.iWidthBlock >> 2) * indexPlayer, this.myAlineacion[positionType][1][1] - (this.iHeightBlock >> 2) * indexPlayer);
                    break;
                }
                case 1: {
                    output = new Point2D(this.myAlineacion[positionType][1][0], this.myAlineacion[positionType][1][1]);
                    break;
                }
                case 2: 
                case 3: 
                case 9: 
                case 10: {
                    output = new Point2D(this.myAlineacion[positionType][indexPlayer][0], this.myAlineacion[positionType][indexPlayer][1]);
                    break;
                }
                case 4: {
                    output = new Point2D(this.myAlineacion[6][10 - (indexPlayer + 1)][0] + this.iWidthBlock / 6, this.myAlineacion[6][10 - (indexPlayer + 1)][1] - this.iHeightBlock / 6);
                    break;
                }
                case 5: {
                    output = new Point2D(this.myAlineacion[5][10 - (indexPlayer + 1)][0] + this.iWidthBlock / 6, this.myAlineacion[5][10 - (indexPlayer + 1)][1] - this.iHeightBlock / 6);
                    break;
                }
                case 6: {
                    output = new Point2D(this.myAlineacion[4][10 - (indexPlayer + 1)][0] + this.iWidthBlock / 6, this.myAlineacion[4][10 - (indexPlayer + 1)][1] - this.iHeightBlock / 6);
                    break;
                }
                case 7: {
                    output = new Point2D(this.myAlineacion[8][10 - (indexPlayer + 1)][0] + this.iWidthBlock / 6, this.myAlineacion[8][10 - (indexPlayer + 1)][1] - this.iHeightBlock / 6);
                    break;
                }
                case 8: {
                    output = new Point2D(this.myAlineacion[7][10 - (indexPlayer + 1)][0] + this.iWidthBlock / 6, this.myAlineacion[7][10 - (indexPlayer + 1)][1] - this.iHeightBlock / 6);
                    break;
                }
                case 11: 
                case 12: {
                    output = new Point2D(this.myAlineacion[positionType][0][0], this.myAlineacion[positionType][0][1]);
                }
            }
        }
        return output;
    }

    boolean isCellCorrect(Point2D pos) {
        if (pos.x < 0 || pos.x >= this.iMatrixWidth) {
            return false;
        }
        return pos.y >= 0 && pos.y < this.iMatrixHeight;
    }

    Point2D getPositionCell(Point2D pos) {
        return new Point2D(pos.x / this.iWidthBlock, pos.y / this.iHeightBlock);
    }

    Point2D getPositionCell(int x, int y) {
        return new Point2D(x / this.iWidthBlock, y / this.iHeightBlock);
    }

    byte getContentCell(Point2D pos, int type) {
        if (pos.x < 0) {
            return 1;
        }
        if (pos.y < 0) {
            return 1;
        }
        if (pos.x >= this.iMatrixWidth) {
            return 1;
        }
        if (pos.y >= this.iMatrixHeight) {
            return 1;
        }
        if (type == 0) {
            return this.cMatrix[pos.x][pos.y];
        }
        return this.rMatrix[pos.x][pos.y];
    }

    byte getContentCell(int x, int y, int type) {
        if (x < 0) {
            return 1;
        }
        if (y < 0) {
            return 1;
        }
        if (x >= this.iMatrixWidth) {
            return 1;
        }
        if (y >= this.iMatrixHeight) {
            return 1;
        }
        if (type == 0) {
            return this.cMatrix[x][y];
        }
        return this.rMatrix[x][y];
    }

    void setContentCell(Point2D pos, byte value, int type) {
        if (!this.isCellCorrect(pos)) {
            return;
        }
        if (type == 0) {
            this.cMatrix[pos.x][pos.y] = value;
        } else {
            this.rMatrix[pos.x][pos.y] = value;
        }
    }

    int collision(int x, int y) {
        Point2D cellColided = this.getPositionCell(x, y);
        byte contentCell = this.getContentCell(cellColided, 0);
        switch (contentCell) {
            case 2: {
                cellColided.setLocation(x - cellColided.x * this.iWidthBlock, this.iHeightBlock - (y - cellColided.y * this.iHeightBlock));
                if (this.testColisionDiagonal(315, cellColided)) {
                    return 2;
                }
                return 0;
            }
            case 3: 
            case 6: {
                cellColided.setLocation(x - cellColided.x * this.iWidthBlock, this.iHeightBlock - (y - cellColided.y * this.iHeightBlock));
                if (this.testColisionDiagonal(225, cellColided)) {
                    return contentCell;
                }
                return 0;
            }
            case 4: 
            case 7: {
                cellColided.setLocation(x - cellColided.x * this.iWidthBlock, this.iHeightBlock - (y - cellColided.y * this.iHeightBlock));
                if (this.testColisionDiagonal(45, cellColided)) {
                    return contentCell;
                }
                return 0;
            }
            case 5: {
                cellColided.setLocation(x - cellColided.x * this.iWidthBlock, this.iHeightBlock - (y - cellColided.y * this.iHeightBlock));
                if (this.testColisionDiagonal(135, cellColided)) {
                    return 5;
                }
                return 0;
            }
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
        }
        return 1;
    }

    boolean testArea(byte pteam) {
        if (pteam == 0) {
            if (this.sideChamp > 284800) {
                zoneGoal = 1;
                int distFromMiddleHorizontal = this.testMiddleCampHorizontal(cGame.gPositionReference);
                if (distFromMiddleHorizontal < 152960 && distFromMiddleHorizontal > -152960) {
                    return true;
                }
            }
        } else if (this.sideChamp < -284800) {
            zoneGoal = 2;
            int distFromMiddleHorizontal = this.testMiddleCampHorizontal(cGame.gPositionReference);
            if (distFromMiddleHorizontal < 152960 && distFromMiddleHorizontal > -152960) {
                return true;
            }
        }
        return false;
    }

    boolean testAreaPenalty(byte pteam) {
        int distFromMiddleHorizontal;
        return pteam == 0 ? this.sideChamp > 310400 && (distFromMiddleHorizontal = this.testMiddleCampHorizontal(cGame.gPositionReference)) < 145920 && distFromMiddleHorizontal > -145920 : this.sideChamp < -310400 && (distFromMiddleHorizontal = this.testMiddleCampHorizontal(cGame.gPositionReference)) < 145920 && distFromMiddleHorizontal > -145920;
    }

    boolean testAreaPenalty(byte pteam, Point2D ppos) {
        int distFromMiddleVertical = this.testMiddleCamp(ppos);
        int distFromMiddleHorizontal = this.testMiddleCampHorizontal(ppos);
        return pteam == 0 ? distFromMiddleVertical > 310400 && distFromMiddleHorizontal < 145920 && distFromMiddleHorizontal >= -145920 : distFromMiddleVertical < -310400 && distFromMiddleHorizontal < 145920 && distFromMiddleHorizontal >= -145920;
    }

    boolean testSubAreaPenalty(byte pteam) {
        int distFromMiddleHorizontal;
        int newsideChamp = this.sideChamp;
        return pteam == 0 ? newsideChamp > 382720 && (distFromMiddleHorizontal = this.testMiddleCampHorizontal(cGame.gPositionReference)) < 48000 && distFromMiddleHorizontal > -48000 : newsideChamp < -382720 && (distFromMiddleHorizontal = this.testMiddleCampHorizontal(cGame.gPositionReference)) < 48000 && distFromMiddleHorizontal > -48000;
    }

    int testMiddleCamp(Point2D pointTest) {
        int newSideChamp = this.iHeightBlock * this.iMatrixWidth * pointTest.x + -(this.iWidthBlock * this.iMatrixHeight) * pointTest.y;
        return this.iHeightBlock * this.iMatrixWidth * pointTest.x + -(this.iWidthBlock * this.iMatrixHeight) * pointTest.y;
    }

    int testMiddleCampHorizontal(Point2D pointTest) {
        return this.iHeightBlock * this.iMatrixWidth * pointTest.x + this.iWidthBlock * this.iMatrixHeight * pointTest.y - this.iHeightBlock * this.iMatrixWidth * (this.iWidthBlock * this.iMatrixHeight);
    }

    boolean testColisionDiagonal(int grad, Point2D pointTest) {
        int val = 0;
        switch (grad) {
            case 45: {
                val = -40 * pointTest.x + -80 * pointTest.y + 3200;
                break;
            }
            case 135: {
                val = 40 * pointTest.x + -80 * pointTest.y;
                break;
            }
            case 225: {
                val = 40 * pointTest.x + 80 * pointTest.y - 3200;
                break;
            }
            case 315: {
                val = -40 * pointTest.x + 80 * pointTest.y;
            }
        }
        return val > 0;
    }

    boolean myLines_insideRange(int z, Point2D pos) {
        return Math.abs(this.myLines_x[z] - pos.x) < this.myLines_detectionRange[z] + 88 && Math.abs(this.myLines_y[z] - pos.y) < this.myLines_detectionRange[z] + 102;
    }

    void myLines_render(int z, Graphics gl) {
        gl.setColor(0xFFFFFF);
        Point2D posIni = cGame.getScreenPoint(this.myLines_xExtreme1[z], this.myLines_yExtreme1[z]);
        Point2D posEnd = cGame.getScreenPoint(this.myLines_xExtreme2[z], this.myLines_yExtreme2[z]);
        gl.drawLine(posIni.x + cGame.gWidthScreenShift, posIni.y + cGame.gHeightScreenShift, posEnd.x + cGame.gWidthScreenShift, posEnd.y + cGame.gHeightScreenShift);
    }

    boolean myCircles_insideRange(int z, Point2D pos) {
        return Math.abs(this.myCircles_x[z] - pos.x) < this.myCircles_detectionRange[z] + 88 && Math.abs(this.myCircles_y[z] - pos.y) < this.myCircles_detectionRange[z] + 102;
    }

    void myCircles_render(int z, Graphics gl) {
        if (z == 1 || z == 2 || z == 6) {
            this.myCircles_xExtreme2[z] = 5;
            this.myCircles_yExtreme2[z] = 3;
        }
        gl.setColor(0xFFFFFF);
        Point2D posIni = cGame.getScreenPoint(this.myCircles_xExtreme1[z], this.myCircles_yExtreme1[z]);
        if (this.myCircles_isFilled[z] != 1) {
            gl.drawArc(posIni.x + cGame.gWidthScreenShift, posIni.y + cGame.gHeightScreenShift, (int)this.myCircles_xExtreme2[z], (int)this.myCircles_yExtreme2[z], this.myCircles_iniAngle[z] + 15, (int)this.myCircles_endAngle[z]);
        } else {
            gl.fillArc(posIni.x + cGame.gWidthScreenShift, posIni.y + cGame.gHeightScreenShift, (int)this.myCircles_xExtreme2[z], (int)this.myCircles_yExtreme2[z], (int)this.myCircles_iniAngle[z], (int)this.myCircles_endAngle[z]);
        }
    }

    void render(Graphics gl) {
        int colVal = -1;
        boolean flagLine1 = false;
        boolean flagLine2 = false;
        boolean flagLine3 = false;
        boolean flagLine4 = false;
        Point2D posCell = new Point2D();
        Point2D centralPos = this.getPositionCell(new Point2D(cGame.gPositionReference.x, cGame.gPositionReference.y));
        if (cGame.gFrames == 0) {
            this.sideChampLast = this.sideChamp;
            this.sideChamp = this.testMiddleCamp(cGame.gPositionReference);
        }
        for (int i = centralPos.x - 3; i < centralPos.x + 4; ++i) {
            for (int j = centralPos.y - 4; j < centralPos.y + 5; ++j) {
                if (i < 0 || j < 0 || i >= this.iMatrixWidth || j >= this.iMatrixHeight) continue;
                byte flag = (byte)(this.rMatrix[i][j] - 1);
                colVal = this.cMatrix[i][j];
                if (!flagLine1 && colVal == 2) {
                    flagLine1 = true;
                }
                if (!(flagLine2 || colVal != 3 && colVal != 6)) {
                    flagLine2 = true;
                }
                if (!(flagLine3 || colVal != 4 && colVal != 7)) {
                    flagLine3 = true;
                }
                if (!flagLine4 && colVal == 5) {
                    flagLine4 = true;
                }
                if (!this.flagLinePorteriaNorth && colVal == 6) {
                    this.flagLinePorteriaNorth = true;
                }
                if (!this.flagLinePorteriaSouth && colVal == 7) {
                    this.flagLinePorteriaSouth = true;
                }
                if (flag == 1) {
                    if (j != centralPos.y - 4 && j != 0) continue;
                    posCell.setLocation(i * this.iWidthBlock, j * this.iHeightBlock);
                    posCell = cGame.getScreenPoint(posCell);
                    cGame.drawImage(gl, this.idMapTiles, posCell.x, posCell.y, flag);
                    continue;
                }
                if (flag == 0) {
                    posCell.setLocation(i * this.iWidthBlock, j * this.iHeightBlock);
                    posCell = cGame.getScreenPoint(posCell);
                    cGame.drawImage(gl, this.idMapTiles, posCell.x, posCell.y, -1);
                    continue;
                }
                posCell.setLocation(i * this.iWidthBlock, j * this.iHeightBlock);
                posCell = cGame.getScreenPoint(posCell);
                cGame.drawImage(gl, this.idMapTiles, posCell.x, posCell.y, flag);
            }
        }
        gl.setClip((int)cGame.gWidthScreenShift, (int)cGame.gHeightScreenShift, 176, 204);
        if (this.sideChamp < 0) {
            int z;
            for (z = 5; z < 11; ++z) {
                if (!this.myLines_insideRange(z, cGame.gPositionReference)) continue;
                this.myLines_render(z, gl);
            }
            for (z = 2; z < 6; ++z) {
                if (!this.myCircles_insideRange(z, cGame.gPositionReference)) continue;
                this.myCircles_render(z, gl);
            }
        } else {
            int z;
            for (z = 11; z < 17; ++z) {
                if (!this.myLines_insideRange(z, cGame.gPositionReference)) continue;
                this.myLines_render(z, gl);
            }
            for (z = 6; z < 10; ++z) {
                if (!this.myCircles_insideRange(z, cGame.gPositionReference)) continue;
                this.myCircles_render(z, gl);
            }
        }
        gl.setClip((int)cGame.gWidthScreenShift, (int)cGame.gHeightScreenShift, 176, 204);
        if (Math.abs(this.sideChamp) < 194560) {
            this.myLines_render(4, gl);
        }
        if (flagLine1) {
            this.myLines_render(1, gl);
        }
        if (flagLine2) {
            this.myLines_render(2, gl);
        }
        if (flagLine3) {
            this.myLines_render(0, gl);
        }
        if (flagLine4) {
            this.myLines_render(3, gl);
        }
        if (this.myCircles_insideRange(0, cGame.gPositionReference)) {
            this.myCircles_render(0, gl);
            this.myCircles_render(1, gl);
        }
    }

    void renderPorterias(Graphics gl) {
        Point2D posCell;
        if (this.flagLinePorteriaNorth) {
            posCell = cGame.getScreenPoint(this.porteriaNorth);
            cGame.drawImage(gl, 17, posCell.x, posCell.y, 0);
        }
        if (this.flagLinePorteriaSouth) {
            posCell = cGame.getScreenPoint(this.porteriaSouth);
            cGame.drawImage(gl, 16, posCell.x, posCell.y, 0);
        }
    }

    static void clearScreen(Graphics gl) {
        if (cGame.gImages == null || cGame.gImages[2] == null) {
            gl.setClip(0, 0, 176, 204);
            gl.setColor(628690);
            gl.fillRect(0, 0, 176, 204);
        } else {
            gl.setClip(0, 0, 176, 204);
            gl.setColor(628690);
            gl.fillRect(0, 0, 176, 204);
            cGame.drawImage(gl, 2, 0, 0, 0);
        }
    }

    static int updateSelectWeather(Graphics gl, boolean painting) {
        if (cGame.giIterator == 1) {
            if (gSelectedWeather == -1) {
                cGame.giSelection = 0;
            } else if (cGame.gState == 23) {
                cGame.giSelection = (byte)(gSelectedWeather + 1);
                if (cGame.giSelection >= Texts.gTextsSetUpGameOptions[5].length - 1) {
                    cGame.giSelection = 0;
                }
            } else {
                cGame.giSelection = gSelectedWeather;
            }
            cGame.bDirty = true;
        } else {
            switch (cGame.getInput()) {
                case -7: {
                    if (cGame.gStateFootball == 23) {
                        gSelectedWeather = (byte)-1;
                        cGame.changeStateFootball((byte)21);
                    } else {
                        cGame.changeStateFootball((byte)22);
                    }
                    cGame.giIterator = 0;
                    return -1;
                }
                case 1: 
                case 2: 
                case 50: 
                case 52: {
                    if (cGame.gStateFootball != 23) break;
                    cGame.playSound(1, 1);
                    cGame.VibrationStart(500);
                    cGame.giSelection = (byte)(cGame.giSelection - 1);
                    if (cGame.giSelection < 0) {
                        cGame.giSelection = (byte)(Texts.gTextsSetUpGameOptions[cGame.idioma][5].length - 2);
                    }
                    cGame.bDirty = true;
                    break;
                }
                case 5: 
                case 6: 
                case 54: 
                case 56: {
                    if (cGame.gStateFootball != 23) break;
                    cGame.playSound(1, 1);
                    cGame.VibrationStart(500);
                    cGame.giSelection = (byte)(cGame.giSelection + 1);
                    if (cGame.giSelection >= Texts.gTextsSetUpGameOptions[cGame.idioma][5].length - 1) {
                        cGame.giSelection = 0;
                    }
                    cGame.bDirty = true;
                    break;
                }
                case -6: 
                case 8: 
                case 53: {
                    cGame.playSound(2, 1);
                    cGame.VibrationStart(500);
                    cGame.giIterator = 0;
                    return cGame.giSelection;
                }
            }
        }
        if (painting && cGame.bDirty) {
            cGame.bDirty = false;
            cWorld.clearScreen(gl);
            int yIni = 0;
            cGame.drawGoodBarWithCenteredText(gl, cGame.getTextoStatic(2, 5, 0, -1), 0, 1, 8, 0, 0x448843, 176, 22, 0, yIni, true);
            xIniSelectionTmp = 88 - (cGame.gImages[32].getWidth() >> 1);
            yIniSelectionTmp = 102 - (cGame.gImages[32].getHeight() >> 1);
            int ajusteY = 20;
            gl.setClip(0, 0, 176, 204);
            gl.setColor(7747084);
            gl.fillRect((int)cGame.gWidthScreenShift, yIniSelectionTmp - 4 - ajusteY + cGame.gHeightScreenShift, 176, 16);
            gl.setColor(0xFFFFFF);
            gl.drawRect((int)cGame.gWidthScreenShift, yIniSelectionTmp - 4 - ajusteY + cGame.gHeightScreenShift, 175, 15);
            cGame.drawGameString(gl, cGame.getTextoStatic(2, 5, cGame.giSelection + 1, -1), 88, yIniSelectionTmp - ajusteY, 0, 1);
            cGame.drawImage(gl, 32, 0, 0, 0);
            gl.setColor(3340053);
            gl.drawRect(xIniSelectionTmp + Define.IMG_WEATHER_COORDS[cGame.giSelection * 2] + cGame.gWidthScreenShift, yIniSelectionTmp + Define.IMG_WEATHER_COORDS[cGame.giSelection * 2 + 1] + cGame.gHeightScreenShift, 43, 32);
            gl.drawRect(xIniSelectionTmp + Define.IMG_WEATHER_COORDS[cGame.giSelection * 2] - 1 + cGame.gWidthScreenShift, yIniSelectionTmp + Define.IMG_WEATHER_COORDS[cGame.giSelection * 2 + 1] - 1 + cGame.gHeightScreenShift, 45, 34);
        }
        if (cGame.GameScreenTouched(xIniSelectionTmp + Define.IMG_WEATHER_COORDS[0] + cGame.gWidthScreenShift, yIniSelectionTmp + Define.IMG_WEATHER_COORDS[1] + cGame.gHeightScreenShift, xIniSelectionTmp + Define.IMG_WEATHER_COORDS[0] + cGame.gWidthScreenShift + 44 - 1, 32 + yIniSelectionTmp + Define.IMG_WEATHER_COORDS[1] + cGame.gHeightScreenShift, false, true) && cGame.gStateFootball == 23) {
            cGame.playSound(1, 1);
            cGame.VibrationStart(500);
            cGame.giSelection = 0;
            cGame.bDirty = true;
        }
        if (cGame.GameScreenTouched(xIniSelectionTmp + Define.IMG_WEATHER_COORDS[2] + cGame.gWidthScreenShift, yIniSelectionTmp + Define.IMG_WEATHER_COORDS[3] + cGame.gHeightScreenShift, xIniSelectionTmp + Define.IMG_WEATHER_COORDS[2] + cGame.gWidthScreenShift + 44 - 1, 32 + yIniSelectionTmp + Define.IMG_WEATHER_COORDS[3] + cGame.gHeightScreenShift, false, true) && cGame.gStateFootball == 23) {
            cGame.playSound(1, 1);
            cGame.VibrationStart(500);
            cGame.giSelection = 1;
            cGame.bDirty = true;
        }
        if (cGame.GameScreenTouched(xIniSelectionTmp + Define.IMG_WEATHER_COORDS[4] + cGame.gWidthScreenShift, yIniSelectionTmp + Define.IMG_WEATHER_COORDS[5] + cGame.gHeightScreenShift, xIniSelectionTmp + Define.IMG_WEATHER_COORDS[4] + cGame.gWidthScreenShift + 44 - 1, 32 + yIniSelectionTmp + Define.IMG_WEATHER_COORDS[5] + cGame.gHeightScreenShift, false, true) && cGame.gStateFootball == 23) {
            cGame.playSound(1, 1);
            cGame.VibrationStart(500);
            cGame.giSelection = (byte)2;
            cGame.bDirty = true;
        }
        if (cGame.GameScreenTouchedReleased(xIniSelectionTmp + Define.IMG_WEATHER_COORDS[0] + cGame.gWidthScreenShift, yIniSelectionTmp + Define.IMG_WEATHER_COORDS[1] + cGame.gHeightScreenShift, xIniSelectionTmp + Define.IMG_WEATHER_COORDS[0] + cGame.gWidthScreenShift + 44 - 1, 32 + yIniSelectionTmp + Define.IMG_WEATHER_COORDS[1] + cGame.gHeightScreenShift) && cGame.gStateFootball == 23) {
            cGame.giSelection = 0;
            cGame.playSound(2, 1);
            cGame.VibrationStart(500);
            cGame.giIterator = 0;
            return cGame.giSelection;
        }
        if (cGame.GameScreenTouchedReleased(xIniSelectionTmp + Define.IMG_WEATHER_COORDS[2] + cGame.gWidthScreenShift, yIniSelectionTmp + Define.IMG_WEATHER_COORDS[3] + cGame.gHeightScreenShift, xIniSelectionTmp + Define.IMG_WEATHER_COORDS[2] + cGame.gWidthScreenShift + 44 - 1, 32 + yIniSelectionTmp + Define.IMG_WEATHER_COORDS[3] + cGame.gHeightScreenShift) && cGame.gStateFootball == 23) {
            cGame.giSelection = 1;
            cGame.playSound(2, 1);
            cGame.VibrationStart(500);
            cGame.giIterator = 0;
            return cGame.giSelection;
        }
        if (cGame.GameScreenTouchedReleased(xIniSelectionTmp + Define.IMG_WEATHER_COORDS[4] + cGame.gWidthScreenShift, yIniSelectionTmp + Define.IMG_WEATHER_COORDS[5] + cGame.gHeightScreenShift, xIniSelectionTmp + Define.IMG_WEATHER_COORDS[4] + cGame.gWidthScreenShift + 44 - 1, 32 + yIniSelectionTmp + Define.IMG_WEATHER_COORDS[5] + cGame.gHeightScreenShift) && cGame.gStateFootball == 23) {
            cGame.giSelection = (byte)2;
            cGame.playSound(2, 1);
            cGame.VibrationStart(500);
            cGame.giIterator = 0;
            return cGame.giSelection;
        }
        if (cGame.GameScreenSoftkeyReleased(0)) {
            cGame.playSound(2, 1);
            cGame.VibrationStart(500);
            cGame.giIterator = 0;
            return cGame.giSelection;
        }
        if (cGame.GameScreenSoftkeyReleased(1)) {
            if (cGame.gStateFootball == 23) {
                gSelectedWeather = (byte)-1;
                cGame.changeStateFootball((byte)21);
            } else {
                cGame.changeStateFootball((byte)22);
            }
            cGame.giIterator = 0;
            return -1;
        }
        return -1;
    }

    static int updateSelectStadium(Graphics gl, boolean painting) {
        if (cGame.giIterator == 1) {
            if (gSelectedStadium == -1) {
                cGame.giSelection = 0;
            } else if (cGame.gStateFootball == 21) {
                cGame.giSelection = (byte)(gSelectedStadium + 1);
                if (cGame.giSelection >= Texts.gTextsSetUpGameOptions[6].length) {
                    cGame.giSelection = 0;
                }
            } else {
                cGame.giSelection = gSelectedStadium;
            }
            cGame.bDirty = true;
        } else {
            switch (cGame.getInput()) {
                case -7: {
                    if (cGame.gStateFootball == 21) {
                        gSelectedStadium = (byte)-1;
                    }
                    cGame.giIterator = (byte)2;
                    cGame.changeStateFootball((byte)2);
                    return -1;
                }
                case 1: 
                case 2: 
                case 50: 
                case 52: {
                    if (cGame.gStateFootball != 21) break;
                    cGame.playSound(1, 1);
                    cGame.VibrationStart(500);
                    cGame.giSelection = (byte)(cGame.giSelection - 1);
                    if (cGame.giSelection < 0) {
                        cGame.giSelection = (byte)(Texts.gTextsSetUpGameOptions[cGame.idioma][6].length - 1);
                    }
                    cGame.bDirty = true;
                    break;
                }
                case 5: 
                case 6: 
                case 54: 
                case 56: {
                    if (cGame.gStateFootball != 21) break;
                    cGame.playSound(1, 1);
                    cGame.VibrationStart(500);
                    cGame.giSelection = (byte)(cGame.giSelection + 1);
                    if (cGame.giSelection >= Texts.gTextsSetUpGameOptions[cGame.idioma][6].length) {
                        cGame.giSelection = 0;
                    }
                    cGame.bDirty = true;
                    break;
                }
                case -6: 
                case 8: 
                case 53: {
                    cGame.playSound(2, 1);
                    cGame.VibrationStart(500);
                    cGame.giIterator = 0;
                    return cGame.giSelection;
                }
            }
        }
        if (painting) {
            if (cGame.bDirty) {
                cGame.bDirty = false;
                cWorld.clearScreen(gl);
                int yIni = 0;
                cGame.drawGoodBarWithCenteredText(gl, cGame.getTextoStatic(8, 0, 0, -1), 0, 1, 8, 0, 0x448843, 176, 22, 0, yIni, true);
                int xIniSelectionTmp = 88 - (cGame.gImages[31].getWidth() >> 1);
                int yIniSelectionTmp = 102 - (cGame.gImages[31].getHeight() >> 1);
                int Ymap = 0;
                cGame.drawImage(gl, 31, 0, Ymap, 0);
                int ajusteY = 20;
                gl.setClip(0, 0, 176, 204);
                gl.setColor(7747084);
                gl.fillRect(1, yIniSelectionTmp - 4 - ajusteY + cGame.gHeightScreenShift, 172, 15);
                gl.setColor(0xFFFFFF);
                gl.drawRect(1, yIniSelectionTmp - 4 - ajusteY + cGame.gHeightScreenShift, 172, 15);
                int ajusteY2 = 30;
                yyy = yIniSelectionTmp + 12 + 107;
                int sizeMaxTmp = Utils.stringSize(cGame.getTextoStatic(8, 0, 2, -1), 7);
                int sizeTmp = Utils.stringSize(cGame.getTextoStatic(8, 0, 3, -1), 7);
                cGame.drawGameString(gl, cGame.getTextoStatic(7, cGame.giSelection, -1, -1), 88, yIniSelectionTmp - ajusteY, 0, 1);
                gl.setColor(7747084);
                gl.fillRect((int)cGame.gWidthScreenShift, (yyy -= ajusteY2) - 2 + cGame.gHeightScreenShift, 176, 25);
                gl.setColor(0xFFFFFF);
                gl.drawRect((int)cGame.gWidthScreenShift, yyy - 2 + cGame.gHeightScreenShift, 175, 24);
                int sep = 5;
                cGame.drawGameString(gl, cGame.getTextoStatic(8, 0, 2, -1), xIniSelectionTmp + sep, yyy, 2, -1);
                cGame.drawGameString(gl, cGame.getTextoStatic(8, 0, 3, -1), xIniSelectionTmp + sep, yyy + 12, 2, -1);
                if (sizeMaxTmp < sizeTmp) {
                    sizeMaxTmp = sizeTmp;
                }
                cGame.drawGameString(gl, cGame.getTextoStatic(8, 4, cGame.giSelection * 2, -1), xIniSelectionTmp + sizeMaxTmp + sep * 3, yyy, 2, -1);
                cGame.drawGameString(gl, cGame.getTextoStatic(8, 4, cGame.giSelection * 2 + 1, -1), xIniSelectionTmp + sizeMaxTmp + sep * 3, yyy + 14, 2, -1);
                if (cGame.TOUCHSCREEN_SUPPORTED && cGame.gStateFootball == 21) {
                    cGame.drawImage(gl, 53, cGame.gWidthScreenShift, yyy - 2 + cGame.gHeightScreenShift + 25, 0);
                    cGame.drawImage(gl, 54, 176 - cGame.gImages[54].getWidth(), yyy - 2 + cGame.gHeightScreenShift + 25, 0);
                }
                gl.setColor(0xFF0000);
            }
            if (cGame.TOUCHSCREEN_SUPPORTED) {
                if (cGame.GameScreenTouchedReleased(0, yyy - 2 + cGame.gHeightScreenShift + 25, 88, yyy - 2 + cGame.gHeightScreenShift + 25 + cGame.gImages[53].getHeight()) && cGame.gStateFootball == 21) {
                    cGame.playSound(1, 1);
                    cGame.VibrationStart(500);
                    cGame.giSelection = (byte)(cGame.giSelection - 1);
                    if (cGame.giSelection < 0) {
                        cGame.giSelection = (byte)(Texts.gTextsSetUpGameOptions[cGame.idioma][6].length - 1);
                    }
                    cGame.bDirty = true;
                }
                if (cGame.GameScreenTouchedReleased(88, yyy - 2 + cGame.gHeightScreenShift + 25, 176, yyy - 2 + cGame.gHeightScreenShift + 25 + cGame.gImages[53].getHeight()) && cGame.gStateFootball == 21) {
                    cGame.playSound(1, 1);
                    cGame.VibrationStart(500);
                    cGame.giSelection = (byte)(cGame.giSelection + 1);
                    if (cGame.giSelection >= Texts.gTextsSetUpGameOptions[cGame.idioma][6].length) {
                        cGame.giSelection = 0;
                    }
                    cGame.bDirty = true;
                }
                if (cGame.GameScreenSoftkeyReleased(0)) {
                    cGame.playSound(2, 1);
                    cGame.VibrationStart(500);
                    cGame.giIterator = 0;
                    return cGame.giSelection;
                }
                if (cGame.GameScreenSoftkeyReleased(1)) {
                    if (cGame.gStateFootball == 21) {
                        gSelectedStadium = (byte)-1;
                    }
                    cGame.giIterator = (byte)2;
                    cGame.changeStateFootball((byte)2);
                    return -1;
                }
            }
        }
        return -1;
    }

    static void updateMariconadaFlechas() {
    }

    static void resetMariconadaBalon(boolean resetFlechas) {
        cGame.gMariconadaBalon[0] = 0;
        cGame.gMariconadaBalon[1] = 4;
        cGame.gMariconadaBalon[2] = 0;
        cGame.gMariconadaBalon[3] = 120;
        cGame.gMariconadaBalon[4] = 0;
        cGame.gMariconadaBalon[5] = 2;
        cGame.gMariconadaBalon[6] = 0;
        cGame.gMariconadaBalon[7] = 0;
        if (resetFlechas) {
            cGame.gMariconadaFlechas[0] = 0;
            cGame.gMariconadaFlechas[1] = 2;
            cGame.gMariconadaFlechas[2] = 0;
            cGame.gMariconadaFlechas[3] = 500;
            cGame.gMariconadaFlechas[4] = 0;
            cGame.gMariconadaFlechas[5] = 0;
            cGame.gMariconadaFlechas[6] = 0;
            cGame.gMariconadaFlechas[7] = 0;
        }
    }

    static int updateSelectTeam(Graphics gl, boolean painting) {
        if (cGame.giIterator == 1) {
            if (cGame.gSelectedTeamA == -1) {
                cGame.giSelection = 0;
            } else {
                cGame.giSelection = (byte)(cGame.gSelectedTeamA + 1);
                if (cGame.giSelection >= Texts.gTeams.length) {
                    cGame.giSelection = 0;
                }
            }
            cGame.bDirty = true;
        } else {
            switch (cGame.getInput()) {
                case -7: {
                    cGame.gSelectedTeamA = (byte)-1;
                    cGame.gSelectedTeamB = (byte)-1;
                    cGame.recoverLastState();
                    return -1;
                }
                case 1: 
                case 2: 
                case 50: 
                case 52: {
                    cGame.playSound(1, 1);
                    cGame.VibrationStart(500);
                    cGame.giSelection = (byte)(cGame.giSelection - 1);
                    if (cGame.giSelection < 0) {
                        cGame.giSelection = (byte)(Texts.gTeams.length - 1);
                    }
                    cGame.bDirty = true;
                    break;
                }
                case 5: 
                case 6: 
                case 54: 
                case 56: {
                    cGame.playSound(1, 1);
                    cGame.VibrationStart(500);
                    cGame.giSelection = (byte)(cGame.giSelection + 1);
                    if (cGame.giSelection >= Texts.gTeams.length) {
                        cGame.giSelection = 0;
                    }
                    cGame.bDirty = true;
                    break;
                }
                case -6: 
                case 8: 
                case 53: {
                    cGame.playSound(2, 1);
                    cGame.VibrationStart(500);
                    cGame.giIterator = 0;
                    return cGame.giSelection;
                }
            }
        }
        if (painting && cGame.bDirty) {
            cGame.bDirty = false;
            cWorld.clearScreen(gl);
            int yIni = 0;
            if (cGame.gSelectedTeamA == -1) {
                yIni = 0;
                cGame.drawGoodBarWithCenteredText(gl, cGame.getTextoStatic(2, 0, 0, -1), 2, 1, 8, 0, 0x448843, 176, 22, 0, yIni, true);
            } else {
                cGame.drawGoodBarWithCenteredText(gl, cGame.getTextoStatic(2, 0, 1, -1), 2, 1, 8, 0, 0x448843, 176, 22, 0, yIni, true);
            }
            cGame.clearConstantRegion(gl, 2, 10);
            int xIniSelectionTmp = 2;
            int yIniSelectionTmp = 44;
            int xWidthSelectionTmp = 172;
            int yHeightSelectionTmp = 148;
            cGame.drawGameString(gl, cGame.getTextoStatic(6, cGame.giSelection, -1, -1), 88, yIniSelectionTmp + 20, 0, 1);
            cGame.drawImage(gl, 19, 80, yIniSelectionTmp + 2, cGame.giSelection);
            xIniSelectionTmp = 58;
            gl.setClip((int)cGame.gWidthScreenShift, (int)cGame.gHeightScreenShift, 176, 204);
            cGame.drawGameString(gl, cGame.getTextoStatic(2, 0, 2, -1), xIniSelectionTmp, yIniSelectionTmp + 5 * (yHeightSelectionTmp / 10), 2, 1);
            int sizeMaxTmp = Utils.stringSize(cGame.getTextoStatic(2, 0, 2, -1), 7);
            cGame.drawGameString(gl, cGame.getTextoStatic(2, 0, 3, -1), xIniSelectionTmp, yIniSelectionTmp + 7 * (yHeightSelectionTmp / 10), 2, 1);
            int sizeTmp = Utils.stringSize(cGame.getTextoStatic(2, 0, 3, -1), 7);
            if (sizeMaxTmp < sizeTmp) {
                sizeMaxTmp = sizeTmp;
            }
            cGame.drawGameString(gl, cGame.getTextoStatic(2, 0, 4, -1), xIniSelectionTmp, yIniSelectionTmp + 9 * (yHeightSelectionTmp / 10), 2, 1);
            sizeTmp = Utils.stringSize(cGame.getTextoStatic(2, 0, 4, -1), 7);
            if (sizeMaxTmp < sizeTmp) {
                sizeMaxTmp = sizeTmp;
            }
            cGame.drawBarraProperties(gl, 0, yIniSelectionTmp, xIniSelectionTmp += sizeMaxTmp / 2 + 4, 5 * (yHeightSelectionTmp / 10), 7, 10, 5, Integer.parseInt(Texts.gTeams[cGame.giSelection][1]));
            cGame.drawBarraProperties(gl, 0, yIniSelectionTmp, xIniSelectionTmp, 7 * (yHeightSelectionTmp / 10), 7, 10, 5, Integer.parseInt(Texts.gTeams[cGame.giSelection][2]));
            cGame.drawBarraProperties(gl, 0, yIniSelectionTmp, xIniSelectionTmp, 9 * (yHeightSelectionTmp / 10), 7, 10, 5, Integer.parseInt(Texts.gTeams[cGame.giSelection][3]));
        }
        if (cGame.TOUCHSCREEN_SUPPORTED) {
            if (cGame.GameScreenTouchedReleased(0, AyIniSelectionTmp, 88, AyIniSelectionTmp + cGame.gImages[53].getHeight())) {
                cGame.playSound(1, 1);
                cGame.VibrationStart(500);
                cGame.giSelection = (byte)(cGame.giSelection - 1);
                if (cGame.giSelection < 0) {
                    cGame.giSelection = (byte)(Texts.gTeams.length - 1);
                }
                cGame.bDirty = true;
            }
            if (cGame.GameScreenTouchedReleased(88, AyIniSelectionTmp, 176, AyIniSelectionTmp + cGame.gImages[54].getHeight())) {
                cGame.playSound(1, 1);
                cGame.VibrationStart(500);
                cGame.giSelection = (byte)(cGame.giSelection + 1);
                if (cGame.giSelection >= Texts.gTeams.length) {
                    cGame.giSelection = 0;
                }
                cGame.bDirty = true;
            }
            if (cGame.GameScreenSoftkeyReleased(0)) {
                cGame.playSound(2, 1);
                cGame.VibrationStart(500);
                cGame.giIterator = 0;
                return cGame.giSelection;
            }
            if (cGame.GameScreenSoftkeyReleased(1)) {
                cGame.gSelectedTeamA = (byte)-1;
                cGame.gSelectedTeamB = (byte)-1;
                cGame.recoverLastState();
                return -1;
            }
        }
        return -1;
    }

    static {
        zoneGoal = 0;
        xIniSelectionTmp = 0;
        yIniSelectionTmp = 0;
        yyy = 0;
        AyIniSelectionTmp = 0;
    }
}

