/*
 * Decompiled with CFR 0.152.
 */
package screens;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import main.MainCanvas;
import utils.Utils;

public class GameOverScreen {
    private Image gameOver;
    private Image newHighScore;
    private Image totalScore;
    private Image popup;
    private Image coin;
    private Image bg;
    private LayerManager selectionLayer;
    private Sprite LSK;
    private Sprite RSK;

    public GameOverScreen() {
        this.init();
    }

    private void init() {
        try {
            this.newHighScore = Image.createImage((String)"/images/new_highscore.png");
            this.totalScore = Image.createImage((String)"/images/new_score.png");
            this.popup = Image.createImage((String)"/images/info_box.png");
            this.coin = Image.createImage((String)"/images/score_coin.png");
            this.bg = Image.createImage((String)"/images/menu_background.png");
            this.generateSelection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generateSelection() {
        try {
            Image softkeys = Image.createImage((String)"/images/sel_sk.png");
            int softkeyWidth = softkeys.getWidth() / 4;
            this.LSK = new Sprite(softkeys, softkeyWidth, softkeys.getHeight());
            this.LSK.setFrame(0);
            this.LSK.setPosition(0, MainCanvas.height - softkeys.getHeight());
            this.RSK = new Sprite(softkeys, softkeyWidth, softkeys.getHeight());
            this.RSK.setFrame(3);
            this.RSK.setPosition(MainCanvas.width - softkeyWidth, MainCanvas.height - softkeys.getHeight());
            this.selectionLayer = new LayerManager();
            this.selectionLayer.append((Layer)this.LSK);
            this.selectionLayer.append((Layer)this.RSK);
            this.selectionLayer.setViewWindow(0, 0, MainCanvas.width, MainCanvas.height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int touch(int x, int y) {
        int type = -1;
        if (x >= this.LSK.getX() && x <= this.LSK.getX() + this.LSK.getWidth() && y >= this.LSK.getY() && y <= this.LSK.getY() + this.LSK.getHeight()) {
            type = this.input(-6);
        } else if (x >= this.RSK.getX() && x <= this.RSK.getX() + this.RSK.getWidth() && y >= this.RSK.getY() && y <= this.RSK.getY() + this.RSK.getHeight()) {
            type = this.input(-7);
        }
        return type;
    }

    public int input(int keyStates) {
        switch (keyStates) {
            case -7: 
            case 256: {
                this.close();
                return 0;
            }
            case -6: {
                this.close();
                return 13;
            }
        }
        return -1;
    }

    public void paint(Graphics g, int scrWidth, int scrHeight) {
        int yPos = MainCanvas.height / 3;
        yPos = Utils.getCenterVPosition(MainCanvas.letters.getStringHeight() + 5 + this.newHighScore.getHeight() + this.totalScore.getHeight() + this.popup.getHeight(), MainCanvas.height);
        g.drawImage(this.bg, 0, 0, 0);
        MainCanvas.letters.drawString(g, Utils.getText(23), Utils.getCenterPosition(MainCanvas.letters.getStringWidth(Utils.getText(23)), MainCanvas.width), yPos, -1);
        yPos += MainCanvas.letters.getStringHeight() + 5;
        if (MainCanvas.isNewHighscore) {
            g.drawImage(this.newHighScore, Utils.getCenterPosition(this.newHighScore.getWidth(), MainCanvas.width), yPos, 0);
            MainCanvas.letters.drawString(g, Utils.getText(24), Utils.getCenterPosition(0, Utils.getText(24), MainCanvas.width), yPos + Utils.getCenterVPosition(MainCanvas.letters.getStringHeight(), this.newHighScore.getHeight()), -1);
        }
        g.drawImage(this.totalScore, Utils.getCenterPosition(this.totalScore.getWidth(), MainCanvas.width), yPos += this.newHighScore.getHeight(), 0);
        MainCanvas.letters.drawString(g, MainCanvas.getAvatar().getTotalScore() + "", Utils.getCenterPosition(0, MainCanvas.getAvatar().getTotalScore() + "", MainCanvas.width), yPos + Utils.getCenterVPosition(MainCanvas.letters.getStringHeight(), this.totalScore.getHeight()), -1);
        int popupX = Utils.getCenterPosition(this.popup.getWidth(), MainCanvas.width);
        int popupTextY = Utils.getCenterVPosition(MainCanvas.letters.getStringHeight(), this.popup.getHeight() / 2);
        g.drawImage(this.popup, popupX, yPos += this.totalScore.getHeight(), 0);
        MainCanvas.letters.drawString(g, Utils.getText(27), popupX + 10, yPos + popupTextY, -1);
        MainCanvas.letters.drawString(g, MainCanvas.getAvatar().getScore() + "", popupX + MainCanvas.letters.getStringWidth(Utils.getText(27)) + 15, yPos + popupTextY, -1);
        int yCoin = yPos + this.popup.getHeight() / 2 + popupTextY;
        if (MainCanvas.height < MainCanvas.width) {
            yCoin = yPos + this.popup.getHeight() / 4 + popupTextY;
        }
        MainCanvas.letters.drawString(g, Utils.getText(26), popupX + 10, yCoin, -1);
        MainCanvas.letters.drawString(g, MainCanvas.getAvatar().getCoinsCollected() + "", popupX + MainCanvas.letters.getStringWidth(Utils.getText(26)) + 15, yCoin, -1);
        yPos += this.popup.getHeight();
        this.selectionLayer.paint(g, 0, 0);
    }

    public void close() {
        this.gameOver = null;
        this.newHighScore = null;
        this.totalScore = null;
        this.popup = null;
        this.LSK = null;
        this.RSK = null;
    }
}

