/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class MiniFruits
extends MiniGame {
    private static final int MAX_FRUITS = 12;
    private static final int MAX_LOW_FRUITS = 6;
    private static final int PEAR = 0;
    private static final int PEAR_DIF = 1;
    private static final int CHERRY = 2;
    private static final int CHERRY_DIF = 3;
    private static final int LEMON = 4;
    private static final int LEMON_DIF = 5;
    private static final int APPLE = 6;
    private static final int APPLE_DIF = 7;
    private static final int ORANGE = 8;
    private static final int ORANGE_DIF = 9;
    private static final int PEACH = 10;
    private static final int PEACH_DIF = 11;
    private static final int BAR = 12;
    private static final int BOX = 13;
    private static final int EXTRALINES = 4;
    private static final int MAX_RANDOMPERCENT = 40;
    private int[] mFruitsColumns;
    private int mFruitsRows;
    private int mFruitsHeight;
    private int mScrollDown;
    private boolean doScroll;
    private int mFruitWidth;
    private int mPosXInit;
    private int mPosYInit;
    private int mRandomPercentage;
    private int mNumCorrects;
    private boolean mFail;
    private int mBoxesY;
    private int mBoxesSpeed;

    public MiniFruits(int n, int n2) {
        this.mBackground = new SpriteObject(SpriteObject.loadAnimation(720897), false);
        this.initialize(n, n2);
        this.createButtons(SpriteObject.loadAnimations(new int[]{917529, 589868}), SpriteObject.loadAnimations(new int[]{655444, 589875}));
        this.mSpritesPool = new SpriteObject[14];
        this.mSpritesPool[0] = new SpriteObject(SpriteObject.loadAnimation(655430), false);
        this.mSpritesPool[1] = new SpriteObject(SpriteObject.loadAnimation(655428), false);
        this.mSpritesPool[2] = new SpriteObject(SpriteObject.loadAnimation(655427), false);
        this.mSpritesPool[3] = new SpriteObject(SpriteObject.loadAnimation(655425), false);
        this.mSpritesPool[4] = new SpriteObject(SpriteObject.loadAnimation(655421), false);
        this.mSpritesPool[5] = new SpriteObject(SpriteObject.loadAnimation(655419), false);
        this.mSpritesPool[6] = new SpriteObject(SpriteObject.loadAnimation(655433), false);
        this.mSpritesPool[7] = new SpriteObject(SpriteObject.loadAnimation(655431), false);
        this.mSpritesPool[8] = new SpriteObject(SpriteObject.loadAnimation(655424), false);
        this.mSpritesPool[9] = new SpriteObject(SpriteObject.loadAnimation(655422), false);
        this.mSpritesPool[10] = new SpriteObject(SpriteObject.loadAnimation(655418), false);
        this.mSpritesPool[11] = new SpriteObject(SpriteObject.loadAnimation(655416), false);
        this.mSpritesPool[12] = new SpriteObject(SpriteObject.loadAnimation(589873), true);
        this.mSpritesPool[13] = new SpriteObject(SpriteObject.loadAnimation(131095), true);
        this.mFruitWidth = this.mSpritesPool[6].getWidth() + 12;
        this.mFruitsHeight = this.mSpritesPool[0].getHeight() + 6;
        this.mFruitsRows = this.mCanvasHeight / this.mFruitsHeight;
        this.mPosXInit = (this.mCanvasWidth - this.mFruitWidth * 3) / 2 + this.mCanvasX + this.mSpritesPool[6].getPivotX() + 6;
        this.mPosYInit = this.mCanvasY + this.mCanvasHeight - this.mFruitsHeight - (this.mCanvasHeight - this.mFruitsHeight * this.mFruitsRows) / 2;
        this.mFruitsColumns = new int[(this.mFruitsRows + 4) * 3];
        for (int i = 0; i < this.mFruitsRows + 4; ++i) {
            this.createNewFruit(i);
        }
        this.doScroll = false;
        this.mNumCorrects = 0;
        this.mRandomPercentage = 0;
        this.mBoxesY = -this.mCanvasHeight;
        this.mBoxesSpeed = 1;
    }

    protected boolean checkAnswer(int n) {
        if (mMiniGameID == 11) {
            return this.mHudConfirmationTicks <= 0;
        }
        if (this.mGameMode == 1) {
            return this.mHudConfirmationTicks <= 0;
        }
        return true;
    }

    protected void drawGame(Graphics graphics) {
        int n;
        int n2 = this.mPosYInit;
        graphics.setClip(this.mCanvasX, this.mCanvasY, this.mCanvasWidth, this.mCanvasHeight);
        this.mSpritesPool[12].draw(graphics, this.mCanvasWidth / 2 + this.mCanvasX + 3, n2 + this.mSpritesPool[12].getPivotY() + 6);
        graphics.setClip(this.mCanvasX, n2 - this.mFruitsRows * this.mFruitsHeight + this.mFruitsHeight, this.mCanvasWidth, this.mFruitsRows * this.mFruitsHeight);
        n2 -= this.mScrollDown;
        n2 += this.mFruitsHeight * 2 - this.mSpritesPool[0].getPivotY();
        for (n = 0; n < this.mFruitsRows + 2; ++n) {
            for (int i = 0; i < 3; ++i) {
                this.mSpritesPool[this.mFruitsColumns[i + (n + 2) * 3]].draw(graphics, this.mPosXInit + this.mFruitWidth * i, n2);
            }
            n2 -= this.mFruitsHeight;
        }
        if (mMiniGameID == 11) {
            if (this.mState[this.mGameMode] == 3) {
                for (n = 0; n < this.mFruitsRows - 1; ++n) {
                    this.mSpritesPool[13].draw(graphics, this.mPosXInit + this.mFruitWidth - this.mFruitWidth / 2, this.mPosYInit - (this.mFruitsRows - 1) * this.mFruitsHeight + this.mFruitsHeight * n + this.mBoxesY);
                }
                this.mSpritesPool[13].draw(graphics, this.mPosXInit - this.mFruitWidth / 2, this.mPosYInit - this.mFruitsHeight + this.mFruitsHeight + this.mBoxesY);
                this.mSpritesPool[13].draw(graphics, this.mPosXInit + this.mFruitWidth * 2 - this.mFruitWidth / 2, this.mPosYInit - this.mFruitsHeight + this.mFruitsHeight + this.mBoxesY);
            } else {
                for (n = 0; n < this.mFruitsRows - 1; ++n) {
                    this.mSpritesPool[13].draw(graphics, this.mPosXInit + this.mFruitWidth - this.mFruitWidth / 2, this.mPosYInit - (this.mFruitsRows - 1) * this.mFruitsHeight + this.mFruitsHeight * n);
                }
                if (this.mState[this.mGameMode] == 4) {
                    this.mSpritesPool[13].draw(graphics, this.mPosXInit - this.mFruitWidth / 2, this.mPosYInit - this.mFruitsHeight + this.mFruitsHeight);
                    this.mSpritesPool[13].draw(graphics, this.mPosXInit + this.mFruitWidth * 2 - this.mFruitWidth / 2, this.mPosYInit - this.mFruitsHeight + this.mFruitsHeight);
                } else {
                    for (n = 0; n < this.mFruitsRows / 2 - 1; ++n) {
                        this.mSpritesPool[13].draw(graphics, this.mPosXInit - this.mFruitWidth / 2, this.mPosYInit - this.mFruitsHeight + n * this.mFruitsHeight);
                        this.mSpritesPool[13].draw(graphics, this.mPosXInit + this.mFruitWidth * 2 - this.mFruitWidth / 2, this.mPosYInit - this.mFruitsHeight + n * this.mFruitsHeight);
                    }
                }
            }
        }
    }

    private void createNewFruit(int n) {
        int n2;
        int n3 = 12;
        int n4 = n2 = MiniFruits.rnd(n3);
        int n5 = n2;
        int n6 = n2;
        if (MiniFruits.rnd(100) < this.mRandomPercentage) {
            if (MiniFruits.rnd(100) < 50) {
                n4 = (n2 + n2 % 2) % n3;
                n6 = n4 + 1;
            } else {
                n4 = (n2 + n2 % 2 + 1) % n3;
                if (n4 == 0) {
                    ++n4;
                }
                n6 = n4 - 1;
            }
            n5 = n4;
            if (MiniFruits.rnd(100) < 50) {
                n5 = n6;
            }
        } else {
            while (n4 == (n6 = MiniFruits.rnd(n3)) - 1 || n4 == n6 || n4 == n6 + 1) {
            }
            if (MiniFruits.rnd(100) >= 50) {
                int n7 = n4;
                n4 = n6;
                n6 = n7;
            }
        }
        this.mFruitsColumns[n * 3] = n4;
        this.mFruitsColumns[n * 3 + 1] = n5;
        this.mFruitsColumns[n * 3 + 2] = n6;
    }

    protected void initNextQuestion() {
        if (this.mNumCorrects == 3) {
            if (this.mRandomPercentage < 40) {
                this.mRandomPercentage += 5;
            }
            this.mNumCorrects = 0;
        }
        if (this.mFail) {
            if (this.mRandomPercentage > 0) {
                this.mRandomPercentage -= 10;
                if (this.mRandomPercentage < 0) {
                    this.mRandomPercentage = 0;
                }
            }
            this.mFail = false;
        }
        for (int i = 0; i < this.mFruitsRows - 1 + 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.mFruitsColumns[i * 3 + j] = this.mFruitsColumns[(i + 1) * 3 + j];
            }
        }
        this.createNewFruit(this.mFruitsRows - 1 + 4);
        if (this.doScroll) {
            this.mScrollDown = this.mFruitsHeight;
            this.doScroll = false;
        }
    }

    protected int isCorrectAnswer(int n) {
        if (n != 0) {
            int n2 = this.mFruitsColumns[9];
            int n3 = this.mFruitsColumns[10];
            int n4 = this.mFruitsColumns[11];
            int n5 = Toolkit.getToolkitGameAction(n);
            if (n5 == 52 || n == 52) {
                this.pressButton(0, n2 == n3, false);
                this.mHudConfirmationPosX = this.mPosXInit + this.mFruitWidth / 2;
                this.mHudConfirmationPosY = this.mPosYInit + (this.mFruitsHeight >> 1);
                if (mMiniGameID == 11) {
                    this.mHudConfirmationTicks = 500;
                }
                this.doScroll = true;
                if (n2 == n3) {
                    ++this.mNumCorrects;
                    this.registerParticle(this.mHudConfirmationPosX, this.mHudConfirmationPosY);
                    return 0;
                }
                this.mNumCorrects = 0;
                this.mFail = true;
                return 1;
            }
            if (n5 == 54 || n == 54) {
                this.pressButton(1, n4 == n3, false);
                this.mHudConfirmationPosX = this.mFruitWidth * 2 + this.mPosXInit - 12;
                this.mHudConfirmationPosY = this.mPosYInit + (this.mFruitsHeight >> 1);
                if (mMiniGameID == 11) {
                    this.mHudConfirmationTicks = 500;
                }
                this.doScroll = true;
                if (n4 == n3) {
                    ++this.mNumCorrects;
                    this.registerParticle(this.mHudConfirmationPosX, this.mHudConfirmationPosY);
                    return 0;
                }
                this.mNumCorrects = 0;
                this.mFail = true;
                return 1;
            }
        }
        return 3;
    }

    protected void updateGame(int n) {
        this.mSpritesPool[12].logicUpdate(n);
        if (this.mScrollDown > 0) {
            while (this.mProcessedTime < this.mElapsedTime) {
                this.mScrollDown -= this.mFruitsHeight / 6;
                this.mProcessedTime += 50;
            }
            if (this.mScrollDown < 0) {
                this.mScrollDown = 0;
            }
        }
    }

    protected boolean updateWatch(int n) {
        if (mMiniGameID == 11) {
            this.mDrawButtons = false;
            while (this.mProcessedTime < this.mElapsedTime) {
                this.mProcessedTime += 50;
                if (this.mPosYInit - (this.mFruitsRows - 1) * this.mFruitsHeight + this.mBoxesY < this.mPosYInit - (this.mFruitsRows - 1) * this.mFruitsHeight) {
                    this.mBoxesY += this.mBoxesSpeed;
                    if (this.mBoxesSpeed >= 10) continue;
                    ++this.mBoxesSpeed;
                    continue;
                }
                this.mDrawButtons = true;
                return true;
            }
            return false;
        }
        return true;
    }
}

