/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Game
implements FlowHandler,
MenuIDs {
    private static final boolean DEBUG_QUERY_BRANCH_VALUES = false;
    private static final String RECORD_STORE_NAME = "gamedata";
    private static final String RECORD_STORE_NAME_SETTINGS = "settings";
    private static final boolean USE_VOLUME_SLIDERS = false;
    private static final boolean SAVING_SETTINGS_REQUIRED = true;
    private ApplicationControl mApplicationControl;
    private GameEngine mGameEngine;
    private Image mDchocLogo;
    private int mDchocLogoCounter;
    private static final int DCHOC_LOGO_DURATION = 3000;
    private int mTitleCounter;
    private static final int TITLE_DURATION = 2000;
    private MenuObject mCurrentMenu;
    private MenuObject mLastMenu;
    private int mCurrentState;
    private int mLastState;
    public static boolean mPauseEventScheduled;
    public static boolean mMusicEnabled;
    private boolean mMLLoading;
    public static final int NO_MUSIC = -1;
    private static final int MUSIC_TITLE = 0;
    public static int mCurrentMusic;
    private static final int[] SOUNDS;
    private boolean mGMGBrowserStarted;
    private int mSelectedLanguage = -1;
    private static boolean mSoundsEnabled;
    private boolean mVibraEnabled;
    private static final int[] CHEAT_CODE;
    private boolean mCheatsEnabled;
    private int[] mCheatCodeInputBuffer = new int[CHEAT_CODE.length];
    private int mCheatCodeInputBufferIndex;
    private int mCheatBoxTimer;
    private static final int CHEAT_BOX_DURATION = 2000;
    private boolean mEnableMobileLeague;
    private boolean mEnableTellAFriend;
    private boolean mEnableGetMoreGames;
    private boolean mEnableLicenseManager;
    private boolean mEnableLicenseManagerMenuItem;
    private IHighScore mHighscore;
    private ILicenseManager mLicenseManager;
    private MenuObject mLanguageQueryMenu;
    private MenuObject mSettingsLanguageMenu;
    private boolean mLicenseManagerActivated;
    private boolean mLicenseManagerAtStartup;
    private ImageFont mSimpleFont;
    private static final boolean LIMIT_RECORD_STORE;
    private static final int LANGUAGE_UNDEFINED = -1;
    private boolean mMenuResourcesLoaded;
    private static Image[] smImageGMG;
    private int mGameCategory;
    public static int mGameSelection;
    public static boolean mustSaveGame;
    private boolean mPlayedBefore = false;
    boolean bDoublePause;
    int[] gameTitles = new int[]{66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89};
    private MenuObject[] mCategorySubMenus;

    public Game(ApplicationControl applicationControl, ImageFont imageFont, ImageFont imageFont2, ImageFont imageFont3) {
        this.mApplicationControl = applicationControl;
        this.mGameEngine = new GameEngine(imageFont, imageFont2, imageFont3);
        this.mEnableMobileLeague = false;
        this.mEnableTellAFriend = false;
        this.mEnableGetMoreGames = false;
        boolean bl = this.mEnableLicenseManager = Toolkit.getToolkitProperty(10) != null;
        if (this.mEnableLicenseManager) {
            this.mLicenseManager = Toolkit.getLicenseManager();
            this.mEnableLicenseManagerMenuItem = this.mLicenseManager.getLicenseManagerMenuItemLabel() != null;
        }
        try {
            this.mSimpleFont = new ImageFont(null, null, Font.getFont((int)32, (int)0, (int)8), 0, -1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.loadGame();
        mCurrentMusic = -1;
        this.loadSettings();
    }

    private void createCheatBox(MenuObject menuObject) {
        int n = Toolkit.getScreenWidth() - (Toolkit.getScreenWidth() >> 2);
        int n2 = Toolkit.getScreenHeight() - (Toolkit.getScreenHeight() >> 2) - Toolkit.getSoftKeyAreaHeight();
        int n3 = Toolkit.getScreenWidth() - n >> 1;
        int n4 = Toolkit.getScreenHeight() - n2 >> 1;
        menuObject.setBounds(n3, n4, n, n2);
    }

    public void pauseGame() {
        if (this.mCurrentState == 35 && GameEngine.mGameState != 3) {
            mPauseEventScheduled = true;
            GameEngine.bSoundFlag = false;
        } else if (GameEngine.mGameState == 3) {
            GameEngine.bSoundFlag = true;
        }
        mMusicEnabled = false;
        mCurrentMusic = -1;
    }

    public void screenSizeChanged() {
        if (this.mCurrentState != 30 && this.mCurrentState != 31 && this.mCurrentState == 34 && this.mEnableLicenseManager) {
            this.mLicenseManager.initMenus();
        }
        this.mGameEngine.screenSizeChanged();
    }

    public int logicUpdate(int n, int n2) {
        if (this.mEnableLicenseManager && this.mLicenseManagerActivated) {
            this.mLicenseManagerActivated = false;
            return 19;
        }
        switch (n) {
            case 28: {
                this.mDchocLogoCounter -= n2;
                if (this.mDchocLogoCounter >= 0) break;
                return -2;
            }
            case 29: {
                this.mTitleCounter -= n2;
                MenuObject.mGears.logicUpdate(n2);
                if (this.mTitleCounter >= 0) break;
                return -2;
            }
            case 32: 
            case 33: {
                int n3;
                if (!this.mEnableLicenseManager || (n3 = this.mLicenseManager.logicUpdate(n2)) == 0) break;
                return -2;
            }
            case 35: {
                if (mPauseEventScheduled) {
                    mPauseEventScheduled = false;
                    return 3;
                }
                int n4 = 0;
                n4 = this.mGameEngine.logicUpdate(n2);
                if (mustSaveGame) {
                    mustSaveGame = false;
                    this.saveGame();
                }
                if (n4 == 1) {
                    Toolkit.stopMusic();
                    return 3;
                }
                if (n4 != 2) break;
                if (!this.mCheatsEnabled) {
                    boolean bl = false;
                }
                this.saveGame();
                return 4;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 34: {
                if (this.mLicenseManager.logicUpdate(n2) != 4) break;
                return -2;
            }
            case 0: {
                if (this.mCheatBoxTimer <= 0) break;
                return -1000;
            }
            case 26: {
                if (this.mCheatBoxTimer <= 0) break;
                this.mCheatBoxTimer -= n2;
                if (this.mCheatBoxTimer > 0) break;
                return -3;
            }
        }
        return -1;
    }

    public void doDraw(int n, Graphics graphics) {
        switch (n) {
            case 32: 
            case 33: {
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
                this.mLicenseManager.doDraw(graphics);
                break;
            }
            case 28: {
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
                graphics.drawImage(this.mDchocLogo, Toolkit.getScreenWidth() >> 1, Toolkit.getScreenHeight() >> 1, 3);
                break;
            }
            case 29: {
                DCPack.drawLoadingScreen(graphics, null, -10, 28);
                break;
            }
            case 35: {
                this.mGameEngine.doDraw(graphics);
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 34: {
                this.mLicenseManager.doDraw(graphics);
                break;
            }
            case 26: {
                if (this.mLastMenu == null) break;
                this.mLastMenu.doDraw(graphics);
            }
        }
        if (this.mMLLoading) {
            DCPack.drawLoadingScreen(graphics, null, 50, this.mCurrentState);
        }
    }

    public void switchState(int n, int n2, MenuObject menuObject) {
        switch (n2) {
            case 37: {
                if (!this.mEnableLicenseManager) break;
                this.mLicenseManagerAtStartup = this.mLicenseManager.setState(2);
                break;
            }
            case 28: {
                this.mDchocLogoCounter = 3000;
                break;
            }
            case 29: {
                this.mTitleCounter = 2000;
                break;
            }
            case 0: {
                this.mLastMenu = null;
                break;
            }
            case 30: {
                break;
            }
            case 34: {
                this.mLicenseManager.setState(4);
                break;
            }
            case 14: {
                this.setCategoryMenu(menuObject, this.mGameCategory);
                break;
            }
            case 24: {
                menuObject.setStyle(5);
                menuObject.setItem(0, 1, Toolkit.getText(435), null, -1);
                menuObject.setBounds(6, Toolkit.getScreenHeight() / 8, Toolkit.getScreenWidth() - 12, Toolkit.getScreenHeight() / 2 + 0);
                menuObject.configSpeechBubble(true, true, true);
                break;
            }
            case 25: {
                menuObject.setStyle(5);
                menuObject.setItem(0, 1, Toolkit.getText(436), null, -1);
                menuObject.setBounds(6, Toolkit.getScreenHeight() / 8, Toolkit.getScreenWidth() - 12, Toolkit.getScreenHeight() / 4);
                menuObject.configSpeechBubble(true, true, true);
                break;
            }
            case 19: {
                menuObject.setItem(0, 1, Toolkit.getText(426), null, -1);
                menuObject.setBounds(6, Toolkit.getScreenHeight() / 7, Toolkit.getScreenWidth() - 12, Toolkit.getScreenHeight() / 2);
                break;
            }
            case 13: {
                menuObject.setItem(0, 1, Toolkit.getText(157), null, -1);
                menuObject.setBounds(6, Toolkit.getScreenHeight() / 8, Toolkit.getScreenWidth() - 12, Toolkit.getScreenHeight() / 3 + 0);
                menuObject.configSpeechBubble(true, true, true);
                break;
            }
            case 21: {
                menuObject.setSelectedItem(mGameSelection);
                mGameSelection = 0;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 26: {
                this.createCheatBox(menuObject);
                menuObject.configSpeechBubble(false, false, false);
            }
        }
        Game.updateMusic(n2);
        this.mCurrentMenu = menuObject;
        if (this.mCurrentState != n2) {
            this.mLastState = this.mCurrentState;
        }
        if (this.mLastState == 23) {
            this.mCurrentMenu.setSelectedItem(4);
        } else if (this.mLastState == 21 && n2 == 12) {
            this.mCurrentMenu.setSelectedItem(3);
        } else if (this.mLastState == 14 && n2 == 12) {
            this.mCurrentMenu.setSelectedItem(1);
        }
        this.mCurrentState = n2;
        if (this.mCurrentMenu != null) {
            this.mCurrentMenu.setCustom(n2);
        }
    }

    private void loadMenuResources() {
        this.mMenuResourcesLoaded = true;
    }

    private void freeMenuResources() {
        this.mMenuResourcesLoaded = false;
    }

    private void loadAchievementsMenuResources() {
        MenuObject.mAchievLocked = new SpriteObject(SpriteObject.loadAnimation(65589), true);
        MenuObject.mAchievUnLocked = new SpriteObject(SpriteObject.loadAnimation(65593), true);
        MenuObject.achievCurrent = -1;
        MenuObject.achievNumber = 1;
        while (GameEngine.ACHIEVEMENTS_NAMES[++MenuObject.achievCurrent] < 0) {
        }
    }

    private void freeAchievementsMenuResources() {
        MenuObject.mAchievLocked.freeResources();
        MenuObject.mAchievLocked = null;
        MenuObject.mAchievUnLocked.freeResources();
        MenuObject.mAchievUnLocked = null;
    }

    public void keyEventOccurred(int n, int n2, int n3) {
        boolean bl;
        int n4 = Toolkit.getToolkitGameAction(n2);
        boolean bl2 = bl = n3 == 0 && n4 == 53 || n3 == 3 && Toolkit.getSoftKeyType(n2) == 0;
        if (!mMusicEnabled && (bl || n3 == 3)) {
            mMusicEnabled = true;
        }
        switch (n) {
            case 8: {
                if (n3 != 0 || n4 != 50 && n4 != 56) break;
                int n5 = this.mLanguageQueryMenu.getSelectedItem();
                Toolkit.setSoftKeyLabel(0, Toolkit.getLanguageDescriptions()[n5][1]);
                break;
            }
            case 32: 
            case 33: {
                this.mLicenseManager.keyEventOccurred(n2, n3);
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 34: {
                this.mLicenseManager.keyEventOccurred(n2, n3);
                break;
            }
            case 35: {
                this.mGameEngine.keyEventOccurred(n2, n3);
                break;
            }
            case 28: {
                if (!bl) break;
                this.mDchocLogoCounter = 0;
                break;
            }
            case 29: {
                if (!bl) break;
                this.mTitleCounter = 0;
                break;
            }
            case 0: {
                int n6;
                if (n3 != 0 || Toolkit.getToolkitProperty(16) == null) break;
                this.mCheatCodeInputBuffer[this.mCheatCodeInputBufferIndex % Game.CHEAT_CODE.length] = n2 & 0xF;
                boolean bl3 = false;
                for (int i = 0; i < CHEAT_CODE.length && !bl3; ++i) {
                    n6 = this.mCheatCodeInputBuffer[(this.mCheatCodeInputBufferIndex + i + 1) % CHEAT_CODE.length];
                    if (n6 == CHEAT_CODE[i]) continue;
                    bl3 = true;
                }
                if (!bl3) {
                    this.mCheatsEnabled = true;
                    this.mGameEngine.mCheatsEnabled = true;
                    for (n6 = 0; n6 < 24; ++n6) {
                        GameEngine.mMiniGameUnlocked[n6] = true;
                    }
                    for (n6 = 0; n6 < GameEngine.achievementDone.length; ++n6) {
                        GameEngine.achievementDone[n6] = true;
                    }
                    this.mCheatBoxTimer = 2000;
                    this.mLastMenu = this.mCurrentMenu;
                }
                ++this.mCheatCodeInputBufferIndex;
                break;
            }
            case 26: {
                if (!bl) break;
                this.mCheatBoxTimer = 1;
            }
        }
    }

    public void pointerEventOccurred(int n, int n2, int n3, int n4) {
        switch (n) {
            case 8: {
                if (n4 != 0) break;
                int n5 = this.mLanguageQueryMenu.getSelectedItem();
                Toolkit.setSoftKeyLabel(0, Toolkit.getLanguageDescriptions()[n5][1]);
                break;
            }
            case 32: 
            case 33: {
                this.mLicenseManager.pointerEventOccurred(n2, n3, n4);
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 34: {
                this.mLicenseManager.pointerEventOccurred(n2, n3, n4);
                break;
            }
            case 28: {
                if (n4 != 0) break;
                this.mDchocLogoCounter = 0;
                break;
            }
            case 29: {
                if (n4 != 0) break;
                this.mTitleCounter = 0;
                break;
            }
            case 35: {
                this.mGameEngine.pointerEventOccurred(n2, n3, n4);
            }
        }
    }

    public boolean evaluateBranchCondition(int n) {
        switch (n) {
            case 36: {
                return this.mSelectedLanguage == -1;
            }
            case 37: {
                return this.mEnableLicenseManager && this.mLicenseManagerAtStartup;
            }
            case 40: {
                if (!GameEngine.mShowingStatistics && !GameEngine.mRunningTestMode) {
                    return this.mGameEngine.mMiniGameId < 24;
                }
                GameEngine.mRunningTestMode = false;
                return false;
            }
            case 44: {
                if (GameEngine.mShowingStatistics) {
                    GameEngine.mShowingStatistics = false;
                    return true;
                }
                return false;
            }
            case 43: {
                return this.mGameCategory == 0;
            }
            case 41: {
                return this.mGameCategory == 1;
            }
            case 42: {
                return this.mGameCategory == 2;
            }
            case 39: {
                if (this.mLastState == 12 || this.mLastState == 21) {
                    return true;
                }
                if (GameEngine.mRunningTestMode || GameEngine.mShowingStatistics || GameEngine.mRunningStupidTest) {
                    return true;
                }
                if (this.mGameEngine.mMiniGameId > 23) {
                    return true;
                }
                return GameEngine.mMiniGameUnlocked[this.mGameEngine.mMiniGameId];
            }
            case 38: {
                boolean bl = this.mPlayedBefore;
                this.mPlayedBefore = true;
                return bl;
            }
            case 45: {
                return this.mEnableLicenseManager && this.mLicenseManagerAtStartup;
            }
        }
        return false;
    }

    public void drawMenu(int n, Graphics graphics, MenuObject menuObject) {
        if (this.mCurrentState == 14) {
            menuObject.doDrawCategory(graphics, 0, 0);
        } else {
            if (this.mLastMenu != null && this.mCurrentState == 19) {
                this.mLastMenu.doDrawCategory(graphics, 0, 0);
            }
            menuObject.doDraw(graphics);
        }
    }

    public void eventOccurred(int n, int n2) {
        switch (n2) {
            case 17: {
                this.mSelectedLanguage = this.mLanguageQueryMenu.getSelectedItem();
                this.mApplicationControl.setLanguage(this.mSelectedLanguage);
                this.saveSettings(true);
                this.mLanguageQueryMenu = null;
                break;
            }
            case 1: {
                this.mSelectedLanguage = this.mSettingsLanguageMenu.getSelectedItem();
                this.mApplicationControl.setLanguage(this.mSelectedLanguage);
                MenuObject.mTitleSprite = Toolkit.getImage(65536);
                this.saveSettings(true);
                this.mSettingsLanguageMenu = null;
                break;
            }
            case 8: {
                DChocMIDlet.getInstance().m_exitApplication = true;
                break;
            }
            case 5: {
                this.setSoundsEnabled(true);
                this.mSimpleFont = null;
                break;
            }
            case 6: {
                this.setSoundsEnabled(false);
                this.mSimpleFont = null;
                break;
            }
            case 9: 
            case 14: {
                int n3 = n2 == 9 ? 0 : 1;
                int n4 = this.mCurrentMenu.getItemIntValue(n3);
                this.setSoundsEnabled(n4 != 0);
                if (n4 == 0) break;
                Toolkit.playMusic(65544, 1);
                break;
            }
            case 10: 
            case 15: {
                break;
            }
            case 11: 
            case 16: {
                int n5 = n2 == 11 ? 2 : 3;
                int n6 = this.mCurrentMenu.getItemIntValue(n5);
                this.mVibraEnabled = n6 != 0;
                Toolkit.setVibraEnabled(this.mVibraEnabled);
                if (this.mVibraEnabled) {
                    Toolkit.vibrate(500);
                }
                this.saveSettings(false);
                break;
            }
            case 13: {
                this.mGameEngine.continueGame();
                mMusicEnabled = true;
                break;
            }
            case 7: {
                this.mGameEngine.playGame();
                break;
            }
            case 0: {
                this.mGameCategory = this.mCurrentState;
                mGameSelection = this.mCurrentMenu.getSelectedItem();
                break;
            }
            case 2: {
                if (this.mCurrentState == 14) {
                    this.mGameCategory = this.mCurrentMenu.getSelectedItem();
                    mGameSelection = this.mCurrentMenu.getSubMenuItemSelection();
                    this.mGameEngine.mMiniGameId = this.mGameCategory * 6 + mGameSelection;
                    break;
                }
                this.mGameCategory = this.mCurrentState;
                mGameSelection = this.mCurrentMenu.getSelectedItem();
                break;
            }
            case 18: {
                int n7;
                int n8;
                for (n8 = 0; n8 < GameEngine.mCurrentMiniGameScoresPer.length; ++n8) {
                    for (n7 = 0; n7 < GameEngine.mCurrentMiniGameScoresPer[n8].length; ++n7) {
                        for (int i = 0; i < GameEngine.mCurrentMiniGameScoresPer[n8][n7].length; ++i) {
                            GameEngine.mCurrentMiniGameScoresPer[n8][n7][i] = i == 0 ? 0 : -1;
                        }
                    }
                }
                for (n8 = 0; n8 < GameEngine.mCurrentMiniGameScoresMax.length; ++n8) {
                    for (n7 = 0; n7 < GameEngine.mCurrentMiniGameScoresMax[n8].length; ++n7) {
                        GameEngine.mCurrentMiniGameScoresMax[n8][n7] = 0;
                    }
                }
                for (n8 = 0; n8 < GameEngine.mCurrentMiniGameTestScoresPer.length; ++n8) {
                    for (n7 = 0; n7 < GameEngine.mCurrentMiniGameTestScoresPer[n8].length; ++n7) {
                        GameEngine.mCurrentMiniGameTestScoresPer[n8][n7] = n7 == 0 ? 0 : -1;
                    }
                }
                GameEngine.popupStatisticsTestShowed = false;
                GameEngine.popupStatisticsPracticeShowed = false;
                for (n8 = 0; n8 < 24; ++n8) {
                    GameEngine.mMiniGameUnlocked[n8] = false;
                    GameEngine.mMiniGameMedals[n8] = 0;
                }
                GameEngine.mMiniGameUnlocked[0] = true;
                GameEngine.mMiniGameUnlocked[6] = true;
                GameEngine.mMiniGameUnlocked[12] = true;
                GameEngine.mMiniGameUnlocked[18] = true;
                for (n8 = 0; n8 < 30; ++n8) {
                    GameEngine.achievementDone[n8] = false;
                }
                GameEngine.mTestModeMaxScore = 0;
                GameEngine.mTestModeMaxScoreStr = "0%";
                GameEngine.mHighScoresPlayerPos = 15;
                GameEngine.mFirstTimeStupidTest = true;
                GameEngine.mFirstTimeTestMode = true;
                this.mPlayedBefore = false;
                this.mGameCategory = 0;
                mGameSelection = 0;
                this.saveGame();
            }
        }
    }

    public String processText(int n, int n2, String string) {
        return string;
    }

    public void processMenu(int n, MenuObject menuObject, int n2) {
        if (n2 == 1) {
            switch (n) {
                case 8: {
                    this.mLanguageQueryMenu = menuObject;
                    menuObject.setImageFonts(null, this.mSimpleFont, this.mSimpleFont);
                    break;
                }
                case 7: {
                    menuObject.setImageFonts(null, this.mSimpleFont, this.mSimpleFont);
                    break;
                }
                case 9: {
                    this.mSettingsLanguageMenu = menuObject;
                }
            }
        }
        if (n2 == 2) {
            switch (n) {
                case 10: {
                    menuObject.setItemIntValue(1, mSoundsEnabled ? 1 : 0);
                    menuObject.setItemIntValue(3, this.mVibraEnabled ? 1 : 0);
                    break;
                }
                case 4: {
                    menuObject.setItemIntValue(0, mSoundsEnabled ? 1 : 0);
                    menuObject.setItemIntValue(2, this.mVibraEnabled ? 1 : 0);
                }
            }
        }
    }

    public boolean isChildGroup(int n, int n2) {
        return n == 0 && n2 == 1;
    }

    public int getStateGroupLoadingCount(int n) {
        switch (n) {
            case 9: {
                return 1;
            }
            case 0: {
                if (!this.mMenuResourcesLoaded) {
                    return 1;
                }
                return 0;
            }
            case 2: 
            case 5: 
            case 6: {
                return 1;
            }
        }
        return 0;
    }

    public void loadStateGroup(int n, int n2) {
        switch (n) {
            case 9: {
                this.mDchocLogo = SpriteObject.getImage(917564, 0, 1);
                MenuObject.setLoadingScreenResources();
                MenuObject.mTitleSprite = Toolkit.getImage(65536);
                break;
            }
            case 0: {
                if (!this.mMenuResourcesLoaded) {
                    this.loadMenuResources();
                }
                MenuObject.setBackgrounImage(0);
                break;
            }
            case 6: {
                this.loadAchievementsMenuResources();
                break;
            }
            case 2: {
                this.mGameEngine.gameInit(this.mGameCategory, mGameSelection);
                break;
            }
            case 5: {
                MenuObject.loadCategory();
            }
        }
    }

    public void unloadStateGroup(int n, int n2) {
        switch (n) {
            case 0: {
                if (n2 == 1) break;
                this.freeMenuResources();
                break;
            }
            case 2: {
                if (this.mGameEngine == null) break;
                this.mGameEngine.gameDestroy();
                break;
            }
            case 5: {
                MenuObject.destroyCategory();
                this.mLastMenu = null;
                break;
            }
            case 6: {
                this.freeAchievementsMenuResources();
            }
        }
    }

    public int getStateLoadingCount(int n) {
        switch (n) {
            case 28: {
                return 1;
            }
            case 31: {
                return 1;
            }
        }
        return 0;
    }

    public void loadState(int n, int n2) {
        switch (n) {
            case 28: {
                break;
            }
            case 31: {
                break;
            }
            case 35: {
                MenuObject.destroyBackgroundImage();
            }
        }
    }

    public void unloadState(int n, int n2) {
        switch (n) {
            case 28: {
                this.mDchocLogo = null;
            }
        }
    }

    private void setSoundsEnabled(boolean bl) {
        mSoundsEnabled = bl;
        if (bl) {
            Toolkit.setSoundEffectVolume(3);
            Toolkit.setMusicVolume(3);
        } else {
            Toolkit.setSoundEffectVolume(0);
            Toolkit.setMusicVolume(0);
        }
        Game.updateMusic(this.mCurrentState);
    }

    public static void stopMusic() {
        Toolkit.stopMusic();
        mCurrentMusic = -1;
    }

    public static void updateMusic(int n) {
        int n2 = -1;
        if (mSoundsEnabled && mMusicEnabled) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 12: 
                case 13: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 27: 
                case 38: {
                    n2 = 65543;
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    n2 = 65545;
                }
                case 35: {
                    n2 = GameEngine.mCurrentMiniGame != null ? GameEngine.mCurrentMiniGame.updateMusic() : 65545;
                }
            }
        }
        if (n2 != mCurrentMusic) {
            if (n2 == -1) {
                Toolkit.stopMusic();
            } else {
                Toolkit.playMusic(n2, -1);
            }
            mCurrentMusic = n2;
        }
    }

    private void saveSettings(boolean bl) {
        if (LIMIT_RECORD_STORE) {
            if (!bl) {
                return;
            }
            Toolkit.enableWritingToRecordStore(true);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.mSelectedLanguage);
            dataOutputStream.writeBoolean(this.mVibraEnabled);
            dataOutputStream.close();
            Toolkit.writeRecord(RECORD_STORE_NAME_SETTINGS, byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (LIMIT_RECORD_STORE) {
            Toolkit.enableWritingToRecordStore(false);
        }
    }

    private void loadSettings() {
        byte[] byArray;
        if (Toolkit.getToolkitProperty(7) != null) {
            this.mSelectedLanguage = Toolkit.getSelectedLanguageIndex();
        }
        if ((byArray = Toolkit.readRecord(RECORD_STORE_NAME_SETTINGS)) != null) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                this.mSelectedLanguage = dataInputStream.readInt();
                this.mApplicationControl.setLanguage(this.mSelectedLanguage);
                this.mVibraEnabled = dataInputStream.readBoolean();
                Toolkit.setVibraEnabled(this.mVibraEnabled);
                dataInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void saveGame() {
        if (!this.mCheatsEnabled) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                int n;
                int n2;
                for (n2 = 0; n2 < GameEngine.mCurrentMiniGameScoresPer.length; ++n2) {
                    for (n = 0; n < GameEngine.mCurrentMiniGameScoresPer[n2].length; ++n) {
                        for (int i = 0; i < GameEngine.mCurrentMiniGameScoresPer[n2][n].length; ++i) {
                            dataOutputStream.writeInt(GameEngine.mCurrentMiniGameScoresPer[n2][n][i]);
                        }
                    }
                }
                for (n2 = 0; n2 < GameEngine.mCurrentMiniGameScoresMax.length; ++n2) {
                    for (n = 0; n < GameEngine.mCurrentMiniGameScoresMax[n2].length; ++n) {
                        dataOutputStream.writeInt(GameEngine.mCurrentMiniGameScoresMax[n2][n]);
                    }
                }
                for (n2 = 0; n2 < GameEngine.mCurrentMiniGameTestScoresPer.length; ++n2) {
                    for (n = 0; n < GameEngine.mCurrentMiniGameTestScoresPer[n2].length; ++n) {
                        dataOutputStream.writeInt(GameEngine.mCurrentMiniGameTestScoresPer[n2][n]);
                    }
                }
                dataOutputStream.writeBoolean(GameEngine.popupStatisticsTestShowed);
                dataOutputStream.writeBoolean(GameEngine.popupStatisticsPracticeShowed);
                for (n2 = 0; n2 < 24; ++n2) {
                    dataOutputStream.writeBoolean(GameEngine.mMiniGameUnlocked[n2]);
                    dataOutputStream.writeInt(GameEngine.mMiniGameMedals[n2]);
                }
                for (n2 = 0; n2 < 30; ++n2) {
                    dataOutputStream.writeBoolean(GameEngine.achievementDone[n2]);
                }
                dataOutputStream.writeInt(GameEngine.mTestModeMaxScore);
                dataOutputStream.writeInt(GameEngine.mHighScoresPlayerPos);
                dataOutputStream.writeBoolean(GameEngine.mFirstTimeStupidTest);
                dataOutputStream.writeBoolean(GameEngine.mFirstTimeTestMode);
                dataOutputStream.writeBoolean(this.mPlayedBefore);
                dataOutputStream.close();
                Toolkit.writeRecord(RECORD_STORE_NAME, byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void loadGame() {
        byte[] byArray = Toolkit.readRecord(RECORD_STORE_NAME);
        if (byArray != null) {
            try {
                int n;
                int n2;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                for (n2 = 0; n2 < GameEngine.mCurrentMiniGameScoresPer.length; ++n2) {
                    for (n = 0; n < GameEngine.mCurrentMiniGameScoresPer[n2].length; ++n) {
                        for (int i = 0; i < GameEngine.mCurrentMiniGameScoresPer[n2][n].length; ++i) {
                            GameEngine.mCurrentMiniGameScoresPer[n2][n][i] = dataInputStream.readInt();
                        }
                    }
                }
                for (n2 = 0; n2 < GameEngine.mCurrentMiniGameScoresMax.length; ++n2) {
                    for (n = 0; n < GameEngine.mCurrentMiniGameScoresMax[n2].length; ++n) {
                        GameEngine.mCurrentMiniGameScoresMax[n2][n] = dataInputStream.readInt();
                    }
                }
                for (n2 = 0; n2 < GameEngine.mCurrentMiniGameTestScoresPer.length; ++n2) {
                    for (n = 0; n < GameEngine.mCurrentMiniGameTestScoresPer[n2].length; ++n) {
                        GameEngine.mCurrentMiniGameTestScoresPer[n2][n] = dataInputStream.readInt();
                    }
                }
                GameEngine.popupStatisticsTestShowed = dataInputStream.readBoolean();
                GameEngine.popupStatisticsPracticeShowed = dataInputStream.readBoolean();
                for (n2 = 0; n2 < 24; ++n2) {
                    GameEngine.mMiniGameUnlocked[n2] = dataInputStream.readBoolean();
                    GameEngine.mMiniGameMedals[n2] = dataInputStream.readInt();
                }
                for (n2 = 0; n2 < 30; ++n2) {
                    GameEngine.achievementDone[n2] = dataInputStream.readBoolean();
                }
                GameEngine.mTestModeMaxScore = dataInputStream.readInt();
                GameEngine.mTestModeMaxScoreStr = GameEngine.mTestModeMaxScore + "%";
                GameEngine.mHighScoresPlayerPos = dataInputStream.readInt();
                GameEngine.mFirstTimeStupidTest = dataInputStream.readBoolean();
                GameEngine.mFirstTimeTestMode = dataInputStream.readBoolean();
                this.mPlayedBefore = dataInputStream.readBoolean();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void licenseManagerActivated() {
        if (this.mEnableLicenseManager) {
            this.mLicenseManagerActivated = true;
        }
    }

    private boolean isTextBox(MenuObject menuObject) {
        return menuObject.getStyle() == 4 || menuObject.getStyle() == 5;
    }

    private boolean isMenuItemVisible(int n, int n2) {
        boolean bl = Toolkit.getLanguageDescriptions().length <= 1 && n == 4 && n2 == 3 || n == 0 && n2 == 4 || n == 0 && n2 == 3 || n == 4 && n2 == 1 || n == 10 && n2 == 2 || (!this.mEnableLicenseManager || !this.mEnableLicenseManagerMenuItem) && n == 0 && n2 == 0 || n == 0 && n2 == 7;
        return !bl;
    }

    public void menuSetScreen(int n, MenuObject menuObject, int n2, int n3, int n4) {
        if (n == 8 || n == 9) {
            String[][] stringArray = Toolkit.getLanguageDescriptions();
            n3 = stringArray.length;
            menuObject.setScreen(n2, n3, n4);
            int n5 = n == 8 ? 17 : 1;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i][0];
                menuObject.setItem(i, 0, string, null, n5);
            }
        } else {
            menuObject.setScreen(n2, n3, n4);
        }
    }

    public void menuSetTitleBarDvc(int n, MenuObject menuObject, String string, SpriteObject spriteObject, int n2) {
        menuObject.setTitleBarDvc(spriteObject == null ? string : null, spriteObject, n2);
    }

    public void menuSetTitleBar(int n, MenuObject menuObject, String string, Image image, int n2) {
        menuObject.setTitleBar(image == null ? string : null, image, n2);
    }

    public void menuSetSoftkey(int n, MenuObject menuObject, int n2, int n3) {
        menuObject.setSoftkey(n2, n3);
    }

    public void menuSetItemDvc(int n, MenuObject menuObject, int n2, int n3, String string, SpriteObject spriteObject, int n4) {
        if (this.isMenuItemVisible(n, n2)) {
            if (n == 0 && n2 == 0 && this.mEnableLicenseManager && this.mEnableLicenseManagerMenuItem) {
                string = this.mLicenseManager.getLicenseManagerMenuItemLabel();
            }
            menuObject.setItemDvc(n2, n3, string, spriteObject, n4);
        }
    }

    public void menuSetItem(int n, MenuObject menuObject, int n2, int n3, String string, Image[] imageArray, int n4) {
        if (this.isMenuItemVisible(n, n2)) {
            menuObject.setItem(n2, n3, string, imageArray, n4);
        }
    }

    public void menuSetSwitchItemDvc(int n, MenuObject menuObject, int n2, String string, SpriteObject spriteObject, String[] stringArray, SpriteObject spriteObject2, int n3) {
        if (this.isMenuItemVisible(n, n2)) {
            menuObject.setSwitchItemDvc(n2, string, spriteObject, stringArray, spriteObject2, n3);
        }
    }

    public void menuSetSwitchItem(int n, MenuObject menuObject, int n2, String string, Image[] imageArray, String[] stringArray, Image[] imageArray2, int n3) {
        if (this.isMenuItemVisible(n, n2)) {
            menuObject.setSwitchItem(n2, string, imageArray, stringArray, imageArray2, n3);
        }
    }

    public void menuSetSliderItemDvc(int n, MenuObject menuObject, int n2, String string, SpriteObject spriteObject, int n3, int n4, int n5) {
        if (this.isMenuItemVisible(n, n2)) {
            menuObject.setSliderItemDvc(n2, string, spriteObject, n3, n4, n5);
        }
    }

    public void menuSetSliderItem(int n, MenuObject menuObject, int n2, String string, Image[] imageArray, int n3, int n4, int n5) {
        if (this.isMenuItemVisible(n, n2)) {
            menuObject.setSliderItem(n2, string, imageArray, n3, n4, n5);
        }
    }

    public void menuSetInputItemDvc(int n, MenuObject menuObject, int n2, int n3, String string, String string2, SpriteObject spriteObject, int n4, int n5) {
        menuObject.setInputItemDvc(n2, n3, string, string2, spriteObject, n4, n5);
    }

    public void menuSetInputItem(int n, MenuObject menuObject, int n2, int n3, String string, String string2, Image[] imageArray, int n4, int n5) {
        menuObject.setInputItem(n2, n3, string, string2, imageArray, n4, n5);
    }

    public void menuSetStyle(int n, MenuObject menuObject, int n2) {
        menuObject.setStyle(n2);
    }

    public void menuSetSize(int n, MenuObject menuObject) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.isTextBox(menuObject)) {
            int n6 = Toolkit.getScreenWidth();
            int n7 = Toolkit.getScreenHeight() - Toolkit.getSoftKeyAreaHeight();
            int n8 = menuObject.getPreferredWidth(n6);
            int n9 = menuObject.getPreferredHeight(n8, n7);
            n5 = n8;
            n4 = n9;
            n3 = n6 - n5 >> 1;
            n2 = n7 - n4 >> 1;
        } else {
            n5 = Toolkit.getScreenWidth();
            n4 = Toolkit.getScreenHeight();
            n3 = 0;
            n2 = 0;
        }
        menuObject.setBounds(n3, n2, n5, n4);
    }

    public boolean shouldStoreStateToHistory(int n) {
        return n != 8 && n != 7 && n != 28 && n != 29;
    }

    private static void initGMG() {
    }

    public void setCategoryMenu(MenuObject menuObject, int n) {
        if (this.mLastMenu != null) {
            menuObject = this.mLastMenu;
            this.mLastMenu = null;
        }
        menuObject.setScreen(3, 4, 9);
        menuObject.setTitleBar(Toolkit.getText(61), null, 3);
        menuObject.setStyle(3);
        for (int i = 0; i < 4; ++i) {
            this.mCategorySubMenus[i].setStyle(7);
            this.mCategorySubMenus[i].setSoftkey(5, 1);
            this.mCategorySubMenus[i].setTitleBar(null, null, 0);
            this.mCategorySubMenus[i].setSize(Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
        }
        if (n < this.mCategorySubMenus.length) {
            this.mCategorySubMenus[n].setSelectedItem(mGameSelection);
        }
        this.mCategorySubMenus[0].setCustom(15);
        this.mCategorySubMenus[1].setCustom(18);
        this.mCategorySubMenus[2].setCustom(17);
        this.mCategorySubMenus[3].setCustom(16);
        menuObject.setSubMenuItem(0, this.mCategorySubMenus[0]);
        menuObject.setSubMenuItem(1, this.mCategorySubMenus[1]);
        menuObject.setSubMenuItem(2, this.mCategorySubMenus[2]);
        menuObject.setSubMenuItem(3, this.mCategorySubMenus[3]);
        menuObject.setSoftkey(1, 0);
        if (n > 3) {
            n = 0;
        }
        menuObject.setSelectedItem(n);
        menuObject.setSize(Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
    }

    public void getSubMenu(MenuObject[] menuObjectArray) {
        if (this.mCategorySubMenus == null) {
            this.mCategorySubMenus = new MenuObject[4];
            this.mCategorySubMenus[0] = menuObjectArray[15];
            this.mCategorySubMenus[1] = menuObjectArray[18];
            this.mCategorySubMenus[2] = menuObjectArray[17];
            this.mCategorySubMenus[3] = menuObjectArray[16];
        }
    }

    public void setLastMenu() {
        this.mLastMenu = this.mCurrentMenu;
    }

    public void removeSubMenus(MenuObject[] menuObjectArray) {
        menuObjectArray[15] = null;
        menuObjectArray[18] = null;
        menuObjectArray[17] = null;
        menuObjectArray[16] = null;
        if (this.mCategorySubMenus != null) {
            this.mCategorySubMenus[0] = null;
            this.mCategorySubMenus[1] = null;
            this.mCategorySubMenus[2] = null;
            this.mCategorySubMenus[3] = null;
            this.mCategorySubMenus = null;
        }
    }

    static {
        mCurrentMusic = -1;
        SOUNDS = new int[0];
        CHEAT_CODE = new int[]{7, 8, 7, 3, 7, 2, 7, 2, 4, 6};
        LIMIT_RECORD_STORE = Toolkit.getToolkitProperty(10) != null;
    }
}

