/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

abstract class MiniGame {
    public static final int SHIFT_VALUE = 8;
    public static final int REFERENCE_TIME = 50;
    public static final int HUD_DIGITS = 3;
    public static final byte GAME_MODE_PLAY = 0;
    public static final byte GAME_MODE_TUTORIAL = 1;
    public static final byte GAME_MODE_END = 2;
    public static final int STATE_START = -1;
    public static final int STATE_INIT = 0;
    public static final int STATE_DESCRIPTION = 1;
    public static final int STATE_NEXT_QUESTION = 2;
    public static final int STATE_WATCH = 3;
    public static final int STATE_GAME = 4;
    public static final int STATE_CHECK_ANSWER = 5;
    public static final int STATE_TIME_OUT = 6;
    public static final int STATE_END = 7;
    public static final int STATE_SHOW_MEDAL = 8;
    public static final int STATE_RESULTS = 9;
    public static final int ANSWER_CORRECT = 0;
    public static final int ANSWER_WRONG = 1;
    public static final int ANSWER_NEXT = 2;
    public static final int ANSWER_INVALID_KEY = 3;
    public static final int INFINITE_TIME = -1;
    public static final int INFINITE_QUESTIONS = -1;
    public static final int TIME_FOR_3_SEC = 3000;
    public static final int TIME_FOR_10_SEC = 10000;
    public static final int TIME_FOR_20_SEC = 20000;
    public static final int TIME_FOR_30_SEC = 30000;
    public static final int TIME_FOR_40_SEC = 40000;
    public static final int TIME_FOR_45_SEC = 45000;
    public static final int TIME_FOR_50_SEC = 50000;
    public static final int TIME_FOR_60_SEC = 60000;
    public static final int KEYPRESSED_LEFT = 0;
    public static final int KEYPRESSED_RIGHT = 1;
    public static final int KEYPRESSED_UP = 2;
    public static final int KEYPRESSED_DOWN = 3;
    public static final int BUTTON_IDLE_ANIMATION = 0;
    public static final int BUTTON_PRESS_ANIMATION = 1;
    public static final int BUTTON_CORRECT_ANIMATION = 1;
    public static final int BUTTON_WRONG_ANIMATION = 2;
    public static final int MEDAL_GOLD = 3;
    public static final int MEDAL_SILVER = 2;
    public static final int MEDAL_BRONZE = 1;
    public int mScore = 0;
    public int mCorrectAnswers = 0;
    public int mWrongAnswers = 0;
    public boolean mIsFinished;
    public byte mGameMode;
    protected static ImageFont smFont;
    protected static int mMiniGameID;
    protected int mCanvasX;
    protected int mCanvasY;
    protected int mCanvasWidth;
    protected int mCanvasHeight;
    protected int mProcessedTime;
    protected int mElapsedTime;
    protected int[] mTicks = new int[]{0, 0, 0};
    protected int[] mState = new int[]{0, 0, 0};
    protected boolean mForceFailure = false;
    protected boolean mForceExit;
    protected int mDifficulty;
    protected int mTutorialMaxWaitTicks;
    protected int mHudConfirmationPosX;
    protected int mHudConfirmationPosY;
    protected int mHudConfirmationTicks;
    protected SpriteObject[] mSpritesPool;
    protected SpriteObject[] mButtons;
    protected boolean mDrawButtons;
    protected int mButtonAnimation;
    protected int[] mButtonsPosition = new int[]{0, 0, 0, 0};
    protected boolean mDrawWatchIcon;
    protected int mKeyPressed;
    protected boolean activateInGameSFX = true;
    protected int[] mLastQuestions = new int[]{-1, -1, -1, -1, -1, -1};
    protected int mLastQuestionsIndex;
    private boolean mMedalAwarded = true;
    private boolean mShowGlobalTestResults = false;
    private int mMedalCat;
    private String mMedalText;
    private int mMaxTime = 0;
    private int mTimeLeft = 0;
    private int mMaxQuestions = 0;
    private int mQuestionsLeft = 0;
    private int mScoreIncrements = 0;
    private int mTimeOutTimer;
    private int mFullCanvasWidth;
    private int mFullCanvasHeight;
    protected SpriteObject mCorrectSprite;
    protected SpriteObject mWrongSprite;
    protected SpriteObject mBigNumbersSprite;
    protected SpriteObject mBackground;
    protected SpriteObject mNoteBook;
    private int mNoteBookX;
    private int mNoteBookY;
    private int mTimerBoxX;
    private int mTimerBoxY;
    private int mTimerBarBoxX;
    private int mTimerBarBoxY;
    private int mScorePosX;
    private int mScorePosY;
    private int mScoreMarkX;
    private int mScoreMarkY;
    private int mFailsPosX;
    private int mFailsPosY;
    private int mFailsMarkPosX;
    private int mFailsMarkPosY;
    private static final int TIMER_EMPTY = 0;
    private static final int TIMER_FULL = 1;
    private SpriteObject mTimerSpr;
    private SpriteObject[] mTimerBarSpr;
    private SpriteObject mNumbersSpr;
    private SpriteObject mScoreMarkSpr;
    private SpriteObject mFailMarkSpr;
    private SpriteObject mCountdownNumbers;
    private SpriteObject mCountdownGears;
    private SpriteObject mCountdownLines;
    private SpriteObject mWatchIcon;
    private static int rnd;
    private static int RND_Cont;
    private static int[] RND_Data;
    private int mCountDownTime;
    private String mTextTimeOut;
    private char[] mCharsTimeOut;
    private int mTimeOutBoxY;
    private int mTimeOutBoxHeight;
    private int[] mTimeOutCharsY;
    private int[] mTimeOutCharsInc;
    private int mTimeOutFontHeight;
    private static String[] mSplitText;
    private static String[] mSplitMinigameName;
    private static final int MAX_PARTICLES = 10;
    private SpriteObject[] mParticleSprites = new SpriteObject[10];
    private static final int MAX_STARPARTICLES = 20;
    private SpriteObject[] mParticleStarSprites = new SpriteObject[20];
    private int mEmptyParticle;
    private int mEmptyStarParticle;
    private int mParticleStartAngle;
    private boolean mMusicPlaying;
    private int mTimeToHelp;
    private int mArrowY;
    private int mArrowInc;
    private String mHelpSoftKey;
    SpriteObject mMiniGameIcon;
    SpriteObject[] mMiniGameMedals = new SpriteObject[3];
    public static int[] categoryColors;
    public static int END_OF_PRACTICE_SCOREUP_TIME;
    int mEndOfPracticeScoreUpTimer;
    private boolean scoreAnimFinished;
    private String miniGameInstrunctionsString;
    private static final int STR_RESULTS_TEST_AVERAGE_TITLE = 0;
    private static final int STR_RESULTS_TEST_TIME_SCORE = 1;
    private static final int STR_RESULTS_TEST_SCORES_PER_FIRST = 2;
    private static final int STR_RESULTS_TEST_COUNT = 6;
    private static final int STR_RESULTS_STUPID_TEST_TITLE = 0;
    private static final int STR_RESULTS_STUPID_TEST_TIMES_CORRECT = 1;
    private static final int STR_RESULTS_STUPID_TEST_TIMES_MISSED = 2;
    private static final int STR_RESULTS_STUPID_TEST_COUNT = 3;
    private static final int STR_RESULTS_DEFAULT_SCORE = 0;
    private static final int STR_RESULTS_DEFAULT_COUNT = 1;
    private static final int INT_RESULTS_TEST_FORM_WIDTH = 0;
    private static final int INT_RESULTS_TEST_AVERAGE_TITLE_X = 1;
    private static final int INT_RESULTS_TEST_AVERAGE_TITLE_NEEDS_SCROLL = 2;
    private static final int INT_RESULTS_TEST_SCORE_SUM = 3;
    private static final int INT_RESULTS_TEST_ANIMATED_RESULTS_X = 4;
    private static final int INT_RESULTS_TEST_ANIMATED_RESULTS_OFFSET_Y = 5;
    private static final int INT_RESULTS_TEST_COUNT = 6;
    public static boolean bKeyEventFlag;
    static final int RND_BIN_MEMORY_LENGTH = 3;
    boolean[] rndBinMemory = new boolean[3];
    int rndBinPointer;
    int rndBinLen;
    int rndBinRight;
    int rndBinWrong;
    static final int[] POINTS_FOR_RIGHT;
    static final int[] POINTS_FOR_WRONG;
    static final int[] FUNCTION_DISCRETIZATION;

    MiniGame() {
    }

    public void destroy() {
        int n = 0;
        smFont = null;
        if (this.mSpritesPool != null) {
            for (n = 0; n < this.mSpritesPool.length; ++n) {
                if (this.mSpritesPool[n] == null) continue;
                this.mSpritesPool[n].freeResources();
            }
        }
        if (this.mButtons != null) {
            for (n = 0; n < this.mButtons.length; ++n) {
                this.mButtons[n].freeResources();
            }
            this.mButtons = null;
        }
        if (this.mBackground != null) {
            this.mBackground.freeResources();
        }
        if (this.mNoteBook != null) {
            this.mNoteBook.freeResources();
        }
        if (this.mCorrectSprite != null) {
            this.mCorrectSprite.freeResources();
        }
        if (this.mWrongSprite != null) {
            this.mWrongSprite.freeResources();
        }
        if (this.mBigNumbersSprite != null) {
            this.mBigNumbersSprite.freeResources();
        }
        this.mTimerSpr.freeResources();
        this.mTimerBarSpr[0].freeResources();
        this.mTimerBarSpr[1].freeResources();
        this.mNumbersSpr.freeResources();
        this.mScoreMarkSpr.freeResources();
        if (this.mMaxQuestions > -1) {
            this.mFailMarkSpr.freeResources();
        }
        this.mCountdownNumbers.freeResources();
        this.mCountdownGears.freeResources();
        this.mCountdownLines.freeResources();
        this.mMiniGameMedals[0].freeResources();
        this.mMiniGameMedals[1].freeResources();
        this.mMiniGameMedals[2].freeResources();
        this.mMiniGameMedals = null;
        this.mCorrectSprite = null;
        this.mWrongSprite = null;
        this.mSpritesPool = null;
        this.mBigNumbersSprite = null;
        if (mSplitMinigameName != null) {
            mSplitMinigameName = null;
        }
        if (mSplitText != null) {
            mSplitText = null;
        }
        GameEngine.mGeneralStr = null;
        GameEngine.mGeneralInt = null;
        GameEngine.formTitleSTE = null;
    }

    public void screenSizeChanged() {
        this.mFullCanvasWidth = Toolkit.getScreenWidth();
        this.mFullCanvasHeight = Toolkit.getScreenHeight() - Toolkit.getSoftKeyAreaHeight();
        this.mNoteBookX = this.mFullCanvasWidth >> 1;
        this.mNoteBookY = this.mFullCanvasHeight >> 1;
        short[] sArray = this.mNoteBook.getCurrentAnimationData();
        int n = this.mNoteBook.getCollisionBoxes();
        n += 2;
        this.mCanvasX = sArray[n++] + this.mNoteBookX;
        this.mCanvasY = sArray[n++] + this.mNoteBookY;
        this.mCanvasWidth = sArray[n++];
        this.mCanvasHeight = sArray[n++];
        if (Toolkit.getScreenHeight() > 132) {
            this.mButtonsPosition[0] = this.mCanvasX;
            this.mButtonsPosition[1] = this.mCanvasX + this.mCanvasWidth;
            this.mButtonsPosition[2] = this.mCanvasY + this.mCanvasHeight - 0;
            this.mButtonsPosition[3] = this.mCanvasY + this.mCanvasHeight - 0;
        } else {
            this.mButtonsPosition[0] = this.mCanvasX >> 1;
            this.mButtonsPosition[1] = this.mCanvasX + (this.mCanvasX >> 1) + this.mCanvasWidth + 1;
            this.mButtonsPosition[2] = this.mCanvasY + (this.mCanvasHeight >> 1) + 0;
            this.mButtonsPosition[3] = this.mCanvasY + (this.mCanvasHeight >> 1) + 0;
        }
        this.mTimerBoxX = 6 + (this.mTimerSpr.getPivotX() >> 2);
        this.mTimerBoxY = this.mTimerSpr.getPivotY() >> 2;
        this.mTimerBarBoxX = this.mTimerBoxX + (this.mTimerSpr.getPivotX() >> 1);
        this.mTimerBarBoxY = this.mTimerBoxY;
        this.mFailsMarkPosX = this.mFullCanvasWidth - 6 - this.mFailMarkSpr.getPivotX();
        this.mFailsMarkPosY = 3 + this.mFailMarkSpr.getPivotY();
        this.mFailsPosX = this.mFailsMarkPosX - 6 - this.mNumbersSpr.getWidth() * 3;
        this.mFailsPosY = this.mFailsMarkPosY;
        this.mScoreMarkX = this.mFailsPosX - 12 - this.mNumbersSpr.getPivotX();
        this.mScoreMarkY = this.mFailsMarkPosY;
        this.mScorePosX = this.mScoreMarkX - 6 - this.mNumbersSpr.getWidth() * 3;
        this.mScorePosY = this.mFailsMarkPosY;
    }

    public static int rnd(int n) {
        int n2 = RND_Cont % 5;
        RND_Data[n2] = RND_Data[n2] ^ RND_Data[++RND_Cont % 5];
        if (RND_Cont > 23) {
            RND_Cont = 0;
        }
        rnd = (RND_Data[RND_Cont % 5] >> RND_Cont & 0xFF) * n >> 8;
        return rnd;
    }

    public boolean rndBin() {
        boolean bl;
        boolean bl2 = bl = MiniGame.rnd(256) - MiniGame.rnd(256) >= 0;
        if (this.rndBinRight + this.rndBinWrong > 6) {
            if (this.rndBinRight * 100 / (this.rndBinRight + this.rndBinWrong) < 35) {
                bl = true;
            }
            if (this.rndBinWrong * 100 / (this.rndBinRight + this.rndBinWrong) < 35) {
                bl = false;
            }
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.rndBinLen; ++i) {
            if (this.rndBinMemory[(this.rndBinPointer + i) % 3]) {
                ++n;
                continue;
            }
            ++n2;
        }
        if (n == 3) {
            bl = false;
        } else if (n2 == 3) {
            bl = true;
        } else if (n >= 2 || n2 >= 2) {
            bl = MiniGame.rnd(256) - MiniGame.rnd(256) >= 0;
        }
        this.rndBinMemory[this.rndBinPointer] = bl;
        ++this.rndBinPointer;
        this.rndBinPointer %= 3;
        if (this.rndBinLen < 3) {
            ++this.rndBinLen;
        }
        if (bl) {
            ++this.rndBinRight;
        } else {
            ++this.rndBinWrong;
        }
        return bl;
    }

    public void updateSoftkeys(boolean bl) {
        try {
            if (this.mState[this.mGameMode] == -1) {
                Toolkit.removeAllSoftKeys();
                Toolkit.setSoftKey(9, 0);
                Toolkit.setSoftKey(15, 0);
            } else if (this.mState[this.mGameMode] == 8) {
                Toolkit.removeAllSoftKeys();
                Toolkit.setSoftKey(15, 0);
            } else if (this.mState[this.mGameMode] == 9) {
                Toolkit.removeAllSoftKeys();
                if (GameEngine.mRunningTestMode) {
                    if (this.mEndOfPracticeScoreUpTimer < END_OF_PRACTICE_SCOREUP_TIME) {
                        Toolkit.setSoftKey(14, 0);
                    } else {
                        Toolkit.setSoftKey(15, 0);
                    }
                } else {
                    Toolkit.setSoftKey(15, 0);
                }
            } else if (bl || this.mState[this.mGameMode] == 0 || this.mState[this.mGameMode] == 7) {
                Toolkit.removeAllSoftKeys();
                Toolkit.setSoftKey(27, 1);
                Toolkit.setSoftKey(9, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void keyEvent(int n, int n2) {
        this.mTimeToHelp = 0;
        if (n2 == 3 && n == 27) {
            GameEngine.createTextBox(0, GameEngine.INSTRUCTIONS_ID[mMiniGameID], null, false);
        } else if (n2 == 3 && n == 14) {
            this.mEndOfPracticeScoreUpTimer = END_OF_PRACTICE_SCOREUP_TIME;
        } else if (this.mGameMode == 0 && this.mState[this.mGameMode] == 4) {
            if (n2 == 0) {
                this.updatePoints(this.isCorrectAnswer(n));
            }
        } else if (n2 == 3 && n == 15 || n2 == 0 && (Toolkit.getToolkitGameAction(n) == 53 || n == 53)) {
            if (this.mState[this.mGameMode] == -1) {
                this.changeState(0);
            } else if (this.mGameMode == 2) {
                if (this.mState[this.mGameMode] == 8) {
                    this.changeState(9);
                } else if (this.mState[this.mGameMode] == 9) {
                    if (GameEngine.mRunningTestMode && GameEngine.mTestModeIndex == 4 && !this.mShowGlobalTestResults) {
                        this.mShowGlobalTestResults = true;
                    } else {
                        this.mIsFinished = true;
                    }
                }
            }
        }
    }

    protected void pointerEventOccurred(int n, int n2, int n3) {
        if (this.mButtons != null && this.mGameMode == 0 && this.mState[this.mGameMode] == 4) {
            int n4 = this.mButtons[0].getWidth();
            if (n3 == 0) {
                int n5;
                int n6;
                if (this.mButtons[0] != null) {
                    n6 = this.mButtonsPosition[0] - this.mButtons[0].getPivotX();
                    n5 = this.mButtonsPosition[2] - this.mButtons[0].getPivotY();
                    if (n > n6 && n < n6 + n4 && n2 > n5 && n2 < n5 + n4) {
                        if (this.mButtons[1] == null) {
                            this.updatePoints(this.isCorrectAnswer(53));
                        } else {
                            this.updatePoints(this.isCorrectAnswer(52));
                        }
                    }
                }
                if (this.mButtons[1] != null) {
                    n6 = this.mButtonsPosition[1] - this.mButtons[0].getPivotX();
                    n5 = this.mButtonsPosition[3] - this.mButtons[0].getPivotY();
                    if (n > n6 && n < n6 + n4 && n2 > n5 && n2 < n5 + n4) {
                        this.updatePoints(this.isCorrectAnswer(54));
                    }
                }
            }
        }
    }

    public void logicUpdate(int n) {
        int n2;
        this.mElapsedTime += n;
        if (this.mGameMode < 2 && this.mMaxTime > -1 && this.mState[this.mGameMode] >= 2 && this.mState[this.mGameMode] < 6) {
            this.mTimeLeft -= n;
            if (this.mTimeLeft <= this.mMaxTime * 20 / 100) {
                this.mTimerSpr.logicUpdate(n);
                this.mTimerBarSpr[1].logicUpdate(n);
            }
            if (this.mTimeLeft <= 0) {
                this.mTimeLeft = 0;
                bKeyEventFlag = true;
                this.changeState(6);
            }
        }
        for (n2 = 0; n2 < 10; ++n2) {
            if (this.mParticleSprites[n2].isFinishedAnimation()) continue;
            this.mParticleSprites[n2].logicUpdate(n);
        }
        if (GameEngine.sintable != null) {
            for (n2 = 0; n2 < 20; ++n2) {
                if (this.mParticleStarSprites[n2].isFinishedAnimation()) continue;
                this.mParticleStarSprites[n2].logicUpdate(n);
                this.mParticleStarSprites[n2].timer += n;
            }
        }
        if (this.mHudConfirmationTicks > 0) {
            this.mHudConfirmationTicks -= n;
        } else {
            this.mKeyPressed = -1;
        }
        this.mTimeToHelp += n;
        if (this.mTimeToHelp > 10000) {
            this.mArrowY += this.mArrowInc * n >> 8;
            if (this.mArrowY > 0 || this.mArrowY < -16384) {
                this.mArrowInc *= -1;
            }
        }
        switch (this.mState[this.mGameMode]) {
            case -1: {
                if (!this.mMusicPlaying) {
                    Toolkit.playMusic(65543, -1);
                    this.mMusicPlaying = true;
                }
                this.updateSoftkeys(false);
                GameEngine.scrollTextEngineCicle(n, GameEngine.formTitleSTE, false);
                break;
            }
            case 0: {
                GameEngine.formTitleSTE = null;
                this.mDifficulty = 0;
                this.initNextQuestion();
                this.changeState(1);
                if (this.mGameMode == 0) {
                    // empty if block
                }
            }
            case 1: {
                this.mCountdownGears.logicUpdate(n);
                if (this.mCountdownLines.isFinishedAnimation()) {
                    this.mCountdownNumbers.logicUpdate(n);
                } else {
                    this.mCountdownLines.logicUpdate(n);
                }
                if (!this.mCountdownNumbers.isFinishedAnimation()) break;
                this.changeState(3);
                break;
            }
            case 2: {
                this.mTicks[this.mGameMode] = 0;
                this.mIsFinished = false;
                if (this.mMaxQuestions > -1) {
                    --this.mQuestionsLeft;
                    if (this.mQuestionsLeft == 0) {
                        bKeyEventFlag = true;
                        this.changeState(6);
                        break;
                    }
                }
                this.initNextQuestion();
                this.changeState(3);
                break;
            }
            case 3: {
                if (this.mDrawWatchIcon) {
                    this.mWatchIcon.logicUpdate(n);
                }
                if (!this.updateWatch(n)) break;
                this.mDrawWatchIcon = false;
                this.changeState(4);
                break;
            }
            case 4: {
                if (this.mForceFailure) {
                    this.updatePoints(1);
                    this.mForceFailure = false;
                    break;
                }
                this.updateGame(n);
                break;
            }
            case 5: {
                byte by = this.mGameMode;
                this.mTicks[by] = this.mTicks[by] + n;
                if (!this.checkAnswer(n)) break;
                if (this.mForceExit) {
                    this.changeState(7);
                    break;
                }
                this.changeState(2);
                break;
            }
            case 6: {
                this.mTimeOutTimer -= n;
                if (this.mTimeOutTimer <= 0) {
                    this.changeState(7);
                }
                while (this.mProcessedTime < this.mElapsedTime) {
                    if (this.mTimeOutBoxHeight < this.mTimeOutFontHeight / 2) {
                        this.mTimeOutBoxHeight += 3;
                        this.mTimeOutBoxY = this.mFullCanvasHeight - this.mTimeOutBoxHeight >> 1;
                    }
                    for (n2 = 0; n2 < this.mTimeOutCharsY.length; ++n2) {
                        int n3 = n2;
                        this.mTimeOutCharsY[n3] = this.mTimeOutCharsY[n3] + this.mTimeOutCharsInc[n2];
                        if ((this.mTimeOutCharsY[n2] > this.mTimeOutBoxY - 10 || this.mTimeOutCharsInc[n2] != -1) && (this.mTimeOutCharsY[n2] + this.mTimeOutFontHeight * 2 / 3 < this.mTimeOutBoxY + 5 + this.mTimeOutBoxHeight || this.mTimeOutCharsInc[n2] != 1)) continue;
                        int n4 = n2;
                        this.mTimeOutCharsInc[n4] = this.mTimeOutCharsInc[n4] * -1;
                    }
                    this.mProcessedTime += 50;
                }
                break;
            }
            case 7: {
                int n5;
                if (mMiniGameID == 24) {
                    this.mGameMode = (byte)2;
                    this.changeState(9);
                    break;
                }
                n2 = this.getBalancedScore(this.mScore);
                this.mMedalAwarded = false;
                if (n2 >= 75) {
                    this.mMedalCat = 3;
                    this.mMedalAwarded = true;
                } else if (n2 >= 50) {
                    this.mMedalCat = 2;
                    this.mMedalAwarded = true;
                } else if (n2 >= 25) {
                    this.mMedalAwarded = true;
                    this.mMedalCat = 1;
                }
                int n6 = this.getBalancedScore(this.mScore);
                int[] nArray = GameEngine.mRunningTestMode ? GameEngine.mCurrentMiniGameTestScoresPer[mMiniGameID / 6] : GameEngine.mCurrentMiniGameScoresPer[mMiniGameID / 6][mMiniGameID % 6];
                int n7 = 0;
                boolean bl = false;
                while (!bl && n7 < nArray.length) {
                    if (nArray[n7] == -1) {
                        bl = true;
                        continue;
                    }
                    ++n7;
                }
                if (bl) {
                    nArray[n7] = n6;
                } else {
                    for (n5 = 1; n5 < nArray.length; ++n5) {
                        nArray[n5 - 1] = nArray[n5];
                    }
                    nArray[nArray.length - 1] = n6;
                }
                if (GameEngine.mRunningTestMode) {
                    this.mGameMode = (byte)2;
                    if (GameEngine.mTestModeIndex == 4 && !this.mShowGlobalTestResults) {
                        this.changeState(9);
                        this.mShowGlobalTestResults = true;
                        break;
                    }
                    this.mIsFinished = true;
                    bKeyEventFlag = false;
                    Toolkit.stopMusic();
                    break;
                }
                if (n6 > GameEngine.mCurrentMiniGameScoresMax[mMiniGameID / 6][mMiniGameID % 6]) {
                    GameEngine.mCurrentMiniGameScoresMax[MiniGame.mMiniGameID / 6][MiniGame.mMiniGameID % 6] = n6;
                }
                this.mGameMode = (byte)2;
                if (this.mMedalAwarded) {
                    GameEngine.mMiniGameMedals[MiniGame.mMiniGameID] = Math.max(GameEngine.mMiniGameMedals[mMiniGameID], this.mMedalCat);
                    switch (this.mMedalCat) {
                        case 3: {
                            this.mMedalText = Toolkit.getText(50);
                            break;
                        }
                        case 2: {
                            this.mMedalText = Toolkit.getText(49);
                            break;
                        }
                        default: {
                            this.mMedalText = Toolkit.getText(48);
                        }
                    }
                    this.changeState(8);
                    n5 = mMiniGameID + 1;
                    while (!GameEngine.miniGameQuerys(n5, 2) && n5 % 6 != 0) {
                        ++n5;
                    }
                    if (n5 % 6 != 0 && n5 <= 23 && !GameEngine.mMiniGameUnlocked[n5]) {
                        GameEngine.mMiniGameUnlocked[n5] = true;
                        GameEngine.createTextBox(0, 432, Toolkit.getText(GameEngine.TITLES_ID[n5]), true);
                        Game.mGameSelection = n5 % 6;
                        Game.mustSaveGame = true;
                        break;
                    }
                    bKeyEventFlag = false;
                    break;
                }
                this.changeState(9);
                break;
            }
            case 8: {
                bKeyEventFlag = true;
                if (this.mMiniGameIcon != null) {
                    this.mMiniGameIcon.logicUpdate(n);
                }
                if (GameEngine.formTitleSTE != null) {
                    GameEngine.scrollTextEngine(n, GameEngine.formTitleSTE, true);
                }
                if (GameEngine.scrollTextSTE != null) {
                    GameEngine.scrollTextEngine(n, GameEngine.scrollTextSTE, true);
                }
                n2 = mMiniGameID + 1;
                while (!GameEngine.miniGameQuerys(n2, 2) && n2 % 6 != 0) {
                    ++n2;
                }
                if ((n2 % 6 == 0 || n2 > 23 || GameEngine.mMiniGameUnlocked[n2]) && GameEngine.mMiniGameMedals[mMiniGameID] == 3 && !GameEngine.achievementDone[mMiniGameID]) {
                    GameEngine.createTextBox(0, 302, Toolkit.getText(GameEngine.ACHIEVEMENTS_NAMES[mMiniGameID]), true);
                    GameEngine.achievementDone[MiniGame.mMiniGameID] = true;
                }
                bKeyEventFlag = false;
                break;
            }
            case 9: {
                if (GameEngine.mRunningTestMode) {
                    GameEngine.scrollTextEngine(n, GameEngine.formTitleSTE, false);
                }
                if (this.mEndOfPracticeScoreUpTimer < END_OF_PRACTICE_SCOREUP_TIME) {
                    this.mEndOfPracticeScoreUpTimer += n;
                    bKeyEventFlag = false;
                } else if (!this.scoreAnimFinished) {
                    this.scoreAnimFinished = true;
                    this.mEndOfPracticeScoreUpTimer = END_OF_PRACTICE_SCOREUP_TIME;
                    this.updateSoftkeys(false);
                } else {
                    bKeyEventFlag = false;
                }
                if (mMiniGameID != 24) break;
                int n8 = -1;
                if (this.mCorrectAnswers < 4) {
                    if (!GameEngine.achievementDone[mMiniGameID + 0]) {
                        n8 = 0;
                        GameEngine.achievementDone[MiniGame.mMiniGameID + 0] = true;
                    }
                } else if (this.mCorrectAnswers < 8) {
                    if (!GameEngine.achievementDone[mMiniGameID + 1]) {
                        n8 = 1;
                        GameEngine.achievementDone[MiniGame.mMiniGameID + 1] = true;
                    }
                } else if (this.mCorrectAnswers < 11) {
                    if (!GameEngine.achievementDone[mMiniGameID + 2]) {
                        n8 = 2;
                        GameEngine.achievementDone[MiniGame.mMiniGameID + 2] = true;
                    }
                } else if (this.mCorrectAnswers < 14) {
                    if (!GameEngine.achievementDone[mMiniGameID + 3]) {
                        n8 = 3;
                        GameEngine.achievementDone[MiniGame.mMiniGameID + 3] = true;
                    }
                } else if (this.mCorrectAnswers < 15 && !GameEngine.achievementDone[mMiniGameID + 4]) {
                    n8 = 4;
                    GameEngine.achievementDone[MiniGame.mMiniGameID + 4] = true;
                }
                if (n8 > -1) {
                    GameEngine.createTextBox(0, 302, Toolkit.getText(GameEngine.ACHIEVEMENTS_NAMES[mMiniGameID + n8]), true);
                    break;
                }
                bKeyEventFlag = false;
            }
        }
        this.updateButtons(n);
    }

    public void draw(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4 = Toolkit.getScreenWidth();
        if ((this.mState[this.mGameMode] == -1 || this.mState[this.mGameMode] == 8) && n4 < 128) {
            n4 -= 12;
            n3 = 6;
        } else {
            n4 = this.mCanvasWidth;
            n3 = this.mCanvasX;
        }
        int n5 = Toolkit.getScreenWidth() / this.mBackground.getWidth();
        int n6 = Toolkit.getScreenHeight() / this.mBackground.getHeight();
        for (n2 = 0; n2 <= n5; ++n2) {
            for (n = 0; n <= n6; ++n) {
                this.mBackground.draw(graphics, n2 * this.mBackground.getWidth(), n * this.mBackground.getHeight());
            }
        }
        this.mNoteBook.draw(graphics, this.mNoteBookX, this.mNoteBookY);
        switch (this.mState[this.mGameMode]) {
            case 8: {
                n5 = this.mCanvasY;
                n5 = this.drawMGIcon(graphics, n5, false) - 24;
                graphics.setClip(0, 0, this.mFullCanvasWidth, this.mFullCanvasHeight);
                n6 = this.mCanvasHeight - (n5 - this.mCanvasY) - 6 - smFont.getHeight();
                this.mMiniGameMedals[this.mMedalCat - 1].draw(graphics, this.mCanvasX + (this.mCanvasWidth >> 1), n5 + (n6 >> 1));
                smFont.drawString(graphics, this.mMedalText, this.mCanvasX + (this.mCanvasWidth >> 1), n5 += n6 + 6, 17);
                break;
            }
            case 9: {
                n5 = this.mCanvasY + 6;
                n6 = Toolkit.getScreenWidth();
                if (n6 < 128) {
                    n2 = n6 - 12;
                    graphics.setColor(0xFFFFFF);
                    graphics.fillRect(n6 - n2 >> 1, this.mCanvasY, n2, this.mCanvasHeight);
                    graphics.setColor(0);
                    graphics.drawRect(n6 - n2 >> 1, this.mCanvasY, n2, this.mCanvasHeight);
                }
                if (GameEngine.mRunningTestMode) {
                    int n7;
                    if (!this.mShowGlobalTestResults) {
                        n5 = this.drawMGIcon(graphics, n5, true);
                        this.drawTestIconList(graphics, n5, true);
                        break;
                    }
                    n2 = GameEngine.mGeneralInt[3];
                    if (GameEngine.mGeneralInt[2] == 1) {
                        graphics.setClip(GameEngine.mGeneralInt[1], n5, GameEngine.mGeneralInt[0], this.mCanvasHeight);
                        smFont.drawString(graphics, GameEngine.mGeneralStr[0], GameEngine.mGeneralInt[1] + GameEngine.formTitleSTE[3], n5, 20);
                    } else {
                        smFont.drawString(graphics, GameEngine.mGeneralStr[0], GameEngine.mGeneralInt[1], n5, 17);
                    }
                    n = END_OF_PRACTICE_SCOREUP_TIME - this.mEndOfPracticeScoreUpTimer;
                    int n8 = (n * n / END_OF_PRACTICE_SCOREUP_TIME * n2 << 10) / END_OF_PRACTICE_SCOREUP_TIME;
                    int n9 = GameEngine.mGeneralInt[4];
                    int n10 = (n5 += smFont.getHeight()) - (this.mBigNumbersSprite.getHeight() * n8 >> 10) + GameEngine.mGeneralInt[5];
                    graphics.setClip(this.mCanvasX, n5, this.mCanvasWidth, this.mBigNumbersSprite.getHeight());
                    for (n7 = -1; n7 <= n2; ++n7) {
                        if (n2 - n7 >= 0 && n10 >= n5 - this.mBigNumbersSprite.getHeight() && n10 < n5 + this.mBigNumbersSprite.getHeight() * 2) {
                            this.printBigNumber(graphics, n9, n10, n2 - n7);
                        }
                        n10 += this.mBigNumbersSprite.getHeight();
                    }
                    n5 += this.mBigNumbersSprite.getHeight() + 1;
                    if (this.mEndOfPracticeScoreUpTimer < END_OF_PRACTICE_SCOREUP_TIME) break;
                    for (n = 0; n < GameEngine.mHighScores.length; ++n) {
                        if (GameEngine.mTestModeMaxScore < GameEngine.mHighScores[n]) continue;
                        if (GameEngine.mHighScoresPlayerPos == n) break;
                        GameEngine.mHighScoresPlayerPos = n;
                        if (GameEngine.mHighScoresPlayerPos == 0 && !GameEngine.achievementDone[29]) {
                            GameEngine.createTextBox(0, 302, Toolkit.getText(GameEngine.ACHIEVEMENTS_NAMES[29]), true);
                            GameEngine.achievementDone[29] = true;
                            break;
                        }
                        GameEngine.createTextBox(24, 284, null, true);
                        break;
                    }
                    n = 2;
                    n8 = this.mCanvasHeight - (n5 - this.mCanvasY) - n - 6 - smFont.getHeight() - 1;
                    n8 -= GameEngine.mIconCategories[0].getHeight();
                    for (n9 = 0; n9 < 4; ++n9) {
                        this.drawGraphicStatics(graphics, GameEngine.mCurrentMiniGameTestScoresPer[n9], n8, n5, categoryColors[n9]);
                    }
                    n5 += n8 + 12;
                    n9 = GameEngine.mIconCategories[0].getWidth();
                    for (n10 = 0; n10 < 4; ++n10) {
                        graphics.setColor(categoryColors[n10]);
                        n7 = this.mCanvasX + (this.mCanvasWidth - (n9 + 1 << 2) >> 1);
                        graphics.fillRect(n7 + (n9 + 1) * n10, n5 + 0, n9, smFont.getHeight() + 1);
                        smFont.drawString(graphics, GameEngine.mGeneralStr[2 + n10], n7 + (n9 + 1) * n10 + (n9 >> 1), n5 + 1 + 0, 17);
                    }
                    n5 += smFont.getHeight() + 3;
                    n10 = GameEngine.mIconCategories[0].getWidth() + 1;
                    n7 = this.mCanvasX + (this.mCanvasWidth - (n10 << 2) >> 1) + GameEngine.mIconCategories[0].getPivotX();
                    n5 += GameEngine.mIconCategories[0].getHeight() >> 1;
                    for (int i = 0; i < 4; ++i) {
                        GameEngine.mIconCategories[i].draw(graphics, n7 + n10 * i, n5 + 0);
                    }
                    break;
                }
                if (mMiniGameID == 24) {
                    smFont.drawString(graphics, GameEngine.mGeneralStr[0], this.mCanvasX + (this.mCanvasWidth >> 1), n5, 17);
                    smFont.drawString(graphics, GameEngine.mGeneralStr[1], this.mCanvasX + (this.mCanvasWidth >> 1), n5 += smFont.getHeight() + 6, 17);
                    smFont.drawString(graphics, GameEngine.mGeneralStr[2], this.mCanvasX + (this.mCanvasWidth >> 1), n5 += smFont.getHeight() + 6, 17);
                    MiniGame.drawText(graphics, mSplitText, smFont, this.mCanvasX + (this.mCanvasWidth >> 1), n5 += smFont.getHeight() + 12, 17);
                    break;
                }
                n5 = this.drawMGIcon(graphics, n5, false);
                n2 = this.mCanvasHeight - (n5 - this.mCanvasY) - 12 - smFont.getHeight();
                this.drawGraphicStatics(graphics, GameEngine.mCurrentMiniGameScoresPer[mMiniGameID / 6][mMiniGameID % 6], n2, n5, 0x20FF00);
                smFont.drawString(graphics, GameEngine.mGeneralStr[0], this.mCanvasX + (this.mCanvasWidth >> 1), n5 += n2 + 12, 17);
                break;
            }
            case -1: {
                n5 = this.mCanvasY;
                n6 = n4;
                n2 = n3 + (n6 >> 1);
                n5 += 6;
                n5 = this.drawMGIcon(graphics, n5, false);
                n5 -= smFont.getHeight() + 6;
                if (GameEngine.mRunningTestMode) {
                    MiniGame.drawText(graphics, mSplitText, smFont, n2, n5, 17);
                    n5 += smFont.getHeight();
                }
                n = this.mCanvasHeight - n5 + this.mCanvasY;
                graphics.setClip(6 + n3, this.mCanvasY, n4 - 12, this.mCanvasHeight);
                smFont.drawString(graphics, this.miniGameInstrunctionsString, 6 + n3 + GameEngine.formTitleSTE[3], n5 += n - smFont.getHeight() >> 1, 20);
                smFont.drawString(graphics, this.miniGameInstrunctionsString, 6 + n3 + GameEngine.formTitleSTE[3] + GameEngine.formTitleSTE[1], n5, 20);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.drawGame(graphics);
                graphics.setClip(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
                if (this.mDrawWatchIcon) {
                    this.mWatchIcon.draw(graphics, this.mButtonsPosition[1], this.mButtonsPosition[3]);
                }
                if (this.mDrawButtons) {
                    for (n5 = 0; n5 < this.mButtons.length; ++n5) {
                        this.mButtons[n5].draw(graphics, this.mButtonsPosition[n5], this.mButtonsPosition[n5 + 2]);
                    }
                }
            }
            default: {
                graphics.setClip(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
                this.drawHud(graphics);
            }
        }
        if (this.mState[this.mGameMode] == 6) {
            graphics.setClip(0, 0, this.mFullCanvasWidth, this.mFullCanvasHeight);
            graphics.setColor(10804085);
            graphics.fillRect(0, this.mTimeOutBoxY, this.mFullCanvasWidth, this.mTimeOutBoxHeight);
            graphics.setColor(7578428);
            n5 = this.mTimeOutBoxHeight * 20 / 100;
            graphics.fillRect(0, this.mTimeOutBoxY, this.mFullCanvasWidth, n5);
            graphics.fillRect(0, this.mTimeOutBoxY + this.mTimeOutBoxHeight - n5, this.mFullCanvasWidth, n5);
            graphics.setColor(0);
            graphics.fillRect(0, this.mTimeOutBoxY - 2, this.mFullCanvasWidth, 2);
            graphics.fillRect(0, this.mTimeOutBoxY + this.mTimeOutBoxHeight, this.mFullCanvasWidth, 2);
            if (this.mTimeOutBoxHeight >= this.mTimeOutFontHeight / 2) {
                n6 = Toolkit.getScreenWidth() - (MenuObject.smDefaultTitleBarImageFont.stringWidth(this.mTextTimeOut) + this.mCharsTimeOut.length) >> 1;
                for (n2 = 0; n2 < this.mCharsTimeOut.length; ++n2) {
                    MenuObject.smDefaultTitleBarImageFont.drawChar(graphics, this.mCharsTimeOut[n2], n6, this.mTimeOutCharsY[n2], 20);
                    n6 += MenuObject.smDefaultTitleBarImageFont.charWidth(this.mCharsTimeOut[n2]) + 1;
                }
            }
        }
    }

    private void printBigNumber(Graphics graphics, int n, int n2, int n3) {
        do {
            this.mBigNumbersSprite.setAnimationFrame(n3 % 10);
            this.mBigNumbersSprite.draw(graphics, n, n2);
            this.mBigNumbersSprite.setAnimationFrame(0);
            n -= this.mBigNumbersSprite.getWidth() + 1;
        } while ((n3 /= 10) > 0);
    }

    private void drawGraphicStatics(Graphics graphics, int[] nArray, int n, int n2, int n3) {
        int n4 = this.mCanvasWidth >> 4;
        int n5 = 2;
        graphics.setClip(0, 0, this.mFullCanvasWidth, this.mFullCanvasHeight);
        graphics.setColor(0x808080);
        graphics.fillRect(this.mCanvasX + n4, n2, n5, n);
        graphics.fillRect(this.mCanvasX + n4, n2 + n, this.mCanvasWidth - (n4 << 1), n5);
        int n6 = this.mCanvasWidth - (n4 << 1) - (n5 << 1);
        graphics.setColor(n3);
        for (int i = 0; i < 4; ++i) {
            int n7 = i * (n6 / 4);
            int n8 = nArray[i];
            if (n8 > 100) {
                n8 = 100;
            }
            n8 = n8 * n / 100;
            int n9 = n2 + n - n8;
            int n10 = (i + 1) * (n6 / 4);
            int n11 = nArray[i + 1];
            if (n11 > 100) {
                n11 = 100;
            }
            n11 = n11 * n / 100;
            int n12 = n2 + n - n11;
            if (nArray[i + 1] == -1) {
                int n13 = 7;
                graphics.fillArc(this.mCanvasX + n4 + n5 + n7 - (n13 >> 1), n9 - (n13 >> 1), n13, n13, 0, 360);
                break;
            }
            graphics.drawLine(this.mCanvasX + n4 + n5 + n7, n9, this.mCanvasX + n4 + n5 + n10, n12);
            if (i != 3) continue;
            int n14 = 7;
            graphics.fillArc(this.mCanvasX + n4 + n5 + n10 - (n14 >> 1), n12 - (n14 >> 1), n14, n14, 0, 360);
            break;
        }
    }

    public static int drawText(Graphics graphics, String[] stringArray, ImageFont imageFont, int n, int n2, int n3) {
        if (stringArray == null) {
            return 0;
        }
        int n4 = n2;
        for (int i = 0; i < stringArray.length; ++i) {
            imageFont.drawString(graphics, stringArray[i], n, n4, n3);
            n4 += imageFont.getHeight();
        }
        return stringArray.length;
    }

    protected void initialize(int n, int n2) {
        int n3;
        SpriteObject.initialize();
        this.mTimeToHelp = 0;
        this.mDifficulty = 0;
        this.mLastQuestionsIndex = 0;
        if (this.mMiniGameIcon == null) {
            this.mMiniGameIcon = new SpriteObject(SpriteObject.loadAnimation(GameEngine.mCurrentMiniGameIconId), true);
        }
        this.mCorrectSprite = new SpriteObject(SpriteObject.loadAnimation(655366), false);
        this.mWrongSprite = new SpriteObject(SpriteObject.loadAnimation(655368), false);
        this.mBigNumbersSprite = new SpriteObject(SpriteObject.loadAnimation(655400), false);
        Toolkit.removeAllSoftKeys();
        this.mProcessedTime = 0;
        this.mElapsedTime = 0;
        this.mGameMode = 0;
        this.mMaxTime = n;
        this.mMaxQuestions = n2;
        for (n3 = 0; n3 < 2; ++n3) {
            this.mState[n3] = 0;
            this.mTicks[n3] = 0;
        }
        this.mTimeLeft = n;
        this.mQuestionsLeft = n2;
        this.mCorrectAnswers = 0;
        this.mWrongAnswers = 0;
        this.mScore = 0;
        this.mScoreIncrements = 0;
        this.mForceFailure = false;
        this.mState[this.mGameMode] = -1;
        if (GameEngine.mRunningTestMode) {
            mSplitText = new String[1];
            MiniGame.mSplitText[0] = GameEngine.mTestModeIndex + 1 + "/" + 4;
        }
        this.mProcessedTime = 0;
        this.mElapsedTime = 0;
        this.mForceExit = false;
        this.mIsFinished = false;
        this.mMiniGameMedals[0] = new SpriteObject(SpriteObject.loadAnimation(262180), true);
        this.mMiniGameMedals[1] = new SpriteObject(SpriteObject.loadAnimation(262182), true);
        this.mMiniGameMedals[2] = new SpriteObject(SpriteObject.loadAnimation(262184), true);
        this.mArrowInc = -20480;
        this.mArrowY = 0;
        this.mHelpSoftKey = Toolkit.getText(53);
        this.initializeHud();
        this.miniGameInstrunctionsString = Toolkit.getText(GameEngine.MINIINSTRUCTIONS_ID[mMiniGameID]);
        GameEngine.formTitleSTE = new int[6];
        GameEngine.formTitleSTE[0] = this.mCanvasWidth - 12;
        GameEngine.formTitleSTE[1] = smFont.stringWidth(this.miniGameInstrunctionsString) + 12;
        n3 = Toolkit.getScreenWidth();
        if (n3 >= 128) {
            n3 = this.mCanvasWidth;
        }
        mSplitMinigameName = MenuObject.splitString(GameEngine.mCurrentMiniGameName, smFont, n3 -= 12);
        this.mCountDownTime = 3000;
    }

    protected void createButtons(short[][] sArray, short[][] sArray2) {
        int n = 2;
        if (sArray2 == null) {
            n = 1;
        }
        this.mButtons = new SpriteObject[n];
        this.mButtons[0] = new SpriteObject(sArray, true);
        this.mButtons[0].setAnimation(0, -1, false);
        if (sArray2 != null) {
            this.mButtons[1] = new SpriteObject(sArray2, true);
            this.mButtons[1].setAnimation(0, -1, false);
        } else {
            this.mButtonsPosition[0] = Toolkit.getScreenWidth() / 2;
        }
        this.mButtonsPosition[2] = this.mButtonsPosition[2] + this.mButtons[0].getPivotY() / 2;
        this.mButtonsPosition[3] = this.mButtonsPosition[3] + this.mButtons[0].getPivotY() / 2;
        if (this.mButtonsPosition[2] + this.mButtons[0].getHeight() > Toolkit.getScreenHeight()) {
            this.mButtonsPosition[2] = Toolkit.getScreenHeight() - this.mButtons[0].getPivotY();
            this.mButtonsPosition[3] = Toolkit.getScreenHeight() - this.mButtons[0].getPivotY();
        }
        this.mDrawButtons = true;
    }

    protected void pressButton(int n, boolean bl, boolean bl2) {
        this.mHudConfirmationTicks = 500;
        this.mKeyPressed = n;
        this.mButtonAnimation = bl2 ? (bl ? 1 : 2) : 1;
    }

    protected void registerParticle(int n, int n2) {
        this.registerParticle(n, n2, false);
    }

    protected void registerParticle(int n, int n2, boolean bl) {
        if (bl && GameEngine.sintable != null) {
            for (int i = 0; i <= 224; i += 32) {
                this.mParticleStarSprites[this.mEmptyStarParticle].x = n;
                this.mParticleStarSprites[this.mEmptyStarParticle].y = n2;
                this.mParticleStarSprites[this.mEmptyStarParticle].angle = this.mParticleStartAngle + i;
                this.mParticleStarSprites[this.mEmptyStarParticle].timer = 0;
                this.mParticleStarSprites[this.mEmptyStarParticle].setAnimationFrame(0);
                this.mEmptyStarParticle = (this.mEmptyStarParticle + 1) % 20;
            }
            this.mParticleStartAngle = (this.mParticleStartAngle + 8) % 32;
        }
        this.mParticleSprites[this.mEmptyParticle].x = n;
        this.mParticleSprites[this.mEmptyParticle].y = n2;
        this.mParticleSprites[this.mEmptyParticle].setAnimationFrame(0);
        this.mEmptyParticle = (this.mEmptyParticle + 1) % 10;
    }

    protected abstract void initNextQuestion();

    protected boolean updateWatch(int n) {
        return true;
    }

    protected abstract void updateGame(int var1);

    protected abstract void drawGame(Graphics var1);

    protected abstract int isCorrectAnswer(int var1);

    protected abstract boolean checkAnswer(int var1);

    protected boolean colision(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n5 < n + n3 && n5 + n7 > n && n6 < n2 + n4 && n6 + n8 > n2;
    }

    protected void drawHud(Graphics graphics) {
        int n;
        this.drawQuestions(graphics);
        if (this.mMaxTime > -1) {
            this.drawClock(graphics, this.mTimeLeft, this.mMaxTime);
        }
        if (this.mHudConfirmationTicks > 0) {
            if (this.mScoreIncrements > 0) {
                this.mCorrectSprite.draw(graphics, this.mHudConfirmationPosX, this.mHudConfirmationPosY);
            } else {
                this.mWrongSprite.draw(graphics, this.mHudConfirmationPosX, this.mHudConfirmationPosY);
            }
        }
        for (n = 0; n < 10; ++n) {
            if (this.mParticleSprites[n].isFinishedAnimation()) continue;
            this.mParticleSprites[n].draw(graphics, this.mParticleSprites[n].x, this.mParticleSprites[n].y);
        }
        if (GameEngine.sintable != null) {
            for (n = 0; n < 20; ++n) {
                if (this.mParticleStarSprites[n].isFinishedAnimation()) continue;
                int n2 = GameEngine.trigon_cos(this.mParticleStarSprites[n].angle) * this.mParticleStarSprites[n].timer >> 10;
                int n3 = GameEngine.trigon_sin(this.mParticleStarSprites[n].angle) * this.mParticleStarSprites[n].timer >> 10;
                n2 = n2 * this.mFullCanvasWidth / 750;
                n3 = n3 * this.mFullCanvasWidth / 750;
                this.mParticleStarSprites[n].draw(graphics, n2 += this.mParticleStarSprites[n].x, n3 += this.mParticleStarSprites[n].y);
            }
        }
        if (this.mState[this.mGameMode] == 1) {
            this.mCountdownLines.draw(graphics, Toolkit.getScreenWidth() >> 1, Toolkit.getScreenHeight() >> 1);
            this.mCountdownGears.draw(graphics, Toolkit.getScreenWidth() >> 1, Toolkit.getScreenHeight() >> 1);
            if (this.mCountdownLines.isFinishedAnimation()) {
                this.mCountdownNumbers.draw(graphics, this.mFullCanvasWidth >> 1, this.mFullCanvasHeight >> 1);
            }
        }
        if (this.mTimeToHelp > 10000 && this.mState[0] < 6) {
            n = smFont.stringWidth(this.mHelpSoftKey) + 24;
            graphics.setClip(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
            MenuObject.smScrollLeftAnimations.draw(graphics, MenuObject.smScrollLeftAnimations.getPivotX() + n - (this.mArrowY >> 12), Toolkit.getScreenHeight() - MenuObject.smScrollLeftAnimations.getPivotY() * 2);
        }
    }

    protected void drawClock(Graphics graphics, int n, int n2) {
        int n3 = this.mTimerBarSpr[0].getWidth();
        this.mTimerSpr.draw(graphics, this.mTimerBoxX, this.mTimerBoxY);
        this.mTimerBarSpr[0].draw(graphics, this.mTimerBarBoxX, this.mTimerBarBoxY);
        graphics.setClip(this.mTimerBarBoxX, this.mTimerBarBoxY, n3 * n / n2, this.mTimerBarSpr[0].getHeight());
        this.mTimerBarSpr[1].draw(graphics, this.mTimerBarBoxX, this.mTimerBarBoxY);
        graphics.setClip(0, 0, this.mFullCanvasWidth, this.mFullCanvasHeight);
    }

    protected boolean isPreviouslyAnswered(int n) {
        for (int i = 0; i < this.mLastQuestions.length; ++i) {
            if (n != this.mLastQuestions[i]) continue;
            return true;
        }
        return false;
    }

    private void initializeHud() {
        int n;
        this.mDrawButtons = false;
        this.mDrawWatchIcon = false;
        this.mKeyPressed = -1;
        this.mDifficulty = 0;
        this.mHudConfirmationPosX = -100;
        this.mHudConfirmationPosY = -100;
        this.mHudConfirmationTicks = -1;
        if (this.mBackground == null) {
            this.mBackground = new SpriteObject(SpriteObject.loadAnimation(786443), false);
        }
        this.mNoteBook = new SpriteObject(SpriteObject.loadAnimation(851969), false);
        this.mTimerSpr = new SpriteObject(SpriteObject.loadAnimation(655443), true);
        this.mTimerBarSpr = new SpriteObject[2];
        this.mTimerBarSpr[0] = new SpriteObject(SpriteObject.loadAnimation(655440), false);
        this.mTimerBarSpr[1] = new SpriteObject(SpriteObject.loadAnimation(655436), true);
        this.mWatchIcon = new SpriteObject(SpriteObject.loadAnimation(65597), true);
        this.mNumbersSpr = new SpriteObject(SpriteObject.loadAnimation(655379), false);
        this.mScoreMarkSpr = new SpriteObject(SpriteObject.loadAnimation(655383), false);
        this.mFailMarkSpr = new SpriteObject(SpriteObject.loadAnimation(655381), false);
        this.mCountdownNumbers = new SpriteObject(SpriteObject.loadAnimation(589859), false);
        this.mCountdownGears = new SpriteObject(SpriteObject.loadAnimation(589826), true);
        this.mCountdownLines = new SpriteObject(SpriteObject.loadAnimation(589860), false);
        for (n = 0; n < 10; ++n) {
            this.mParticleSprites[n] = new SpriteObject(SpriteObject.loadAnimation(65598), false);
        }
        if (GameEngine.sintable != null) {
            for (n = 0; n < 20; ++n) {
                this.mParticleStarSprites[n] = new SpriteObject(SpriteObject.loadAnimation(65598), false);
            }
        }
        this.screenSizeChanged();
    }

    private void changeState(int n) {
        int n2 = this.mState[this.mGameMode];
        this.mState[this.mGameMode] = n;
        this.mProcessedTime = 0;
        this.mElapsedTime = 0;
        switch (n) {
            case 9: {
                if (n2 == 8) {
                    GameEngine.formTitleSTE = null;
                    GameEngine.scrollTextSTE = null;
                } else {
                    Game.mustSaveGame = true;
                }
                if (GameEngine.mRunningTestMode) {
                    if (GameEngine.mGeneralStr == null) {
                        String string;
                        int n3;
                        GameEngine.mGeneralStr = new String[6];
                        GameEngine.mGeneralStr[0] = Toolkit.getText(430);
                        int n4 = GameEngine.getLastTest();
                        int n5 = 0;
                        for (n3 = 0; n3 < 4; ++n3) {
                            n5 += GameEngine.mCurrentMiniGameTestScoresPer[n3][n4];
                        }
                        GameEngine.mTestModeMaxScore = n5 /= 4;
                        GameEngine.mTestModeMaxScoreStr = n5 + "%";
                        GameEngine.mGeneralStr[1] = n5 + "%";
                        for (n3 = 0; n3 < 4; ++n3) {
                            string = "" + GameEngine.mCurrentMiniGameTestScoresPer[n3][n4];
                            GameEngine.mGeneralStr[2 + n3] = string = string + "%";
                        }
                        GameEngine.mGeneralInt = new int[6];
                        n3 = Toolkit.getScreenWidth();
                        GameEngine.mGeneralInt[0] = n3 - 12;
                        if (smFont.stringWidth(GameEngine.mGeneralStr[0]) > GameEngine.mGeneralInt[0]) {
                            GameEngine.mGeneralInt[1] = n3 - GameEngine.mGeneralInt[0] >> 1;
                            GameEngine.mGeneralInt[2] = 1;
                            if (GameEngine.formTitleSTE == null) {
                                GameEngine.formTitleSTE = new int[6];
                            }
                            GameEngine.formTitleSTE[0] = GameEngine.mGeneralInt[0];
                            GameEngine.formTitleSTE[1] = smFont.stringWidth(GameEngine.mGeneralStr[0]) + 12;
                        } else {
                            GameEngine.mGeneralInt[2] = 0;
                            GameEngine.mGeneralInt[1] = this.mCanvasX + (this.mCanvasWidth >> 1);
                        }
                        GameEngine.mGeneralInt[3] = n5;
                        string = "" + n5;
                        int n6 = string.length();
                        this.mBigNumbersSprite.setAnimationFrame(0);
                        GameEngine.mGeneralInt[4] = this.mCanvasX + (this.mCanvasWidth >> 1) + (this.mBigNumbersSprite.getWidth() >> 1) * (n6 - 1);
                        GameEngine.mGeneralInt[5] = (this.mBigNumbersSprite.getHeight() >> 1) - this.mBigNumbersSprite.getHeight();
                    }
                    Toolkit.playMusic(65546, -1);
                    break;
                }
                if (mMiniGameID == 24) {
                    int n7 = 401;
                    if (this.mCorrectAnswers == 0) {
                        n7 = 395;
                    } else if (this.mCorrectAnswers < 4) {
                        n7 = 396;
                    } else if (this.mCorrectAnswers < 7) {
                        n7 = 397;
                    } else if (this.mCorrectAnswers < 10) {
                        n7 = 398;
                    } else if (this.mCorrectAnswers < 13) {
                        n7 = 399;
                    } else if (this.mCorrectAnswers < 15) {
                        n7 = 400;
                    }
                    mSplitText = MenuObject.splitString(Toolkit.getText(n7), smFont, this.mCanvasWidth);
                    if (GameEngine.mGeneralStr == null) {
                        GameEngine.mGeneralStr = new String[3];
                        GameEngine.mGeneralStr[0] = Toolkit.getText(425);
                        GameEngine.mGeneralStr[1] = Toolkit.getText(171) + " " + this.mCorrectAnswers;
                        GameEngine.mGeneralStr[2] = Toolkit.getText(172) + " " + this.mWrongAnswers;
                    }
                } else if (GameEngine.mGeneralStr == null) {
                    GameEngine.mGeneralStr = new String[1];
                    int n8 = this.getBalancedScore(this.mScore);
                    String string = Toolkit.getText(429) + Toolkit.getText(431) + " ";
                    GameEngine.mGeneralStr[0] = string + n8 + "%";
                }
                Toolkit.playMusic(65545, -1);
                break;
            }
            case 8: {
                if (this.mMedalCat == 3) {
                    Toolkit.playMusic(65548, -1);
                    break;
                }
                Toolkit.playMusic(65547, -1);
                break;
            }
            case 6: {
                this.mTimeOutTimer = 3000;
                int n9 = 402;
                if (mMiniGameID == 24) {
                    n9 = 403;
                }
                this.mTextTimeOut = Toolkit.getText(n9);
                this.mCharsTimeOut = this.mTextTimeOut.toCharArray();
                this.mTimeOutBoxHeight = 1;
                this.mTimeOutFontHeight = MenuObject.smDefaultTitleBarImageFont.getHeight();
                this.mTimeOutCharsY = new int[this.mCharsTimeOut.length];
                this.mTimeOutCharsInc = new int[this.mCharsTimeOut.length];
                for (int i = 0; i < this.mCharsTimeOut.length; ++i) {
                    this.mTimeOutCharsY[i] = (this.mFullCanvasHeight - this.mTimeOutFontHeight >> 1) + i;
                    this.mTimeOutCharsInc[i] = -1;
                }
                break;
            }
        }
        this.updateSoftkeys(false);
    }

    private void updatePoints(int n) {
        if (this.mGameMode != 0 && this.mGameMode != 1) {
            return;
        }
        if (n < 3) {
            if (n != 2) {
                this.changeState(5);
            }
            if (n == 0 || n == 2) {
                this.mScoreIncrements = POINTS_FOR_RIGHT[mMiniGameID];
                ++this.mCorrectAnswers;
                if (n == 0) {
                    ++this.mDifficulty;
                    if (this.mDifficulty > 10) {
                        this.mDifficulty = 10;
                    }
                }
            } else {
                this.mScoreIncrements = -POINTS_FOR_WRONG[mMiniGameID];
                ++this.mWrongAnswers;
                --this.mDifficulty;
                if (this.mDifficulty < 0) {
                    this.mDifficulty = 0;
                }
                Toolkit.vibrate(500);
            }
            this.mScore += this.mScoreIncrements;
            if (this.mScore < 0) {
                this.mScore = 0;
            }
        }
    }

    private void updateButtons(int n) {
        if (this.mDrawButtons) {
            if (this.mKeyPressed > -1) {
                switch (this.mButtons[this.mKeyPressed].getCurrentAnimationIndex()) {
                    case 0: {
                        if (this.mButtonAnimation == 1) {
                            this.mButtons[this.mKeyPressed].setAnimation(1, 0, false);
                            break;
                        }
                        this.mButtons[this.mKeyPressed].setAnimation(this.mButtonAnimation, -1, false);
                        break;
                    }
                    default: {
                        if (this.mButtons[this.mKeyPressed].getCurrentAnimationIndex() == this.mButtonAnimation) break;
                        this.mButtons[this.mKeyPressed].setAnimation(this.mButtonAnimation, -1, false);
                    }
                }
            }
            for (int i = 0; i < this.mButtons.length; ++i) {
                if (this.mKeyPressed != i && this.mButtons[i].getCurrentAnimationIndex() != 0) {
                    this.mButtons[i].setAnimation(0, -1, false);
                    if (this.mButtons.length > 1) {
                        this.mButtons[Math.abs(i - 1)].setAnimation(0, -1, false);
                    }
                }
                this.mButtons[i].logicUpdate(n);
            }
        }
    }

    private void drawQuestions(Graphics graphics) {
        if (mMiniGameID == 14 || mMiniGameID == 17) {
            this.mScoreMarkSpr.draw(graphics, this.mFailsMarkPosX, this.mFailsMarkPosY);
            this.drawNumbers(graphics, this.mCorrectAnswers, this.mFailsPosX, this.mFailsPosY, 3);
        } else if (Toolkit.getScreenWidth() < 132) {
            this.mFailMarkSpr.draw(graphics, this.mFailsMarkPosX, this.mFailsMarkPosY);
            this.drawNumbers(graphics, this.mWrongAnswers, this.mFailsPosX - 6, this.mFailsPosY, 3);
            this.mScoreMarkSpr.draw(graphics, this.mScoreMarkX - 18, this.mScoreMarkY);
            this.drawNumbers(graphics, this.mCorrectAnswers, this.mScorePosX - 24, this.mScorePosY, 3);
        } else {
            this.mFailMarkSpr.draw(graphics, this.mFailsMarkPosX, this.mFailsMarkPosY);
            this.drawNumbers(graphics, this.mWrongAnswers, this.mFailsPosX, this.mFailsPosY, 3);
            this.mScoreMarkSpr.draw(graphics, this.mScoreMarkX, this.mScoreMarkY);
            this.drawNumbers(graphics, this.mCorrectAnswers, this.mScorePosX, this.mScorePosY, 3);
        }
    }

    private void drawNumbers(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = 0;
        if (Toolkit.getScreenWidth() < 128) {
            n2 -= 1 + (n4 - 2);
            n6 = 1;
        }
        int n7 = n5 / 1000;
        int n8 = (n5 -= n7 * 1000) / 100;
        int n9 = (n5 -= n8 * 100) / 10;
        n5 -= n9 * 10;
        if (n4 > 3) {
            this.mNumbersSpr.setAnimationFrame(n7);
            this.mNumbersSpr.draw(graphics, n2, n3);
            n2 += this.mNumbersSpr.getWidth() + n6;
        }
        if (n4 > 2) {
            this.mNumbersSpr.setAnimationFrame(n8);
            this.mNumbersSpr.draw(graphics, n2, n3);
            n2 += this.mNumbersSpr.getWidth() + n6;
        }
        this.mNumbersSpr.setAnimationFrame(n9);
        this.mNumbersSpr.draw(graphics, n2, n3);
        this.mNumbersSpr.setAnimationFrame(n5);
        this.mNumbersSpr.draw(graphics, n2 += this.mNumbersSpr.getWidth() + n6, n3);
    }

    private int drawMGIcon(Graphics graphics, int n, boolean bl) {
        if (this.mMiniGameIcon != null) {
            this.mMiniGameIcon.draw(graphics, this.mCanvasX + (this.mCanvasWidth >> 1), n + (this.mMiniGameIcon.getHeight() >> 1));
            n += this.mMiniGameIcon.getHeight() + 6;
        }
        MiniGame.drawText(graphics, mSplitMinigameName, smFont, this.mCanvasX + (this.mCanvasWidth >> 1), n, 17);
        n += smFont.getHeight() * mSplitMinigameName.length + 6;
        if (bl) {
            int n2 = 0;
            int n3 = 0;
            int[] nArray = GameEngine.mCurrentMiniGameTestScoresPer[GameEngine.mTestModeIndex - 1];
            while (nArray[n3] != -1) {
                n2 = nArray[n3];
                ++n3;
            }
            smFont.drawString(graphics, Toolkit.getText(429) + ": " + n2 + "%", this.mCanvasX + (this.mCanvasWidth >> 1), n, 17);
        }
        return n + smFont.getHeight() + 6;
    }

    private int drawTestIconList(Graphics graphics, int n, boolean bl) {
        int n2 = GameEngine.mIconCategories[0].getWidth() + 1;
        int n3 = this.mCanvasX + (this.mCanvasWidth - (n2 << 2) >> 1) + GameEngine.mIconCategories[0].getPivotX();
        n += GameEngine.mIconCategories[0].getHeight() >> 1;
        if (bl) {
            MenuObject.smScrollDownAnimations.draw(graphics, n3 + n2 * (GameEngine.mTestModeIndex - 1), n -= MenuObject.smScrollDownAnimations.getHeight());
            n += MenuObject.smScrollDownAnimations.getHeight() << 1;
        }
        for (int i = 0; i < 4; ++i) {
            GameEngine.mIconCategories[i].draw(graphics, n3 + n2 * i, n);
        }
        return n + GameEngine.mIconCategories[0].getHeight();
    }

    private int getBalancedScore(int n) {
        int n2;
        if (n <= 0) {
            n2 = 0;
        } else if (n <= FUNCTION_DISCRETIZATION[mMiniGameID * 4]) {
            n2 = n * 25 / FUNCTION_DISCRETIZATION[mMiniGameID * 4];
        } else if (n <= FUNCTION_DISCRETIZATION[mMiniGameID * 4 + 1]) {
            n2 = (n -= FUNCTION_DISCRETIZATION[mMiniGameID * 4]) * 25 / (FUNCTION_DISCRETIZATION[mMiniGameID * 4 + 1] - FUNCTION_DISCRETIZATION[mMiniGameID * 4]);
            n2 += 25;
        } else if (n <= FUNCTION_DISCRETIZATION[mMiniGameID * 4 + 2]) {
            n2 = (n -= FUNCTION_DISCRETIZATION[mMiniGameID * 4 + 1]) * 25 / (FUNCTION_DISCRETIZATION[mMiniGameID * 4 + 2] - FUNCTION_DISCRETIZATION[mMiniGameID * 4 + 1]);
            n2 += 50;
        } else {
            n2 = (n -= FUNCTION_DISCRETIZATION[mMiniGameID * 4 + 2]) * 25 / (FUNCTION_DISCRETIZATION[mMiniGameID * 4 + 3] - FUNCTION_DISCRETIZATION[mMiniGameID * 4 + 2]);
            n2 += 75;
        }
        return n2;
    }

    public int updateMusic() {
        if (this.mState[this.mGameMode] == 9) {
            if (GameEngine.mRunningTestMode) {
                return 65546;
            }
            return 65545;
        }
        if (this.mState[this.mGameMode] == 8) {
            if (this.mMedalCat == 3) {
                return 65548;
            }
            return 65547;
        }
        this.mMusicPlaying = true;
        return 65543;
    }

    static {
        rnd = 0;
        RND_Cont = (int)(System.currentTimeMillis() >> 8 & 0xFL);
        RND_Data = new int[]{440777937, 1385877358, -210086711, 541049956, 838251821};
        categoryColors = new int[]{16755724, 4561669, 10092629, 30348};
        END_OF_PRACTICE_SCOREUP_TIME = 10000;
        POINTS_FOR_RIGHT = new int[]{3, 10, 3, 3, 3, 3, 2, 1, 1, 1, 3, 3, 1, 3, 1, 3, 3, 1, 3, 3, 1, 1, 1, 3, 1};
        POINTS_FOR_WRONG = new int[]{2, 5, 2, 2, 2, 2, 3, 1, 3, 1, 2, 2, 0, 2, 0, 2, 2, 0, 2, 2, 8, 0, 5, 2, 1};
        FUNCTION_DISCRETIZATION = new int[]{100, 150, 175, 200, 80, 120, 150, 170, 90, 110, 125, 150, 40, 45, 50, 55, 30, 55, 65, 75, 100, 140, 200, 220, 40, 70, 90, 110, 14, 17, 20, 25, 35, 58, 60, 70, 15, 20, 25, 30, 35, 60, 70, 80, 20, 50, 75, 85, 10, 13, 15, 17, 70, 100, 150, 170, 10, 20, 28, 35, 70, 85, 100, 120, 45, 55, 65, 75, 20, 25, 30, 35, 15, 20, 25, 30, 10, 15, 29, 35, 30, 50, 80, 90, 8, 10, 12, 14, 60, 85, 100, 120, 20, 27, 35, 40, 4, 8, 12, 16};
    }
}

