/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class MiniChamaleon
extends MiniGame {
    private static final int MAX_FLIES = 6;
    private static final int CHAMALEON = 0;
    private static final int FLY = 1;
    private static final int NUM_SPRITES = 2;
    static final int TONGUE_ANIM_MILIS = 400;
    protected SpriteObject[] mSpritesPool;
    private int[] flyX = new int[6];
    private int[] flyY = new int[6];
    private int mQuadX;
    private int mQuadY;
    private int mQuadWidth;
    private int mQuadHeight;
    private int mFlyY;
    private int mFlyHeight;
    static final int ACCURACY = 12;
    private int[] mFlySpeedY = new int[6];
    private int[] mFlySpeedX = new int[6];
    private boolean mCheckCollision;
    private int mAnswer;
    private int numFlies;
    private int killedFlies;
    int mTimer;
    int[] flyTime = new int[6];
    int status;
    static final int STATUS_AIMING = 1;
    static final int STATUS_STRIKE = 2;
    static final int STATUS_RELOAD = 3;
    boolean[] flyAlive = new boolean[6];
    static final int FLY_ALIVE = 0;
    static final int FLY_IN_TONGUE = 1;
    static final int FLY_DEAD = 2;
    private int mTongueTimer;
    private boolean mCreateParticle;

    public MiniChamaleon(int n, int n2) {
        this.mBackground = new SpriteObject(SpriteObject.loadAnimation(720907), false);
        this.initialize(n, n2);
        this.mSpritesPool = new SpriteObject[2];
        this.mSpritesPool[0] = new SpriteObject(SpriteObject.loadAnimation(458826), false);
        this.mSpritesPool[1] = new SpriteObject(SpriteObject.loadAnimation(458813), true);
        this.mSpritesPool[0].setAnimationFrame(this.mSpritesPool[0].getFrameCount() - 1);
        short[] sArray = this.mSpritesPool[0].getCurrentAnimationData();
        int n3 = this.mSpritesPool[0].getCollisionBoxes();
        n3 += 2;
        this.mQuadX = sArray[n3++] + this.mCanvasX;
        this.mQuadY = sArray[n3++] + this.mCanvasY + this.mCanvasHeight;
        this.mQuadWidth = sArray[n3++];
        this.mQuadHeight = sArray[n3++];
        sArray = this.mSpritesPool[1].getCurrentAnimationData();
        n3 = this.mSpritesPool[1].getCollisionBoxes();
        n3 += 2;
        int n4 = ++n3;
        ++n3;
        this.mFlyY = sArray[n4];
        int n5 = ++n3;
        ++n3;
        this.mFlyHeight = sArray[n5];
        this.createButtons(SpriteObject.loadAnimations(new int[]{458817, 458830}), null);
    }

    public void updateGame(int n) {
        int n2;
        int n3;
        int n4;
        this.mTimer += n;
        if (this.status == 1) {
            this.mSpritesPool[0].setAnimationFrame(0);
        } else if (this.status == 2) {
            if (this.mCheckCollision && this.mSpritesPool[0].getCurrentFrameIndex() == this.mSpritesPool[0].getFrameCount() - 1) {
                this.mAnswer = 3;
                this.mButtonAnimation = 1;
                n4 = 0;
                n3 = 0;
                for (n2 = 0; n2 < this.numFlies; ++n2) {
                    if (!this.flyAlive[n2] || (this.mCanvasY + this.mFlyY + (this.flyY[n2] >> 12) + this.mFlyHeight <= this.mQuadY || this.mCanvasY + this.mFlyY + (this.flyY[n2] >> 12) + this.mFlyHeight >= this.mQuadY + this.mQuadHeight) && (this.mCanvasY + this.mFlyY + (this.flyY[n2] >> 12) <= this.mQuadY || this.mCanvasY + this.mFlyY + (this.flyY[n2] >> 12) >= this.mQuadY + this.mQuadHeight)) continue;
                    this.flyAlive[n2] = false;
                    n4 = 1;
                    ++this.killedFlies;
                    ++n3;
                }
                if (n4 != 0) {
                    this.mHudConfirmationPosX = this.mQuadX + this.mQuadWidth;
                    this.mHudConfirmationPosY = this.mQuadY + (this.mQuadHeight >> 1);
                    if (this.mCreateParticle) {
                        this.registerParticle(this.mHudConfirmationPosX, this.mHudConfirmationPosY);
                        this.mCreateParticle = false;
                    }
                    while (n3 > 0) {
                        this.mAnswer = --n3 == 0 && this.killedFlies == this.numFlies ? 0 : 2;
                        if (this.mAnswer == 3 || this.mGameMode == 1) continue;
                        this.mCheckCollision = false;
                        this.keyEvent(53, 0);
                        this.mCheckCollision = true;
                        this.mAnswer = 3;
                        this.mHudConfirmationTicks = 500;
                    }
                } else {
                    this.status = 3;
                    this.mTongueTimer = 400;
                }
            }
        } else {
            this.mTongueTimer -= n;
            if (this.mTongueTimer < 0) {
                this.status = 1;
            } else {
                this.mSpritesPool[0].setAnimationFrame(this.mTongueTimer * this.mSpritesPool[0].getFrameCount() / 400);
            }
        }
        for (n4 = 0; n4 < this.numFlies; ++n4) {
            if (!this.flyAlive[n4]) continue;
            int n5 = n4;
            this.flyTime[n5] = this.flyTime[n5] + n;
            this.mFlySpeedX[n4] = GameEngine.trigon_sin(this.mTimer >> 2) << 6;
            int n6 = n4;
            this.flyY[n6] = this.flyY[n6] + (this.mFlySpeedY[n4] * n >> 8);
            n3 = this.mQuadY - this.mCanvasY - this.mCanvasHeight / 3;
            n2 = this.mQuadY - this.mCanvasY + this.mCanvasHeight / 3;
            if (n3 < 0) {
                n3 = 0;
            }
            if (n2 > this.mCanvasY + this.mCanvasHeight) {
                n2 = this.mCanvasY + this.mCanvasHeight;
            }
            if (this.mFlySpeedY[n4] > 0 && this.flyY[n4] > n2 << 12) {
                this.mFlySpeedY[n4] = -this.mFlySpeedY[n4];
            }
            if (this.mFlySpeedY[n4] >= 0 || this.flyY[n4] > n3 << 12) continue;
            this.mFlySpeedY[n4] = -this.mFlySpeedY[n4];
        }
        for (n4 = 0; n4 < 2; ++n4) {
            this.mSpritesPool[n4].logicUpdate(n);
        }
    }

    protected boolean checkAnswer(int n) {
        return true;
    }

    public void drawGame(Graphics graphics) {
        short[] sArray;
        int n;
        graphics.setClip(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
        for (int i = 0; i < this.numFlies; ++i) {
            if (!this.flyAlive[i]) continue;
            n = GameEngine.trigon_cos(this.flyTime[i] >> 2) * this.mCanvasWidth >> 2;
            this.mSpritesPool[1].draw(graphics, this.mCanvasX + (this.flyX[i] + n >> 12), this.mCanvasY + (this.flyY[i] >> 12));
        }
        this.mSpritesPool[0].draw(graphics, this.mCanvasX, this.mCanvasY + this.mCanvasHeight);
        if (this.status == 3 && this.mAnswer == 2 && (sArray = this.mSpritesPool[0].getCurrentAnimationData())[n = this.mSpritesPool[0].getCollisionBoxes()] != 0) {
            n += 2;
            int n2 = sArray[n++];
            int n3 = sArray[n++];
            n2 += sArray[n++] >> 1;
            n3 += sArray[n++] >> 1;
            this.mSpritesPool[1].draw(graphics, n2 += this.mCanvasX, n3 += this.mCanvasY + this.mCanvasHeight);
        }
        graphics.setClip(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
    }

    protected void initNextQuestion() {
        int n;
        this.killedFlies = 0;
        this.numFlies = 3;
        this.mCheckCollision = true;
        this.status = 1;
        this.mAnswer = 3;
        this.mSpritesPool[0].setAnimationFrame(0);
        for (n = 0; n < this.numFlies; ++n) {
            this.flyAlive[n] = true;
            this.flyTime[n] = MiniChamaleon.rnd(5000);
            this.flyX[n] = this.mSpritesPool[0].getWidth() - (this.mCanvasWidth >> 7) << 12;
            this.flyY[n] = MiniChamaleon.rnd(256) <= 128 ? (this.mCanvasHeight >> 4) + MiniChamaleon.rnd(this.mCanvasHeight / 3) : this.mCanvasHeight - (this.mCanvasHeight >> 4) - MiniChamaleon.rnd(this.mCanvasHeight / 3);
        }
        n = Math.max(this.mDifficulty, 1);
        int n2 = 8;
        if (this.mDifficulty < 4) {
            n2 = 6;
        }
        if (this.mDifficulty > 8) {
            n2 = 10;
        }
        for (int i = 0; i < this.numFlies; ++i) {
            this.mFlySpeedY[i] = (n2 + MiniChamaleon.rnd(n)) * this.mCanvasHeight << 5;
            this.mFlySpeedY[i] = Math.abs(this.mFlySpeedY[i]);
            if (this.flyY[i] > this.mQuadY + this.mQuadHeight) {
                int n3 = i;
                this.mFlySpeedY[n3] = this.mFlySpeedY[n3] * -1;
            }
            this.flyY[i] = this.flyY[i] << 12;
        }
    }

    protected int isCorrectAnswer(int n) {
        int n2;
        if (this.status == 1 && n != 0 && ((n2 = Toolkit.getToolkitGameAction(n)) == 53 || n == 53) && this.mCheckCollision) {
            this.status = 2;
            this.pressButton(0, true, false);
            this.mHudConfirmationPosX = -1000;
            this.mHudConfirmationPosY = -1000;
            this.mCreateParticle = true;
        }
        return this.mAnswer;
    }
}

