/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.EnemyType;
import Game.Sprite;
import SAF_Engine.Trigger;
import SAF_Util.Mat;
import SAF_Util.Util;

public class Enemy
extends Sprite {
    static final byte AI_TYPE_FIGHTING = 0;
    static final byte AI_TYPE_POLICEMAN = 1;
    static final byte AI_TYPE_SHOOTING_OFFENSIVE = 2;
    static final byte AI_TYPE_SHOOTING_DEFENSIVE = 3;
    static final byte AI_TYPE_STATIC = 4;
    static final byte AGGRO_LEVEL_NEUTRAL = 0;
    static final byte AGGRO_LEVEL_AGGRESIVE = 1;
    static final byte BLOOD_TYPE_NONE = -1;
    static final byte BLOOD_TYPE_RED = 0;
    static final byte STATE_WAITING_FOR_REMOVE = -2;
    static final byte STATE_UNDEFINED = -1;
    static final byte STATE_IDLE = 0;
    static final byte STATE_PATROL = 1;
    static final byte STATE_WALKING = 2;
    static final byte STATE_WALKING_WAITING = 3;
    static final byte STATE_WALKING_REST = 4;
    static final byte STATE_CHASING = 5;
    static final byte STATE_CHASING_STEP_BACK = 6;
    static final byte STATE_AIM = 6;
    static final byte STATE_SHOOT = 7;
    static final byte STATE_RETREAT = 8;
    static final byte STATE_PANIC = 9;
    static final byte STATE_LOST = 10;
    static final byte STATE_DEATH = 11;
    static final byte SEQUENCE_IDLE = 0;
    static final byte SEQUENCE_WALK = 4;
    static final byte SEQUENCE_AIM = 8;
    static final byte SEQUENCE_SHOOT = 12;
    static final byte SEQUENCE_DEATH = 16;
    EnemyType enemyType;
    byte aggroLevel;
    boolean isActive;
    private byte state;
    long stateTime;
    int stateTimeOverall;
    short healthPoints;
    int patrolDestXf;
    int patrolDestYf;
    int patrolStartXf;
    int patrolStartYf;
    short spawnPositionX;
    short spawnPositionY;
    short spawnPatrolDestX;
    short spawnPatrolDestY;
    byte spawnState;
    byte spawnDirection;
    int proposedPositionXf;
    int proposedPositionYf;
    int speedF;
    int speedAlternativeXf;
    int speedAlternativeYf;
    boolean isSlide = false;
    boolean isSlideReverse;
    boolean panicIsAfter;
    private static long auxRange;
    private static long auxLx;
    private static long auxLy;
    private static int auxX;
    private static int auxY;
    private static int auxR;

    void init() {
        this.type = 1;
        this.panicIsAfter = false;
    }

    void reset() {
    }

    void update(int n) {
    }

    private void stateInit() {
        switch (this.state) {
            case 11: {
                this.isActive = false;
                break;
            }
            case 6: {
                this.stateTimeOverall = Util.getRandom(this.enemyType.aimTimeMinMs, this.enemyType.aimTimeMaxMs);
                break;
            }
            case 7: {
                this.stateTimeOverall = Util.getRandom(this.enemyType.shootDelayTimeMinMs, this.enemyType.shootDelayTimeMaxMs);
                break;
            }
            case 1: {
                this.patrolStartXf = this.positionXf;
                this.patrolStartYf = this.positionYf;
                break;
            }
            case 2: {
                this.speedWalkingCalculate();
                this.stateTimeOverall = Util.getRandom(10000, 30000);
                break;
            }
            case 4: {
                this.stateTimeOverall = Util.getRandom(2000, 2000);
                break;
            }
            case 9: {
                this.panicIsAfter = true;
                this.stateTimeOverall = Util.getRandom(this.enemyType.panicTimeMinMs, this.enemyType.panicTimeMaxMs);
            }
        }
    }

    void stateReset() {
        this.state = (byte)-1;
    }

    public void stateChange(byte by) {
        if (by != this.state) {
            this.animationFrameCounterReset();
            this.state = by;
            this.stateTime ^= this.stateTime;
            this.stateInit();
        }
    }

    public byte getState() {
        return this.state;
    }

    public long getStateTime() {
        return this.stateTime;
    }

    boolean damageTake(int n) {
        if (this.state != -2 && this.state != 11) {
            this.aggroLevel = 1;
            this.healthPoints = (short)(this.healthPoints - n);
            if (this.healthPoints <= 0) {
                this.stateChange((byte)11);
                return true;
            }
            if (!this.panicIsAfter && this.enemyType.aiType != 1 && this.enemyType.aiType != 4 && this.healthPoints < this.enemyType.healthPointsMax * 33 / 100 && Util.getRandom(0, 100) <= this.enemyType.panicChance) {
                this.stateChange((byte)9);
            }
        }
        return false;
    }

    private void speedWalkingCalculate() {
        switch (this.direction) {
            case 0: {
                this.speedAlternativeXf = -this.speedF;
                this.speedAlternativeYf ^= this.speedAlternativeYf;
                break;
            }
            case 1: {
                this.speedAlternativeXf = this.speedF;
                this.speedAlternativeYf ^= this.speedAlternativeYf;
                break;
            }
            case 2: {
                this.speedAlternativeXf ^= this.speedAlternativeXf;
                this.speedAlternativeYf = -this.speedF;
                break;
            }
            case 3: {
                this.speedAlternativeXf ^= this.speedAlternativeXf;
                this.speedAlternativeYf = this.speedF;
            }
        }
    }

    void directionChangeOnTrigger(Trigger trigger) {
        this.setDirection(Sprite.directionRandomGenerate((byte)trigger.params[0], Sprite.getDirectionMask(Sprite.getDirectionOpposite(this.direction))));
        this.speedWalkingCalculate();
        this.positionXf = this.proposedPositionXf = (this.positionXf & 0x7FFFFC00) + 512;
        this.positionYf = this.proposedPositionYf = (this.positionYf & 0x7FFFFC00) + 512;
    }

    byte getCurrentFrame() {
        return this.animationFrameCounter;
    }

    byte getCurrentSequence() {
        switch (this.state) {
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                return 4;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 12;
            }
            case 11: {
                return 16;
            }
        }
        return 0;
    }

    void speedEstablish() {
        this.speedF = Util.getRandom(this.enemyType.movementSpeedMin, this.enemyType.movementSpeedMax);
    }

    boolean isTartgetInEyeRange(int n, int n2) {
        auxX = this.positionXf - n;
        auxY = this.positionYf - n2;
        auxRange = (auxX * auxX >> 10) + (auxY * auxY >> 10);
        return auxRange <= (long)this.enemyType.eyeRangeQf;
    }

    boolean isTargetInShootRange(int n, int n2) {
        auxX = this.positionXf - n;
        auxY = this.positionYf - n2;
        auxRange = (auxX * auxX >> 10) + (auxY * auxY >> 10);
        return auxRange <= (long)this.enemyType.shootRangeQf;
    }

    void moveTo(int n, int n2, int n3) {
        int n4 = n - this.positionXf;
        int n5 = n2 - this.positionYf;
        long l = n4;
        long l2 = n5;
        if (Mat.abs(n4) < 10240 && Mat.abs(n5) < 10240) {
            auxRange = (l * l >> 10) + (l2 * l2 >> 10);
            auxR = Mat.sqrtFixedInt(auxR, 0, (auxR = (int)auxRange) > 1024 ? auxR : 1024);
        } else {
            auxR = (n4 >>= 10) * n4 + (n5 >>= 10) * n5;
            auxR = Mat.sqrtInt(auxR, 0, auxR);
            auxR <<= 10;
        }
        if (auxR > 0) {
            this.proposedPositionXf = this.positionXf + (((int)(l << 10) / auxR * this.speedF >> 10) * n3 >> 10);
            this.proposedPositionYf = this.positionYf + (((int)(l2 << 10) / auxR * this.speedF >> 10) * n3 >> 10);
        }
    }

    void moveFrom(int n, int n2, int n3) {
        auxLx = n - this.positionXf;
        auxLy = n2 - this.positionYf;
        auxRange = (auxLx * auxLx >> 10) + (auxLy * auxLy >> 10);
        auxR = Mat.sqrtFixedInt(auxR, 0, (auxR = (int)auxRange) > 1024 ? auxR : 1024);
        this.proposedPositionXf = this.positionXf - (((int)(auxLx << 10) / auxR * this.speedF >> 10) * n3 >> 10);
        this.proposedPositionYf = this.positionYf - (((int)(auxLy << 10) / auxR * this.speedF >> 10) * n3 >> 10);
    }

    void positionAccept() {
        this.positionXf = this.proposedPositionXf;
        this.positionYf = this.proposedPositionYf;
    }
}

