/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core_gui.UIFloatingTextBox;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGHit;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.EndOfCareerScreen;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.SelectPlanet;
import baltorogames.project_gui.ShowGalaxyUnlock;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import baltorogames.system.Platform;

public class LevelWinScreen
extends MainScreen {
    private UIFloatingTextBox infoBox;
    public static int showUnlockScreen = 0;
    private int numStars = 0;
    protected boolean m_bEndOfCareer = false;

    public LevelWinScreen() {
        this.drawTop = true;
        this.drawTitle = true;
        this.setCaption("");
        this.updateInfo();
        CGAchievements.completeAchievement(0);
        CGAchievements.CheckGalaxy1Completed();
        CGAchievements.CheckGalaxy2Completed();
        CGAchievements.CheckGalaxy3Completed();
        int nMaxCareerLevel = CGUserCareer.GetAdventureLevel();
        int nCurrentCareerLevel = CGEngine.m_nCurrentGalaxy * 12 + CGEngine.m_nCurrentLevel;
        this.numStars = CGUserCareer.arrLevelStats[nCurrentCareerLevel].m_nStars;
        System.out.println("nMaxCareerLevel = " + nMaxCareerLevel);
        System.out.println("nCurrentCareerLevel = " + nCurrentCareerLevel);
        if (nCurrentCareerLevel == nMaxCareerLevel && nCurrentCareerLevel < 36) {
            CGUserCareer.SetAdventureLevel(nCurrentCareerLevel + 1);
            if (nCurrentCareerLevel + 1 >= 36) {
                this.m_bEndOfCareer = true;
                System.out.println("-----ACHI END OF CAREER NOT IMPLEMENTED----");
            }
        } else {
            this.m_bEndOfCareer = false;
        }
        if (nCurrentCareerLevel + 1 < 36 || this.m_bEndOfCareer) {
            this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
            if (this.m_bEndOfCareer) {
                this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, null, null);
            }
        } else {
            this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        }
        CGUserCareer.SetLevelTime(nCurrentCareerLevel, CGLevelStats.m_nTime);
        CGUserCareer.SetLevelScore(nCurrentCareerLevel, CGLevelStats.m_nScore);
        CGUserCareer.AddPoints(CGLevelStats.m_nScore);
        if (nCurrentCareerLevel >= 27) {
            CGAchievements.completeAchievement(3);
        }
        CGAchievements.CheckAllLevels3Stars();
        ApplicationData.generalGameMode = 3;
    }

    public void autoSize() {
        this.clientAreaX = Platform.WND_MARGIN_LEFT;
        this.clientAreaWidth = this.width - Platform.WND_MARGIN_LEFT - Platform.WND_MARGIN_RIGHT;
        this.clientAreaY = Platform.WND_MARGIN_TOP;
        this.clientAreaHeight = this.height - Platform.WND_MARGIN_TOP - Platform.WND_MARGIN_BOTTOM;
    }

    private void updateInfo() {
        if (this.infoBox == null) {
            this.infoBox = new UIFloatingTextBox(true, 0, ApplicationData.screenHeight / 2 + CGHit.m_HitTextures[8][0].GetHeight(), ApplicationData.screenWidth, ApplicationData.defaultFont.getFontHeight() * 3);
        }
        this.infoBox.setText(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_USER_SCORE_SURVIVE") + '\u00ff' + ApplicationData.defaultFont.encodeDynamicString("" + CGLevelStats.m_nScore));
    }

    public void onUpdate(float deltaTime) {
        super.onUpdate(deltaTime);
    }

    public void draw() {
        this.infoBox.draw();
        Graphic2D.DrawImage(ObjectsCache.menuStarsBackground, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
        Graphic2D.DrawImage(CGHit.m_HitTextures[8][0], ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 4, 3);
        if (ObjectsCache.star == null) {
            for (int i = 1; i <= 3; ++i) {
                Graphic2D.DrawImage(this.numStars < i ? ObjectsCache.menuStarsGrey : ObjectsCache.menuStarsGold, i * ApplicationData.screenWidth / 4, ApplicationData.screenHeight / 2, 3);
            }
        } else if (this.lifeTime < 2.0f) {
            if (this.numStars >= 1) {
                ObjectsCache.star.setTime((int)(this.lifeTime * 1000.0f));
                ObjectsCache.star.renderV(ApplicationData.screenWidth / 4, ApplicationData.screenHeight / 2);
            } else {
                Graphic2D.DrawImage(ObjectsCache.menuStarsGrey, ApplicationData.screenWidth / 4, ApplicationData.screenHeight / 2, 3);
            }
        } else if (this.lifeTime < 4.0f) {
            if (this.numStars >= 2) {
                Graphic2D.DrawImage(ObjectsCache.menuStarsGold, ApplicationData.screenWidth / 4, ApplicationData.screenHeight / 2, 3);
                ObjectsCache.star.setTime((int)((this.lifeTime - 2.0f) * 1000.0f));
                ObjectsCache.star.renderV(2 * ApplicationData.screenWidth / 4, ApplicationData.screenHeight / 2);
            } else {
                Graphic2D.DrawImage(ObjectsCache.menuStarsGrey, 2 * ApplicationData.screenWidth / 4, ApplicationData.screenHeight / 2, 3);
                Graphic2D.DrawImage(this.numStars >= 1 ? ObjectsCache.menuStarsGold : ObjectsCache.menuStarsGrey, ApplicationData.screenWidth / 4, ApplicationData.screenHeight / 2, 3);
            }
        } else if (this.lifeTime < 6.0f) {
            if (this.numStars >= 3) {
                Graphic2D.DrawImage(ObjectsCache.menuStarsGold, ApplicationData.screenWidth / 4, ApplicationData.screenHeight / 2, 3);
                Graphic2D.DrawImage(ObjectsCache.menuStarsGold, 2 * ApplicationData.screenWidth / 4, ApplicationData.screenHeight / 2, 3);
                ObjectsCache.star.setTime((int)((this.lifeTime - 4.0f) * 1000.0f));
                ObjectsCache.star.renderV(3 * ApplicationData.screenWidth / 4, ApplicationData.screenHeight / 2);
            } else {
                Graphic2D.DrawImage(ObjectsCache.menuStarsGrey, 3 * ApplicationData.screenWidth / 4, ApplicationData.screenHeight / 2, 3);
                Graphic2D.DrawImage(this.numStars >= 1 ? ObjectsCache.menuStarsGold : ObjectsCache.menuStarsGrey, ApplicationData.screenWidth / 4, ApplicationData.screenHeight / 2, 3);
                Graphic2D.DrawImage(this.numStars >= 2 ? ObjectsCache.menuStarsGold : ObjectsCache.menuStarsGrey, 2 * ApplicationData.screenWidth / 4, ApplicationData.screenHeight / 2, 3);
            }
        } else {
            for (int i = 1; i <= 3; ++i) {
                Graphic2D.DrawImage(this.numStars < i ? ObjectsCache.menuStarsGrey : ObjectsCache.menuStarsGold, i * ApplicationData.screenWidth / 4, ApplicationData.screenHeight / 2, 3);
            }
        }
    }

    public boolean rightSoftButton() {
        if (!this.m_bEndOfCareer) {
            UIScreen.SetCurrentScreen(new SelectPlanet(CGEngine.m_nCurrentGalaxy));
            ApplicationData.SetMusic();
            CGUserCareer.Save();
            return true;
        }
        return false;
    }

    public boolean leftSoftButton() {
        if (!this.m_bEndOfCareer) {
            if (++CGEngine.m_nCurrentLevel >= 12) {
                CGEngine.m_nCurrentLevel = 0;
                showUnlockScreen = ++CGEngine.m_nCurrentGalaxy;
            }
            ApplicationData.setMainMenuMode();
            if (showUnlockScreen > 0) {
                UIScreen.SetCurrentScreen(new ShowGalaxyUnlock(showUnlockScreen));
            } else {
                UIScreen.SetCurrentScreen(new SelectPlanet(CGEngine.m_nCurrentGalaxy, CGEngine.m_nCurrentLevel));
            }
        } else {
            UIScreen.SetCurrentScreen(new EndOfCareerScreen(true, 0, false, this));
        }
        CGUserCareer.Save();
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }
}

