/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGBall;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGFallingPowerUp;
import baltorogames.project_gameplay.CGHit;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.CGShot;
import baltorogames.project_gameplay.CollisionObject;
import baltorogames.project_gameplay.PaddleObject;
import baltorogames.project_gameplay.WorldObject;

public class CGEngineRenderer {
    public static final int PADDLE_ANIM_TYPES = 2;
    public static final int PADDLE_IDDLE_FRAMES = 17;
    public static final int PADDLE_SIDEWAYS_ANIM_FRAMES = 15;
    public static final int PADDLE_COLL_ANIM_FRAMES = 10;
    public static int selectedMenuBackground = 0;
    public static float m_fBoardStartY = 0.0f;
    public static float m_fScreenOffsetX = 0.0f;
    public static float m_fScreenOffsetY = 0.0f;
    public static CGTexture[] m_FallingPowerUpTextures = new CGTexture[11];
    public static CGTexture m_NormalBallTexture = null;
    public static CGTexture m_SuperBallTexture = null;
    public static CGTexture m_FireBallTexture = null;
    public static CGTexture[] m_BlockerBallTexture = new CGTexture[1];
    public static CGTexture[] m_ShotTexture = new CGTexture[5];
    public static CGTexture[] m_BlockTexture = new CGTexture[9];
    public static CGTexture[] m_PaddleTexture = new CGTexture[3];
    public static CGTexture[] m_BlockShieldTexture = new CGTexture[3];
    public static CGTexture[] m_BackGroundTexture = new CGTexture[6];
    public static CGTexture[] m_BlockPortalTexture = new CGTexture[4];
    public static CGTexture m_BlockBombTexture;
    public static CGTexture m_BlockIndestructableTexture;
    public static CGTexture m_BlockRubberTexture;
    public static CGTexture m_BlockHorizontTexture;
    public static CGTexture m_BlockVerticalTexture;
    public static CGTexture[][] m_HUD_Borders;
    public static CGTexture[] m_HUD_elements;
    public static float middleX;

    public static void Init() {
        int i;
        CGEngineRenderer.m_FallingPowerUpTextures[0] = TextureManager.CreateFilteredTexture("/gameplay/powerups/pup_laser_0.png");
        CGEngineRenderer.m_FallingPowerUpTextures[1] = TextureManager.CreateFilteredTexture("/gameplay/powerups/pup_fball_0.png");
        CGEngineRenderer.m_FallingPowerUpTextures[2] = TextureManager.CreateFilteredTexture("/gameplay/powerups/pup_glue_0.png");
        CGEngineRenderer.m_FallingPowerUpTextures[3] = TextureManager.CreateFilteredTexture("/gameplay/powerups/pup_dstick_0.png");
        CGEngineRenderer.m_FallingPowerUpTextures[4] = TextureManager.CreateFilteredTexture("/gameplay/powerups/pup_tball_0.png");
        CGEngineRenderer.m_FallingPowerUpTextures[5] = TextureManager.CreateFilteredTexture("/gameplay/powerups/pup_slow_0.png");
        CGEngineRenderer.m_FallingPowerUpTextures[6] = TextureManager.CreateFilteredTexture("/gameplay/powerups/pdn_icontrols_0.png");
        CGEngineRenderer.m_FallingPowerUpTextures[7] = TextureManager.CreateFilteredTexture("/gameplay/powerups/pdn_speedup_0.png");
        CGEngineRenderer.m_FallingPowerUpTextures[8] = TextureManager.CreateFilteredTexture("/gameplay/powerups/pdn_blocker_0.png");
        CGEngineRenderer.m_FallingPowerUpTextures[9] = TextureManager.CreateFilteredTexture("/gameplay/powerups/pdn_shrink_0.png");
        CGEngineRenderer.m_FallingPowerUpTextures[10] = TextureManager.CreateFilteredTexture("/gameplay/powerups/pup_time_0.png");
        CGEngineRenderer.m_BlockerBallTexture[0] = TextureManager.CreateFilteredTexture("/gameplay/ball_frames/blocker/blockerball_0.png");
        m_BlockBombTexture = TextureManager.CreateFilteredTexture("/gameplay/bomb/block_bomb_0.png");
        m_FireBallTexture = TextureManager.CreateFilteredTexture("/gameplay/ball_frames/fireball/fireball_0.png");
        for (i = 0; i < m_HUD_Borders.length; ++i) {
            CGEngineRenderer.m_HUD_Borders[i][0] = TextureManager.CreateFilteredTexture("/menu/hud_border" + (i + 1) + "_left.png");
            CGEngineRenderer.m_HUD_Borders[i][1] = TextureManager.CreateFilteredTexture("/menu/hud_border" + (i + 1) + "_right.png");
            CGEngineRenderer.m_HUD_Borders[i][2] = TextureManager.CreateFilteredTexture("/menu/hud_border" + (i + 1) + "_top.png");
            CGEngineRenderer.m_HUD_Borders[i][3] = TextureManager.CreateFilteredTexture("/menu/hud_fill_left_" + (i + 1) + ".png");
            CGEngineRenderer.m_HUD_Borders[i][4] = TextureManager.CreateFilteredTexture("/menu/hud_fill_right_" + (i + 1) + ".png");
        }
        for (i = 0; i < m_BackGroundTexture.length; ++i) {
            CGEngineRenderer.m_BackGroundTexture[i] = TextureManager.CreateFilteredTexture("/gameplay/bg/bg_" + (i + 1) + ".png");
        }
        for (i = 0; i < m_ShotTexture.length; ++i) {
            CGEngineRenderer.m_ShotTexture[i] = TextureManager.CreateFilteredTexture("/gameplay/laser/laser_" + (i + 1) + ".png");
        }
        m_NormalBallTexture = TextureManager.CreateFilteredTexture("/gameplay/ball_frames/normal/ball.png");
        m_SuperBallTexture = TextureManager.CreateFilteredTexture("/gameplay/ball_frames/superball/superball.png");
        m_BlockIndestructableTexture = TextureManager.CreateFilteredTexture("/gameplay/block_indestruct.png");
        m_BlockRubberTexture = TextureManager.CreateFilteredTexture("/gameplay/block_rubber.png");
        m_BlockVerticalTexture = TextureManager.CreateFilteredTexture("/gameplay/block_vertical.png");
        m_BlockHorizontTexture = TextureManager.CreateFilteredTexture("/gameplay/block_horizontal.png");
        CGEngineRenderer.m_HUD_elements[0] = TextureManager.CreateFilteredTexture("/menu/hud_ico_time.png");
        CGEngineRenderer.m_HUD_elements[1] = TextureManager.CreateFilteredTexture("/menu/ico_star.png");
        for (i = 0; i < m_BlockTexture.length; ++i) {
            CGEngineRenderer.m_BlockTexture[i] = TextureManager.CreateFilteredTexture("/gameplay/normal_block/block_" + (i + 1) + ".png");
        }
        for (i = 0; i < m_BlockShieldTexture.length; ++i) {
            CGEngineRenderer.m_BlockShieldTexture[i] = TextureManager.CreateFilteredTexture("/gameplay/block_shield/block_drb_" + (i + 1) + ".png");
        }
        for (i = 0; i < m_BlockPortalTexture.length; ++i) {
            CGEngineRenderer.m_BlockPortalTexture[i] = TextureManager.CreateFilteredTexture("/gameplay/portal_frames/block_prt_" + i + ".png");
        }
        CGEngineRenderer.m_PaddleTexture[0] = TextureManager.CreateFilteredTexture("/gameplay/deck_frames/normal_deck.png");
        CGEngineRenderer.m_PaddleTexture[1] = TextureManager.CreateFilteredTexture("/gameplay/deck_frames/double_deck.png");
        CGEngineRenderer.m_PaddleTexture[2] = TextureManager.CreateFilteredTexture("/gameplay/deck_frames/shrink_deck.png");
    }

    public static void RenderFallingPowerUp(int nTime, int nType, float x, float y) {
        Graphic2D.DrawRegion(m_FallingPowerUpTextures[nType], ((x += 23.0f * CGEngine.m_fEngineScale) - CGFallingPowerUp.eHalfWidth) * CGEngine.m_fEngineScale + m_fScreenOffsetX, (y - CGFallingPowerUp.eHalfHeight) * CGEngine.m_fEngineScale + m_fScreenOffsetY, 0.0f, 0.0f, (x + CGFallingPowerUp.eHalfWidth) * CGEngine.m_fEngineScale + m_fScreenOffsetX, (y + CGFallingPowerUp.eHalfHeight) * CGEngine.m_fEngineScale + m_fScreenOffsetY, 1.0f, 1.0f);
    }

    public static void RenderBall(CGBall ball, int nTime) {
        if (ball.isPupBlockerBall) {
            Graphic2D.DrawRegion(m_BlockerBallTexture[0], (float)((int)(ball.vecPos.x - (double)CGBall.eRadius)) * CGEngine.m_fEngineScale + m_fScreenOffsetX, (float)((int)(ball.vecPos.y - (double)CGBall.eRadius)) * CGEngine.m_fEngineScale + m_fScreenOffsetY, 0.0f, 0.0f, (float)((int)(ball.vecPos.x + (double)CGBall.eRadius)) * CGEngine.m_fEngineScale + m_fScreenOffsetX, (float)((int)(ball.vecPos.y + (double)CGBall.eRadius)) * CGEngine.m_fEngineScale + m_fScreenOffsetY, 1.0f, 1.0f);
        } else if (ball.isPupFireBall) {
            Graphic2D.DrawRegion(m_FireBallTexture, (float)((int)(ball.vecPos.x - (double)CGBall.eRadius)) * CGEngine.m_fEngineScale + m_fScreenOffsetX, (float)((int)(ball.vecPos.y - (double)CGBall.eRadius)) * CGEngine.m_fEngineScale + m_fScreenOffsetY, 0.0f, 0.0f, (float)((int)(ball.vecPos.x + (double)CGBall.eRadius)) * CGEngine.m_fEngineScale + m_fScreenOffsetX, (float)((int)(ball.vecPos.y + (double)CGBall.eRadius)) * CGEngine.m_fEngineScale + m_fScreenOffsetY, 1.0f, 1.0f);
        } else if (CGBall.isSuperBall) {
            Graphic2D.DrawRegion(m_SuperBallTexture, (float)((int)(ball.vecPos.x - (double)CGBall.eRadius)) * CGEngine.m_fEngineScale + m_fScreenOffsetX, (float)((int)(ball.vecPos.y - (double)CGBall.eRadius)) * CGEngine.m_fEngineScale + m_fScreenOffsetY, 0.0f, 0.0f, (float)((int)(ball.vecPos.x + (double)CGBall.eRadius)) * CGEngine.m_fEngineScale + m_fScreenOffsetX, (float)((int)(ball.vecPos.y + (double)CGBall.eRadius)) * CGEngine.m_fEngineScale + m_fScreenOffsetY, 1.0f, 1.0f);
        } else {
            Graphic2D.DrawRegion(m_NormalBallTexture, (float)((int)(ball.vecPos.x - (double)CGBall.eRadius)) * CGEngine.m_fEngineScale + m_fScreenOffsetX, (float)((int)(ball.vecPos.y - (double)CGBall.eRadius)) * CGEngine.m_fEngineScale + m_fScreenOffsetY, 0.0f, 0.0f, (float)((int)(ball.vecPos.x + (double)CGBall.eRadius)) * CGEngine.m_fEngineScale + m_fScreenOffsetX, (float)((int)(ball.vecPos.y + (double)CGBall.eRadius)) * CGEngine.m_fEngineScale + m_fScreenOffsetY, 1.0f, 1.0f);
        }
    }

    public static void RenderShot(float x, float y, int nFrame) {
        Graphic2D.DrawRegion(m_ShotTexture[nFrame], (x - CGShot.eHalfWidth) * CGEngine.m_fEngineScale + m_fScreenOffsetX, y * CGEngine.m_fEngineScale + m_fScreenOffsetY, 0.0f, 0.0f, (x + CGShot.eHalfWidth) * CGEngine.m_fEngineScale + m_fScreenOffsetX, (y + CGShot.eHalfHeight) * CGEngine.m_fEngineScale + m_fScreenOffsetY, 1.0f, 1.0f);
    }

    public static void RenderBlock(float x, float y, int nType, int collCounter, int nCurrentFrame) {
        if (nType <= 9) {
            Graphic2D.DrawRegion(m_BlockTexture[nType - 1], x * CGEngine.m_fEngineScale + m_fScreenOffsetX, y * CGEngine.m_fEngineScale + m_fScreenOffsetY, 0.0f, 0.0f, (x + 70.0f) * CGEngine.m_fEngineScale + m_fScreenOffsetX, (y + 24.0f) * CGEngine.m_fEngineScale + m_fScreenOffsetY, 1.0f, 1.0f);
        } else if (nType == 16) {
            Graphic2D.DrawRegion(m_BlockPortalTexture[nCurrentFrame % 4], x * CGEngine.m_fEngineScale + m_fScreenOffsetX, y * CGEngine.m_fEngineScale + m_fScreenOffsetY, 0.0f, 0.0f, (x + 70.0f) * CGEngine.m_fEngineScale + m_fScreenOffsetX, (y + 24.0f) * CGEngine.m_fEngineScale + m_fScreenOffsetY, 1.0f, 1.0f);
        } else if (nType == 12) {
            Graphic2D.DrawRegion(m_BlockBombTexture, x * CGEngine.m_fEngineScale + m_fScreenOffsetX, y * CGEngine.m_fEngineScale + m_fScreenOffsetY, 0.0f, 0.0f, (x + 70.0f) * CGEngine.m_fEngineScale + m_fScreenOffsetX, (y + 24.0f) * CGEngine.m_fEngineScale + m_fScreenOffsetY, 1.0f, 1.0f);
        } else if (nType == 10) {
            if (collCounter > 0) {
                Graphic2D.DrawRegion(m_BlockTexture[0], x * CGEngine.m_fEngineScale + m_fScreenOffsetX, y * CGEngine.m_fEngineScale + m_fScreenOffsetY, 0.0f, 0.0f, (x + 70.0f) * CGEngine.m_fEngineScale + m_fScreenOffsetX, (y + 24.0f) * CGEngine.m_fEngineScale + m_fScreenOffsetY, 1.0f, 1.0f);
            }
            if (collCounter > 1) {
                Graphic2D.DrawRegion(m_BlockShieldTexture[collCounter - 2], x * CGEngine.m_fEngineScale + m_fScreenOffsetX, y * CGEngine.m_fEngineScale + m_fScreenOffsetY, 0.0f, 0.0f, (x + 70.0f) * CGEngine.m_fEngineScale + m_fScreenOffsetX, (y + 24.0f) * CGEngine.m_fEngineScale + m_fScreenOffsetY, 1.0f, 1.0f);
            }
        } else if (nType == 11) {
            Graphic2D.DrawRegion(m_BlockIndestructableTexture, x * CGEngine.m_fEngineScale + m_fScreenOffsetX, y * CGEngine.m_fEngineScale + m_fScreenOffsetY, 0.0f, 0.0f, (x + 70.0f) * CGEngine.m_fEngineScale + m_fScreenOffsetX, (y + 24.0f) * CGEngine.m_fEngineScale + m_fScreenOffsetY, 1.0f, 1.0f);
        } else if (nType == 13) {
            Graphic2D.DrawRegion(m_BlockRubberTexture, x * CGEngine.m_fEngineScale + m_fScreenOffsetX, y * CGEngine.m_fEngineScale + m_fScreenOffsetY, 0.0f, 0.0f, (x + 70.0f) * CGEngine.m_fEngineScale + m_fScreenOffsetX, (y + 24.0f) * CGEngine.m_fEngineScale + m_fScreenOffsetY, 1.0f, 1.0f);
        } else if (nType == 14) {
            Graphic2D.DrawRegion(m_BlockHorizontTexture, x * CGEngine.m_fEngineScale + m_fScreenOffsetX, y * CGEngine.m_fEngineScale + m_fScreenOffsetY, 0.0f, 0.0f, (x + 70.0f) * CGEngine.m_fEngineScale + m_fScreenOffsetX, (y + 24.0f) * CGEngine.m_fEngineScale + m_fScreenOffsetY, 1.0f, 1.0f);
        } else if (nType == 14) {
            Graphic2D.DrawRegion(m_BlockVerticalTexture, x * CGEngine.m_fEngineScale + m_fScreenOffsetX, y * CGEngine.m_fEngineScale + m_fScreenOffsetY, 0.0f, 0.0f, (x + 70.0f) * CGEngine.m_fEngineScale + m_fScreenOffsetX, (y + 24.0f) * CGEngine.m_fEngineScale + m_fScreenOffsetY, 1.0f, 1.0f);
        }
    }

    public static void RenderPaddle(PaddleObject po) {
        Graphic2D.DrawRegion(m_PaddleTexture[po.currentFrame], (float)((po.m_fX - po.m_fW / 2.0) * (double)CGEngine.m_fEngineScale + (double)m_fScreenOffsetX), (float)(po.m_fY * (double)CGEngine.m_fEngineScale + (double)m_fScreenOffsetY), 0.0f, 0.0f, (float)((po.m_fX + po.m_fW / 2.0) * (double)CGEngine.m_fEngineScale + (double)m_fScreenOffsetX), (float)((po.m_fY + po.m_fH) * (double)CGEngine.m_fEngineScale + (double)m_fScreenOffsetY), 1.0f, 1.0f);
    }

    public static void RenderHit(CGHit hit, float x, float y) {
        CGTexture frame = CGHit.m_HitTextures[hit.m_nType][hit.m_nCurrentFrame];
        if (frame != null) {
            int xx = (int)(0.5f + x * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetX;
            int yy = (int)(0.5f + (y + m_fBoardStartY) * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetY;
            if (hit.m_nType == 4) {
                if (xx < frame.GetWidth() / 2) {
                    xx = frame.GetWidth() / 2;
                } else if (xx > ApplicationData.screenWidth - frame.GetWidth() / 2) {
                    xx = ApplicationData.screenWidth - frame.GetWidth() / 2;
                }
            }
            Graphic2D.DrawImage(frame, xx, yy, 17);
        }
    }

    public static void RenderBackground() {
        Graphic2D.DrawImage(m_BackGroundTexture[selectedMenuBackground], ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
    }

    public static void RenderHUD() {
        Graphic2D.DrawImage(m_HUD_Borders[selectedMenuBackground][3], 0, 0, 20);
        Graphic2D.DrawImage(m_HUD_Borders[selectedMenuBackground][4], ApplicationData.screenWidth, 0, 24);
        Graphic2D.DrawImage(m_HUD_Borders[selectedMenuBackground][2], ApplicationData.screenWidth - m_HUD_Borders[selectedMenuBackground][4].GetWidth(), 0, 24);
        Graphic2D.DrawImage(m_HUD_Borders[selectedMenuBackground][0], m_HUD_Borders[selectedMenuBackground][3].GetWidth(), ApplicationData.screenHeight, 36);
        Graphic2D.DrawImage(m_HUD_Borders[selectedMenuBackground][1], ApplicationData.screenWidth - m_HUD_Borders[selectedMenuBackground][4].GetWidth(), ApplicationData.screenHeight, 40);
        CGEngineRenderer.DrawHUDValues();
    }

    private static void DrawHUDValues() {
        if (CGEngine.m_nGameMode == 1) {
            Graphic2D.DrawImage(m_HUD_elements[0], ApplicationData.screenWidth / 2 - m_HUD_Borders[selectedMenuBackground][2].GetWidth() / 4 + m_HUD_elements[0].GetWidth(), m_HUD_elements[0].GetHeight() / 2, 20);
            Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("" + CGLevelStats.m_nTime), ApplicationData.screenWidth / 2 - m_HUD_Borders[selectedMenuBackground][2].GetWidth() / 4 + 2 * m_HUD_elements[0].GetWidth(), m_HUD_elements[0].GetHeight() / 3, 20, 0);
            Graphic2D.DrawImage(m_HUD_elements[1], ApplicationData.screenWidth / 2, m_HUD_elements[1].GetHeight() / 2, 20);
            Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("" + CGLevelStats.m_nScore), ApplicationData.screenWidth / 2 + m_HUD_elements[1].GetWidth(), m_HUD_elements[1].GetHeight() / 3, 20, 0);
            Graphic2D.DrawImage(m_NormalBallTexture, ApplicationData.screenWidth / 2 - m_HUD_Borders[selectedMenuBackground][2].GetWidth() / 3, m_NormalBallTexture.GetHeight() * 2, 17);
            Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("" + CGLevelStats.m_nLifes), ApplicationData.screenWidth / 2 - m_HUD_Borders[selectedMenuBackground][2].GetWidth() / 3, m_NormalBallTexture.GetHeight() * 2 + ApplicationData.defaultFont.getFontHeight(), 3, 0);
        } else if (CGEngine.m_nGameMode == 2) {
            Graphic2D.DrawImage(m_HUD_elements[0], ApplicationData.screenWidth / 2 - m_HUD_Borders[selectedMenuBackground][2].GetWidth() / 4 + m_HUD_elements[0].GetWidth(), m_HUD_elements[0].GetHeight() / 2, 20);
            Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("" + CGLevelStats.m_nTime), ApplicationData.screenWidth / 2 - m_HUD_Borders[selectedMenuBackground][2].GetWidth() / 4 + 2 * m_HUD_elements[0].GetWidth(), m_HUD_elements[0].GetHeight() / 3, 20, 0);
            Graphic2D.DrawImage(m_HUD_elements[1], ApplicationData.screenWidth / 2, m_HUD_elements[1].GetHeight() / 2, 20);
            Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("" + CGLevelStats.m_nScore), ApplicationData.screenWidth / 2 + m_HUD_elements[1].GetWidth(), m_HUD_elements[1].GetHeight() / 3, 20, 0);
        } else if (CGEngine.m_nGameMode == 3) {
            Graphic2D.DrawImage(m_HUD_elements[0], ApplicationData.screenWidth / 2 - m_HUD_Borders[selectedMenuBackground][2].GetWidth() / 4 + m_HUD_elements[0].GetWidth(), m_HUD_elements[0].GetHeight() / 2, 20);
            Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("" + CGLevelStats.m_nTime), ApplicationData.screenWidth / 2 - m_HUD_Borders[selectedMenuBackground][2].GetWidth() / 4 + 2 * m_HUD_elements[0].GetWidth(), m_HUD_elements[0].GetHeight() / 3, 20, 0);
            Graphic2D.DrawImage(m_HUD_elements[1], ApplicationData.screenWidth / 2, m_HUD_elements[1].GetHeight() / 2, 20);
            Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("" + CGLevelStats.m_nScore), ApplicationData.screenWidth / 2 + m_HUD_elements[1].GetWidth(), m_HUD_elements[1].GetHeight() / 3, 20, 0);
        }
    }

    public static void RenderWorldObject(WorldObject w) {
        if (!w.m_bVisible) {
            return;
        }
        if (w.m_nAnimSize == 1) {
            if (CGEngine.m_bEngineChangeAxis) {
                float yy;
                float xx = w.m_fX + w.m_fW / 2;
                float fTmp = yy = (float)(w.m_fY + w.m_fH / 2);
                yy = xx;
                xx = 480.0f - fTmp;
                Graphic2D.DrawImage(w.m_Texture[0], (int)(xx * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetX - (int)CGEngine.m_fCameraPosX, (int)(yy * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetY - (int)CGEngine.m_fCameraPosY, 3);
            } else if (w.m_Texture[0] != null) {
                Graphic2D.DrawRegion(w.m_Texture[0], (float)w.m_fX * CGEngine.m_fEngineScale + m_fScreenOffsetX - (float)((int)CGEngine.m_fCameraPosX), (float)w.m_fY * CGEngine.m_fEngineScale + m_fScreenOffsetY - (float)((int)CGEngine.m_fCameraPosY), 0.0f, 0.0f, (float)(w.m_fX + w.m_fW) * CGEngine.m_fEngineScale + m_fScreenOffsetX - (float)((int)CGEngine.m_fCameraPosX), (float)(w.m_fY + w.m_fH) * CGEngine.m_fEngineScale + m_fScreenOffsetY - (float)((int)CGEngine.m_fCameraPosY), 1.0f, 1.0f);
            }
        } else {
            float fX = w.m_fX - (int)CGEngine.m_fCameraPosX;
            float fY = w.m_fY - (int)CGEngine.m_fCameraPosY;
            int nCurrentFrame = 0;
            float u1 = 0.0f;
            float v1 = 0.0f;
            float u2 = 1.0f;
            float v2 = 1.0f;
            if (w.m_nAnimSize > 1) {
                nCurrentFrame = w.m_nCurrentFrame;
                int nX = nCurrentFrame % w.m_nAnimGridX;
                int nY = nCurrentFrame / w.m_nAnimGridX;
                u1 = (float)nX / (float)w.m_nAnimGridX;
                v1 = (float)nY / (float)w.m_nAnimGridY;
                u2 = u1 + 1.0f / (float)w.m_nAnimGridX;
                v2 = v1 + 1.0f / (float)w.m_nAnimGridY;
            }
            if (w.m_nM == 1) {
                Graphic2D.DrawRegion(w.m_Texture[0], m_fScreenOffsetX + fX * CGEngine.m_fEngineScale, m_fScreenOffsetY + fY * CGEngine.m_fEngineScale, u2, v1, m_fScreenOffsetX + (fX + (float)w.m_fW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY + (float)w.m_fH) * CGEngine.m_fEngineScale, u1, v2);
            }
            if (w.m_nM == 2) {
                Graphic2D.DrawRegion(w.m_Texture[0], m_fScreenOffsetX + fX * CGEngine.m_fEngineScale, m_fScreenOffsetY + fY * CGEngine.m_fEngineScale, u1, v2, m_fScreenOffsetX + (fX + (float)w.m_fW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY + (float)w.m_fH) * CGEngine.m_fEngineScale, u2, v1);
            }
            if (w.m_nM == 3) {
                Graphic2D.DrawRegion(w.m_Texture[0], m_fScreenOffsetX + fX * CGEngine.m_fEngineScale, m_fScreenOffsetY + fY * CGEngine.m_fEngineScale, u2, v2, m_fScreenOffsetX + (fX + (float)w.m_fW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY + (float)w.m_fH) * CGEngine.m_fEngineScale, u1, v1);
            } else {
                Graphic2D.DrawRegion(w.m_Texture[0], m_fScreenOffsetX + fX * CGEngine.m_fEngineScale, m_fScreenOffsetY + fY * CGEngine.m_fEngineScale, u1, v1, m_fScreenOffsetX + (fX + (float)w.m_fW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY + (float)w.m_fH) * CGEngine.m_fEngineScale, u2, v2);
            }
        }
    }

    public static void RenderCollisionObject(CollisionObject p, double fX, double fY) {
        Graphic2D.SetColor(-1);
        for (int i = 0; i < p.GetTransformSize() - 1; ++i) {
            int x1 = (int)((fX + p.GetTransform((int)i).m_fX) * (double)CGEngine.m_fEngineScale + (double)m_fScreenOffsetX);
            int y1 = (int)((fY + p.GetTransform((int)i).m_fY) * (double)CGEngine.m_fEngineScale + (double)m_fScreenOffsetY);
            int x2 = (int)((fX + p.GetTransform((int)(i + 1)).m_fX) * (double)CGEngine.m_fEngineScale + (double)m_fScreenOffsetX);
            int y2 = (int)((fY + p.GetTransform((int)(i + 1)).m_fY) * (double)CGEngine.m_fEngineScale + (double)m_fScreenOffsetY);
            Graphic2D.DrawLine(x1, y1, x2, y2);
        }
    }

    static {
        m_BlockIndestructableTexture = new CGTexture();
        m_BlockRubberTexture = new CGTexture();
        m_BlockHorizontTexture = new CGTexture();
        m_BlockVerticalTexture = new CGTexture();
        m_HUD_Borders = new CGTexture[6][5];
        m_HUD_elements = new CGTexture[2];
        middleX = -1.0f;
    }
}

