/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.system.FileManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class LevelScenario {
    public int m_nOffset = 0;
    public int m_nRowSize = 0;
    public char[][] m_Data = null;
    public int m_timeLimit;
    public int m_ballLimit;
    public int m_scoreLimit;
    public int m_itemLimit;
    static int[][] sortedProbabilitiesOfPowerUps;
    public int m_threeStarsBallLimit;
    public int m_threeStarsTimeLimit;
    public int m_threeStarsItemLimit;
    public int m_threeStarsScoreLimit;
    public final int BOARD_NUM_LINES;
    public final int BOARD_NUM_ROWS;
    public int m_numBallsFromFile;
    public int[] m_ballsFromFile;

    public LevelScenario() {
        this.BOARD_NUM_LINES = 15;
        this.BOARD_NUM_ROWS = 6;
    }

    public int Load(String szFileNameTXT) {
        Vector<String> vector = new Vector<String>();
        try {
            int ch;
            InputStream is = FileManager.OpenFile(szFileNameTXT);
            if (is == null) {
                is = FileManager.OpenURLFile(szFileNameTXT);
            }
            if (is == null) {
                return 0;
            }
            StringBuffer sb = new StringBuffer();
            while ((ch = is.read()) != -1) {
                sb.append((char)ch);
            }
            StringBuffer sub = new StringBuffer();
            int nLength = sb.length();
            for (int i = 0; i < nLength; ++i) {
                char c = sb.charAt(i);
                if (c == '\r' || c == '\n') {
                    String s = sub.toString();
                    vector.addElement(s);
                    sub.delete(0, sb.length());
                    ++i;
                    continue;
                }
                sub.append(c);
            }
            if (sub.length() > 0) {
                String s = sub.toString();
                vector.addElement(s);
                sub.delete(0, sb.length());
            }
        }
        catch (IOException e2) {
            System.out.println("Error1 scenario reading");
            e2.printStackTrace();
            return 0;
        }
        this.m_Data = new char[6][15];
        if (((String)vector.elementAt(0)).length() == 0) {
            System.out.println("Error2 scenario reading");
            return 0;
        }
        for (int i = 0; i < 15; ++i) {
            String szLine = (String)vector.elementAt(i);
            int nL = szLine.length();
            if (nL != 6) {
                System.out.println("Error scenario reading (line " + (i + 1) + ")");
                return 0;
            }
            this.m_Data[0][i] = (char)(szLine.charAt(0) - 48);
            this.m_Data[1][i] = (char)(szLine.charAt(1) - 48);
            this.m_Data[2][i] = (char)(szLine.charAt(2) - 48);
            this.m_Data[3][i] = (char)(szLine.charAt(3) - 48);
            this.m_Data[4][i] = (char)(szLine.charAt(4) - 48);
            this.m_Data[5][i] = (char)(szLine.charAt(5) - 48);
            if (szLine.length() != 0) continue;
        }
        int[][] tmpNotSorted = new int[11][2];
        int j = 0;
        for (int i = 15; i < 26; ++i) {
            String szLine = (String)vector.elementAt(i);
            int kk = Integer.parseInt(szLine);
            tmpNotSorted[j][0] = j;
            tmpNotSorted[j][1] = kk;
            ++j;
        }
        sortedProbabilitiesOfPowerUps = this.bubble_srt(tmpNotSorted, tmpNotSorted.length);
        String szLine = (String)vector.elementAt(26);
        CGUserCareer.newPowerUpIDInfo = Integer.parseInt(szLine);
        szLine = (String)vector.elementAt(27);
        CGUserCareer.newBlockIDInfo = Integer.parseInt(szLine);
        szLine = (String)vector.elementAt(28);
        CGBoard.probabilityOfPowerUp = Integer.parseInt(szLine);
        return 1;
    }

    public int LoadSurvival(String szFileNameTXT) {
        int i;
        Vector<String> vector = new Vector<String>();
        try {
            int ch;
            InputStream is = FileManager.OpenFile(szFileNameTXT);
            if (is == null) {
                is = FileManager.OpenURLFile(szFileNameTXT);
            }
            if (is == null) {
                return 0;
            }
            StringBuffer sb = new StringBuffer();
            while ((ch = is.read()) != -1) {
                sb.append((char)ch);
            }
            StringBuffer sub = new StringBuffer();
            int nLength = sb.length();
            for (int i2 = 0; i2 < nLength; ++i2) {
                char c = sb.charAt(i2);
                if (c == '\r' || c == '\n') {
                    String s = sub.toString();
                    vector.addElement(s);
                    sub.delete(0, sb.length());
                    ++i2;
                    continue;
                }
                sub.append(c);
            }
            if (sub.length() > 0) {
                String s = sub.toString();
                vector.addElement(s);
                sub.delete(0, sb.length());
            }
        }
        catch (IOException e2) {
            System.out.println("Error1 scenario reading");
            e2.printStackTrace();
            return 0;
        }
        this.m_nRowSize = vector.size();
        System.out.println("Scenario row size: " + this.m_nRowSize);
        this.m_Data = new char[10][this.m_nRowSize];
        if (vector.size() == 0 || ((String)vector.elementAt(0)).length() == 0) {
            System.out.println("Error2 scenario reading");
            return 0;
        }
        if (vector.size() % 2 > 0) {
            System.out.println("Error reading scenario ... odd number of lines");
            return 0;
        }
        for (i = 0; i < vector.size(); ++i) {
            String szLine = (String)vector.elementAt(i);
            int nL = szLine.length();
            if (i % 2 == 0 && nL < 19) {
                System.out.println("Error scenario reading (line " + (i + 1) + ")");
                this.m_nRowSize = 0;
                return 0;
            }
            if (i % 2 > 0 && nL < 20) {
                System.out.println("Error scenario reading (line " + (i + 1) + ")");
                this.m_nRowSize = 0;
                return 0;
            }
            if (i % 2 == 0) {
                this.m_Data[0][i] = (char)(szLine.charAt(0) - 48);
                this.m_Data[1][i] = (char)(szLine.charAt(2) - 48);
                this.m_Data[2][i] = (char)(szLine.charAt(4) - 48);
                this.m_Data[3][i] = (char)(szLine.charAt(6) - 48);
                this.m_Data[4][i] = (char)(szLine.charAt(8) - 48);
                this.m_Data[5][i] = (char)(szLine.charAt(10) - 48);
                this.m_Data[6][i] = (char)(szLine.charAt(12) - 48);
                this.m_Data[7][i] = (char)(szLine.charAt(14) - 48);
                this.m_Data[8][i] = (char)(szLine.charAt(16) - 48);
                this.m_Data[9][i] = (char)(szLine.charAt(18) - 48);
            } else {
                this.m_Data[0][i] = (char)(szLine.charAt(1) - 48);
                this.m_Data[1][i] = (char)(szLine.charAt(3) - 48);
                this.m_Data[2][i] = (char)(szLine.charAt(5) - 48);
                this.m_Data[3][i] = (char)(szLine.charAt(7) - 48);
                this.m_Data[4][i] = (char)(szLine.charAt(9) - 48);
                this.m_Data[5][i] = (char)(szLine.charAt(11) - 48);
                this.m_Data[6][i] = (char)(szLine.charAt(13) - 48);
                this.m_Data[7][i] = (char)(szLine.charAt(15) - 48);
                this.m_Data[8][i] = (char)(szLine.charAt(17) - 48);
                this.m_Data[9][i] = (char)(szLine.charAt(19) - 48);
            }
            if (szLine.length() != 0) continue;
        }
        this.m_nOffset = this.m_nRowSize - 1;
        System.out.println("Scenario m_nOffset: " + this.m_nOffset);
        this.m_ballsFromFile = new int[5];
        for (i = 0; i < 5; ++i) {
            this.m_ballsFromFile[i] = i + 1;
        }
        this.m_ballLimit = 10000000;
        this.m_timeLimit = 10000000;
        this.m_itemLimit = 10000000;
        this.m_scoreLimit = 10000000;
        return 1;
    }

    static void sortValuesFromGreater(int[][] table) {
    }

    private int[][] bubble_srt(int[][] a, int n) {
        int r = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 1; j < n - i; ++j) {
                if (a[j - 1][1] >= a[j][1]) continue;
                int t = a[j - 1][1];
                r = a[j - 1][0];
                a[j - 1][1] = a[j][1];
                a[j - 1][0] = a[j][0];
                a[j][1] = t;
                a[j][0] = r;
            }
        }
        return a;
    }
}

