/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.particles.CGDynamicObj;
import baltorogames.project_gameplay.CGActivePowerUp;
import baltorogames.project_gameplay.CGBall;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CGFallingPowerUp;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.CollisionObject;

class GameObject {
    public static final int TYPE_ORDINARY_GREEN = 1;
    public static final int TYPE_ORDINARY_BLUE = 2;
    public static final int TYPE_ORDINARY_RED = 3;
    public static final int TYPE_ORDINARY_LIGHT_BLUE = 4;
    public static final int TYPE_ORDINARY_YELLOW = 5;
    public static final int TYPE_ORDINARY_WHITE = 6;
    public static final int TYPE_ORDINARY_BLACK = 7;
    public static final int TYPE_ORDINARY_GOLD = 8;
    public static final int TYPE_ORDINARY_PINK = 9;
    public static final int TYPE_DURABLE = 10;
    public static final int TYPE_INDESTRUCTIBLE = 11;
    public static final int TYPE_EXPLODING = 12;
    public static final int TYPE_RUBBER = 13;
    public static final int TYPE_TRAVEL_HORIZONT = 14;
    public static final int TYPE_TRAVEL_VERTICAL = 15;
    public static final int TYPE_PORTALS = 16;
    public double m_fStartX;
    public double m_fStartY;
    public double m_fMoveXPerSec;
    public double m_fMoveYPerSec;
    public double m_fMaxDX;
    public double m_fMaxDY;
    public int m_nCollisionCounter = 1;
    public boolean m_bPermanent = false;
    public int m_nCordOnBoardX = 0;
    public int m_nCordOnBoardY = 0;
    public float m_CenterX;
    public float m_CenterY;
    public double m_fX;
    public double m_fY;
    public double m_fW;
    public double m_fH;
    public int m_nType;
    public int m_nID;
    public int m_nCurrentFrame;
    public int m_nTime;
    CollisionObject m_CollisionObject;

    public void Init(double fX, double fY, double fW, double fH, int nType, int nID) {
        this.m_fStartX = fX;
        this.m_fStartY = fY;
        this.m_fX = fX;
        this.m_fY = fY;
        this.m_fW = fW;
        this.m_fH = fH;
        this.m_nID = nID;
        this.m_nType = nType;
        this.m_CenterX = (float)(this.m_fX + this.m_fW / 2.0);
        this.m_CenterY = (float)(this.m_fY + this.m_fH / 2.0);
        this.m_nCollisionCounter = 1;
        double fM = fW / 20.0;
        this.m_CollisionObject = new CollisionObject();
        this.m_CollisionObject.Add(0.0, 0.0);
        this.m_CollisionObject.Add(fW, 0.0);
        this.m_CollisionObject.Add(fW, fH);
        this.m_CollisionObject.Add(0.0, fH);
        this.m_CollisionObject.CreateTransformPoints(CGBall.eRadius);
        this.m_CollisionObject.m_nObjectID = nID;
        this.m_CollisionObject.m_fX = fX;
        this.m_CollisionObject.m_fY = fY;
        CGEngine.m_CollisionScene.Add(this.m_CollisionObject);
        this.m_fMoveXPerSec = 0.0;
        this.m_fMoveYPerSec = 0.0;
        this.m_fMaxDX = 0.0;
        this.m_fMaxDY = 0.0;
    }

    public void Destroy() {
    }

    public void PreUpdate(int deltaTimeInMs) {
        double fDX = this.m_fMoveXPerSec * (double)deltaTimeInMs / 1000.0;
        double fDY = this.m_fMoveYPerSec * (double)deltaTimeInMs / 1000.0;
        this.m_CollisionObject.m_fDX = fDX;
        this.m_CollisionObject.m_fDY = fDY;
    }

    public void Update(int deltaTimeInMs) {
        if (this.m_fMoveXPerSec != 0.0) {
            double fDX = this.m_fMoveXPerSec * (double)deltaTimeInMs / 1000.0;
            this.m_fX += fDX;
            if (this.m_fMoveXPerSec > 0.0) {
                if (this.m_fX > this.m_fStartX + this.m_fMaxDX) {
                    this.m_fX = this.m_fStartX + this.m_fMaxDX;
                    this.m_fMoveXPerSec = -this.m_fMoveXPerSec;
                }
            } else if (this.m_fX < this.m_fStartX - this.m_fMaxDX) {
                this.m_fX = this.m_fStartX - this.m_fMaxDX;
                this.m_fMoveXPerSec = -this.m_fMoveXPerSec;
            }
        } else if (this.m_fMoveYPerSec != 0.0) {
            double fDY = this.m_fMoveYPerSec * (double)deltaTimeInMs / 1000.0;
            this.m_fY += fDY;
            if (this.m_fMoveYPerSec > 0.0) {
                if (this.m_fY > this.m_fStartY + this.m_fMaxDY) {
                    this.m_fY = this.m_fStartY + this.m_fMaxDY;
                    this.m_fMoveYPerSec = -this.m_fMoveYPerSec;
                }
            } else if (this.m_fY < this.m_fStartY - this.m_fMaxDY) {
                this.m_fY = this.m_fStartY - this.m_fMaxDY;
                this.m_fMoveYPerSec = -this.m_fMoveYPerSec;
            }
        }
        this.m_CollisionObject.m_fX = this.m_fX;
        this.m_CollisionObject.m_fY = this.m_fY;
        this.m_nTime += deltaTimeInMs;
        this.m_nCurrentFrame = this.m_nTime / 100;
        this.m_CenterX = (float)(this.m_fX + this.m_fW / 2.0);
        this.m_CenterY = (float)(this.m_fY + this.m_fH / 2.0);
    }

    public void CollisionAction() {
        if (this.m_nType == 10 && !CGEngine.m_Ball[0].isPupBlockerBall) {
            if (this.m_nCollisionCounter >= 2) {
                CGDynamicObj.AddToCurrentDynamics("block_drb_hit_0" + (this.m_nCollisionCounter - 1) + ".do", this.m_CenterX, (float)((double)this.m_CenterY + this.m_fH), 0.0f);
            } else if (this.m_nCollisionCounter == 1) {
                CGDynamicObj.AddToCurrentDynamics("block_boom_01.do", this.m_CenterX, (float)((double)this.m_CenterY + this.m_fH), 0.0f);
            }
            if (this.m_nCollisionCounter > 0 && CGBall.isSuperBall) {
                this.m_nCollisionCounter = 1;
            }
        } else if (this.m_nType == 16) {
            CGDynamicObj.AddToCurrentDynamics("block_teleport_in.do", this.m_CenterX, (float)((double)this.m_CenterY + this.m_fH), 0.0f);
            int secondPortalID = CGEngine.m_Board.findSecondPortal(this.m_nID);
            if (secondPortalID != -1 && CGEngine.m_Ball != null) {
                for (int i = 0; i < CGEngine.m_Ball.length; ++i) {
                    if (CGEngine.m_Ball[i] == null) continue;
                    CGEngine.m_Ball[i].vecNewPos.x = CGEngine.m_Board.GetObjectByID((int)secondPortalID).m_CenterX;
                    CGEngine.m_Ball[i].vecNewPos.y = CGEngine.m_Board.GetObjectByID((int)secondPortalID).m_CenterY;
                    CGDynamicObj.AddToCurrentDynamics("block_teleport_out.do", (float)CGEngine.m_Ball[i].vecNewPos.x, (float)CGEngine.m_Ball[0].vecNewPos.y, 0.0f);
                }
            }
        } else if (this.m_nType == 13 && !CGEngine.m_Ball[0].isPupBlockerBall) {
            if (CGEngine.m_Ball != null) {
                for (int i = 0; i < CGEngine.m_Ball.length; ++i) {
                    if (CGEngine.m_Ball[i] == null || !(CGEngine.m_Ball[i].vecPos.y <= this.m_fY)) continue;
                    this.m_nCollisionCounter = 1;
                    CGDynamicObj.AddToCurrentDynamics("block_boom_06.do", this.m_CenterX, this.m_CenterY, 0.0f);
                }
            }
        } else if (this.m_nType <= 9 && !CGEngine.m_Ball[0].isPupBlockerBall) {
            CGDynamicObj.AddToCurrentDynamics("block_boom_0" + this.m_nType + ".do", this.m_CenterX, this.m_CenterY, 0.0f);
        }
        if (!CGEngine.m_Ball[0].isPupBlockerBall) {
            --this.m_nCollisionCounter;
        }
        if (this.m_nCollisionCounter <= 0) {
            if (!this.m_bPermanent) {
                --CGEngine.m_Board.m_DestructableLeft;
            }
            CGEngine.m_Board.RemoveByID(this.m_nID);
            CGEngine.m_CollisionScene.Remove(this.m_CollisionObject);
            if (CGFallingPowerUp.timeIntervalBetweenPowerUps <= 0) {
                CGFallingPowerUp.NewPowerUp((float)this.m_CollisionObject.m_fX, (float)this.m_CollisionObject.m_fY);
                CGFallingPowerUp.timeIntervalBetweenPowerUps = 1500;
            }
        }
    }

    public void CollisionAction(int ballID, boolean weakerParticles) {
        if (!CGEngine.m_Ball[ballID].isPupBlockerBall) {
            if (this.m_nType == 10) {
                if (this.m_nCollisionCounter >= 2) {
                    // empty if block
                }
                if (this.m_nCollisionCounter == 1) {
                    this.m_nType = 1;
                    this.m_CollisionObject.isDurableWithoutShield = true;
                }
            } else if (this.m_nType == 16) {
                CGDynamicObj.AddToCurrentDynamics("block_teleport_in.do", this.m_CenterX, this.m_CenterY, 0.0f);
                int secondPortalID = CGEngine.m_Board.findSecondPortal(this.m_nID);
                if (secondPortalID != -1) {
                    CGEngine.m_Ball[ballID].vecNewPos.x = CGEngine.m_Board.GetObjectByID((int)secondPortalID).m_CenterX;
                    CGEngine.m_Ball[ballID].vecNewPos.y = CGEngine.m_Board.GetObjectByID((int)secondPortalID).m_CenterY;
                    CGDynamicObj.AddToCurrentDynamics("block_teleport_out.do", (float)CGEngine.m_Ball[ballID].vecNewPos.x, (float)CGEngine.m_Ball[ballID].vecNewPos.y, 0.0f);
                }
            } else if (this.m_nType == 13 && !CGEngine.m_Ball[ballID].isPupBlockerBall) {
                if (CGEngine.m_Ball[ballID].vecPos.y <= this.m_fY) {
                    this.m_nCollisionCounter = 1;
                    CGDynamicObj.AddToCurrentDynamics("block_boom_06.do", this.m_CenterX, this.m_CenterY, 0.0f);
                } else {
                    CGDynamicObj.AddToCurrentDynamics("block_rubber.do", this.m_CenterX, this.m_CenterY, 0.0f);
                }
            } else if (this.m_nType == 11) {
                CGDynamicObj.AddToCurrentDynamics("block_indestruct_hit.do", this.m_CenterX, this.m_CenterY, 0.0f);
            }
            if (this.m_nType <= 9 && !CGEngine.m_Ball[ballID].isPupBlockerBall) {
                if (weakerParticles) {
                    CGDynamicObj.AddToCurrentDynamics("block_weak_boom.do", this.m_CenterX, this.m_CenterY, 0.0f);
                } else {
                    CGDynamicObj.AddToCurrentDynamics("block_boom_0" + this.m_nType + ".do", this.m_CenterX, this.m_CenterY, 0.0f);
                }
            }
            if (!CGEngine.m_Ball[ballID].isPupBlockerBall) {
                --this.m_nCollisionCounter;
            }
            if (this.m_nCollisionCounter == 1 && this.m_nType == 10) {
                this.m_nType = 1;
                this.m_CollisionObject.isDurableWithoutShield = true;
            }
            if (this.m_nCollisionCounter <= 0) {
                if (!this.m_bPermanent) {
                    int addScore;
                    --CGEngine.m_Board.m_DestructableLeft;
                    if (CGActivePowerUp.IsAnyPowerUpActive()) {
                        addScore = 50;
                        CGDynamicObj.AddToCurrentDynamics("score_50.do", this.m_CenterX, this.m_CenterY, 0.0f);
                    } else if (CGActivePowerUp.IsAnyPowerDownActive()) {
                        addScore = 200;
                        CGDynamicObj.AddToCurrentDynamics("score_200.do", this.m_CenterX, this.m_CenterY, 0.0f);
                    } else {
                        addScore = 100;
                        CGDynamicObj.AddToCurrentDynamics("score_100.do", this.m_CenterX, this.m_CenterY, 0.0f);
                    }
                    CGLevelStats.m_nScore += addScore;
                }
                CGEngine.m_Board.RemoveByID(this.m_nID);
                CGEngine.m_CollisionScene.Remove(this.m_CollisionObject);
                if (CGFallingPowerUp.timeIntervalBetweenPowerUps <= 0) {
                    CGFallingPowerUp.NewPowerUp((float)this.m_CollisionObject.m_fX, (float)this.m_CollisionObject.m_fY);
                    CGFallingPowerUp.timeIntervalBetweenPowerUps = 1500;
                }
            }
        }
    }

    public void setObjectCords(int x, int y) {
        this.m_nCordOnBoardX = x;
        this.m_nCordOnBoardY = y;
    }

    public void incObjectCordsY() {
        ++this.m_nCordOnBoardY;
    }

    public void Render() {
        CGEngineRenderer.RenderBlock((float)this.m_fX, (float)this.m_fY, this.m_nType, this.m_nCollisionCounter, this.m_nCurrentFrame);
    }
}

