/*
 * Decompiled with CFR 0.152.
 */
package modules;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import main.Logic;
import modules.Anim;
import modules.Draw;
import modules.Font;
import modules.FontEnums;
import modules.Fx;
import modules.GFXRegion;
import modules.Gfx;
import modules.GfxEnums;
import modules.Gmg;
import modules.IDeviceConstants;
import modules.Keyb;
import modules.Loader;
import modules.Rms;
import modules.Sound;
import modules.Sys;
import modules.Text;
import modules.Timer;
import modules.cFsm;
import modules.cMIDlet;

public class Lib
extends Canvas
implements Runnable,
IDeviceConstants {
    static short[] events;
    private static final long PROGRESS_BAR_THRESHOLD_TIME = 1000L;
    public static int SCREEN_WIDTH;
    public static int SCREEN_HEIGHT;
    public static final short KEY_NONE = 0;
    public static final short KEY_0 = 1;
    public static final short KEY_1 = 2;
    public static final short KEY_2 = 3;
    public static final short KEY_3 = 4;
    public static final short KEY_4 = 5;
    public static final short KEY_5 = 6;
    public static final short KEY_6 = 7;
    public static final short KEY_7 = 8;
    public static final short KEY_8 = 9;
    public static final short KEY_9 = 10;
    public static final short KEY_STAR = 11;
    public static final short KEY_POUND = 12;
    public static final short KEY_UP = 13;
    public static final short KEY_DOWN = 14;
    public static final short KEY_LEFT = 15;
    public static final short KEY_RIGHT = 16;
    public static final short KEY_FIRE = 17;
    public static final short KEY_SOFTLEFT = 18;
    public static final short KEY_SOFTRIGHT = 19;
    public static final short KEY_CLEAR = 20;
    public static final short KEY_BACK = 21;
    public static final short KEYSET_KEYBOARD_NORMAL = 0;
    public static final short KEYSET_KEYBOARD_VISUAL = 1;
    public static final short KEYSET_GAME = 2;
    private static short[][][] keySetEvents;
    private static short keySetSelected;
    private static short keySetSelectedMappedKey;
    private static short _keySetValue;
    private static int _keySet_i;
    private static short[] _keySetEvents;
    private static transient boolean keyMapFree;
    private static transient boolean keyTriggerBackEvent;
    private static volatile boolean paintWait;
    static volatile boolean isHideNotifyLocked;
    private static long pauseTime;
    private static long pausedLastTime;
    private static volatile boolean pauseEnabled;
    private static final int PAUSE_LAPSO = 6000;
    public static boolean isToExitGame;
    static long timer_pauseTime;
    private static short levelPause;

    public void initLib(cFsm cFsm2) {
        events = cFsm2.eventLookup;
        Lib.events[32] = 1;
        Lib.initModules();
        this.setFullScreenMode(true);
        SCREEN_WIDTH = this.getWidth();
        SCREEN_HEIGHT = this.getHeight();
    }

    protected void sizeChanged(int n, int n2) {
        SCREEN_WIDTH = n;
        SCREEN_HEIGHT = n2;
    }

    private static void initModules() {
        cFsm.lib = cMIDlet.libInstance;
        cFsm.sys = new Sys();
        cFsm.sound = new Sound();
        cFsm.fx = new Fx();
        cFsm.rms = new Rms();
        cFsm.text = new Text();
        cFsm.timer = new Timer();
        cFsm.anim = new Anim();
        cFsm.font = new Font();
        cFsm.fontEnums = new FontEnums();
        cFsm.gfx = new Gfx();
        cFsm.gfxRegion = new GFXRegion();
        cFsm.gfxEnums = new GfxEnums();
        cFsm.loader = new Loader();
        cFsm.draw = new Draw();
        cFsm.keyb = new Keyb();
        cFsm.gmg = new Gmg();
        cFsm.lib = cMIDlet.libInstance;
    }

    private static void keySetEvent(int n, boolean bl) {
        _keySetValue = (short)(bl ? 2 : 0);
        _keySetEvents = keySetEvents[keySetSelected][n];
        for (_keySet_i = 0; _keySet_i < _keySetEvents.length; ++_keySet_i) {
            Lib.events[Lib._keySetEvents[Lib._keySet_i]] = _keySetValue;
        }
    }

    private static short keyCode(int n) {
        switch (n) {
            case -1: {
                return 13;
            }
            case -2: {
                return 14;
            }
            case -3: {
                return 15;
            }
            case -4: {
                return 16;
            }
            case -5: {
                return 17;
            }
            case -6: {
                return 18;
            }
            case -7: {
                return 19;
            }
            case 42: {
                return 11;
            }
            case 35: {
                return 12;
            }
            case -8: {
                return 20;
            }
            case -11: {
                return 21;
            }
            case 48: {
                return 1;
            }
            case 49: {
                return 2;
            }
            case 50: {
                return 3;
            }
            case 51: {
                return 4;
            }
            case 52: {
                return 5;
            }
            case 53: {
                return 6;
            }
            case 54: {
                return 7;
            }
            case 55: {
                return 8;
            }
            case 56: {
                return 9;
            }
            case 57: {
                return 10;
            }
        }
        return 0;
    }

    public static void keyConsume() {
        Logic.resetAnimHud(keySetSelectedMappedKey);
        Lib.keySetEvent(keySetSelectedMappedKey, false);
        keySetSelectedMappedKey = 0;
        keyMapFree = true;
    }

    protected void keyPressed(int n) {
        if (n == -11) {
            return;
        }
        Lib.keyTrigger(n);
    }

    protected void keyReleased(int n) {
        if (n == -11 && keyTriggerBackEvent) {
            Lib.keyTrigger(-11);
        } else {
            keyTriggerBackEvent = true;
        }
    }

    protected void keyRepeated(int n) {
        if (n == -11 && events[25] == 2) {
            keyTriggerBackEvent = false;
        }
    }

    private static void keyTrigger(int n) {
        if (keyMapFree) {
            keyMapFree = false;
            Lib.keySetEvent(keySetSelectedMappedKey, false);
            keySetSelectedMappedKey = Lib.keyCode(n);
            Lib.keySetEvent(keySetSelectedMappedKey, true);
            keyMapFree = true;
        }
        if (levelPause == 1) {
            Gmg.gmgProcessKey(n);
        }
    }

    public static boolean keyPressedAnyKey() {
        _keySetEvents = keySetEvents[keySetSelected][keySetSelectedMappedKey];
        for (_keySet_i = 0; _keySet_i < _keySetEvents.length; ++_keySet_i) {
            if (events[_keySetEvents[_keySet_i]] != 2) continue;
            return true;
        }
        return false;
    }

    public static void keyClear() {
        Lib.keyConsume();
    }

    public static void keySet(short s) {
        keySetSelected = s;
    }

    public static short keySetGetValue() {
        return keySetSelected;
    }

    void postPaint(Graphics graphics) {
    }

    public void systemGC() {
    }

    protected void paint(Graphics graphics) {
        if (!paintWait) {
            paintWait = true;
            try {
                Gfx.gfxDoPaintZOrder(graphics);
                cFsm.fx.fxUpdate();
                cFsm.timer.timerUpdateTicks();
            }
            catch (Exception exception) {
                // empty catch block
            }
            paintWait = false;
        }
    }

    protected void showNotify() {
    }

    protected void hideNotify() {
        if (!isHideNotifyLocked) {
            isHideNotifyLocked = true;
            this.systemGC();
            Lib.pauseTrigger();
            isHideNotifyLocked = false;
        }
    }

    public static void pauseTrigger() {
        if (Lib.pauseAllowed()) {
            Sound.soundManageOnCall(true);
            Lib.events[25] = 2;
            Lib.pauseTimeReset();
            cFsm.gfx.gfxDoPaint();
        }
    }

    private static void pauseTimeReset() {
        pauseTime = pausedLastTime = Timer.timer_GlobalTimer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean pauseAllowed() {
        if (!pauseEnabled) return false;
        if (Timer.timer_GlobalTimer - pausedLastTime <= 1000L) return false;
        return true;
    }

    private static void pauseManage() {
        if (Timer.timer_GlobalTimer - pauseTime >= 6000L && !isHideNotifyLocked) {
            Lib.pauseTrigger();
        }
    }

    public static void pauseEnable(boolean bl) {
        pauseEnabled = bl;
        if (pauseEnabled) {
            Lib.pauseTimeReset();
        }
    }

    public static long pauseGetLastTime() {
        return pausedLastTime;
    }

    public void run() {
        try {
            while (!isToExitGame) {
                pauseTime = System.currentTimeMillis();
                if (this.isShown()) {
                    cFsm.fsm.update();
                    Timer.timer_GlobalTimer = System.currentTimeMillis();
                    cFsm.timer.timerUpdateTimer();
                } else {
                    Lib.pauseTrigger();
                }
                Lib.pauseManage();
            }
            Lib.disposeLib();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void SyncFramePeriod() {
        block6: {
            timer_pauseTime = System.currentTimeMillis() - Timer.timer_GlobalTimer;
            if (timer_pauseTime > 1000L) {
                // empty if block
            }
            try {
                timer_pauseTime = 45L - timer_pauseTime;
                if (timer_pauseTime <= 0L) break block6;
                Lib lib = cMIDlet.libInstance;
                synchronized (lib) {
                    cMIDlet.libInstance.wait(timer_pauseTime);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Timer.timer_GlobalTimer = System.currentTimeMillis();
        ++Timer.timer_Ticks;
    }

    public static void disposeLib() {
        cFsm.rms.rmsDispose();
        cFsm.sound.soundStopAll();
        cFsm.sound.soundDestroyServer();
        cMIDlet.midlet.destroyApp(true);
    }

    public static void pauseAll() {
        if (levelPause < 10) {
            Anim.animPause(levelPause);
            Fx.fxPause(levelPause);
            Timer.timerPause(levelPause);
            Gfx.gfxPause(levelPause);
            levelPause = (short)(levelPause + 1);
        }
    }

    public static void resumeAll() {
        if (levelPause < 10) {
            if (levelPause > 0) {
                levelPause = (short)(levelPause - 1);
            }
            Anim.animResume(levelPause);
            Fx.fxResume(levelPause);
            Timer.timerResume(levelPause);
            Gfx.gfxResume(levelPause);
        }
    }

    public static void resetPauseAll() {
        while (levelPause > 0) {
            Lib.resumeAll();
        }
    }

    static {
        SCREEN_WIDTH = 240;
        SCREEN_HEIGHT = 304;
        keySetEvents = new short[][][]{new short[][]{new short[0], {1}, {2}, {3}, {4}, {5}, {6}, {7}, {8}, {9}, {10}, {11}, {12}, {13}, {14}, {15}, {16}, {17, 21}, {17, 21}, {20}, {36}, {35, 20}}, new short[][]{new short[0], {1}, {2}, {3, 13}, {4}, {5, 15}, {18, 17}, {7, 16}, {8}, {9, 14}, {10}, {11}, {12}, {13}, {14}, {15}, {16}, {18, 17, 6}, {17, 21}, {20}, {36}, {35, 20}}, new short[][]{new short[0], {1}, {2}, {3, 13}, {4}, {5, 15}, {6, 17}, {7, 16}, {8}, {9, 14}, {10}, {11}, {12}, {13}, {14}, {15}, {16}, {18, 17, 6}, {17, 21}, {20}, {36}, {35, 20}}};
        keySetSelected = 0;
        keySetSelectedMappedKey = 0;
        keyMapFree = true;
        keyTriggerBackEvent = true;
        paintWait = false;
        isHideNotifyLocked = false;
        pausedLastTime = -1L;
        pauseEnabled = false;
        isToExitGame = false;
        timer_pauseTime = 0L;
        levelPause = 0;
    }
}

