/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.extensions.cc3d;

import cocos2d.CCDirector;
import cocos2d.cocos2d;
import cocos2d.extensions.cc3d.CC3Camera;
import cocos2d.extensions.cc3d.CC3Group;
import cocos2d.extensions.cc3d.CC3Light;
import cocos2d.extensions.cc3d.CC3Node;
import cocos2d.extensions.cc3d.CC3Scene;
import cocos2d.extensions.cc3d.CC3Transform;
import cocos2d.extensions.cc3d.CC3Vector;
import cocos2d.nodes.CCLayerColor;
import cocos2d.nodes.CCNode;
import cocos2d.types.CCPoint;
import cocos2d.types.CCTexture2D;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.World;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CC3Renderer
extends CCLayerColor {
    public boolean USE_RETAINED_MODE = true;
    private CCPoint a;
    private static Graphics3D a = Graphics3D.getInstance();
    public final CC3Camera camera;
    public CC3Scene running3dScene;
    private Background a;
    private String a;
    private static CC3Vector a = new CC3Vector();
    private static CCPoint b = CCPoint.ccp(0, 0);
    private boolean a = CCPoint.ccp(0, 0);

    public static CC3Renderer rendererWithSize(int n2, int n3, int n4) {
        return new CC3Renderer(n2, n3, n4);
    }

    public static CC3Renderer customRendererWithSize(int n2, int n3, int n4) {
        CC3Renderer cC3Renderer = new CC3Renderer(n2, n3, n4);
        new CC3Renderer(n2, n3, n4).USE_RETAINED_MODE = false;
        return cC3Renderer;
    }

    public CC3Renderer(int n2, int n3, int n4) {
        super(n2, n3, n4);
        this.running3dScene = new CC3Scene();
        this.a = new Background();
        this.a = System.getProperty("microedition.m3g.version");
        "1.1".equals(this.a);
        this.width = n2;
        this.height = n3;
        a.resetLights();
        this.camera = new CC3Camera(n2, n3);
        this.setBackgroundColor(n4);
        this.replace3dScene(this.running3dScene);
    }

    public int getBackgroundImageWidth() {
        if (!this.hasBackgroundImage()) {
            return 0;
        }
        return this.a.getImage().getWidth();
    }

    public void enableColorClear() {
        this.a.setColorClearEnable(true);
    }

    public void disableColorClear() {
        this.a.setColorClearEnable(false);
    }

    public int getBackgroundImageHeight() {
        if (!this.hasBackgroundImage()) {
            return 0;
        }
        return this.a.getImage().getHeight();
    }

    public boolean hasBackgroundImage() {
        return this.a.getImage() != null;
    }

    public void setBackgroundCrop(int n2, int n3, int n4, int n5) {
        this.a.setCrop(n2, n3, n4, n5);
    }

    public void setBackgroundColor(int n2) {
        this.color = n2;
        this.a.setColor(this._alphaRaw + this.color);
        this.a.setImage(null);
    }

    public void setBackgroundImage(String string) {
        try {
            string = new Image2D(99, (Object)CCTexture2D.textureWithFile((String)string).image);
            this.a.setImage((Image2D)string);
            this.a.setImageMode(33, 32);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void addChild(CCNode cCNode) {
        try {
            CC3Node cC3Node = (CC3Node)cCNode;
            this.running3dScene.addChild(cC3Node);
        }
        catch (ClassCastException classCastException) {}
        super.addChild(cCNode);
    }

    public void removeChild(CCNode cCNode, boolean bl) {
        try {
            CC3Node cC3Node = (CC3Node)cCNode;
            this.running3dScene.removeChild(cC3Node, bl);
        }
        catch (ClassCastException classCastException) {}
        super.removeChild(cCNode, bl);
    }

    public void onExit() {
        super.onExit();
        --this.running3dScene.a;
        if (this.running3dScene.a == 0) {
            this.running3dScene.onExit();
        }
    }

    public void onEnter() {
        super.onEnter();
        ++this.running3dScene.a;
        if (this.running3dScene.a == 1) {
            this.running3dScene.onEnter();
        }
    }

    public void replace3dScene(CC3Scene cC3Scene) {
        --this.running3dScene.a;
        if (this.running3dScene.a == 0) {
            this.running3dScene.onExit();
            this.running3dScene.parent = null;
        }
        this.running3dScene = cC3Scene;
        ++this.running3dScene.a;
        if (this.running3dScene.a == 1) {
            cC3Scene.parent = this.parent;
            this.running3dScene.onEnter();
        }
    }

    public void drawAxes(Graphics graphics, CC3Vector cC3Vector, CC3Vector cC3Vector2, CC3Vector cC3Vector3, CC3Vector cC3Vector4) {
        if (this.camera.a(cC3Vector4, b)) {
            graphics.setColor(0);
            graphics.drawRoundRect(this.a.x + (CC3Renderer.b.x - 2), -this.a.y - (CC3Renderer.b.y + 2), 4, 4, 20, 20);
            graphics.setColor(-65536);
            a.set(cC3Vector);
            a.add(cC3Vector4);
            this.drawLine(graphics, cC3Vector4, a);
            graphics.setColor(-16711936);
            a.set(cC3Vector2);
            a.add(cC3Vector4);
            this.drawLine(graphics, cC3Vector4, a);
            graphics.setColor(-16776961);
            a.set(cC3Vector3);
            a.add(cC3Vector4);
            this.drawLine(graphics, cC3Vector4, a);
        }
    }

    public final void drawVector(Graphics graphics, CC3Vector cC3Vector, CC3Vector cC3Vector2) {
        if (this.camera.a(cC3Vector2, b)) {
            graphics.drawRoundRect(this.a.x + (CC3Renderer.b.x - 2), -this.a.y - (CC3Renderer.b.y + 2), 4, 4, 20, 20);
            a.set(cC3Vector);
            a.add(cC3Vector2);
            this.drawLine(graphics, cC3Vector2, a);
        }
    }

    public final void drawPoint(Graphics graphics, CC3Vector cC3Vector) {
        if (!this.camera.a(cC3Vector, b)) {
            graphics.drawRoundRect(this.a.x + (CC3Renderer.b.x - 2), -this.a.y - (CC3Renderer.b.y + 2), 4, 4, 20, 20);
        }
    }

    public final void drawLine(Graphics graphics, CC3Vector cC3Vector, CC3Vector cC3Vector2) {
        if (this.camera.a(cC3Vector, b)) {
            int n2 = CC3Renderer.b.x;
            int n3 = CC3Renderer.b.y;
            this.camera.a(cC3Vector2, b);
            graphics.drawLine(this.a.x + n2, -this.a.y - n3, this.a.x + CC3Renderer.b.x, -this.a.y - CC3Renderer.b.y);
        }
    }

    public void setCameraLookAt(CC3Vector cC3Vector) {
        this.camera.setLookAt(cC3Vector);
    }

    public void setCameraLookAt(float f2, float f3, float f4) {
        this.camera.setLookAt(f2, f3, f4);
    }

    public void setCameraPosition(CC3Vector cC3Vector) {
        this.camera.setPosition(cC3Vector.x, cC3Vector.y, cC3Vector.z);
    }

    public void setCameraPosition(float f2, float f3, float f4) {
        this.camera.setPosition(f2, f3, f4);
    }

    public void visit(Graphics graphics, long l2, boolean bl, boolean bl2) {
        this.running3dScene.update((float)CCDirector.averageDt / 1000.0f, this);
        this.camera.update(l2, this);
        this.camera.visit(graphics, CCDirector.averageDt, bl, bl2);
        super.visit(graphics, CCDirector.averageDt, bl, bl2);
        this.running3dScene.visit(graphics, CCDirector.averageDt, bl, bl2);
    }

    public void draw(Graphics graphics) {
        CCNode cCNode;
        int n2 = cocos2d.isAndroid ? 0 : graphics.getTranslateY();
        graphics.translate(0, -n2);
        this.getScreenPosition(this.a);
        this.a.y -= n2;
        if (this.isRelativeAnchorPoint) {
            this.a.x = this.a.x - (this.anchorPoint.x == 0 ? 0 : this.width / (100 / this.anchorPoint.x));
            this.a.y = this.a.y - (this.anchorPoint.y == 0 ? 0 : this.height / (100 / this.anchorPoint.y));
        }
        this.camera.width = this.width;
        this.camera.height = this.height;
        this.camera.updateCamera();
        cocos2d.setClip(graphics, this.a.x, -this.a.y - this.height, this.width, this.height);
        this.running3dScene.setBackground(this.a);
        a.setViewport(this.a.x, -this.a.y - this.height, this.width, this.height);
        a.bindTarget((Object)graphics);
        this.running3dScene.a(this.camera);
        if (this.USE_RETAINED_MODE) {
            a.render((World)this.running3dScene.m3gObject);
        } else {
            cCNode = this;
            a.clear(((CC3Renderer)cCNode).a);
            ((CC3Renderer)cCNode).camera.a.getTransformTo(((CC3Renderer)cCNode).running3dScene.m3gObject, CC3Transform.a);
            a.setCamera(((CC3Renderer)cCNode).camera.a, CC3Transform.a);
            ((CC3Renderer)cCNode).a = false;
            ((CC3Renderer)cCNode).a(((CC3Renderer)cCNode).running3dScene);
            ((CC3Renderer)cCNode).a = true;
            ((CC3Renderer)cCNode).a(((CC3Renderer)cCNode).running3dScene);
            a.resetLights();
            cCNode = this;
            int n3 = ((CC3Renderer)cCNode).camera.children.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                CC3Node cC3Node = (CC3Node)((CC3Renderer)cCNode).camera.children.elementAt(i2);
                Node node = cC3Node.m3gObject;
                if (!node.isRenderingEnabled()) continue;
                if (node instanceof Group) {
                    super.a((CC3Group)cC3Node);
                }
                if (node instanceof Mesh) {
                    super.a(node);
                    continue;
                }
                if (!(node instanceof Sprite3D)) continue;
                super.a(node);
            }
        }
        a.releaseTarget();
        graphics.translate(0, n2);
        if (cocos2d.DEBUG) {
            n2 = this.running3dScene.children.size();
            while (n2-- != 0) {
                cCNode = (CC3Node)this.running3dScene.children.elementAt(n2);
                ((CC3Node)cCNode).drawDebug(graphics, this);
            }
        }
    }

    static void a(CC3Light cC3Light) {
        a.addLight((Light)cC3Light.m3gObject, cC3Light.objTransform.getTransform());
    }

    private void a(CC3Group cC3Group) {
        if (cC3Group.batchRender) {
            if (cC3Group.isTransparent == this.a) {
                this.a(cC3Group.m3gObject);
                return;
            }
        } else {
            int n2 = cC3Group.children.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                CCNode cCNode = (CC3Node)cC3Group.children.elementAt(i2);
                Node node = cCNode.m3gObject;
                if (!node.isRenderingEnabled()) continue;
                if (node instanceof Group) {
                    this.a((CC3Group)cCNode);
                    continue;
                }
                if (cCNode.isTransparent != this.a) continue;
                CC3Node cC3Node = cCNode;
                cCNode = this;
                if (!(cC3Node.cullingSphereRadius == 0.0f || ((CC3Renderer)cCNode).camera.frustum.sphereIntersection(cC3Node.position, cC3Node.cullingSphereRadius)) || !(node instanceof Mesh) && !(node instanceof Sprite3D)) continue;
                this.a(node);
            }
        }
    }

    private void a(Node node) {
        if (node.getTransformTo(this.running3dScene.m3gObject, CC3Transform.a)) {
            a.render(node, CC3Transform.a);
            return;
        }
        a.render(node, null);
    }

    public void pauseAllActions(boolean bl) {
        super.pauseAllActions(bl);
        this.running3dScene.onPause();
    }

    public void resumeAllActions(boolean bl) {
        super.resumeAllActions(bl);
        this.running3dScene.onResume();
    }
}

