/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngineRenderer;
import java.util.Vector;

public class CrashAnimationObject {
    public static final float eWidth = 164.0f;
    public static final float eHeight = 164.0f;
    public static final int eSize = 8;
    public static final int eMaxTime = 500;
    public float m_fPosX;
    public float m_fPosY;
    public int m_nTime;
    protected static Vector m_List = null;
    protected static Vector m_TmpList = null;
    protected static CGTexture[] m_arrTextures;

    public void Destroy() {
    }

    public static void Reset() {
        int nS = m_List.size();
        if (nS > 0) {
            for (int i = nS - 1; i >= 0; --i) {
                m_TmpList.addElement(m_List.elementAt(i));
            }
            m_List.removeAllElements();
        }
    }

    public void Step(int nDeltaTimeInMs) {
        this.m_nTime += nDeltaTimeInMs;
    }

    public void Render() {
        if (this.m_nTime < 500) {
            int nFrame = (int)(8.0f * (float)this.m_nTime / 500.0f);
            if (nFrame >= 8) {
                nFrame = 7;
            }
            CGTexture t = m_arrTextures[nFrame];
            CGEngineRenderer.RenderCrashAnimationObject(t, this.m_fPosX, this.m_fPosY);
        }
    }

    public static void Init() {
        m_arrTextures = new CGTexture[8];
        CrashAnimationObject.m_arrTextures[0] = TextureManager.CreateTexture("/gameplay/crash_1.png");
        CrashAnimationObject.m_arrTextures[1] = TextureManager.CreateTexture("/gameplay/crash_2.png");
        CrashAnimationObject.m_arrTextures[2] = TextureManager.CreateTexture("/gameplay/crash_3.png");
        CrashAnimationObject.m_arrTextures[3] = TextureManager.CreateTexture("/gameplay/crash_4.png");
        CrashAnimationObject.m_arrTextures[4] = TextureManager.CreateTexture("/gameplay/crash_5.png");
        CrashAnimationObject.m_arrTextures[5] = TextureManager.CreateTexture("/gameplay/crash_6.png");
        CrashAnimationObject.m_arrTextures[6] = TextureManager.CreateTexture("/gameplay/crash_7.png");
        CrashAnimationObject.m_arrTextures[7] = TextureManager.CreateTexture("/gameplay/crash_8.png");
        m_List = new Vector();
        m_TmpList = new Vector();
        for (int i = 0; i < 20; ++i) {
            m_TmpList.addElement(new CrashAnimationObject());
        }
    }

    public static void NewItem(float x, float y) {
        CrashAnimationObject to = null;
        if (m_TmpList.size() > 0) {
            to = (CrashAnimationObject)m_TmpList.elementAt(0);
            m_TmpList.removeElementAt(0);
        } else {
            to = new CrashAnimationObject();
        }
        to.m_fPosX = x;
        to.m_fPosY = y;
        to.m_nTime = 0;
        m_List.addElement(to);
    }

    public static void StepAll(int nDeltaTimeInMs) {
        int nS = m_List.size();
        for (int i = nS - 1; i >= 0; --i) {
            CrashAnimationObject to = (CrashAnimationObject)m_List.elementAt(i);
            to.Step(nDeltaTimeInMs);
            if (to.m_nTime < 500) continue;
            m_TmpList.addElement(to);
            m_List.removeElementAt(i);
        }
    }

    public static void RenderAll() {
        int nS = m_List.size();
        for (int i = 0; i < nS; ++i) {
            ((CrashAnimationObject)m_List.elementAt(i)).Render();
        }
    }

    public static int GetCurrentSize() {
        return m_List.size();
    }
}

