/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.project_gameplay.BombObject;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.PowerupManager;
import baltorogames.project_gameplay.SelectBoostScreen;
import baltorogames.project_gameplay.TrampolineObject;
import baltorogames.project_gameplay.WorldObject;

public class CGEngineRenderer {
    public static float m_fScreenOffsetX = 0.0f;
    public static float m_fScreenOffsetY = 0.0f;
    public static int m_nComboTime;

    public static void StartCombo(int nTime) {
        m_nComboTime = nTime;
    }

    public static void Init() {
    }

    public static void Render() {
    }

    public static void RenderBomb(BombObject b, CGTexture t, float fX, float fY) {
        float fHalfSizeW = 36.0f;
        float fHalfSizeH = 36.0f;
        Graphic2D.DrawRegion(t, m_fScreenOffsetX + (fX - fHalfSizeW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY - fHalfSizeH) * CGEngine.m_fEngineScale, 0.0f, 0.0f, m_fScreenOffsetX + (fX + fHalfSizeW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY + fHalfSizeH) * CGEngine.m_fEngineScale, 1.0f, 1.0f);
    }

    public static void RenderExplodeBig(CGTexture t, float fX, float fY) {
        float fHalfSizeW = 123.0f;
        float fHalfSizeH = 123.0f;
        Graphic2D.DrawRegion(t, m_fScreenOffsetX + (fX - fHalfSizeW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY - fHalfSizeH) * CGEngine.m_fEngineScale, 0.0f, 0.0f, m_fScreenOffsetX + (fX + fHalfSizeW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY + fHalfSizeH) * CGEngine.m_fEngineScale, 1.0f, 1.0f);
    }

    public static void RenderExplodeNormal(CGTexture t, float fX, float fY) {
        float fHalfSizeW = 82.0f;
        float fHalfSizeH = 82.0f;
        Graphic2D.DrawRegion(t, m_fScreenOffsetX + (fX - fHalfSizeW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY - fHalfSizeH) * CGEngine.m_fEngineScale, 0.0f, 0.0f, m_fScreenOffsetX + (fX + fHalfSizeW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY + fHalfSizeH) * CGEngine.m_fEngineScale, 1.0f, 1.0f);
    }

    public static void RenderCrashAnimationObject(CGTexture t, float fX, float fY) {
        float fHalfSizeW = 82.0f;
        float fHalfSizeH = 82.0f;
        Graphic2D.DrawRegion(t, m_fScreenOffsetX + (fX - fHalfSizeW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY - fHalfSizeH) * CGEngine.m_fEngineScale, 0.0f, 0.0f, m_fScreenOffsetX + (fX + fHalfSizeW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY + fHalfSizeH) * CGEngine.m_fEngineScale, 1.0f, 1.0f);
    }

    public static void RenderPowerup(CGTexture t, float fX, float fY) {
        float fHalfSizeW = 24.0f;
        float fHalfSizeH = 24.0f;
        Graphic2D.DrawRegion(t, m_fScreenOffsetX + (fX - fHalfSizeW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY - fHalfSizeH) * CGEngine.m_fEngineScale, 0.0f, 0.0f, m_fScreenOffsetX + (fX + fHalfSizeW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY + fHalfSizeH) * CGEngine.m_fEngineScale, 1.0f, 1.0f);
    }

    public static void RenderHitAnimationObject(CGTexture t, float fX, float fY) {
        float fHalfSizeW = 64.0f;
        float fHalfSizeH = 64.0f;
        Graphic2D.DrawRegion(t, m_fScreenOffsetX + (fX - fHalfSizeW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY - fHalfSizeH) * CGEngine.m_fEngineScale, 0.0f, 0.0f, m_fScreenOffsetX + (fX + fHalfSizeW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY + fHalfSizeH) * CGEngine.m_fEngineScale, 1.0f, 1.0f);
    }

    public static void RenderTrail(CGTexture t, float fX, float fY, float fAlpha) {
        float fHalfSizeW = 32.0f;
        float fHalfSizeH = 32.0f;
        Graphic2D.DrawRegion(t, m_fScreenOffsetX + (fX - fHalfSizeW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY - fHalfSizeH) * CGEngine.m_fEngineScale, 0.0f, 0.0f, m_fScreenOffsetX + (fX + fHalfSizeW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY + fHalfSizeH) * CGEngine.m_fEngineScale, 1.0f, 1.0f);
    }

    public static void RenderGetPowerupAnimation(CGTexture t, float fX, float fY) {
        float fHalfSizeW = 64.0f;
        float fHalfSizeH = 64.0f;
        Graphic2D.DrawRegion(t, m_fScreenOffsetX + (fX - fHalfSizeW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY - fHalfSizeH) * CGEngine.m_fEngineScale, 0.0f, 0.0f, m_fScreenOffsetX + (fX + fHalfSizeW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY + fHalfSizeH) * CGEngine.m_fEngineScale, 1.0f, 1.0f);
    }

    public static void RenderThiefThingObject(CGTexture t, float fX, float fY, float fAlpha) {
        if (fAlpha < 1.0f) {
            return;
        }
        float fHalfSizeW = 48.0f;
        float fHalfSizeH = 48.0f;
        Graphic2D.DrawRegion(t, m_fScreenOffsetX + (fX - fHalfSizeW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY - fHalfSizeH) * CGEngine.m_fEngineScale, 0.0f, 0.0f, m_fScreenOffsetX + (fX + fHalfSizeW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY + fHalfSizeH) * CGEngine.m_fEngineScale, 1.0f, 1.0f);
    }

    public static void RenderThingObject(CGTexture t, float fX, float fY, float fAngle) {
        float fHalfSizeW = 64.0f;
        float fHalfSizeH = 64.0f;
        Graphic2D.DrawRegion(t, m_fScreenOffsetX + (fX - fHalfSizeW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY - fHalfSizeH) * CGEngine.m_fEngineScale, 0.0f, 0.0f, m_fScreenOffsetX + (fX + fHalfSizeW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY + fHalfSizeH) * CGEngine.m_fEngineScale, 1.0f, 1.0f);
    }

    public static void RenderTrampoline(TrampolineObject o, float fX, float fY) {
        if (!o.m_bAfterBomb) {
            float fTrampolineScale = 1.0f;
            if (SelectBoostScreen.isBoostLargeBagActivate()) {
                fTrampolineScale = 1.2f;
                if (PowerupManager.IsPowerup_BigSize()) {
                    fTrampolineScale = 1.5f;
                }
            } else {
                fTrampolineScale = 1.0f;
                if (PowerupManager.IsPowerup_BigSize()) {
                    fTrampolineScale = 1.3f;
                }
            }
            Graphic2D.DrawRegion(o.m_pTrampolineTextures[1], m_fScreenOffsetX + (fX - fTrampolineScale * 102.4f / 2.0f) * CGEngine.m_fEngineScale, m_fScreenOffsetY + 684.4f * CGEngine.m_fEngineScale, 0.0f, 0.0f, m_fScreenOffsetX + (fX + fTrampolineScale * 102.4f / 2.0f) * CGEngine.m_fEngineScale, m_fScreenOffsetY + 710.0f * CGEngine.m_fEngineScale, 1.0f, 1.0f);
            float fXX = fX - fTrampolineScale * 8.0f * 102.4f / 10.0f;
            Graphic2D.DrawRegion(o.m_pMainTexture[0][o.m_nCurrentFrame], m_fScreenOffsetX + (fXX - 51.2f) * CGEngine.m_fEngineScale, m_fScreenOffsetY + 607.6f * CGEngine.m_fEngineScale, 0.0f, 0.0f, m_fScreenOffsetX + (fXX + 51.2f) * CGEngine.m_fEngineScale, m_fScreenOffsetY + 710.0f * CGEngine.m_fEngineScale, 1.0f, 1.0f);
            fXX = fX + fTrampolineScale * 8.0f * 102.4f / 10.0f;
            Graphic2D.DrawRegion(o.m_pMainTexture[1][o.m_nCurrentFrame], m_fScreenOffsetX + (fXX - 51.2f) * CGEngine.m_fEngineScale, m_fScreenOffsetY + 607.6f * CGEngine.m_fEngineScale, 0.0f, 0.0f, m_fScreenOffsetX + (fXX + 51.2f) * CGEngine.m_fEngineScale, m_fScreenOffsetY + 710.0f * CGEngine.m_fEngineScale, 1.0f, 1.0f);
            if (fTrampolineScale == 1.0f) {
                Graphic2D.DrawRegion(o.m_pTrampolineTextures[0], m_fScreenOffsetX + (fX - fTrampolineScale * 102.4f / 2.0f) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (607.6f + o.m_fDeflactionY) * CGEngine.m_fEngineScale, 0.0f, 0.0f, m_fScreenOffsetX + (fX + fTrampolineScale * 102.4f / 2.0f) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (710.0f + o.m_fDeflactionY) * CGEngine.m_fEngineScale, 1.0f, 1.0f);
            } else {
                Graphic2D.DrawRegion(o.m_pTrampolineTextures[3], m_fScreenOffsetX + (fX - fTrampolineScale * 102.4f / 2.0f) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (607.6f + o.m_fDeflactionY) * CGEngine.m_fEngineScale, 0.0f, 0.0f, m_fScreenOffsetX + (fX + fTrampolineScale * 102.4f / 2.0f) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (710.0f + o.m_fDeflactionY) * CGEngine.m_fEngineScale, 1.0f, 1.0f);
            }
            if (PowerupManager.IsPowerup_Shield()) {
                Graphic2D.DrawRegion(o.m_pShieldTexture, m_fScreenOffsetX + (fX - 51.2f) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (582.0f + o.m_fDeflactionY) * CGEngine.m_fEngineScale, 0.0f, 0.0f, m_fScreenOffsetX + (fX + 51.2f) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (607.6f + o.m_fDeflactionY) * CGEngine.m_fEngineScale, 1.0f, 1.0f);
            }
            if (PowerupManager.IsPowerup_Magnet()) {
                Graphic2D.DrawRegion(o.m_pMagnetTexture, m_fScreenOffsetX + (fX - 51.2f) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (556.39996f + o.m_fDeflactionY) * CGEngine.m_fEngineScale, 0.0f, 0.0f, m_fScreenOffsetX + (fX + 51.2f) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (607.6f + o.m_fDeflactionY) * CGEngine.m_fEngineScale, 1.0f, 1.0f);
            }
        } else {
            Graphic2D.DrawRegion(o.m_pTrampolineTextures[2], m_fScreenOffsetX + (fX - 51.2f) * CGEngine.m_fEngineScale, m_fScreenOffsetY + 684.4f * CGEngine.m_fEngineScale, 0.0f, 0.0f, m_fScreenOffsetX + (fX + 51.2f + 16.0f) * CGEngine.m_fEngineScale, m_fScreenOffsetY + 726.0f * CGEngine.m_fEngineScale, 1.0f, 1.0f);
            float fXX = fX - 81.92f;
            Graphic2D.DrawRegion(o.m_pDeadTexture[0][o.m_nCurrentFrame], m_fScreenOffsetX + (fXX - 51.2f) * CGEngine.m_fEngineScale, m_fScreenOffsetY + 607.6f * CGEngine.m_fEngineScale, 0.0f, 0.0f, m_fScreenOffsetX + (fXX + 51.2f) * CGEngine.m_fEngineScale, m_fScreenOffsetY + 710.0f * CGEngine.m_fEngineScale, 1.0f, 1.0f);
            fXX = fX + 81.92f;
            Graphic2D.DrawRegion(o.m_pDeadTexture[1][o.m_nCurrentFrame], m_fScreenOffsetX + (fXX - 51.2f) * CGEngine.m_fEngineScale, m_fScreenOffsetY + 607.6f * CGEngine.m_fEngineScale, 0.0f, 0.0f, m_fScreenOffsetX + (fXX + 51.2f) * CGEngine.m_fEngineScale, m_fScreenOffsetY + 710.0f * CGEngine.m_fEngineScale, 1.0f, 1.0f);
        }
    }

    public static void RenderWorldObject(WorldObject w) {
        CGTexture t = w.m_Texture[CGEngine.m_nViewMode];
        if (t == null) {
            return;
        }
        float fViewModeScale = 1.0f * CGEngine.m_fEngineScale;
        float fX = (float)w.m_fX - CGEngine.m_fCameraPosX;
        float fY = (float)w.m_fY - CGEngine.m_fCameraPosY;
        float fF = m_fScreenOffsetX + fX * fViewModeScale;
        if (fF > (float)ApplicationData.screenWidth) {
            return;
        }
        fF = m_fScreenOffsetX + (fX + (float)w.m_fW) * fViewModeScale;
        if (fF < 0.0f) {
            return;
        }
        fF = m_fScreenOffsetY + fY * fViewModeScale;
        if (fF > (float)ApplicationData.screenHeight) {
            return;
        }
        fF = m_fScreenOffsetY + (fY + (float)w.m_fH) * fViewModeScale;
        if (fF < 0.0f) {
            return;
        }
        if (w.m_nAnimSize <= 1) {
            if (w.m_nM == 1) {
                Graphic2D.DrawRegion(t, m_fScreenOffsetX + fX * fViewModeScale, m_fScreenOffsetY + fY * fViewModeScale, 1.0f, 0.0f, m_fScreenOffsetX + (fX + (float)w.m_fW) * fViewModeScale, m_fScreenOffsetY + (fY + (float)w.m_fH) * fViewModeScale, 0.0f, 1.0f);
            }
            if (w.m_nM == 2) {
                Graphic2D.DrawRegion(t, m_fScreenOffsetX + fX * fViewModeScale, m_fScreenOffsetY + fY * fViewModeScale, 0.0f, 1.0f, m_fScreenOffsetX + (fX + (float)w.m_fW) * fViewModeScale, m_fScreenOffsetY + (fY + (float)w.m_fH) * fViewModeScale, 1.0f, 0.0f);
            } else if (w.m_nM == 3) {
                Graphic2D.DrawRegion(t, m_fScreenOffsetX + fX * fViewModeScale, m_fScreenOffsetY + fY * fViewModeScale, 1.0f, 1.0f, m_fScreenOffsetX + (fX + (float)w.m_fW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY + (float)w.m_fH) * CGEngine.m_fEngineScale, 0.0f, 0.0f);
            } else {
                Graphic2D.DrawRegion(t, m_fScreenOffsetX + fX * fViewModeScale, m_fScreenOffsetY + fY * fViewModeScale, 0.0f, 0.0f, m_fScreenOffsetX + (fX + (float)w.m_fW) * fViewModeScale, m_fScreenOffsetY + (fY + (float)w.m_fH) * fViewModeScale, 1.0f, 1.0f);
            }
        } else {
            int nCurrentFrame = 0;
            float u1 = 0.0f;
            float v1 = 0.0f;
            float u2 = 1.0f;
            float v2 = 1.0f;
            if (w.m_nAnimSize > 1) {
                nCurrentFrame = w.m_nCurrentFrame;
                int nX = nCurrentFrame % w.m_nAnimGridX;
                int nY = nCurrentFrame / w.m_nAnimGridX;
                u1 = (float)nX / (float)w.m_nAnimGridX;
                v1 = (float)nY / (float)w.m_nAnimGridY;
                u2 = u1 + 1.0f / (float)w.m_nAnimGridX;
                v2 = v1 + 1.0f / (float)w.m_nAnimGridY;
            }
            if (w.m_nM == 1) {
                Graphic2D.DrawRegion(t, m_fScreenOffsetX + fX * fViewModeScale, m_fScreenOffsetY + fY * fViewModeScale, u2, v1, m_fScreenOffsetX + (fX + (float)w.m_fW) * fViewModeScale, m_fScreenOffsetY + (fY + (float)w.m_fH) * fViewModeScale, u1, v2);
            }
            if (w.m_nM == 2) {
                Graphic2D.DrawRegion(t, m_fScreenOffsetX + fX * fViewModeScale, m_fScreenOffsetY + fY * fViewModeScale, u1, v2, m_fScreenOffsetX + (fX + (float)w.m_fW) * fViewModeScale, m_fScreenOffsetY + (fY + (float)w.m_fH) * fViewModeScale, u2, v1);
            }
            if (w.m_nM == 3) {
                Graphic2D.DrawRegion(t, m_fScreenOffsetX + fX * fViewModeScale, m_fScreenOffsetY + fY * fViewModeScale, u2, v2, m_fScreenOffsetX + (fX + (float)w.m_fW) * fViewModeScale, m_fScreenOffsetY + (fY + (float)w.m_fH) * fViewModeScale, u1, v1);
            } else {
                Graphic2D.DrawRegion(t, m_fScreenOffsetX + fX * fViewModeScale, m_fScreenOffsetY + fY * fViewModeScale, u1, v1, m_fScreenOffsetX + (fX + (float)w.m_fW) * fViewModeScale, m_fScreenOffsetY + (fY + (float)w.m_fH) * fViewModeScale, u2, v2);
            }
        }
    }
}

