/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameSprite
extends GameDrawable {
    public static final int ANCHOR_TOP_LEFT = 20;
    public static final int ANCHOR_CENTERED = 3;
    public static final int ANCHOR_TOP = 16;
    public static final int ANCHOR_HCENTER = 1;
    public static final int DEFAULT_ANCHOR = 3;
    public static final short NULL_IMAGE = -1;
    public Image mImage;
    public int mAnchor;
    public short mImageId = (short)-1;
    public Vector2i position = new Vector2i();
    public Vector2i refPosition = new Vector2i();
    public Vector2i size = new Vector2i();
    public static byte[] gRefId = new byte[345];
    public static boolean flagMirror = false;
    UiListener mTouchListener;
    int[] bbox = null;

    GameSprite setTouchListener(UiListener uiListener) {
        this.mTouchListener = uiListener;
        return this;
    }

    GameSprite setBBox(int n, int n2, int n3, int n4) {
        this.bbox = new int[4];
        this.bbox[0] = n;
        this.bbox[1] = n2;
        this.bbox[2] = n3;
        this.bbox[3] = n4;
        return this;
    }

    BaseObject createCopy(BaseObject baseObject) {
        GameSprite gameSprite = (GameSprite)baseObject;
        if (gameSprite == null) {
            gameSprite = new GameSprite();
        }
        gameSprite.mImage = this.mImage;
        gameSprite.mAnchor = this.mAnchor;
        gameSprite.position.set(this.position);
        gameSprite.refPosition.set(this.refPosition);
        return gameSprite;
    }

    void onInit(GameObject gameObject) {
    }

    void destroyImage() {
        if (this.mImageId >= 0) {
            short s = this.mImageId;
            gRefId[s] = (byte)(gRefId[s] - 1);
            if (gRefId[this.mImageId] <= 0) {
                Tools.println("destory image : ");
                Tools.println(this.mImageId);
                GameResourceMgr.destroyImage(this.mImageId);
            }
            this.mImageId = (short)-1;
        }
    }

    public void reposition() {
        DataInputStream dataInputStream;
        this.refPosition.x = 0;
        this.refPosition.y = 0;
        this.size.x = this.mImage.getWidth();
        this.size.y = this.mImage.getHeight();
        if (!this.isFlag(4096) && (dataInputStream = GameResourceMgr.loadImageDataStream(this.mImageId)) != null) {
            try {
                this.refPosition.x = dataInputStream.readShort();
                this.refPosition.y = dataInputStream.readShort();
                this.size.x = dataInputStream.readShort();
                this.size.y = dataInputStream.readShort();
                if (flagMirror) {
                    this.refPosition.x = this.size.x - this.refPosition.x - this.mImage.getWidth();
                }
                dataInputStream.close();
                dataInputStream = null;
                Tools.println("img=");
                Tools.println(this.mImageId);
                Tools.println("refX= ");
                Tools.println(this.refPosition.x);
                Tools.println(" refY= ");
                Tools.println(this.refPosition.y);
                Tools.println("sizx= ");
                Tools.println(this.size.x);
                Tools.println(" sizy= ");
                Tools.println(this.size.y);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((this.mAnchor & 1) != 0) {
            this.refPosition.x -= this.size.x >> 1;
        }
        if ((this.mAnchor & 8) != 0) {
            this.refPosition.x -= this.size.x;
        }
        if ((this.mAnchor & 2) != 0) {
            this.refPosition.y -= this.size.y >> 1;
        }
        if ((this.mAnchor & 0x20) != 0) {
            this.refPosition.y -= this.size.y;
        }
    }

    void changeImage(short s) {
        this.destroyImage();
        this.mImageId = s;
        if (s >= 0) {
            Tools.print("load image");
            Tools.println(this.mImageId);
            this.mImage = GameResourceMgr.loadImage(s);
            Tools.println("image loaded");
            short s2 = this.mImageId;
            gRefId[s2] = (byte)(gRefId[s2] + 1);
            this.reposition();
        }
    }

    GameSprite(short s, int n, int n2, int n3, int n4) {
        this.mAnchor = n2;
        this.changeImage(s);
        this.refPosition.x += n3;
        this.refPosition.y += n4;
        this.mHashType = (byte)13;
    }

    GameSprite(short s, int n, int n2, boolean bl) {
        this.mAnchor = n2;
        this.changeImage(s);
        this.refPosition.x += 0;
        this.refPosition.y += 0;
        this.mHashType = (byte)13;
        if (bl) {
            this.mImage = Image.createImage((Image)GameResourceMgr.loadImage(s), (int)0, (int)0, (int)GameResourceMgr.loadImage(s).getWidth(), (int)GameResourceMgr.loadImage(s).getHeight(), (int)2);
        }
    }

    GameSprite(short s, int n, int n2) {
        this(s, n, n2, 0, 0);
    }

    GameSprite(short s, int n) {
        this(s, n, 3);
    }

    GameSprite(short s) {
        this(s, 0);
    }

    GameSprite() {
        this(-1);
    }

    void onDestroy(GameObject gameObject) {
        super.onDestroy(gameObject);
        this.mImage = null;
        this.destroyImage();
    }

    void onPaint(GameObject gameObject, Graphics graphics) {
        this.position.set(gameObject.getGlobalXY().x + this.refPosition.x, gameObject.getGlobalXY().y + this.refPosition.y);
        graphics.drawImage(this.mImage, this.position.x, this.position.y, 0x10 | 4);
        if (this.mTouchListener != null) {
            int n;
            int n2;
            int n3;
            int n4;
            if (this.bbox != null) {
                n4 = gameObject.getGlobalXY().x + this.bbox[0];
                n3 = gameObject.getGlobalXY().y + this.bbox[1];
                n2 = this.bbox[2];
                n = this.bbox[3];
            } else {
                n4 = this.position.x;
                n3 = this.position.y;
                n2 = this.mImage.getWidth();
                n = this.mImage.getHeight();
            }
            if (TouchScreen.PointerReleased(n4, n3, n2, n) && gameObject != null && gameObject.isEnabled()) {
                this.mTouchListener.onMessage(gameObject, 105);
            }
        }
    }

    Vector2i getSize() {
        return this.size;
    }

    static GameSprite getSprite(GameObject gameObject) {
        return (GameSprite)gameObject.getPropertyByHashType((byte)13);
    }

    public Image getImage() {
        return this.mImage;
    }
}

