/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class GameCanvas
extends Canvas
implements Runnable {
    public static final long TIME_PER_FRAME = 100L;
    public Thread mThread = null;
    public int mLastKey;
    public GameMidlet mMidlet;
    long mLastTime = 0L;
    public boolean mQuit = false;
    int mKeyToPress;
    int mKeyToRelease;
    int mKeyToClick;
    public static int WIDTH = -1;
    public static int HEIGHT = -1;
    public static int WIDTH_2 = -1;
    public static int HEIGHT_2 = -1;
    public static int GAME_HEIGHT = -1;
    public static int GAME_HEIGHT_2 = -1;
    public static long mFrame;
    boolean firstPaint = true;
    boolean restoreScreen = true;
    boolean rotation = false;
    public int cheatCode = 0;
    public static Image gBackBuffer;
    GameState mGameState;
    long deltaTime = 0L;
    boolean mBlockKeys = false;

    public GameCanvas(GameMidlet gameMidlet) {
        this.mMidlet = gameMidlet;
        this.setFullScreenMode(true);
        mFrame = 0L;
    }

    public void onInit() {
        this.setupScreenSize(null);
        this.mGameState = new GameState(this);
        this.mGameState.onInit();
        if (Boxal.bInfCallSerially) {
            Display.getDisplay((MIDlet)this.mMidlet).callSerially((Runnable)this);
        } else {
            this.mThread = new Thread(this);
            this.mThread.start();
        }
    }

    public void quit() {
        this.mQuit = true;
    }

    public void run() {
        boolean bl = false;
        while (!bl) {
            try {
                if (!this.rotation && !Boxal.bInfUseWatchdog) {
                    this.mGameState.onUpdate();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.updateKeys();
            ++mFrame;
            this.repaint();
            this.serviceRepaints();
            long l = System.currentTimeMillis();
            try {
                if (Boxal.bInfFixedSleep) {
                    Thread.sleep(Boxal.iInfFixedSleepLength);
                } else {
                    this.deltaTime = l - this.mLastTime;
                    if (this.deltaTime < 100L) {
                        Thread.sleep(100L - this.deltaTime);
                        l += 100L - this.deltaTime;
                    } else {
                        Thread.sleep(5L);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mLastTime = l;
            if (Boxal.bInfCallSerially) {
                bl = true;
            }
            if (!this.mQuit) continue;
            bl = true;
        }
        if (this.mQuit) {
            try {
                Tools.println("quit");
                if (this.mGameState != null) {
                    this.mGameState.onDestroy();
                    this.mGameState = null;
                }
                GameResourceMgr.onDestroy();
                gBackBuffer = null;
                TouchScreen.onDestroy();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Boxal.stopAll();
            this.mMidlet.destroyApp(true);
        } else if (Boxal.bInfCallSerially) {
            Display.getDisplay((MIDlet)this.mMidlet).callSerially((Runnable)this);
        }
    }

    public int getKeyAction(int n) {
        n = Boxal.translateKeyCode(this, n);
        int n2 = 0;
        try {
            n2 = this.getGameAction(n);
        }
        catch (Exception exception) {
            n2 = 0;
        }
        switch (n2) {
            case 2: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 8: {
                return 5;
            }
        }
        switch (n) {
            case 1001: {
                return 6;
            }
            case 1000: {
                return 5;
            }
        }
        switch (n) {
            case 50: {
                return 3;
            }
            case 52: {
                return 1;
            }
            case 54: {
                return 2;
            }
            case 56: {
                return 4;
            }
            case 53: {
                return 5;
            }
        }
        if (n != 0) {
            return 7;
        }
        return 0;
    }

    public void updateKeys() {
        this.mGameState.keyPressed = this.getKeyAction(this.mKeyToPress);
        this.mGameState.keyClicked = this.getKeyAction(this.mKeyToClick);
        this.mKeyToClick = 0;
        if (this.mKeyToRelease != 0) {
            this.mKeyToPress = 0;
        }
        this.mKeyToRelease = 0;
    }

    public void paint(Graphics graphics) {
        try {
            int n;
            if (this.firstPaint) {
                this.firstPaint = false;
                this.setupScreenSize(graphics);
            }
            if (!this.mGameState.mIsLoading) {
                Boxal.ignoreWatchDogFrame = true;
                Boxal.watchDogLastTick = System.currentTimeMillis();
            }
            if (Boxal.watchDogTick()) {
                this.onPause();
            }
            if (Boxal.checkRotation(this, graphics)) {
                if (!this.rotation) {
                    this.onPause();
                }
                this.rotation = true;
                return;
            }
            if (this.restoreScreen) {
                this.restoreScreen = false;
                this.setupScreenSize(graphics);
            }
            this.rotation = false;
            if (Boxal.bInfUseWatchdog && this.mGameState != null) {
                this.mGameState.onUpdate();
            }
            Graphics graphics2 = graphics;
            if (gBackBuffer != null) {
                graphics = gBackBuffer.getGraphics();
            }
            if (this.mGameState != null) {
                this.mGameState.onPaint(graphics);
            }
            if (gBackBuffer != null) {
                graphics2.drawImage(gBackBuffer, 0, 0, 0);
            }
            if (Boxal.bInfForceSize && Boxal.bInfFillFullscreen && (n = super.getHeight() - Boxal.iInfForcedHeight) > 0) {
                graphics2.setColor(0);
                graphics2.setClip(0, 0, super.getWidth(), super.getHeight());
                graphics2.fillRect(0, Boxal.iInfForcedHeight, super.getWidth(), n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void keyPressed(int n) {
        int n2;
        if (this.mBlockKeys) {
            return;
        }
        if (!this.rotation) {
            this.mKeyToPress = n;
            this.mKeyToClick = n;
            if (this.getKeyAction(this.mKeyToPress) == 5) {
                this.mGameState.firePressed = true;
            }
            if (this.getKeyAction(this.mKeyToPress) == 6) {
                this.mGameState.backPressed = true;
            }
        }
        if ((n2 = n - 48) > 0 && n2 <= 9) {
            this.cheatCode = this.cheatCode * 10 + n2;
            this.cheatCode %= 1000000;
        }
    }

    public void keyReleased(int n) {
        if (this.mBlockKeys) {
            return;
        }
        this.mKeyToRelease = n;
    }

    public void hideNotify() {
        if (!Boxal.bInfIgnoreHideNotify) {
            this.onPause();
        }
    }

    public void showNotify() {
        this.onResume();
    }

    void onPause() {
        if (this.mGameState != null) {
            this.mGameState.onPause();
        }
    }

    void onResume() {
    }

    void setupScreenSize(Graphics graphics) {
        if (Boxal.bInfForceSize) {
            WIDTH = Boxal.iInfForcedWidth;
            HEIGHT = Boxal.iInfForcedHeight;
        } else if (graphics != null && Boxal.bInfUseAlternateSizeDetect && Boxal.iInfSizeDetectMethod == 1) {
            WIDTH = graphics.getClipWidth();
            HEIGHT = graphics.getClipHeight();
        } else {
            WIDTH = this.getWidth();
            HEIGHT = this.getHeight();
        }
        WIDTH_2 = WIDTH / 2;
        HEIGHT_2 = HEIGHT / 2;
        GAME_HEIGHT = HEIGHT - 20;
        GAME_HEIGHT_2 = GAME_HEIGHT / 2;
        if (Boxal.bInfDoubleBuffer && (gBackBuffer == null || gBackBuffer.getWidth() != WIDTH || gBackBuffer.getHeight() != HEIGHT)) {
            gBackBuffer = Image.createImage((int)WIDTH, (int)HEIGHT);
        }
    }

    protected void pointerPressed(int n, int n2) {
        if (!Boxal.bInfNoTouch) {
            this.mGameState.touchScreenOn = true;
            this.mBlockKeys = true;
        }
        if (this.mGameState.touchScreenOn) {
            TouchScreen.getInstance().pointerPressed(n, n2);
        }
    }

    protected void pointerDragged(int n, int n2) {
        if (this.mGameState.touchScreenOn) {
            TouchScreen.getInstance().pointerDragged(n, n2);
        }
    }

    protected void pointerReleased(int n, int n2) {
        if (this.mGameState.touchScreenOn) {
            TouchScreen.getInstance().pointerReleased(n, n2);
        }
    }

    static {
        gBackBuffer = null;
    }
}

